/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-23 11:38:36 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=10929 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=29474 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=32731 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_cache` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(80) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_cache_key` (`key`),
  KEY `ndx_aioseo_cache_expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=4805 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_crawl_cleanup_blocked_args` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` text COLLATE utf8mb4_unicode_520_ci,
  `value` text COLLATE utf8mb4_unicode_520_ci,
  `key_value_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `regex` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hits` int NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_crawl_cleanup_blocked_args_key_value_hash` (`key_value_hash`),
  UNIQUE KEY `ndx_aioseo_crawl_cleanup_blocked_args_regex` (`regex`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_crawl_cleanup_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `key` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_520_ci,
  `hash` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hits` int NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_crawl_cleanup_logs_hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(13) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `addon` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `level` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `notification_id` bigint unsigned DEFAULT NULL,
  `notification_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `start` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `button1_label` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `button1_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `button2_label` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `button2_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `dismissed` tinyint(1) NOT NULL DEFAULT '0',
  `new` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_notifications_slug` (`slug`),
  KEY `ndx_aioseo_notifications_dates` (`start`,`end`),
  KEY `ndx_aioseo_notifications_type` (`type`),
  KEY `ndx_aioseo_notifications_dismissed` (`dismissed`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` text COLLATE utf8mb4_unicode_520_ci,
  `keywords` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `keyphrases` longtext COLLATE utf8mb4_unicode_520_ci,
  `page_analysis` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_term` longtext COLLATE utf8mb4_unicode_520_ci,
  `canonical_url` text COLLATE utf8mb4_unicode_520_ci,
  `og_title` text COLLATE utf8mb4_unicode_520_ci,
  `og_description` text COLLATE utf8mb4_unicode_520_ci,
  `og_object_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT 'default',
  `og_image_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT 'default',
  `og_image_url` text COLLATE utf8mb4_unicode_520_ci,
  `og_image_width` int DEFAULT NULL,
  `og_image_height` int DEFAULT NULL,
  `og_image_custom_url` text COLLATE utf8mb4_unicode_520_ci,
  `og_image_custom_fields` text COLLATE utf8mb4_unicode_520_ci,
  `og_video` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `og_custom_url` text COLLATE utf8mb4_unicode_520_ci,
  `og_article_section` text COLLATE utf8mb4_unicode_520_ci,
  `og_article_tags` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_use_og` tinyint(1) DEFAULT '0',
  `twitter_card` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT 'default',
  `twitter_image_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT 'default',
  `twitter_image_url` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_custom_url` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_custom_fields` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` text COLLATE utf8mb4_unicode_520_ci,
  `seo_score` int NOT NULL DEFAULT '0',
  `schema` longtext COLLATE utf8mb4_unicode_520_ci,
  `schema_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT 'default',
  `schema_type_options` longtext COLLATE utf8mb4_unicode_520_ci,
  `pillar_content` tinyint(1) DEFAULT NULL,
  `robots_default` tinyint(1) NOT NULL DEFAULT '1',
  `robots_noindex` tinyint(1) NOT NULL DEFAULT '0',
  `robots_noarchive` tinyint(1) NOT NULL DEFAULT '0',
  `robots_nosnippet` tinyint(1) NOT NULL DEFAULT '0',
  `robots_nofollow` tinyint(1) NOT NULL DEFAULT '0',
  `robots_noimageindex` tinyint(1) NOT NULL DEFAULT '0',
  `robots_noodp` tinyint(1) NOT NULL DEFAULT '0',
  `robots_notranslate` tinyint(1) NOT NULL DEFAULT '0',
  `robots_max_snippet` int DEFAULT NULL,
  `robots_max_videopreview` int DEFAULT NULL,
  `robots_max_imagepreview` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT 'large',
  `images` longtext COLLATE utf8mb4_unicode_520_ci,
  `image_scan_date` datetime DEFAULT NULL,
  `priority` float DEFAULT NULL,
  `frequency` tinytext COLLATE utf8mb4_unicode_520_ci,
  `videos` longtext COLLATE utf8mb4_unicode_520_ci,
  `video_thumbnail` text COLLATE utf8mb4_unicode_520_ci,
  `video_scan_date` datetime DEFAULT NULL,
  `local_seo` longtext COLLATE utf8mb4_unicode_520_ci,
  `limit_modified_date` tinyint(1) NOT NULL DEFAULT '0',
  `options` longtext COLLATE utf8mb4_unicode_520_ci,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ndx_aioseo_posts_post_id` (`post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_writing_assistant_keywords` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `keyword` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `country` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'us',
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'en',
  `progress` tinyint DEFAULT '0',
  `keywords` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `competitors` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_writing_assistant_keywords_uuid` (`uuid`),
  KEY `ndx_aioseo_writing_assistant_keywords_keyword` (`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_writing_assistant_posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned DEFAULT NULL,
  `keyword_id` bigint unsigned DEFAULT NULL,
  `content_analysis_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `content_analysis` text COLLATE utf8mb4_unicode_520_ci,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_writing_assistant_posts_post_id` (`post_id`),
  KEY `ndx_aioseo_writing_assistant_posts_keyword_id` (`keyword_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=42719 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4720 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=12141 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=24443 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text COLLATE utf8mb4_unicode_520_ci,
  `last_name` text COLLATE utf8mb4_unicode_520_ci,
  `company` text COLLATE utf8mb4_unicode_520_ci,
  `address_1` text COLLATE utf8mb4_unicode_520_ci,
  `address_2` text COLLATE utf8mb4_unicode_520_ci,
  `city` text COLLATE utf8mb4_unicode_520_ci,
  `state` text COLLATE utf8mb4_unicode_520_ci,
  `postcode` text COLLATE utf8mb4_unicode_520_ci,
  `country` text COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `types` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint DEFAULT NULL,
  `entry_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payment_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `payment_id` bigint NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `form_id` bigint NOT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `discount_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `total_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `currency` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `entry_id` bigint NOT NULL DEFAULT '0',
  `gateway` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `type` varchar(12) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `mode` varchar(4) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `transaction_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `customer_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=291 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("26", "action_scheduler/migration_hook", "failed", "2024-12-24 17:31:45", "2024-12-24 17:31:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735061505;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735061505;}", "2", "1", "2024-12-24 17:32:04", "2024-12-24 17:32:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("30", "wpforms_email_summaries_fetch_info_blocks", "failed", "2024-12-27 21:28:00", "2024-12-27 21:28:00", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735334880;s:18:\"\0*\0first_timestamp\";i:1735334880;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735334880;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2024-12-27 21:38:59", "2024-12-27 21:38:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("242", "wpforms_email_summaries_fetch_info_blocks", "failed", "2025-01-03 21:38:59", "2025-01-03 21:38:59", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735940339;s:18:\"\0*\0first_timestamp\";i:1735334880;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735940339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-01-03 23:05:41", "2025-01-03 23:05:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("488", "wpforms_email_summaries_fetch_info_blocks", "failed", "2025-01-10 23:05:41", "2025-01-10 23:05:41", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1736550341;s:18:\"\0*\0first_timestamp\";i:1735334880;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1736550341;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-01-11 00:36:24", "2025-01-11 00:36:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("792", "wpforms_email_summaries_fetch_info_blocks", "failed", "2025-01-18 00:36:24", "2025-01-18 00:36:24", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737160584;s:18:\"\0*\0first_timestamp\";i:1735334880;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737160584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-01-18 01:07:51", "2025-01-18 01:07:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1041", "wpforms_email_summaries_fetch_info_blocks", "failed", "2025-01-25 01:07:51", "2025-01-25 01:07:51", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737767271;s:18:\"\0*\0first_timestamp\";i:1735334880;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737767271;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-01-25 01:19:55", "2025-01-25 01:19:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("9860", "aioseo_report_summary", "complete", "2025-09-30 09:37:25", "2025-09-30 09:37:25", "10", "{\"frequency\":\"monthly\"}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759225045;s:18:\"\0*\0first_timestamp\";i:1735884000;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759225045;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "1", "1", "2028-03-10 04:29:15", "2028-03-10 04:29:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10044", "wpforms_process_purge_spam", "complete", "2025-09-05 14:59:13", "2025-09-05 14:59:13", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757084353;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757084353;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-05 15:37:56", "2025-09-05 15:37:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10066", "wpforms_admin_addons_cache_update", "complete", "2025-09-12 06:33:50", "2025-09-12 06:33:50", "10", "{\"tasks_meta_id\":25}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757658830;s:18:\"\0*\0first_timestamp\";i:1737046826;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757658830;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-09-12 06:50:08", "2025-09-12 06:50:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10067", "wpforms_builder_help_cache_update", "complete", "2025-09-12 06:33:50", "2025-09-12 06:33:50", "10", "{\"tasks_meta_id\":26}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757658830;s:18:\"\0*\0first_timestamp\";i:1737046829;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757658830;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-09-12 06:50:08", "2025-09-12 06:50:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10068", "wpforms_admin_builder_templates_cache_update", "complete", "2025-09-12 06:33:51", "2025-09-12 06:33:51", "10", "{\"tasks_meta_id\":27}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757658831;s:18:\"\0*\0first_timestamp\";i:1737046829;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757658831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-09-12 06:50:08", "2025-09-12 06:50:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10077", "woocommerce_cleanup_draft_orders", "complete", "2025-09-06 15:37:56", "2025-09-06 15:37:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757173076;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757173076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-06 15:49:19", "2025-09-06 15:49:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10078", "wpforms_process_forms_locator_save", "complete", "2025-09-05 15:37:56", "2025-09-05 15:37:56", "10", "{\"tasks_meta_id\":267}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-05 15:37:56", "2025-09-05 15:37:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10079", "wpforms_process_forms_locator_scan", "complete", "2025-09-06 15:37:56", "2025-09-06 15:37:56", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757173076;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757173076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-06 15:49:19", "2025-09-06 15:49:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10080", "wpforms_process_purge_spam", "complete", "2025-09-06 15:37:56", "2025-09-06 15:37:56", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757173076;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757173076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-06 15:49:19", "2025-09-06 15:49:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10112", "woocommerce_cleanup_draft_orders", "complete", "2025-09-07 15:49:19", "2025-09-07 15:49:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757260159;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757260159;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-07 16:03:21", "2025-09-07 16:03:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10113", "wpforms_process_forms_locator_save", "complete", "2025-09-06 15:49:19", "2025-09-06 15:49:19", "10", "{\"tasks_meta_id\":268}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-06 15:49:19", "2025-09-06 15:49:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10114", "wpforms_process_forms_locator_scan", "complete", "2025-09-07 15:49:19", "2025-09-07 15:49:19", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757260159;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757260159;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-07 16:03:21", "2025-09-07 16:03:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10115", "wpforms_process_purge_spam", "complete", "2025-09-07 15:49:19", "2025-09-07 15:49:19", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757260159;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757260159;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-07 16:03:21", "2025-09-07 16:03:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10150", "woocommerce_cleanup_draft_orders", "complete", "2025-09-08 16:03:21", "2025-09-08 16:03:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757347401;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757347401;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-08 16:03:23", "2025-09-08 16:03:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10151", "wpforms_process_forms_locator_save", "complete", "2025-09-07 16:03:21", "2025-09-07 16:03:21", "10", "{\"tasks_meta_id\":269}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-07 16:03:21", "2025-09-07 16:03:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10152", "wpforms_process_forms_locator_scan", "complete", "2025-09-08 16:03:21", "2025-09-08 16:03:21", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757347401;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757347401;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-08 16:03:23", "2025-09-08 16:03:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10153", "wpforms_process_purge_spam", "complete", "2025-09-08 16:03:21", "2025-09-08 16:03:21", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757347401;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757347401;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-08 16:03:23", "2025-09-08 16:03:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10188", "woocommerce_cleanup_draft_orders", "complete", "2025-09-09 16:03:23", "2025-09-09 16:03:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757433803;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757433803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-09 16:23:05", "2025-09-09 16:23:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10189", "wpforms_process_forms_locator_save", "complete", "2025-09-08 16:03:23", "2025-09-08 16:03:23", "10", "{\"tasks_meta_id\":270}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-08 16:03:23", "2025-09-08 16:03:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10190", "wpforms_process_forms_locator_scan", "complete", "2025-09-09 16:03:23", "2025-09-09 16:03:23", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757433803;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757433803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-09 16:23:05", "2025-09-09 16:23:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10191", "wpforms_process_purge_spam", "complete", "2025-09-09 16:03:23", "2025-09-09 16:03:23", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757433803;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757433803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-09 16:23:05", "2025-09-09 16:23:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10231", "woocommerce_cleanup_draft_orders", "complete", "2025-09-10 16:23:05", "2025-09-10 16:23:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757521385;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757521385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-10 16:33:47", "2025-09-10 16:33:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10232", "wpforms_process_forms_locator_save", "complete", "2025-09-09 16:23:05", "2025-09-09 16:23:05", "10", "{\"tasks_meta_id\":271}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-09 16:23:05", "2025-09-09 16:23:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10233", "wpforms_process_forms_locator_scan", "complete", "2025-09-10 16:23:05", "2025-09-10 16:23:05", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757521385;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757521385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-10 16:33:47", "2025-09-10 16:33:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10234", "wpforms_process_purge_spam", "complete", "2025-09-10 16:23:05", "2025-09-10 16:23:05", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757521385;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757521385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-10 16:33:47", "2025-09-10 16:33:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10271", "woocommerce_cleanup_draft_orders", "complete", "2025-09-11 16:33:47", "2025-09-11 16:33:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757608427;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757608427;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-11 16:40:15", "2025-09-11 16:40:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10272", "wpforms_process_forms_locator_save", "complete", "2025-09-10 16:33:47", "2025-09-10 16:33:47", "10", "{\"tasks_meta_id\":272}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-10 16:33:47", "2025-09-10 16:33:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10273", "wpforms_process_forms_locator_scan", "complete", "2025-09-11 16:33:47", "2025-09-11 16:33:47", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757608427;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757608427;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-11 16:40:15", "2025-09-11 16:40:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10274", "wpforms_process_purge_spam", "complete", "2025-09-11 16:33:47", "2025-09-11 16:33:47", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757608427;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757608427;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-11 16:40:15", "2025-09-11 16:40:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10311", "woocommerce_cleanup_draft_orders", "complete", "2025-09-12 16:40:15", "2025-09-12 16:40:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757695215;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757695215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-12 17:24:33", "2025-09-12 17:24:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10312", "wpforms_process_forms_locator_save", "complete", "2025-09-11 16:40:15", "2025-09-11 16:40:15", "10", "{\"tasks_meta_id\":273}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-11 16:40:15", "2025-09-11 16:40:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10313", "wpforms_process_forms_locator_scan", "complete", "2025-09-12 16:40:15", "2025-09-12 16:40:15", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757695215;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757695215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-12 17:24:33", "2025-09-12 17:24:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10314", "wpforms_process_purge_spam", "complete", "2025-09-12 16:40:15", "2025-09-12 16:40:15", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757695215;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757695215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-12 17:24:33", "2025-09-12 17:24:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10339", "wpforms_admin_addons_cache_update", "complete", "2025-09-19 06:50:08", "2025-09-19 06:50:08", "10", "{\"tasks_meta_id\":25}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758264608;s:18:\"\0*\0first_timestamp\";i:1737046826;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758264608;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-09-19 07:19:56", "2025-09-19 07:19:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10340", "wpforms_builder_help_cache_update", "complete", "2025-09-19 06:50:08", "2025-09-19 06:50:08", "10", "{\"tasks_meta_id\":26}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758264608;s:18:\"\0*\0first_timestamp\";i:1737046829;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758264608;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-09-19 07:19:56", "2025-09-19 07:19:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10341", "wpforms_admin_builder_templates_cache_update", "complete", "2025-09-19 06:50:08", "2025-09-19 06:50:08", "10", "{\"tasks_meta_id\":27}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758264608;s:18:\"\0*\0first_timestamp\";i:1737046829;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758264608;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-09-19 07:19:56", "2025-09-19 07:19:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10358", "woocommerce_cleanup_draft_orders", "complete", "2025-09-13 17:24:33", "2025-09-13 17:24:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757784273;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757784273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-13 17:35:01", "2025-09-13 17:35:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10359", "wpforms_process_forms_locator_save", "complete", "2025-09-12 17:24:33", "2025-09-12 17:24:33", "10", "{\"tasks_meta_id\":274}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-12 17:24:33", "2025-09-12 17:24:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10360", "wpforms_process_forms_locator_scan", "complete", "2025-09-13 17:24:33", "2025-09-13 17:24:33", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757784273;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757784273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-13 17:35:01", "2025-09-13 17:35:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10361", "wpforms_process_purge_spam", "complete", "2025-09-13 17:24:33", "2025-09-13 17:24:33", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757784273;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757784273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-13 17:35:01", "2025-09-13 17:35:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10393", "woocommerce_cleanup_draft_orders", "complete", "2025-09-14 17:35:01", "2025-09-14 17:35:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757871301;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757871301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-14 19:09:44", "2025-09-14 19:09:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10394", "wpforms_process_forms_locator_save", "complete", "2025-09-13 17:35:01", "2025-09-13 17:35:01", "10", "{\"tasks_meta_id\":275}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-13 17:35:01", "2025-09-13 17:35:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10395", "wpforms_process_forms_locator_scan", "complete", "2025-09-14 17:35:01", "2025-09-14 17:35:01", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757871301;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757871301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-14 19:09:44", "2025-09-14 19:09:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10396", "wpforms_process_purge_spam", "complete", "2025-09-14 17:35:01", "2025-09-14 17:35:01", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757871301;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757871301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-14 19:09:44", "2025-09-14 19:09:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10447", "woocommerce_cleanup_draft_orders", "complete", "2025-09-15 19:09:44", "2025-09-15 19:09:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757963384;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757963384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-15 19:18:33", "2025-09-15 19:18:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10448", "wpforms_process_forms_locator_save", "complete", "2025-09-14 19:09:44", "2025-09-14 19:09:44", "10", "{\"tasks_meta_id\":276}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-14 19:09:44", "2025-09-14 19:09:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10449", "wpforms_process_forms_locator_scan", "complete", "2025-09-15 19:09:44", "2025-09-15 19:09:44", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757963384;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757963384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-15 19:18:33", "2025-09-15 19:18:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10450", "wpforms_process_purge_spam", "complete", "2025-09-15 19:09:44", "2025-09-15 19:09:44", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757963384;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757963384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-15 19:18:33", "2025-09-15 19:18:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10480", "woocommerce_cleanup_draft_orders", "complete", "2025-09-16 19:18:33", "2025-09-16 19:18:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758050313;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758050313;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-16 19:41:57", "2025-09-16 19:41:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10481", "wpforms_process_forms_locator_save", "complete", "2025-09-15 19:18:33", "2025-09-15 19:18:33", "10", "{\"tasks_meta_id\":277}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-15 19:18:33", "2025-09-15 19:18:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10482", "wpforms_process_forms_locator_scan", "complete", "2025-09-16 19:18:33", "2025-09-16 19:18:33", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758050313;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758050313;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-16 19:41:57", "2025-09-16 19:41:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10483", "wpforms_process_purge_spam", "complete", "2025-09-16 19:18:33", "2025-09-16 19:18:33", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758050313;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758050313;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-16 19:41:57", "2025-09-16 19:41:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10515", "woocommerce_cleanup_draft_orders", "complete", "2025-09-17 19:41:57", "2025-09-17 19:41:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758138117;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758138117;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-17 20:29:00", "2025-09-17 20:29:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10516", "wpforms_process_forms_locator_save", "complete", "2025-09-16 19:41:57", "2025-09-16 19:41:57", "10", "{\"tasks_meta_id\":278}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-16 19:41:57", "2025-09-16 19:41:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10517", "wpforms_process_forms_locator_scan", "complete", "2025-09-17 19:41:57", "2025-09-17 19:41:57", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758138117;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758138117;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-17 20:29:00", "2025-09-17 20:29:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10518", "wpforms_process_purge_spam", "complete", "2025-09-17 19:41:57", "2025-09-17 19:41:57", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758138117;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758138117;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-17 20:29:00", "2025-09-17 20:29:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10551", "woocommerce_cleanup_draft_orders", "complete", "2025-09-18 20:29:00", "2025-09-18 20:29:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758227340;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758227340;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-18 21:14:09", "2025-09-18 21:14:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10552", "wpforms_process_forms_locator_save", "complete", "2025-09-17 20:29:00", "2025-09-17 20:29:00", "10", "{\"tasks_meta_id\":279}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-17 20:29:00", "2025-09-17 20:29:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10553", "wpforms_process_forms_locator_scan", "complete", "2025-09-18 20:29:00", "2025-09-18 20:29:00", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758227340;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758227340;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-18 21:14:09", "2025-09-18 21:14:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10554", "wpforms_process_purge_spam", "complete", "2025-09-18 20:29:00", "2025-09-18 20:29:00", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758227340;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758227340;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-18 21:14:09", "2025-09-18 21:14:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10588", "woocommerce_cleanup_draft_orders", "complete", "2025-09-19 21:14:09", "2025-09-19 21:14:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758316449;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758316449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-19 22:10:37", "2025-09-19 22:10:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10589", "wpforms_process_forms_locator_save", "complete", "2025-09-18 21:14:09", "2025-09-18 21:14:09", "10", "{\"tasks_meta_id\":280}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-18 21:14:09", "2025-09-18 21:14:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10590", "wpforms_process_forms_locator_scan", "complete", "2025-09-19 21:14:09", "2025-09-19 21:14:09", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758316449;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758316449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-19 22:10:37", "2025-09-19 22:10:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10591", "wpforms_process_purge_spam", "complete", "2025-09-19 21:14:09", "2025-09-19 21:14:09", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758316449;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758316449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-19 22:10:37", "2025-09-19 22:10:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10604", "wpforms_admin_addons_cache_update", "complete", "2025-09-26 07:19:56", "2025-09-26 07:19:56", "10", "{\"tasks_meta_id\":25}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758871196;s:18:\"\0*\0first_timestamp\";i:1737046826;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758871196;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-09-26 07:26:17", "2025-09-26 07:26:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10605", "wpforms_builder_help_cache_update", "complete", "2025-09-26 07:19:56", "2025-09-26 07:19:56", "10", "{\"tasks_meta_id\":26}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758871196;s:18:\"\0*\0first_timestamp\";i:1737046829;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758871196;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-09-26 07:26:17", "2025-09-26 07:26:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10606", "wpforms_admin_builder_templates_cache_update", "complete", "2025-09-26 07:19:56", "2025-09-26 07:19:56", "10", "{\"tasks_meta_id\":27}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758871196;s:18:\"\0*\0first_timestamp\";i:1737046829;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758871196;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-09-26 07:26:17", "2025-09-26 07:26:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10630", "woocommerce_cleanup_draft_orders", "complete", "2025-09-20 22:10:37", "2025-09-20 22:10:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758406237;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758406237;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-20 22:16:13", "2025-09-20 22:16:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10631", "wpforms_process_forms_locator_save", "complete", "2025-09-19 22:10:37", "2025-09-19 22:10:37", "10", "{\"tasks_meta_id\":281}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-19 22:10:37", "2025-09-19 22:10:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10632", "wpforms_process_forms_locator_scan", "complete", "2025-09-20 22:10:37", "2025-09-20 22:10:37", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758406237;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758406237;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-20 22:16:13", "2025-09-20 22:16:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10633", "wpforms_process_purge_spam", "complete", "2025-09-20 22:10:37", "2025-09-20 22:10:37", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758406237;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758406237;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-20 22:16:13", "2025-09-20 22:16:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10671", "woocommerce_cleanup_draft_orders", "complete", "2025-09-21 22:16:13", "2025-09-21 22:16:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758492973;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758492973;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-21 23:05:39", "2025-09-21 23:05:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10672", "wpforms_process_forms_locator_save", "complete", "2025-09-20 22:16:13", "2025-09-20 22:16:13", "10", "{\"tasks_meta_id\":282}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-20 22:16:13", "2025-09-20 22:16:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10673", "wpforms_process_forms_locator_scan", "complete", "2025-09-21 22:16:13", "2025-09-21 22:16:13", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758492973;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758492973;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-21 23:05:39", "2025-09-21 23:05:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10674", "wpforms_process_purge_spam", "complete", "2025-09-21 22:16:13", "2025-09-21 22:16:13", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758492973;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758492973;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-21 23:05:39", "2025-09-21 23:05:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10703", "woocommerce_cleanup_draft_orders", "complete", "2025-09-22 23:05:39", "2025-09-22 23:05:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758582339;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758582339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-22 23:52:38", "2025-09-22 23:52:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10704", "wpforms_process_forms_locator_save", "complete", "2025-09-21 23:05:39", "2025-09-21 23:05:39", "10", "{\"tasks_meta_id\":283}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-21 23:05:39", "2025-09-21 23:05:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10705", "wpforms_process_forms_locator_scan", "complete", "2025-09-22 23:05:39", "2025-09-22 23:05:39", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758582339;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758582339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-22 23:52:38", "2025-09-22 23:52:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10706", "wpforms_process_purge_spam", "complete", "2025-09-22 23:05:39", "2025-09-22 23:05:39", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758582339;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758582339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-22 23:52:38", "2025-09-22 23:52:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10734", "aioseo_report_summary", "complete", "2025-09-29 21:55:08", "2025-09-29 21:55:08", "10", "{\"frequency\":\"weekly\"}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759182908;s:18:\"\0*\0first_timestamp\";i:1735538400;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759182908;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "1", "1", "2028-03-10 04:29:15", "2028-03-10 04:29:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10739", "woocommerce_cleanup_draft_orders", "complete", "2025-09-23 23:52:38", "2025-09-23 23:52:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758671558;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758671558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-24 00:41:22", "2025-09-24 00:41:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10740", "wpforms_process_forms_locator_save", "complete", "2025-09-22 23:52:38", "2025-09-22 23:52:38", "10", "{\"tasks_meta_id\":284}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-22 23:52:38", "2025-09-22 23:52:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10741", "wpforms_process_forms_locator_scan", "complete", "2025-09-23 23:52:38", "2025-09-23 23:52:38", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758671558;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758671558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-24 00:41:22", "2025-09-24 00:41:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10742", "wpforms_process_purge_spam", "complete", "2025-09-23 23:52:38", "2025-09-23 23:52:38", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758671558;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758671558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-24 00:41:22", "2025-09-24 00:41:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10768", "woocommerce_cleanup_draft_orders", "complete", "2025-09-25 00:41:22", "2025-09-25 00:41:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758760882;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758760882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-25 01:44:24", "2025-09-25 01:44:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10769", "wpforms_process_forms_locator_save", "complete", "2025-09-24 00:41:22", "2025-09-24 00:41:22", "10", "{\"tasks_meta_id\":285}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-24 00:41:22", "2025-09-24 00:41:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10770", "wpforms_process_forms_locator_scan", "complete", "2025-09-25 00:41:22", "2025-09-25 00:41:22", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758760882;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758760882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-25 01:44:24", "2025-09-25 01:44:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10771", "wpforms_process_purge_spam", "complete", "2025-09-25 00:41:22", "2025-09-25 00:41:22", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758760882;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758760882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-25 01:44:24", "2025-09-25 01:44:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10799", "woocommerce_cleanup_draft_orders", "complete", "2025-09-26 01:44:24", "2025-09-26 01:44:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758851064;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758851064;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-26 01:52:36", "2025-09-26 01:52:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10800", "wpforms_process_forms_locator_save", "complete", "2025-09-25 01:44:24", "2025-09-25 01:44:24", "10", "{\"tasks_meta_id\":286}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-25 01:44:24", "2025-09-25 01:44:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10801", "wpforms_process_forms_locator_scan", "complete", "2025-09-26 01:44:24", "2025-09-26 01:44:24", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758851064;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758851064;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-26 01:52:36", "2025-09-26 01:52:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10802", "wpforms_process_purge_spam", "complete", "2025-09-26 01:44:24", "2025-09-26 01:44:24", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758851064;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758851064;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-26 01:52:36", "2025-09-26 01:52:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10835", "woocommerce_cleanup_draft_orders", "complete", "2025-09-27 01:52:36", "2025-09-27 01:52:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758937956;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758937956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-27 02:22:49", "2025-09-27 02:22:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10836", "wpforms_process_forms_locator_save", "complete", "2025-09-26 01:52:36", "2025-09-26 01:52:36", "10", "{\"tasks_meta_id\":287}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-26 01:52:36", "2025-09-26 01:52:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10837", "wpforms_process_forms_locator_scan", "complete", "2025-09-27 01:52:36", "2025-09-27 01:52:36", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758937956;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758937956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-27 02:22:49", "2025-09-27 02:22:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10838", "wpforms_process_purge_spam", "complete", "2025-09-27 01:52:36", "2025-09-27 01:52:36", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758937956;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758937956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-09-27 02:22:49", "2025-09-27 02:22:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10850", "wpforms_admin_addons_cache_update", "complete", "2025-10-03 07:26:17", "2025-10-03 07:26:17", "10", "{\"tasks_meta_id\":25}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759476377;s:18:\"\0*\0first_timestamp\";i:1737046826;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759476377;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2028-03-10 04:29:15", "2028-03-10 04:29:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10851", "wpforms_builder_help_cache_update", "complete", "2025-10-03 07:26:17", "2025-10-03 07:26:17", "10", "{\"tasks_meta_id\":26}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759476377;s:18:\"\0*\0first_timestamp\";i:1737046829;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759476377;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2028-03-10 04:29:15", "2028-03-10 04:29:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10852", "wpforms_admin_builder_templates_cache_update", "complete", "2025-10-03 07:26:17", "2025-10-03 07:26:17", "10", "{\"tasks_meta_id\":27}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759476377;s:18:\"\0*\0first_timestamp\";i:1737046829;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759476377;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2028-03-10 04:29:15", "2028-03-10 04:29:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10885", "aioseo_cache_prune", "complete", "2025-09-28 02:22:49", "2025-09-28 02:22:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759026169;s:18:\"\0*\0first_timestamp\";i:1735061356;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759026169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2028-03-10 04:29:15", "2028-03-10 04:29:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10886", "woocommerce_cleanup_draft_orders", "complete", "2025-09-28 02:22:49", "2025-09-28 02:22:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759026169;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759026169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2028-03-10 04:29:15", "2028-03-10 04:29:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10887", "wpforms_process_forms_locator_save", "complete", "2025-09-27 02:22:49", "2025-09-27 02:22:49", "10", "{\"tasks_meta_id\":288}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-09-27 02:22:49", "2025-09-27 02:22:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10888", "wpforms_process_forms_locator_scan", "complete", "2025-09-28 02:22:49", "2025-09-28 02:22:49", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759026169;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759026169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2028-03-10 04:29:15", "2028-03-10 04:29:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10889", "wpforms_process_purge_spam", "complete", "2025-09-28 02:22:49", "2025-09-28 02:22:49", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759026169;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759026169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2028-03-10 04:29:15", "2028-03-10 04:29:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10915", "aioseo_image_sitemap_scan", "complete", "2025-09-27 22:49:40", "2025-09-27 22:49:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759013380;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759013380;}", "1", "1", "2028-03-10 04:29:15", "2028-03-10 04:29:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10916", "aioseo_image_sitemap_scan", "pending", "2028-03-10 04:44:15", "2028-03-10 04:44:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1836276255;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1836276255;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10917", "aioseo_cache_prune", "pending", "2028-03-11 04:29:15", "2028-03-11 04:29:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1836361755;s:18:\"\0*\0first_timestamp\";i:1735061356;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1836361755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10918", "woocommerce_cleanup_draft_orders", "pending", "2028-03-11 04:29:15", "2028-03-11 04:29:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1836361755;s:18:\"\0*\0first_timestamp\";i:1735061358;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1836361755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10919", "wpforms_process_forms_locator_save", "complete", "2028-03-10 04:29:15", "2028-03-10 04:29:15", "10", "{\"tasks_meta_id\":289}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2028-03-10 04:29:15", "2028-03-10 04:29:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10920", "wpforms_process_forms_locator_scan", "pending", "2028-03-11 04:29:15", "2028-03-11 04:29:15", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1836361755;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1836361755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10921", "wpforms_process_purge_spam", "pending", "2028-03-11 04:29:15", "2028-03-11 04:29:15", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1836361755;s:18:\"\0*\0first_timestamp\";i:1735061445;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1836361755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10922", "aioseo_report_summary", "pending", "2028-03-17 04:29:15", "2028-03-17 04:29:15", "10", "{\"frequency\":\"weekly\"}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1836880155;s:18:\"\0*\0first_timestamp\";i:1735538400;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1836880155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10923", "aioseo_report_summary", "pending", "2028-04-09 04:29:15", "2028-04-09 04:29:15", "10", "{\"frequency\":\"monthly\"}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1838867355;s:18:\"\0*\0first_timestamp\";i:1735884000;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1838867355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10924", "wpforms_admin_addons_cache_update", "pending", "2028-03-17 04:29:15", "2028-03-17 04:29:15", "10", "{\"tasks_meta_id\":25}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1836880155;s:18:\"\0*\0first_timestamp\";i:1737046826;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1836880155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10925", "wpforms_builder_help_cache_update", "pending", "2028-03-17 04:29:15", "2028-03-17 04:29:15", "10", "{\"tasks_meta_id\":26}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1836880155;s:18:\"\0*\0first_timestamp\";i:1737046829;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1836880155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10926", "wpforms_admin_builder_templates_cache_update", "pending", "2028-03-17 04:29:15", "2028-03-17 04:29:15", "10", "{\"tasks_meta_id\":27}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1836880155;s:18:\"\0*\0first_timestamp\";i:1737046829;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1836880155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10927", "aioseo_admin_notifications_update", "complete", "2028-03-10 04:29:18", "2028-03-10 04:29:18", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "1", "1", "2028-03-10 04:29:19", "2028-03-10 04:29:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("10928", "wpforms_admin_notifications_update", "pending", "2025-11-06 03:19:33", "2025-11-06 03:19:33", "10", "{\"tasks_meta_id\":290}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "aioseo");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "wpforms");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "woocommerce-db-updates");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("32", "26", "acção criada", "2024-12-24 17:30:45", "2024-12-24 17:30:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("37", "30", "acção criada", "2024-12-24 17:30:45", "2024-12-24 17:30:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("50", "26", "action started via WP Cron", "2024-12-24 17:32:04", "2024-12-24 17:32:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("51", "26", "acção falhada via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-12-24 17:32:04", "2024-12-24 17:32:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("673", "30", "action started via WP Cron", "2024-12-27 21:38:59", "2024-12-27 21:38:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("674", "30", "acção falhada via WP Cron: Scheduled action for wpforms_email_summaries_fetch_info_blocks will not be executed as no callbacks are registered.", "2024-12-27 21:38:59", "2024-12-27 21:38:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("675", "242", "acção criada", "2024-12-27 21:38:59", "2024-12-27 21:38:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1411", "242", "action started via WP Cron", "2025-01-03 23:05:41", "2025-01-03 23:05:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1412", "242", "acção falhada via WP Cron: Scheduled action for wpforms_email_summaries_fetch_info_blocks will not be executed as no callbacks are registered.", "2025-01-03 23:05:41", "2025-01-03 23:05:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1413", "488", "acção criada", "2025-01-03 23:05:41", "2025-01-03 23:05:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2319", "488", "action started via WP Cron", "2025-01-11 00:36:24", "2025-01-11 00:36:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2320", "488", "acção falhada via WP Cron: Scheduled action for wpforms_email_summaries_fetch_info_blocks will not be executed as no callbacks are registered.", "2025-01-11 00:36:24", "2025-01-11 00:36:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2321", "792", "acção criada", "2025-01-11 00:36:24", "2025-01-11 00:36:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3066", "792", "action started via WP Cron", "2025-01-18 01:07:51", "2025-01-18 01:07:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3067", "792", "acção falhada via WP Cron: Scheduled action for wpforms_email_summaries_fetch_info_blocks will not be executed as no callbacks are registered.", "2025-01-18 01:07:51", "2025-01-18 01:07:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3068", "1041", "acção criada", "2025-01-18 01:07:51", "2025-01-18 01:07:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3678", "1041", "action started via WP Cron", "2025-01-25 01:19:55", "2025-01-25 01:19:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3679", "1041", "acção falhada via WP Cron: Scheduled action for wpforms_email_summaries_fetch_info_blocks will not be executed as no callbacks are registered.", "2025-01-25 01:19:55", "2025-01-25 01:19:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3680", "1041", "This action appears to be consistently failing. A new instance will not be scheduled.", "2025-01-25 01:19:55", "2025-01-25 01:19:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("29528", "9860", "acção criada", "2025-08-31 09:37:25", "2025-08-31 09:37:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("30078", "10044", "acção criada", "2025-09-04 14:59:13", "2025-09-04 14:59:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("30146", "10066", "acção criada", "2025-09-05 06:33:50", "2025-09-05 06:33:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("30149", "10067", "acção criada", "2025-09-05 06:33:50", "2025-09-05 06:33:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("30152", "10068", "acção criada", "2025-09-05 06:33:51", "2025-09-05 06:33:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("30179", "10077", "acção criada", "2025-09-05 15:37:56", "2025-09-05 15:37:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("30181", "10078", "acção criada", "2025-09-05 15:37:56", "2025-09-05 15:37:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("30183", "10079", "acção criada", "2025-09-05 15:37:56", "2025-09-05 15:37:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("30184", "10044", "action started via WP Cron", "2025-09-05 15:37:56", "2025-09-05 15:37:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("30185", "10044", "acção concluída via WP Cron", "2025-09-05 15:37:56", "2025-09-05 15:37:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("30186", "10080", "acção criada", "2025-09-05 15:37:56", "2025-09-05 15:37:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("30187", "10078", "action started via WP Cron", "2025-09-05 15:37:56", "2025-09-05 15:37:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("30188", "10078", "acção concluída via WP Cron", "2025-09-05 15:37:56", "2025-09-05 15:37:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("30282", "10077", "action started via WP Cron", "2025-09-06 15:49:19", "2025-09-06 15:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("30283", "10077", "acção concluída via WP Cron", "2025-09-06 15:49:19", "2025-09-06 15:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("30284", "10112", "acção criada", "2025-09-06 15:49:19", "2025-09-06 15:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("30285", "10079", "action started via WP Cron", "2025-09-06 15:49:19", "2025-09-06 15:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("30286", "10113", "acção criada", "2025-09-06 15:49:19", "2025-09-06 15:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("30287", "10079", "acção concluída via WP Cron", "2025-09-06 15:49:19", "2025-09-06 15:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("30288", "10114", "acção criada", "2025-09-06 15:49:19", "2025-09-06 15:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("30289", "10080", "action started via WP Cron", "2025-09-06 15:49:19", "2025-09-06 15:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("30290", "10080", "acção concluída via WP Cron", "2025-09-06 15:49:19", "2025-09-06 15:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("30291", "10115", "acção criada", "2025-09-06 15:49:19", "2025-09-06 15:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("30292", "10113", "action started via WP Cron", "2025-09-06 15:49:19", "2025-09-06 15:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("30293", "10113", "acção concluída via WP Cron", "2025-09-06 15:49:19", "2025-09-06 15:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("30396", "10112", "action started via WP Cron", "2025-09-07 16:03:21", "2025-09-07 16:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("30397", "10112", "acção concluída via WP Cron", "2025-09-07 16:03:21", "2025-09-07 16:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("30398", "10150", "acção criada", "2025-09-07 16:03:21", "2025-09-07 16:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("30399", "10114", "action started via WP Cron", "2025-09-07 16:03:21", "2025-09-07 16:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("30400", "10151", "acção criada", "2025-09-07 16:03:21", "2025-09-07 16:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("30401", "10114", "acção concluída via WP Cron", "2025-09-07 16:03:21", "2025-09-07 16:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("30402", "10152", "acção criada", "2025-09-07 16:03:21", "2025-09-07 16:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("30403", "10115", "action started via WP Cron", "2025-09-07 16:03:21", "2025-09-07 16:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("30404", "10115", "acção concluída via WP Cron", "2025-09-07 16:03:21", "2025-09-07 16:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("30405", "10153", "acção criada", "2025-09-07 16:03:21", "2025-09-07 16:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("30406", "10151", "action started via WP Cron", "2025-09-07 16:03:21", "2025-09-07 16:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("30407", "10151", "acção concluída via WP Cron", "2025-09-07 16:03:21", "2025-09-07 16:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("30510", "10150", "action started via WP Cron", "2025-09-08 16:03:23", "2025-09-08 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("30511", "10150", "acção concluída via WP Cron", "2025-09-08 16:03:23", "2025-09-08 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("30512", "10188", "acção criada", "2025-09-08 16:03:23", "2025-09-08 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("30513", "10152", "action started via WP Cron", "2025-09-08 16:03:23", "2025-09-08 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("30514", "10189", "acção criada", "2025-09-08 16:03:23", "2025-09-08 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("30515", "10152", "acção concluída via WP Cron", "2025-09-08 16:03:23", "2025-09-08 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("30516", "10190", "acção criada", "2025-09-08 16:03:23", "2025-09-08 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("30517", "10153", "action started via WP Cron", "2025-09-08 16:03:23", "2025-09-08 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("30518", "10153", "acção concluída via WP Cron", "2025-09-08 16:03:23", "2025-09-08 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("30519", "10191", "acção criada", "2025-09-08 16:03:23", "2025-09-08 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("30520", "10189", "action started via WP Cron", "2025-09-08 16:03:23", "2025-09-08 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("30521", "10189", "acção concluída via WP Cron", "2025-09-08 16:03:23", "2025-09-08 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("30639", "10188", "action started via WP Cron", "2025-09-09 16:23:05", "2025-09-09 16:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("30640", "10188", "acção concluída via WP Cron", "2025-09-09 16:23:05", "2025-09-09 16:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("30641", "10231", "acção criada", "2025-09-09 16:23:05", "2025-09-09 16:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("30642", "10190", "action started via WP Cron", "2025-09-09 16:23:05", "2025-09-09 16:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("30643", "10232", "acção criada", "2025-09-09 16:23:05", "2025-09-09 16:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("30644", "10190", "acção concluída via WP Cron", "2025-09-09 16:23:05", "2025-09-09 16:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("30645", "10233", "acção criada", "2025-09-09 16:23:05", "2025-09-09 16:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("30646", "10191", "action started via WP Cron", "2025-09-09 16:23:05", "2025-09-09 16:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("30647", "10191", "acção concluída via WP Cron", "2025-09-09 16:23:05", "2025-09-09 16:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("30648", "10234", "acção criada", "2025-09-09 16:23:05", "2025-09-09 16:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("30649", "10232", "action started via WP Cron", "2025-09-09 16:23:05", "2025-09-09 16:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("30650", "10232", "acção concluída via WP Cron", "2025-09-09 16:23:05", "2025-09-09 16:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("30759", "10231", "action started via WP Cron", "2025-09-10 16:33:47", "2025-09-10 16:33:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("30760", "10231", "acção concluída via WP Cron", "2025-09-10 16:33:47", "2025-09-10 16:33:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("30761", "10271", "acção criada", "2025-09-10 16:33:47", "2025-09-10 16:33:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("30762", "10233", "action started via WP Cron", "2025-09-10 16:33:47", "2025-09-10 16:33:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("30763", "10272", "acção criada", "2025-09-10 16:33:47", "2025-09-10 16:33:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("30764", "10233", "acção concluída via WP Cron", "2025-09-10 16:33:47", "2025-09-10 16:33:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("30765", "10273", "acção criada", "2025-09-10 16:33:47", "2025-09-10 16:33:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("30766", "10234", "action started via WP Cron", "2025-09-10 16:33:47", "2025-09-10 16:33:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("30767", "10234", "acção concluída via WP Cron", "2025-09-10 16:33:47", "2025-09-10 16:33:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("30768", "10274", "acção criada", "2025-09-10 16:33:47", "2025-09-10 16:33:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("30769", "10272", "action started via WP Cron", "2025-09-10 16:33:47", "2025-09-10 16:33:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("30770", "10272", "acção concluída via WP Cron", "2025-09-10 16:33:47", "2025-09-10 16:33:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("30879", "10271", "action started via WP Cron", "2025-09-11 16:40:15", "2025-09-11 16:40:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("30880", "10271", "acção concluída via WP Cron", "2025-09-11 16:40:15", "2025-09-11 16:40:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("30881", "10311", "acção criada", "2025-09-11 16:40:15", "2025-09-11 16:40:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("30882", "10273", "action started via WP Cron", "2025-09-11 16:40:15", "2025-09-11 16:40:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("30883", "10312", "acção criada", "2025-09-11 16:40:15", "2025-09-11 16:40:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("30884", "10273", "acção concluída via WP Cron", "2025-09-11 16:40:15", "2025-09-11 16:40:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("30885", "10313", "acção criada", "2025-09-11 16:40:15", "2025-09-11 16:40:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("30886", "10274", "action started via WP Cron", "2025-09-11 16:40:15", "2025-09-11 16:40:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("30887", "10274", "acção concluída via WP Cron", "2025-09-11 16:40:15", "2025-09-11 16:40:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("30888", "10314", "acção criada", "2025-09-11 16:40:15", "2025-09-11 16:40:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("30892", "10312", "action started via WP Cron", "2025-09-11 16:40:15", "2025-09-11 16:40:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("30893", "10312", "acção concluída via WP Cron", "2025-09-11 16:40:15", "2025-09-11 16:40:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("30963", "10066", "action started via WP Cron", "2025-09-12 06:50:08", "2025-09-12 06:50:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("30964", "10066", "acção concluída via WP Cron", "2025-09-12 06:50:08", "2025-09-12 06:50:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("30965", "10339", "acção criada", "2025-09-12 06:50:08", "2025-09-12 06:50:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("30966", "10067", "action started via WP Cron", "2025-09-12 06:50:08", "2025-09-12 06:50:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("30967", "10067", "acção concluída via WP Cron", "2025-09-12 06:50:08", "2025-09-12 06:50:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("30968", "10340", "acção criada", "2025-09-12 06:50:08", "2025-09-12 06:50:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("30969", "10068", "action started via WP Cron", "2025-09-12 06:50:08", "2025-09-12 06:50:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("30970", "10068", "acção concluída via WP Cron", "2025-09-12 06:50:08", "2025-09-12 06:50:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("30971", "10341", "acção criada", "2025-09-12 06:50:08", "2025-09-12 06:50:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("31020", "10311", "action started via WP Cron", "2025-09-12 17:24:33", "2025-09-12 17:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31021", "10311", "acção concluída via WP Cron", "2025-09-12 17:24:33", "2025-09-12 17:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31022", "10358", "acção criada", "2025-09-12 17:24:33", "2025-09-12 17:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31023", "10313", "action started via WP Cron", "2025-09-12 17:24:33", "2025-09-12 17:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31024", "10359", "acção criada", "2025-09-12 17:24:33", "2025-09-12 17:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31025", "10313", "acção concluída via WP Cron", "2025-09-12 17:24:33", "2025-09-12 17:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31026", "10360", "acção criada", "2025-09-12 17:24:33", "2025-09-12 17:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31027", "10314", "action started via WP Cron", "2025-09-12 17:24:33", "2025-09-12 17:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31028", "10314", "acção concluída via WP Cron", "2025-09-12 17:24:33", "2025-09-12 17:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31029", "10361", "acção criada", "2025-09-12 17:24:33", "2025-09-12 17:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31030", "10359", "action started via WP Cron", "2025-09-12 17:24:33", "2025-09-12 17:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31031", "10359", "acção concluída via WP Cron", "2025-09-12 17:24:33", "2025-09-12 17:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31125", "10358", "action started via WP Cron", "2025-09-13 17:35:01", "2025-09-13 17:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("31126", "10358", "acção concluída via WP Cron", "2025-09-13 17:35:01", "2025-09-13 17:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("31127", "10393", "acção criada", "2025-09-13 17:35:01", "2025-09-13 17:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("31128", "10360", "action started via WP Cron", "2025-09-13 17:35:01", "2025-09-13 17:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("31129", "10394", "acção criada", "2025-09-13 17:35:01", "2025-09-13 17:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("31130", "10360", "acção concluída via WP Cron", "2025-09-13 17:35:01", "2025-09-13 17:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("31131", "10395", "acção criada", "2025-09-13 17:35:01", "2025-09-13 17:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("31132", "10361", "action started via WP Cron", "2025-09-13 17:35:01", "2025-09-13 17:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("31133", "10361", "acção concluída via WP Cron", "2025-09-13 17:35:01", "2025-09-13 17:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("31134", "10396", "acção criada", "2025-09-13 17:35:01", "2025-09-13 17:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("31135", "10394", "action started via WP Cron", "2025-09-13 17:35:01", "2025-09-13 17:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("31136", "10394", "acção concluída via WP Cron", "2025-09-13 17:35:01", "2025-09-13 17:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("31287", "10393", "action started via WP Cron", "2025-09-14 19:09:44", "2025-09-14 19:09:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31288", "10393", "acção concluída via WP Cron", "2025-09-14 19:09:44", "2025-09-14 19:09:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31289", "10447", "acção criada", "2025-09-14 19:09:44", "2025-09-14 19:09:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31290", "10395", "action started via WP Cron", "2025-09-14 19:09:44", "2025-09-14 19:09:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31291", "10448", "acção criada", "2025-09-14 19:09:44", "2025-09-14 19:09:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31292", "10395", "acção concluída via WP Cron", "2025-09-14 19:09:44", "2025-09-14 19:09:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31293", "10449", "acção criada", "2025-09-14 19:09:44", "2025-09-14 19:09:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31294", "10396", "action started via WP Cron", "2025-09-14 19:09:44", "2025-09-14 19:09:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31295", "10396", "acção concluída via WP Cron", "2025-09-14 19:09:44", "2025-09-14 19:09:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31296", "10450", "acção criada", "2025-09-14 19:09:44", "2025-09-14 19:09:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31297", "10448", "action started via WP Cron", "2025-09-14 19:09:44", "2025-09-14 19:09:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31298", "10448", "acção concluída via WP Cron", "2025-09-14 19:09:44", "2025-09-14 19:09:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31386", "10447", "action started via WP Cron", "2025-09-15 19:18:33", "2025-09-15 19:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31387", "10447", "acção concluída via WP Cron", "2025-09-15 19:18:33", "2025-09-15 19:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31388", "10480", "acção criada", "2025-09-15 19:18:33", "2025-09-15 19:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31389", "10449", "action started via WP Cron", "2025-09-15 19:18:33", "2025-09-15 19:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31390", "10481", "acção criada", "2025-09-15 19:18:33", "2025-09-15 19:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31391", "10449", "acção concluída via WP Cron", "2025-09-15 19:18:33", "2025-09-15 19:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31392", "10482", "acção criada", "2025-09-15 19:18:33", "2025-09-15 19:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31393", "10450", "action started via WP Cron", "2025-09-15 19:18:33", "2025-09-15 19:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31394", "10450", "acção concluída via WP Cron", "2025-09-15 19:18:33", "2025-09-15 19:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31395", "10483", "acção criada", "2025-09-15 19:18:33", "2025-09-15 19:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31396", "10481", "action started via WP Cron", "2025-09-15 19:18:33", "2025-09-15 19:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31397", "10481", "acção concluída via WP Cron", "2025-09-15 19:18:33", "2025-09-15 19:18:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31491", "10480", "action started via WP Cron", "2025-09-16 19:41:57", "2025-09-16 19:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31492", "10480", "acção concluída via WP Cron", "2025-09-16 19:41:57", "2025-09-16 19:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31493", "10515", "acção criada", "2025-09-16 19:41:57", "2025-09-16 19:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31494", "10482", "action started via WP Cron", "2025-09-16 19:41:57", "2025-09-16 19:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31495", "10516", "acção criada", "2025-09-16 19:41:57", "2025-09-16 19:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31496", "10482", "acção concluída via WP Cron", "2025-09-16 19:41:57", "2025-09-16 19:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31497", "10517", "acção criada", "2025-09-16 19:41:57", "2025-09-16 19:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31498", "10483", "action started via WP Cron", "2025-09-16 19:41:57", "2025-09-16 19:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31499", "10483", "acção concluída via WP Cron", "2025-09-16 19:41:57", "2025-09-16 19:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31500", "10518", "acção criada", "2025-09-16 19:41:57", "2025-09-16 19:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31504", "10516", "action started via WP Cron", "2025-09-16 19:41:57", "2025-09-16 19:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31505", "10516", "acção concluída via WP Cron", "2025-09-16 19:41:57", "2025-09-16 19:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31599", "10515", "action started via WP Cron", "2025-09-17 20:29:00", "2025-09-17 20:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31600", "10515", "acção concluída via WP Cron", "2025-09-17 20:29:00", "2025-09-17 20:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31601", "10551", "acção criada", "2025-09-17 20:29:00", "2025-09-17 20:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31602", "10517", "action started via WP Cron", "2025-09-17 20:29:00", "2025-09-17 20:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31603", "10552", "acção criada", "2025-09-17 20:29:00", "2025-09-17 20:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31604", "10517", "acção concluída via WP Cron", "2025-09-17 20:29:00", "2025-09-17 20:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31605", "10553", "acção criada", "2025-09-17 20:29:00", "2025-09-17 20:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31606", "10518", "action started via WP Cron", "2025-09-17 20:29:00", "2025-09-17 20:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31607", "10518", "acção concluída via WP Cron", "2025-09-17 20:29:00", "2025-09-17 20:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31608", "10554", "acção criada", "2025-09-17 20:29:00", "2025-09-17 20:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31609", "10552", "action started via WP Cron", "2025-09-17 20:29:00", "2025-09-17 20:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31610", "10552", "acção concluída via WP Cron", "2025-09-17 20:29:00", "2025-09-17 20:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("31710", "10551", "action started via WP Cron", "2025-09-18 21:14:09", "2025-09-18 21:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("31711", "10551", "acção concluída via WP Cron", "2025-09-18 21:14:09", "2025-09-18 21:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("31712", "10588", "acção criada", "2025-09-18 21:14:09", "2025-09-18 21:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("31713", "10553", "action started via WP Cron", "2025-09-18 21:14:09", "2025-09-18 21:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("31714", "10589", "acção criada", "2025-09-18 21:14:09", "2025-09-18 21:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("31715", "10553", "acção concluída via WP Cron", "2025-09-18 21:14:09", "2025-09-18 21:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("31716", "10590", "acção criada", "2025-09-18 21:14:09", "2025-09-18 21:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("31717", "10554", "action started via WP Cron", "2025-09-18 21:14:09", "2025-09-18 21:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("31718", "10554", "acção concluída via WP Cron", "2025-09-18 21:14:09", "2025-09-18 21:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("31719", "10591", "acção criada", "2025-09-18 21:14:09", "2025-09-18 21:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("31720", "10589", "action started via WP Cron", "2025-09-18 21:14:09", "2025-09-18 21:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("31721", "10589", "acção concluída via WP Cron", "2025-09-18 21:14:09", "2025-09-18 21:14:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("31758", "10339", "action started via WP Cron", "2025-09-19 07:19:56", "2025-09-19 07:19:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("31759", "10339", "acção concluída via WP Cron", "2025-09-19 07:19:56", "2025-09-19 07:19:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("31760", "10604", "acção criada", "2025-09-19 07:19:56", "2025-09-19 07:19:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("31761", "10340", "action started via WP Cron", "2025-09-19 07:19:56", "2025-09-19 07:19:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("31762", "10340", "acção concluída via WP Cron", "2025-09-19 07:19:56", "2025-09-19 07:19:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("31763", "10605", "acção criada", "2025-09-19 07:19:56", "2025-09-19 07:19:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("31764", "10341", "action started via WP Cron", "2025-09-19 07:19:56", "2025-09-19 07:19:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("31765", "10341", "acção concluída via WP Cron", "2025-09-19 07:19:56", "2025-09-19 07:19:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("31766", "10606", "acção criada", "2025-09-19 07:19:56", "2025-09-19 07:19:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("31836", "10588", "action started via WP Cron", "2025-09-19 22:10:37", "2025-09-19 22:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31837", "10588", "acção concluída via WP Cron", "2025-09-19 22:10:37", "2025-09-19 22:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31838", "10630", "acção criada", "2025-09-19 22:10:37", "2025-09-19 22:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31839", "10590", "action started via WP Cron", "2025-09-19 22:10:37", "2025-09-19 22:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31840", "10631", "acção criada", "2025-09-19 22:10:37", "2025-09-19 22:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31841", "10590", "acção concluída via WP Cron", "2025-09-19 22:10:37", "2025-09-19 22:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31842", "10632", "acção criada", "2025-09-19 22:10:37", "2025-09-19 22:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31843", "10591", "action started via WP Cron", "2025-09-19 22:10:37", "2025-09-19 22:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31844", "10591", "acção concluída via WP Cron", "2025-09-19 22:10:37", "2025-09-19 22:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31845", "10633", "acção criada", "2025-09-19 22:10:37", "2025-09-19 22:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31846", "10631", "action started via WP Cron", "2025-09-19 22:10:37", "2025-09-19 22:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31847", "10631", "acção concluída via WP Cron", "2025-09-19 22:10:37", "2025-09-19 22:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31959", "10630", "action started via WP Cron", "2025-09-20 22:16:13", "2025-09-20 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("31960", "10630", "acção concluída via WP Cron", "2025-09-20 22:16:13", "2025-09-20 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("31961", "10671", "acção criada", "2025-09-20 22:16:13", "2025-09-20 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("31962", "10632", "action started via WP Cron", "2025-09-20 22:16:13", "2025-09-20 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("31963", "10672", "acção criada", "2025-09-20 22:16:13", "2025-09-20 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("31964", "10632", "acção concluída via WP Cron", "2025-09-20 22:16:13", "2025-09-20 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("31965", "10673", "acção criada", "2025-09-20 22:16:13", "2025-09-20 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("31966", "10633", "action started via WP Cron", "2025-09-20 22:16:13", "2025-09-20 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("31967", "10633", "acção concluída via WP Cron", "2025-09-20 22:16:13", "2025-09-20 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("31968", "10674", "acção criada", "2025-09-20 22:16:13", "2025-09-20 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("31969", "10672", "action started via WP Cron", "2025-09-20 22:16:13", "2025-09-20 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("31970", "10672", "acção concluída via WP Cron", "2025-09-20 22:16:13", "2025-09-20 22:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("32055", "10671", "action started via WP Cron", "2025-09-21 23:05:39", "2025-09-21 23:05:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("32056", "10671", "acção concluída via WP Cron", "2025-09-21 23:05:39", "2025-09-21 23:05:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("32057", "10703", "acção criada", "2025-09-21 23:05:39", "2025-09-21 23:05:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("32058", "10673", "action started via WP Cron", "2025-09-21 23:05:39", "2025-09-21 23:05:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("32059", "10704", "acção criada", "2025-09-21 23:05:39", "2025-09-21 23:05:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("32060", "10673", "acção concluída via WP Cron", "2025-09-21 23:05:39", "2025-09-21 23:05:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("32061", "10705", "acção criada", "2025-09-21 23:05:39", "2025-09-21 23:05:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("32062", "10674", "action started via WP Cron", "2025-09-21 23:05:39", "2025-09-21 23:05:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("32063", "10674", "acção concluída via WP Cron", "2025-09-21 23:05:39", "2025-09-21 23:05:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("32064", "10706", "acção criada", "2025-09-21 23:05:39", "2025-09-21 23:05:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("32065", "10704", "action started via WP Cron", "2025-09-21 23:05:39", "2025-09-21 23:05:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("32066", "10704", "acção concluída via WP Cron", "2025-09-21 23:05:39", "2025-09-21 23:05:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("32150", "10734", "acção criada", "2025-09-22 21:55:08", "2025-09-22 21:55:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("32163", "10703", "action started via WP Cron", "2025-09-22 23:52:38", "2025-09-22 23:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("32164", "10703", "acção concluída via WP Cron", "2025-09-22 23:52:38", "2025-09-22 23:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("32165", "10739", "acção criada", "2025-09-22 23:52:38", "2025-09-22 23:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("32166", "10705", "action started via WP Cron", "2025-09-22 23:52:38", "2025-09-22 23:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("32167", "10740", "acção criada", "2025-09-22 23:52:38", "2025-09-22 23:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("32168", "10705", "acção concluída via WP Cron", "2025-09-22 23:52:38", "2025-09-22 23:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("32169", "10741", "acção criada", "2025-09-22 23:52:38", "2025-09-22 23:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("32170", "10706", "action started via WP Cron", "2025-09-22 23:52:38", "2025-09-22 23:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("32171", "10706", "acção concluída via WP Cron", "2025-09-22 23:52:38", "2025-09-22 23:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("32172", "10742", "acção criada", "2025-09-22 23:52:38", "2025-09-22 23:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("32173", "10740", "action started via WP Cron", "2025-09-22 23:52:38", "2025-09-22 23:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("32174", "10740", "acção concluída via WP Cron", "2025-09-22 23:52:38", "2025-09-22 23:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("32250", "10739", "action started via WP Cron", "2025-09-24 00:41:22", "2025-09-24 00:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32251", "10739", "acção concluída via WP Cron", "2025-09-24 00:41:22", "2025-09-24 00:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32252", "10768", "acção criada", "2025-09-24 00:41:22", "2025-09-24 00:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32253", "10741", "action started via WP Cron", "2025-09-24 00:41:22", "2025-09-24 00:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32254", "10769", "acção criada", "2025-09-24 00:41:22", "2025-09-24 00:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32255", "10741", "acção concluída via WP Cron", "2025-09-24 00:41:22", "2025-09-24 00:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32256", "10770", "acção criada", "2025-09-24 00:41:22", "2025-09-24 00:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32257", "10742", "action started via WP Cron", "2025-09-24 00:41:22", "2025-09-24 00:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32258", "10742", "acção concluída via WP Cron", "2025-09-24 00:41:22", "2025-09-24 00:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32259", "10771", "acção criada", "2025-09-24 00:41:22", "2025-09-24 00:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32260", "10769", "action started via WP Cron", "2025-09-24 00:41:22", "2025-09-24 00:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32261", "10769", "acção concluída via WP Cron", "2025-09-24 00:41:22", "2025-09-24 00:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("32343", "10768", "action started via WP Cron", "2025-09-25 01:44:24", "2025-09-25 01:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32344", "10768", "acção concluída via WP Cron", "2025-09-25 01:44:24", "2025-09-25 01:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32345", "10799", "acção criada", "2025-09-25 01:44:24", "2025-09-25 01:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32346", "10770", "action started via WP Cron", "2025-09-25 01:44:24", "2025-09-25 01:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32347", "10800", "acção criada", "2025-09-25 01:44:24", "2025-09-25 01:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32348", "10770", "acção concluída via WP Cron", "2025-09-25 01:44:24", "2025-09-25 01:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32349", "10801", "acção criada", "2025-09-25 01:44:24", "2025-09-25 01:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32350", "10771", "action started via WP Cron", "2025-09-25 01:44:24", "2025-09-25 01:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32351", "10771", "acção concluída via WP Cron", "2025-09-25 01:44:24", "2025-09-25 01:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32352", "10802", "acção criada", "2025-09-25 01:44:24", "2025-09-25 01:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32353", "10800", "action started via WP Cron", "2025-09-25 01:44:24", "2025-09-25 01:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32354", "10800", "acção concluída via WP Cron", "2025-09-25 01:44:24", "2025-09-25 01:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("32451", "10799", "action started via WP Cron", "2025-09-26 01:52:36", "2025-09-26 01:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("32452", "10799", "acção concluída via WP Cron", "2025-09-26 01:52:36", "2025-09-26 01:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("32453", "10835", "acção criada", "2025-09-26 01:52:36", "2025-09-26 01:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("32454", "10801", "action started via WP Cron", "2025-09-26 01:52:36", "2025-09-26 01:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("32455", "10836", "acção criada", "2025-09-26 01:52:36", "2025-09-26 01:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("32456", "10801", "acção concluída via WP Cron", "2025-09-26 01:52:36", "2025-09-26 01:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("32457", "10837", "acção criada", "2025-09-26 01:52:36", "2025-09-26 01:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("32458", "10802", "action started via WP Cron", "2025-09-26 01:52:36", "2025-09-26 01:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("32459", "10802", "acção concluída via WP Cron", "2025-09-26 01:52:36", "2025-09-26 01:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("32460", "10838", "acção criada", "2025-09-26 01:52:36", "2025-09-26 01:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("32461", "10836", "action started via WP Cron", "2025-09-26 01:52:36", "2025-09-26 01:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("32462", "10836", "acção concluída via WP Cron", "2025-09-26 01:52:36", "2025-09-26 01:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("32496", "10604", "action started via WP Cron", "2025-09-26 07:26:17", "2025-09-26 07:26:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("32497", "10604", "acção concluída via WP Cron", "2025-09-26 07:26:17", "2025-09-26 07:26:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("32498", "10850", "acção criada", "2025-09-26 07:26:17", "2025-09-26 07:26:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("32499", "10605", "action started via WP Cron", "2025-09-26 07:26:17", "2025-09-26 07:26:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("32500", "10605", "acção concluída via WP Cron", "2025-09-26 07:26:17", "2025-09-26 07:26:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("32501", "10851", "acção criada", "2025-09-26 07:26:17", "2025-09-26 07:26:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("32502", "10606", "action started via WP Cron", "2025-09-26 07:26:17", "2025-09-26 07:26:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("32503", "10606", "acção concluída via WP Cron", "2025-09-26 07:26:17", "2025-09-26 07:26:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("32504", "10852", "acção criada", "2025-09-26 07:26:17", "2025-09-26 07:26:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("32603", "10885", "acção criada", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32604", "10835", "action started via WP Cron", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32605", "10835", "acção concluída via WP Cron", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32606", "10886", "acção criada", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32607", "10837", "action started via WP Cron", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32608", "10887", "acção criada", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32609", "10837", "acção concluída via WP Cron", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32610", "10888", "acção criada", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32611", "10838", "action started via WP Cron", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32612", "10838", "acção concluída via WP Cron", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32613", "10889", "acção criada", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32614", "10887", "action started via WP Cron", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32615", "10887", "acção concluída via WP Cron", "2025-09-27 02:22:49", "2025-09-27 02:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("32692", "10915", "acção criada", "2025-09-27 22:34:40", "2025-09-27 22:34:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("32694", "10915", "action started via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32695", "10916", "acção criada", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32696", "10915", "acção concluída via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32697", "10885", "action started via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32698", "10885", "acção concluída via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32699", "10917", "acção criada", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32700", "10886", "action started via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32701", "10886", "acção concluída via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32702", "10918", "acção criada", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32703", "10888", "action started via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32704", "10919", "acção criada", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32705", "10888", "acção concluída via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32706", "10920", "acção criada", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32707", "10889", "action started via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32708", "10889", "acção concluída via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32709", "10921", "acção criada", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32710", "10734", "action started via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32711", "10734", "acção concluída via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32712", "10922", "acção criada", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32713", "9860", "action started via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32714", "9860", "acção concluída via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32715", "10923", "acção criada", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32716", "10850", "action started via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32717", "10850", "acção concluída via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32718", "10924", "acção criada", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32719", "10851", "action started via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32720", "10851", "acção concluída via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32721", "10925", "acção criada", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32722", "10852", "action started via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32723", "10852", "acção concluída via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32724", "10926", "acção criada", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32725", "10919", "action started via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32726", "10919", "acção concluída via WP Cron", "2028-03-10 04:29:15", "2028-03-10 04:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("32727", "10927", "acção criada", "2028-03-10 04:29:18", "2028-03-10 04:29:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("32728", "10927", "action started via Async Request", "2028-03-10 04:29:19", "2028-03-10 04:29:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("32729", "10927", "acção concluída via Async Request", "2028-03-10 04:29:19", "2028-03-10 04:29:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("32730", "10928", "acção criada", "2025-11-06 03:19:33", "2025-11-06 03:19:33");

/* INSERT TABLE DATA: wp_aioseo_cache */
INSERT INTO `wp_aioseo_cache` VALUES("509", "addons", "a:9:{i:0;a:23:{s:3:\"sku\";s:11:\"aioseo-eeat\";s:4:\"name\";s:20:\"Author SEO (E-E-A-T)\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"image\";N;s:4:\"icon\";s:8:\"svg-eeat\";s:6:\"levels\";a:3:{i:0;s:4:\"plus\";i:1;s:3:\"pro\";i:2;s:5:\"elite\";}s:13:\"currentLevels\";a:3:{i:0;s:4:\"plus\";i:1;s:3:\"pro\";i:2;s:5:\"elite\";}s:15:\"requiresUpgrade\";b:1;s:11:\"description\";s:146:\"<p>Optimize your site for Google\'s E-E-A-T ranking factor by proving your writer\'s expertise through author schema markup and new UI elements.</p>\";s:18:\"descriptionVersion\";i:0;s:10:\"productUrl\";s:35:\"https://aioseo.com/author-seo-eeat/\";s:12:\"learnMoreUrl\";s:35:\"https://aioseo.com/author-seo-eeat/\";s:9:\"manageUrl\";s:49:\"https://route#aioseo-search-appearance:author-seo\";s:8:\"basename\";s:27:\"aioseo-eeat/aioseo-eeat.php\";s:9:\"installed\";b:0;s:8:\"isActive\";b:0;s:10:\"canInstall\";b:0;s:11:\"canActivate\";b:0;s:9:\"canUpdate\";b:0;s:10:\"capability\";s:17:\"aioseo_manage_seo\";s:14:\"minimumVersion\";s:5:\"0.0.0\";s:17:\"hasMinimumVersion\";b:0;s:8:\"featured\";i:300;}i:1;a:23:{s:3:\"sku\";s:16:\"aioseo-redirects\";s:4:\"name\";s:19:\"Redirection Manager\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"image\";N;s:4:\"icon\";s:12:\"svg-redirect\";s:6:\"levels\";a:4:{i:0;s:6:\"agency\";i:1;s:8:\"business\";i:2;s:3:\"pro\";i:3;s:5:\"elite\";}s:13:\"currentLevels\";a:2:{i:0;s:3:\"pro\";i:1;s:5:\"elite\";}s:15:\"requiresUpgrade\";b:1;s:11:\"description\";s:274:\"<p>Our Redirection Manager allows you to easily create and manage redirects for your broken links to avoid confusing search engines and users, as well as losing valuable backlinks. It even automatically sends users and search engines from your old URLs to your new ones.</p>\";s:18:\"descriptionVersion\";i:0;s:10:\"productUrl\";s:48:\"https://aioseo.com/features/redirection-manager/\";s:12:\"learnMoreUrl\";s:48:\"https://aioseo.com/features/redirection-manager/\";s:9:\"manageUrl\";s:40:\"https://route#aioseo-redirects:redirects\";s:8:\"basename\";s:37:\"aioseo-redirects/aioseo-redirects.php\";s:9:\"installed\";b:0;s:8:\"isActive\";b:0;s:10:\"canInstall\";b:0;s:11:\"canActivate\";b:0;s:9:\"canUpdate\";b:0;s:10:\"capability\";s:25:\"aioseo_redirects_settings\";s:14:\"minimumVersion\";s:5:\"0.0.0\";s:17:\"hasMinimumVersion\";b:0;s:8:\"featured\";i:200;}i:2;a:23:{s:3:\"sku\";s:21:\"aioseo-link-assistant\";s:4:\"name\";s:14:\"Link Assistant\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"image\";N;s:4:\"icon\";s:18:\"svg-link-assistant\";s:6:\"levels\";a:3:{i:0;s:6:\"agency\";i:1;s:3:\"pro\";i:2;s:5:\"elite\";}s:13:\"currentLevels\";a:2:{i:0;s:3:\"pro\";i:1;s:5:\"elite\";}s:15:\"requiresUpgrade\";b:1;s:11:\"description\";s:282:\"<p>Super-charge your SEO with Link Assistant! Get relevant suggestions for adding internal links to older content as well as finding any orphaned posts that have no internal links. Use our reporting feature to see all link suggestions or add them directly from any page or post.</p>\";s:18:\"descriptionVersion\";i:0;s:10:\"productUrl\";s:51:\"https://aioseo.com/feature/internal-link-assistant/\";s:12:\"learnMoreUrl\";s:51:\"https://aioseo.com/feature/internal-link-assistant/\";s:9:\"manageUrl\";s:44:\"https://route#aioseo-link-assistant:overview\";s:8:\"basename\";s:47:\"aioseo-link-assistant/aioseo-link-assistant.php\";s:9:\"installed\";b:0;s:8:\"isActive\";b:0;s:10:\"canInstall\";b:0;s:11:\"canActivate\";b:0;s:9:\"canUpdate\";b:0;s:10:\"capability\";s:17:\"aioseo_manage_seo\";s:14:\"minimumVersion\";s:5:\"0.0.0\";s:17:\"hasMinimumVersion\";b:0;s:8:\"featured\";i:100;}i:3;a:22:{s:3:\"sku\";s:20:\"aioseo-video-sitemap\";s:4:\"name\";s:13:\"Video Sitemap\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"image\";N;s:4:\"icon\";s:16:\"svg-sitemaps-pro\";s:6:\"levels\";a:5:{i:0;s:10:\"individual\";i:1;s:8:\"business\";i:2;s:6:\"agency\";i:3;s:3:\"pro\";i:4;s:5:\"elite\";}s:13:\"currentLevels\";a:2:{i:0;s:3:\"pro\";i:1;s:5:\"elite\";}s:15:\"requiresUpgrade\";b:1;s:11:\"description\";s:242:\"<p>The Video Sitemap works in much the same way as the XML Sitemap module, it generates an XML Sitemap specifically for video content on your site. Search engines use this information to display rich snippet information in search results.</p>\";s:18:\"descriptionVersion\";i:0;s:10:\"productUrl\";s:32:\"https://aioseo.com/video-sitemap\";s:12:\"learnMoreUrl\";s:32:\"https://aioseo.com/video-sitemap\";s:9:\"manageUrl\";s:43:\"https://route#aioseo-sitemaps:video-sitemap\";s:8:\"basename\";s:45:\"aioseo-video-sitemap/aioseo-video-sitemap.php\";s:9:\"installed\";b:0;s:8:\"isActive\";b:0;s:10:\"canInstall\";b:0;s:11:\"canActivate\";b:0;s:9:\"canUpdate\";b:0;s:10:\"capability\";s:23:\"aioseo_sitemap_settings\";s:14:\"minimumVersion\";s:5:\"0.0.0\";s:17:\"hasMinimumVersion\";b:0;}i:4;a:22:{s:3:\"sku\";s:21:\"aioseo-local-business\";s:4:\"name\";s:18:\"Local Business SEO\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"image\";N;s:4:\"icon\";s:18:\"svg-local-business\";s:6:\"levels\";a:5:{i:0;s:8:\"business\";i:1;s:6:\"agency\";i:2;s:4:\"plus\";i:3;s:3:\"pro\";i:4;s:5:\"elite\";}s:13:\"currentLevels\";a:3:{i:0;s:4:\"plus\";i:1;s:3:\"pro\";i:2;s:5:\"elite\";}s:15:\"requiresUpgrade\";b:1;s:11:\"description\";s:252:\"<p>Local Business schema markup enables you to tell Google about your business, including your business name, address and phone number, opening hours and price range. This information may be displayed as a Knowledge Graph card or business carousel.</p>\";s:18:\"descriptionVersion\";i:0;s:10:\"productUrl\";s:33:\"https://aioseo.com/local-business\";s:12:\"learnMoreUrl\";s:33:\"https://aioseo.com/local-business\";s:9:\"manageUrl\";s:40:\"https://route#aioseo-local-seo:locations\";s:8:\"basename\";s:47:\"aioseo-local-business/aioseo-local-business.php\";s:9:\"installed\";b:0;s:8:\"isActive\";b:0;s:10:\"canInstall\";b:0;s:11:\"canActivate\";b:0;s:9:\"canUpdate\";b:0;s:10:\"capability\";s:25:\"aioseo_local_seo_settings\";s:14:\"minimumVersion\";s:5:\"0.0.0\";s:17:\"hasMinimumVersion\";b:0;}i:5;a:22:{s:3:\"sku\";s:19:\"aioseo-news-sitemap\";s:4:\"name\";s:12:\"News Sitemap\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"image\";N;s:4:\"icon\";s:16:\"svg-sitemaps-pro\";s:6:\"levels\";a:4:{i:0;s:8:\"business\";i:1;s:6:\"agency\";i:2;s:3:\"pro\";i:3;s:5:\"elite\";}s:13:\"currentLevels\";a:2:{i:0;s:3:\"pro\";i:1;s:5:\"elite\";}s:15:\"requiresUpgrade\";b:1;s:11:\"description\";s:283:\"<p>Our Google News Sitemap lets you control which content you submit to Google News and only contains articles that were published in the last 48 hours. In order to submit a News Sitemap to Google, you must have added your site to Google’s Publisher Center and had it approved.</p>\";s:18:\"descriptionVersion\";i:0;s:10:\"productUrl\";s:31:\"https://aioseo.com/news-sitemap\";s:12:\"learnMoreUrl\";s:31:\"https://aioseo.com/news-sitemap\";s:9:\"manageUrl\";s:42:\"https://route#aioseo-sitemaps:news-sitemap\";s:8:\"basename\";s:43:\"aioseo-news-sitemap/aioseo-news-sitemap.php\";s:9:\"installed\";b:0;s:8:\"isActive\";b:0;s:10:\"canInstall\";b:0;s:11:\"canActivate\";b:0;s:9:\"canUpdate\";b:0;s:10:\"capability\";s:23:\"aioseo_sitemap_settings\";s:14:\"minimumVersion\";s:5:\"0.0.0\";s:17:\"hasMinimumVersion\";b:0;}i:6;a:23:{s:3:\"sku\";s:16:\"aioseo-index-now\";s:4:\"name\";s:8:\"IndexNow\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"image\";N;s:4:\"icon\";s:16:\"svg-sitemaps-pro\";s:6:\"levels\";a:6:{i:0;s:6:\"agency\";i:1;s:8:\"business\";i:2;s:5:\"basic\";i:3;s:4:\"plus\";i:4;s:3:\"pro\";i:5;s:5:\"elite\";}s:13:\"currentLevels\";a:4:{i:0;s:5:\"basic\";i:1;s:4:\"plus\";i:2;s:3:\"pro\";i:3;s:5:\"elite\";}s:15:\"requiresUpgrade\";b:1;s:11:\"description\";s:192:\"<p>Add IndexNow support to instantly notify search engines when your content has changed. This helps the search engines to prioritize the changes on your website and helps you rank faster.</p>\";s:18:\"descriptionVersion\";i:0;s:11:\"downloadUrl\";s:0:\"\";s:10:\"productUrl\";s:29:\"https://aioseo.com/index-now/\";s:12:\"learnMoreUrl\";s:29:\"https://aioseo.com/index-now/\";s:9:\"manageUrl\";s:45:\"https://route#aioseo-settings:webmaster-tools\";s:8:\"basename\";s:37:\"aioseo-index-now/aioseo-index-now.php\";s:9:\"installed\";b:0;s:8:\"isActive\";b:0;s:10:\"canInstall\";b:0;s:11:\"canActivate\";b:0;s:9:\"canUpdate\";b:0;s:10:\"capability\";s:23:\"aioseo_general_settings\";s:14:\"minimumVersion\";s:5:\"0.0.0\";s:17:\"hasMinimumVersion\";b:0;}i:7;a:23:{s:3:\"sku\";s:15:\"aioseo-rest-api\";s:4:\"name\";s:8:\"REST API\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"image\";N;s:4:\"icon\";s:8:\"svg-code\";s:6:\"levels\";a:3:{i:0;s:4:\"plus\";i:1;s:3:\"pro\";i:2;s:5:\"elite\";}s:13:\"currentLevels\";a:3:{i:0;s:4:\"plus\";i:1;s:3:\"pro\";i:2;s:5:\"elite\";}s:15:\"requiresUpgrade\";b:1;s:11:\"description\";s:136:\"<p>Manage your post and term SEO meta via the WordPress REST API. This addon also works seamlessly with headless WordPress installs.</p>\";s:18:\"descriptionVersion\";i:0;s:11:\"downloadUrl\";s:0:\"\";s:10:\"productUrl\";s:36:\"https://aioseo.com/feature/rest-api/\";s:12:\"learnMoreUrl\";s:36:\"https://aioseo.com/feature/rest-api/\";s:9:\"manageUrl\";N;s:8:\"basename\";s:35:\"aioseo-rest-api/aioseo-rest-api.php\";s:9:\"installed\";b:0;s:8:\"isActive\";b:0;s:10:\"canInstall\";b:0;s:11:\"canActivate\";b:0;s:9:\"canUpdate\";b:0;s:10:\"capability\";N;s:14:\"minimumVersion\";s:5:\"0.0.0\";s:17:\"hasMinimumVersion\";b:0;}i:8;a:22:{s:3:\"sku\";s:16:\"aioseo-image-seo\";s:4:\"name\";s:9:\"Image SEO\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"image\";N;s:4:\"icon\";s:13:\"svg-image-seo\";s:6:\"levels\";a:6:{i:0;s:10:\"individual\";i:1;s:8:\"business\";i:2;s:6:\"agency\";i:3;s:4:\"plus\";i:4;s:3:\"pro\";i:5;s:5:\"elite\";}s:13:\"currentLevels\";a:3:{i:0;s:4:\"plus\";i:1;s:3:\"pro\";i:2;s:5:\"elite\";}s:15:\"requiresUpgrade\";b:1;s:11:\"description\";s:147:\"<p>Globally control the Title attribute and Alt text for images in your content. These attributes are essential for both accessibility and SEO.</p>\";s:18:\"descriptionVersion\";i:0;s:10:\"productUrl\";s:28:\"https://aioseo.com/image-seo\";s:12:\"learnMoreUrl\";s:28:\"https://aioseo.com/image-seo\";s:9:\"manageUrl\";s:44:\"https://route#aioseo-search-appearance:media\";s:8:\"basename\";s:37:\"aioseo-image-seo/aioseo-image-seo.php\";s:9:\"installed\";b:0;s:8:\"isActive\";b:0;s:10:\"canInstall\";b:0;s:11:\"canActivate\";b:0;s:9:\"canUpdate\";b:0;s:10:\"capability\";s:33:\"aioseo_search_appearance_settings\";s:14:\"minimumVersion\";s:5:\"0.0.0\";s:17:\"hasMinimumVersion\";b:0;}}", "2028-03-11 04:29:14", "2025-01-09 00:10:53", "2028-03-10 04:29:14");
INSERT INTO `wp_aioseo_cache` VALUES("3648", "action_scheduler_log_cleanup", "b:1;", "2028-03-11 04:29:15", "2025-09-16 19:41:57", "2028-03-10 04:29:15");
INSERT INTO `wp_aioseo_cache` VALUES("3758", "attachment_url_to_post_id_d99ed2ddbeefba28910cca4100f73b401b38bc49", "s:4:\"none\";", "2028-03-11 04:29:14", "2025-09-25 03:16:56", "2028-03-10 04:29:14");
INSERT INTO `wp_aioseo_cache` VALUES("3807", "admin_notifications_update", "i:1836361758;", "2028-03-11 04:29:18", "2028-03-10 04:29:18", "2028-03-10 04:29:18");
INSERT INTO `wp_aioseo_cache` VALUES("3808", "aioseo_sitemap_sitemap.rss", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:38:{s:32:\"https://tangoandmore.com/videos/\";a:2:{s:4:\"date\";s:17:\"November 18, 2025\";s:4:\"time\";s:8:\"12:05 pm\";}s:55:\"https://tangoandmore.com/work/leather-drawstring-pouch/\";a:2:{s:4:\"date\";s:14:\"April 12, 2016\";s:4:\"time\";s:7:\"6:16 am\";}s:30:\"https://tangoandmore.com/blog/\";a:2:{s:4:\"date\";s:14:\"March 24, 2016\";s:4:\"time\";s:7:\"7:36 am\";}s:25:\"https://tangoandmore.com/\";a:2:{s:4:\"date\";s:17:\"December 24, 2024\";s:4:\"time\";s:7:\"7:21 pm\";}s:32:\"https://tangoandmore.com/albums/\";a:2:{s:4:\"date\";s:17:\"February 14, 2018\";s:4:\"time\";s:8:\"10:10 am\";}s:38:\"https://tangoandmore.com/info-contact/\";a:2:{s:4:\"date\";s:15:\"January 9, 2025\";s:4:\"time\";s:8:\"11:52 am\";}s:38:\"https://tangoandmore.com/night-colors/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:35 pm\";}s:36:\"https://tangoandmore.com/north-pole/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:31 pm\";}s:39:\"https://tangoandmore.com/lost-paradise/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:31 pm\";}s:38:\"https://tangoandmore.com/black-coffee/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:31 pm\";}s:36:\"https://tangoandmore.com/fruit-boom/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:24 pm\";}s:44:\"https://tangoandmore.com/work/poster-mockup/\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"6:14 pm\";}s:46:\"https://tangoandmore.com/work/a4-paper-mockup/\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"6:11 pm\";}s:41:\"https://tangoandmore.com/work/label-tags/\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"6:00 pm\";}s:52:\"https://tangoandmore.com/work/paper-cup-soft-drinks/\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"5:25 pm\";}s:42:\"https://tangoandmore.com/album/fullscreen/\";a:2:{s:4:\"date\";s:13:\"April 4, 2025\";s:4:\"time\";s:7:\"2:54 pm\";}s:40:\"https://tangoandmore.com/adventure-trip/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:23 pm\";}s:46:\"https://tangoandmore.com/work/paper-packaging/\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"4:37 pm\";}s:43:\"https://tangoandmore.com/album/fullscreen2/\";a:2:{s:4:\"date\";s:16:\"January 29, 2017\";s:4:\"time\";s:7:\"7:55 pm\";}s:32:\"https://tangoandmore.com/photos/\";a:2:{s:4:\"date\";s:16:\"November 7, 2025\";s:4:\"time\";s:7:\"3:04 am\";}s:36:\"https://tangoandmore.com/last-shoot/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:21 pm\";}s:43:\"https://tangoandmore.com/album/fullscreen3/\";a:2:{s:4:\"date\";s:16:\"January 28, 2017\";s:4:\"time\";s:7:\"7:50 pm\";}s:43:\"https://tangoandmore.com/last-day-in-vegas/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:21 pm\";}s:40:\"https://tangoandmore.com/album/gallery3/\";a:2:{s:4:\"date\";s:16:\"January 25, 2017\";s:4:\"time\";s:7:\"1:43 pm\";}s:29:\"https://tangoandmore.com/bio/\";a:2:{s:4:\"date\";s:16:\"November 7, 2025\";s:4:\"time\";s:7:\"7:22 pm\";}s:45:\"https://tangoandmore.com/?people=mark-roberts\";a:2:{s:4:\"date\";s:14:\"April 13, 2016\";s:4:\"time\";s:7:\"6:54 am\";}s:47:\"https://tangoandmore.com/?people=jennifer-ollie\";a:2:{s:4:\"date\";s:14:\"April 13, 2016\";s:4:\"time\";s:7:\"6:52 am\";}s:43:\"https://tangoandmore.com/?people=marry-pops\";a:2:{s:4:\"date\";s:14:\"April 13, 2016\";s:4:\"time\";s:7:\"6:48 am\";}s:44:\"https://tangoandmore.com/?people=mary-thorne\";a:2:{s:4:\"date\";s:14:\"April 13, 2016\";s:4:\"time\";s:7:\"6:46 am\";}s:40:\"https://tangoandmore.com/album/gallery2/\";a:2:{s:4:\"date\";s:16:\"January 24, 2017\";s:4:\"time\";s:7:\"1:37 pm\";}s:49:\"https://tangoandmore.com/?people=dan-michaels-2-3\";a:2:{s:4:\"date\";s:14:\"April 12, 2016\";s:4:\"time\";s:7:\"1:04 pm\";}s:49:\"https://tangoandmore.com/?people=dan-michaels-2-2\";a:2:{s:4:\"date\";s:14:\"April 12, 2016\";s:4:\"time\";s:8:\"12:40 pm\";}s:47:\"https://tangoandmore.com/?people=dan-michaels-2\";a:2:{s:4:\"date\";s:14:\"April 12, 2016\";s:4:\"time\";s:8:\"12:16 pm\";}s:45:\"https://tangoandmore.com/?people=dan-michaels\";a:2:{s:4:\"date\";s:14:\"April 12, 2016\";s:4:\"time\";s:8:\"12:00 pm\";}s:40:\"https://tangoandmore.com/album/gallery4/\";a:2:{s:4:\"date\";s:16:\"January 26, 2017\";s:4:\"time\";s:7:\"2:18 pm\";}s:39:\"https://tangoandmore.com/album/uncover/\";a:2:{s:4:\"date\";s:16:\"January 22, 2017\";s:4:\"time\";s:8:\"10:10 am\";}s:40:\"https://tangoandmore.com/album/gallery1/\";a:2:{s:4:\"date\";s:16:\"January 23, 2017\";s:4:\"time\";s:8:\"11:32 am\";}s:43:\"https://tangoandmore.com/album/fullscreen4/\";a:2:{s:4:\"date\";s:16:\"January 27, 2017\";s:4:\"time\";s:7:\"7:45 pm\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:38;s:5:\"total\";i:38;}}", "2026-01-16 15:09:33", "2025-09-28 00:53:30", "2025-12-17 15:09:33");
INSERT INTO `wp_aioseo_cache` VALUES("3831", "aioseo_sitemap_sitemap.xml", "a:3:{s:6:\"counts\";a:10:{s:41:\"https://tangoandmore.com/post-sitemap.xml\";i:8;s:41:\"https://tangoandmore.com/page-sitemap.xml\";i:7;s:42:\"https://tangoandmore.com/album-sitemap.xml\";i:9;s:41:\"https://tangoandmore.com/work-sitemap.xml\";i:6;s:43:\"https://tangoandmore.com/people-sitemap.xml\";i:8;s:45:\"https://tangoandmore.com/category-sitemap.xml\";i:6;s:45:\"https://tangoandmore.com/post_tag-sitemap.xml\";i:5;s:42:\"https://tangoandmore.com/genre-sitemap.xml\";i:4;s:47:\"https://tangoandmore.com/work_genre-sitemap.xml\";i:4;s:42:\"https://tangoandmore.com/group-sitemap.xml\";i:2;}s:8:\"datetime\";a:10:{s:41:\"https://tangoandmore.com/post-sitemap.xml\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:35 pm\";}s:41:\"https://tangoandmore.com/page-sitemap.xml\";a:2:{s:4:\"date\";s:17:\"November 18, 2025\";s:4:\"time\";s:8:\"12:05 pm\";}s:42:\"https://tangoandmore.com/album-sitemap.xml\";a:2:{s:4:\"date\";s:13:\"April 4, 2025\";s:4:\"time\";s:7:\"2:54 pm\";}s:41:\"https://tangoandmore.com/work-sitemap.xml\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"6:14 pm\";}s:43:\"https://tangoandmore.com/people-sitemap.xml\";a:2:{s:4:\"date\";s:14:\"April 13, 2016\";s:4:\"time\";s:7:\"6:54 am\";}s:45:\"https://tangoandmore.com/category-sitemap.xml\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:35 pm\";}s:45:\"https://tangoandmore.com/post_tag-sitemap.xml\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:35 pm\";}s:42:\"https://tangoandmore.com/genre-sitemap.xml\";a:2:{s:4:\"date\";s:13:\"April 4, 2025\";s:4:\"time\";s:7:\"2:54 pm\";}s:47:\"https://tangoandmore.com/work_genre-sitemap.xml\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"6:14 pm\";}s:42:\"https://tangoandmore.com/group-sitemap.xml\";a:2:{s:4:\"date\";s:14:\"April 13, 2016\";s:4:\"time\";s:7:\"6:54 am\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:10;s:5:\"total\";i:10;}}", "2026-01-21 15:48:31", "2025-09-30 17:42:41", "2025-12-22 15:48:31");
INSERT INTO `wp_aioseo_cache` VALUES("3832", "aioseo_sitemap_post-sitemap.xml", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:9:{s:30:\"https://tangoandmore.com/blog/\";a:2:{s:4:\"date\";s:14:\"March 24, 2016\";s:4:\"time\";s:7:\"7:36 am\";}s:38:\"https://tangoandmore.com/night-colors/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:35 pm\";}s:36:\"https://tangoandmore.com/north-pole/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:31 pm\";}s:39:\"https://tangoandmore.com/lost-paradise/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:31 pm\";}s:38:\"https://tangoandmore.com/black-coffee/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:31 pm\";}s:36:\"https://tangoandmore.com/fruit-boom/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:24 pm\";}s:40:\"https://tangoandmore.com/adventure-trip/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:23 pm\";}s:36:\"https://tangoandmore.com/last-shoot/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:21 pm\";}s:43:\"https://tangoandmore.com/last-day-in-vegas/\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:21 pm\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:9;s:5:\"total\";i:9;}}", "2026-01-21 07:21:20", "2025-09-30 17:42:42", "2025-12-22 07:21:20");
INSERT INTO `wp_aioseo_cache` VALUES("3833", "aioseo_sitemap_page-sitemap.xml", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:6:{s:25:\"https://tangoandmore.com/\";a:2:{s:4:\"date\";s:17:\"December 24, 2024\";s:4:\"time\";s:7:\"7:21 pm\";}s:32:\"https://tangoandmore.com/videos/\";a:2:{s:4:\"date\";s:17:\"November 18, 2025\";s:4:\"time\";s:8:\"12:05 pm\";}s:29:\"https://tangoandmore.com/bio/\";a:2:{s:4:\"date\";s:16:\"November 7, 2025\";s:4:\"time\";s:7:\"7:22 pm\";}s:32:\"https://tangoandmore.com/photos/\";a:2:{s:4:\"date\";s:16:\"November 7, 2025\";s:4:\"time\";s:7:\"3:04 am\";}s:38:\"https://tangoandmore.com/info-contact/\";a:2:{s:4:\"date\";s:15:\"January 9, 2025\";s:4:\"time\";s:8:\"11:52 am\";}s:32:\"https://tangoandmore.com/albums/\";a:2:{s:4:\"date\";s:17:\"February 14, 2018\";s:4:\"time\";s:8:\"10:10 am\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:6;s:5:\"total\";i:6;}}", "2026-01-21 04:06:37", "2025-09-30 17:42:44", "2025-12-22 04:06:37");
INSERT INTO `wp_aioseo_cache` VALUES("3834", "aioseo_sitemap_album-sitemap.xml", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:9:{s:42:\"https://tangoandmore.com/album/fullscreen/\";a:2:{s:4:\"date\";s:13:\"April 4, 2025\";s:4:\"time\";s:7:\"2:54 pm\";}s:43:\"https://tangoandmore.com/album/fullscreen2/\";a:2:{s:4:\"date\";s:16:\"January 29, 2017\";s:4:\"time\";s:7:\"7:55 pm\";}s:43:\"https://tangoandmore.com/album/fullscreen3/\";a:2:{s:4:\"date\";s:16:\"January 28, 2017\";s:4:\"time\";s:7:\"7:50 pm\";}s:43:\"https://tangoandmore.com/album/fullscreen4/\";a:2:{s:4:\"date\";s:16:\"January 27, 2017\";s:4:\"time\";s:7:\"7:45 pm\";}s:40:\"https://tangoandmore.com/album/gallery4/\";a:2:{s:4:\"date\";s:16:\"January 26, 2017\";s:4:\"time\";s:7:\"2:18 pm\";}s:40:\"https://tangoandmore.com/album/gallery3/\";a:2:{s:4:\"date\";s:16:\"January 25, 2017\";s:4:\"time\";s:7:\"1:43 pm\";}s:40:\"https://tangoandmore.com/album/gallery2/\";a:2:{s:4:\"date\";s:16:\"January 24, 2017\";s:4:\"time\";s:7:\"1:37 pm\";}s:40:\"https://tangoandmore.com/album/gallery1/\";a:2:{s:4:\"date\";s:16:\"January 23, 2017\";s:4:\"time\";s:8:\"11:32 am\";}s:39:\"https://tangoandmore.com/album/uncover/\";a:2:{s:4:\"date\";s:16:\"January 22, 2017\";s:4:\"time\";s:8:\"10:10 am\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:9;s:5:\"total\";i:9;}}", "2026-01-21 04:06:40", "2025-09-30 17:42:46", "2025-12-22 04:06:40");
INSERT INTO `wp_aioseo_cache` VALUES("3835", "aioseo_sitemap_work-sitemap.xml", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:6:{s:44:\"https://tangoandmore.com/work/poster-mockup/\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"6:14 pm\";}s:46:\"https://tangoandmore.com/work/a4-paper-mockup/\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"6:11 pm\";}s:41:\"https://tangoandmore.com/work/label-tags/\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"6:00 pm\";}s:52:\"https://tangoandmore.com/work/paper-cup-soft-drinks/\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"5:25 pm\";}s:46:\"https://tangoandmore.com/work/paper-packaging/\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"4:37 pm\";}s:55:\"https://tangoandmore.com/work/leather-drawstring-pouch/\";a:2:{s:4:\"date\";s:14:\"April 12, 2016\";s:4:\"time\";s:7:\"6:16 am\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:6;s:5:\"total\";i:6;}}", "2026-01-21 07:20:10", "2025-09-30 17:42:47", "2025-12-22 07:20:10");
INSERT INTO `wp_aioseo_cache` VALUES("3836", "aioseo_sitemap_people-sitemap.xml", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:8:{s:45:\"https://tangoandmore.com/?people=mark-roberts\";a:2:{s:4:\"date\";s:14:\"April 13, 2016\";s:4:\"time\";s:7:\"6:54 am\";}s:47:\"https://tangoandmore.com/?people=jennifer-ollie\";a:2:{s:4:\"date\";s:14:\"April 13, 2016\";s:4:\"time\";s:7:\"6:52 am\";}s:43:\"https://tangoandmore.com/?people=marry-pops\";a:2:{s:4:\"date\";s:14:\"April 13, 2016\";s:4:\"time\";s:7:\"6:48 am\";}s:44:\"https://tangoandmore.com/?people=mary-thorne\";a:2:{s:4:\"date\";s:14:\"April 13, 2016\";s:4:\"time\";s:7:\"6:46 am\";}s:49:\"https://tangoandmore.com/?people=dan-michaels-2-3\";a:2:{s:4:\"date\";s:14:\"April 12, 2016\";s:4:\"time\";s:7:\"1:04 pm\";}s:49:\"https://tangoandmore.com/?people=dan-michaels-2-2\";a:2:{s:4:\"date\";s:14:\"April 12, 2016\";s:4:\"time\";s:8:\"12:40 pm\";}s:47:\"https://tangoandmore.com/?people=dan-michaels-2\";a:2:{s:4:\"date\";s:14:\"April 12, 2016\";s:4:\"time\";s:8:\"12:16 pm\";}s:45:\"https://tangoandmore.com/?people=dan-michaels\";a:2:{s:4:\"date\";s:14:\"April 12, 2016\";s:4:\"time\";s:8:\"12:00 pm\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:8;s:5:\"total\";i:8;}}", "2026-01-21 07:21:35", "2025-09-30 17:42:49", "2025-12-22 07:21:35");
INSERT INTO `wp_aioseo_cache` VALUES("3837", "aioseo_sitemap_category-sitemap.xml", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:6:{s:44:\"https://tangoandmore.com/category/lifestyle/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:39:\"https://tangoandmore.com/category/news/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:41:\"https://tangoandmore.com/category/others/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:41:\"https://tangoandmore.com/category/people/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:39:\"https://tangoandmore.com/category/post/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:44:\"https://tangoandmore.com/category/wordpress/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:6;s:5:\"total\";i:6;}}", "2026-01-21 07:19:47", "2025-09-30 17:42:50", "2025-12-22 07:19:47");
INSERT INTO `wp_aioseo_cache` VALUES("3838", "aioseo_sitemap_post_tag-sitemap.xml", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:5:{s:36:\"https://tangoandmore.com/tag/agency/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:38:\"https://tangoandmore.com/tag/apollo13/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:41:\"https://tangoandmore.com/tag/information/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:37:\"https://tangoandmore.com/tag/popular/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:39:\"https://tangoandmore.com/tag/wordpress/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:5;s:5:\"total\";i:5;}}", "2026-01-21 07:20:36", "2025-09-30 17:42:51", "2025-12-22 07:20:36");
INSERT INTO `wp_aioseo_cache` VALUES("3839", "aioseo_sitemap_genre-sitemap.xml", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:4:{s:39:\"https://tangoandmore.com/genre/gallery/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:37:\"https://tangoandmore.com/genre/model/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:41:\"https://tangoandmore.com/genre/slideshow/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:38:\"https://tangoandmore.com/genre/studio/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:4;s:5:\"total\";i:4;}}", "2026-01-21 07:20:55", "2025-09-30 17:42:52", "2025-12-22 07:20:55");
INSERT INTO `wp_aioseo_cache` VALUES("3840", "aioseo_sitemap_work_genre-sitemap.xml", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:4:{s:50:\"https://tangoandmore.com/work_genre/advertisement/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:50:\"https://tangoandmore.com/work_genre/art-direction/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:54:\"https://tangoandmore.com/work_genre/branding-identity/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:51:\"https://tangoandmore.com/work_genre/graphic-design/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:4;s:5:\"total\";i:4;}}", "2026-01-21 04:07:14", "2025-09-30 17:42:55", "2025-12-22 04:07:14");
INSERT INTO `wp_aioseo_cache` VALUES("3841", "aioseo_sitemap_group-sitemap.xml", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:2:{s:36:\"https://tangoandmore.com/group/team/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}s:44:\"https://tangoandmore.com/group/testimonials/\";a:2:{s:4:\"date\";s:15:\"January 1, 1970\";s:4:\"time\";s:8:\"12:00 am\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:2;s:5:\"total\";i:2;}}", "2026-01-21 07:21:49", "2025-09-30 17:42:56", "2025-12-22 07:21:49");
INSERT INTO `wp_aioseo_cache` VALUES("3847", "wp_notices", "a:0:{}", "2025-12-24 11:37:24", "2025-10-01 15:44:31", "2025-12-23 11:37:24");
INSERT INTO `wp_aioseo_cache` VALUES("3913", "aioseo_sitemap_sitemap.xml.gz", "a:3:{s:6:\"counts\";a:10:{s:41:\"https://tangoandmore.com/post-sitemap.xml\";i:8;s:41:\"https://tangoandmore.com/page-sitemap.xml\";i:7;s:42:\"https://tangoandmore.com/album-sitemap.xml\";i:9;s:41:\"https://tangoandmore.com/work-sitemap.xml\";i:6;s:43:\"https://tangoandmore.com/people-sitemap.xml\";i:8;s:45:\"https://tangoandmore.com/category-sitemap.xml\";i:6;s:45:\"https://tangoandmore.com/post_tag-sitemap.xml\";i:5;s:42:\"https://tangoandmore.com/genre-sitemap.xml\";i:4;s:47:\"https://tangoandmore.com/work_genre-sitemap.xml\";i:4;s:42:\"https://tangoandmore.com/group-sitemap.xml\";i:2;}s:8:\"datetime\";a:10:{s:41:\"https://tangoandmore.com/post-sitemap.xml\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:35 pm\";}s:41:\"https://tangoandmore.com/page-sitemap.xml\";a:2:{s:4:\"date\";s:17:\"November 18, 2025\";s:4:\"time\";s:8:\"12:05 pm\";}s:42:\"https://tangoandmore.com/album-sitemap.xml\";a:2:{s:4:\"date\";s:13:\"April 4, 2025\";s:4:\"time\";s:7:\"2:54 pm\";}s:41:\"https://tangoandmore.com/work-sitemap.xml\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"6:14 pm\";}s:43:\"https://tangoandmore.com/people-sitemap.xml\";a:2:{s:4:\"date\";s:14:\"April 13, 2016\";s:4:\"time\";s:7:\"6:54 am\";}s:45:\"https://tangoandmore.com/category-sitemap.xml\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:35 pm\";}s:45:\"https://tangoandmore.com/post_tag-sitemap.xml\";a:2:{s:4:\"date\";s:16:\"January 29, 2018\";s:4:\"time\";s:7:\"2:35 pm\";}s:42:\"https://tangoandmore.com/genre-sitemap.xml\";a:2:{s:4:\"date\";s:13:\"April 4, 2025\";s:4:\"time\";s:7:\"2:54 pm\";}s:47:\"https://tangoandmore.com/work_genre-sitemap.xml\";a:2:{s:4:\"date\";s:16:\"February 5, 2018\";s:4:\"time\";s:7:\"6:14 pm\";}s:42:\"https://tangoandmore.com/group-sitemap.xml\";a:2:{s:4:\"date\";s:14:\"April 13, 2016\";s:4:\"time\";s:7:\"6:54 am\";}}s:10:\"pagination\";a:2:{s:7:\"showing\";i:10;s:5:\"total\";i:10;}}", "2026-01-18 21:31:56", "2025-10-11 18:17:34", "2025-12-19 21:31:56");
INSERT INTO `wp_aioseo_cache` VALUES("4035", "aioseo_sitemap_author-sitemap.xml", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:0:{}s:10:\"pagination\";a:2:{s:7:\"showing\";i:0;s:5:\"total\";i:0;}}", "2026-01-10 07:46:24", "2025-11-05 04:22:33", "2025-12-11 07:46:24");
INSERT INTO `wp_aioseo_cache` VALUES("4047", "license_features", "a:49:{i:0;a:3:{s:13:\"license_level\";s:3:\"pro\";s:7:\"section\";s:6:\"schema\";s:7:\"feature\";s:5:\"event\";}i:1;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:6:\"schema\";s:7:\"feature\";s:5:\"event\";}i:2;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:6:\"schema\";s:7:\"feature\";s:11:\"job-posting\";}i:3;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:5:\"tools\";s:7:\"feature\";s:29:\"network-tools-site-activation\";}i:4;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:5:\"tools\";s:7:\"feature\";s:22:\"network-tools-database\";}i:5;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:5:\"tools\";s:7:\"feature\";s:27:\"network-tools-import-export\";}i:6;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:5:\"tools\";s:7:\"feature\";s:20:\"network-tools-robots\";}i:7;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:14:\"seo-statistics\";}i:8;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:16:\"keyword-rankings\";}i:9;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:22:\"keyword-rankings-pages\";}i:10;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:11:\"post-detail\";}i:11;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:22:\"post-detail-page-speed\";}i:12;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:26:\"post-detail-seo-statistics\";}i:13;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:20:\"post-detail-keywords\";}i:14;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:31:\"post-detail-focus-keyword-trend\";}i:15;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:16:\"keyword-tracking\";}i:16;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:28:\"post-detail-keyword-tracking\";}i:17;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:16:\"content-rankings\";}i:18;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:13:\"seo-revisions\";s:7:\"feature\";s:12:\"revisions:-1\";}i:19;a:3:{s:13:\"license_level\";s:3:\"pro\";s:7:\"section\";s:13:\"seo-revisions\";s:7:\"feature\";s:12:\"revisions:30\";}i:20;a:3:{s:13:\"license_level\";s:4:\"plus\";s:7:\"section\";s:13:\"seo-revisions\";s:7:\"feature\";s:12:\"revisions:15\";}i:21;a:3:{s:13:\"license_level\";s:3:\"pro\";s:7:\"section\";s:7:\"general\";s:7:\"feature\";s:19:\"cornerstone-content\";}i:22;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:7:\"general\";s:7:\"feature\";s:19:\"cornerstone-content\";}i:23;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:12:\"index-status\";}i:24;a:3:{s:13:\"license_level\";s:4:\"plus\";s:7:\"section\";s:11:\"aioseo-eeat\";s:7:\"feature\";s:11:\"author-info\";}i:25;a:3:{s:13:\"license_level\";s:3:\"pro\";s:7:\"section\";s:11:\"aioseo-eeat\";s:7:\"feature\";s:11:\"author-info\";}i:26;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:11:\"aioseo-eeat\";s:7:\"feature\";s:11:\"author-info\";}i:27;a:3:{s:13:\"license_level\";s:3:\"pro\";s:7:\"section\";s:11:\"aioseo-eeat\";s:7:\"feature\";s:18:\"author-archive-bio\";}i:28;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:11:\"aioseo-eeat\";s:7:\"feature\";s:18:\"author-archive-bio\";}i:29;a:3:{s:13:\"license_level\";s:3:\"pro\";s:7:\"section\";s:11:\"aioseo-eeat\";s:7:\"feature\";s:13:\"post-reviewer\";}i:30;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:11:\"aioseo-eeat\";s:7:\"feature\";s:13:\"post-reviewer\";}i:31;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:17:\"search-statistics\";s:7:\"feature\";s:24:\"keyword-rank-tracker:100\";}i:32;a:3:{s:13:\"license_level\";s:4:\"plus\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:12:\"http-headers\";}i:33;a:3:{s:13:\"license_level\";s:3:\"pro\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:12:\"http-headers\";}i:34;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:12:\"http-headers\";}i:35;a:3:{s:13:\"license_level\";s:3:\"pro\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:4:\"logs\";}i:36;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:4:\"logs\";}i:37;a:3:{s:13:\"license_level\";s:3:\"pro\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:21:\"advanced-404-settings\";}i:38;a:3:{s:13:\"license_level\";s:3:\"pro\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:18:\"full-site-redirect\";}i:39;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:18:\"full-site-redirect\";}i:40;a:3:{s:13:\"license_level\";s:5:\"elite\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:21:\"advanced-404-settings\";}i:41;a:3:{s:13:\"license_level\";s:6:\"agency\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:12:\"http-headers\";}i:42;a:3:{s:13:\"license_level\";s:6:\"agency\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:4:\"logs\";}i:43;a:3:{s:13:\"license_level\";s:6:\"agency\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:18:\"full-site-redirect\";}i:44;a:3:{s:13:\"license_level\";s:8:\"business\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:12:\"http-headers\";}i:45;a:3:{s:13:\"license_level\";s:8:\"business\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:4:\"logs\";}i:46;a:3:{s:13:\"license_level\";s:8:\"business\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:18:\"full-site-redirect\";}i:47;a:3:{s:13:\"license_level\";s:6:\"agency\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:21:\"advanced-404-settings\";}i:48;a:3:{s:13:\"license_level\";s:8:\"business\";s:7:\"section\";s:9:\"redirects\";s:7:\"feature\";s:21:\"advanced-404-settings\";}}", "2025-12-24 11:37:24", "2025-11-06 03:19:37", "2025-12-23 11:37:24");
INSERT INTO `wp_aioseo_cache` VALUES("4048", "admin_help_docs", "s:74143:\"{\"categories\":{\"getting-started\":\"Getting Started\",\"advanced-settings\":\"Advanced Settings\",\"display-settings\":\"Display Settings\",\"general-seo-topics\":\"General SEO Topics\",\"feature-manager\":\"Feature Manager\",\"installation\":\"Installation\"},\"docs\":{\"401534\":{\"title\":\"How to Generate Your SEO Email Reports\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-generate-your-seo-email-reports\\/\",\"categories\":[\"advanced-settings\",\"general-settings\",\"search-statistics\"]},\"389367\":{\"title\":\"Using the Keyword Rank Tracker feature in Search Statistics\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-keyword-rank-tracker-feature-in-search-statistics\\/\",\"categories\":[\"keyword-settings\",\"search-statistics\"]},\"379863\":{\"title\":\"Setting Vehicle (Car) Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-vehicle-car-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"379713\":{\"title\":\"Setting Product Review Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-product-review-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"332691\":{\"title\":\"Google Permissions for oAuth\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/google-permissions-for-the-aioseo-google-search-console-integration\\/\",\"categories\":[]},\"326862\":{\"title\":\"aioseo_user_profile_tab_allowed_user_ids\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_user_profile_tab_allowed_user_ids\\/\",\"categories\":[\"developer-documentation\",\"filter-hooks\"]},\"326858\":{\"title\":\"aioseo_import_yoast_seo_posts_per_action\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_import_yoast_seo_posts_per_action\\/\",\"categories\":[\"developer-documentation\",\"filter-hooks\"]},\"326856\":{\"title\":\"aioseo_import_seopress_posts_per_action\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_import_seopress_posts_per_action\\/\",\"categories\":[\"developer-documentation\",\"filter-hooks\"]},\"326850\":{\"title\":\"aioseo_import_rank_math_posts_per_action\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_import_rank_math_posts_per_action\\/\",\"categories\":[\"developer-documentation\",\"filter-hooks\"]},\"298356\":{\"title\":\"aioseo_redirects_log_skip\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_redirects_log_skip\\/\",\"categories\":[\"developer-documentation\",\"filter-hooks\"]},\"294047\":{\"title\":\"Using the Query Arg Monitoring in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-query-arg-monitoring-in-all-in-one-seo\\/\",\"categories\":[\"advanced-settings\"]},\"279241\":{\"title\":\"How to Schedule a Redirect in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-schedule-a-redirect-in-all-in-one-seo\\/\",\"categories\":[\"redirection-manager\"]},\"269732\":{\"title\":\"Displaying Detailed Author Information on Your Site\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/displaying-detailed-author-information-on-your-site\\/\",\"categories\":[\"author-seo\",\"content-blocks\"]},\"267254\":{\"title\":\"Adding Author SEO (E-E-A-T) to Your Site\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-author-seo-e-e-a-t-to-your-site\\/\",\"categories\":[\"author-seo\"]},\"262344\":{\"title\":\"How to Get Your Images to Appear in Search Results\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-get-your-images-to-appear-in-search-results\\/\",\"categories\":[\"frequently-asked-questions\",\"general-seo-topics\",\"image-seo\"]},\"261932\":{\"title\":\"Sharing Content on Slack\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/sharing-content-on-slack\\/\",\"categories\":[\"social-networks\"]},\"261923\":{\"title\":\"Sharing Content on WhatsApp\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/sharing-content-on-whatsapp\\/\",\"categories\":[\"social-networks\"]},\"261517\":{\"title\":\"Importing Locations From Other Plugins\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/importing-locations-from-other-plugins\\/\",\"categories\":[\"importer-exporter\",\"local-business-seo\"]},\"244975\":{\"title\":\"Checking the Index Status of Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/checking-the-index-status-of-content\\/\",\"categories\":[\"post-page-settings\",\"search-statistics\"]},\"242346\":{\"title\":\"Using AIOSEO Details on the Posts Screen\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-aioseo-details-on-the-posts-screen\\/\",\"categories\":[\"category-tag-settings\",\"post-page-settings\"]},\"240583\":{\"title\":\"Setting WP_HOME and WP_SITEURL in the wp-config.php File\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-wp_home-and-wp_siteurl-in-the-wp-config-php-file\\/\",\"categories\":[\"troubleshooting\"]},\"240452\":{\"title\":\"Should I Use Meta Keywords?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/should-i-use-meta-keywords\\/\",\"categories\":[\"frequently-asked-questions\",\"general-seo-topics\"]},\"235044\":{\"title\":\"Setting Cornerstone Content in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/cornerstone-content\\/\",\"categories\":[\"link-assistant\",\"post-page-settings\"]},\"222363\":{\"title\":\"aioseo_get_post_id\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_get_post_id\\/\",\"categories\":[\"filter-hooks\"]},\"200603\":{\"title\":\"Viewing Detailed Search Statistics For Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/viewing-detailed-search-statistics-for-your-content\\/\",\"categories\":[\"search-statistics\"]},\"200304\":{\"title\":\"Tracking Changes to Your SEO Using SEO Revisions\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/tracking-changes-to-your-seo-using-seo-revisions\\/\",\"categories\":[\"seo-revisions\"]},\"188167\":{\"title\":\"WPCode Snippet Library\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/wpcode-snippet-library\\/\",\"categories\":[\"tools\"]},\"186946\":{\"title\":\"aioseo_hide_version_number\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_hide_version_number\\/\",\"categories\":[\"filter-hooks\"]},\"178887\":{\"title\":\"Setting the Primary Term for Breadcrumbs\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-primary-term-for-breadcrumbs\\/\",\"categories\":[\"breadcrumbs\"]},\"178727\":{\"title\":\"Using Broken Link Checker to Find and Fix Broken Links and Images\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-broken-link-checker-to-find-and-fix-broken-links-and-images\\/\",\"categories\":[\"broken-link-checker\"]},\"163922\":{\"title\":\"aioseo_schema_json_flags\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_schema_json_flags\\/\",\"categories\":[\"filter-hooks\"]},\"163519\":{\"title\":\"Using OpenAI to Generate SEO Titles and Meta Descriptions\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-openai-to-generate-seo-titles-and-meta-descriptions\\/\",\"categories\":[]},\"145363\":{\"title\":\"Using the Search Statistics in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-search-statistics-in-all-in-one-seo\\/\",\"categories\":[\"google-search-console\",\"search-statistics\"]},\"145281\":{\"title\":\"Connecting Search Statistics to Google Search Console\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/connecting-search-statistics-to-google-search-console\\/\",\"categories\":[\"google-search-console\",\"search-statistics\"]},\"139798\":{\"title\":\"Checking Your SEO Using the SEO Preview\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/checking-your-seo-using-the-seo-preview\\/\",\"categories\":[\"facebook-settings\",\"post-page-settings\",\"seo-preview\",\"truseo\",\"twitter-settings\"]},\"136509\":{\"title\":\"aioseo_sitemap_lastmod_disable\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_sitemap_lastmod_disable\\/\",\"categories\":[\"filter-hooks\"]},\"135249\":{\"title\":\"aioseo_sitemap_rss\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_sitemap_rss\\/\",\"categories\":[\"filter-hooks\"]},\"133251\":{\"title\":\"aioseo_user_profile_tab_disable\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_user_profile_tab_disable\\/\",\"categories\":[\"filter-hooks\"]},\"131885\":{\"title\":\"Setting Web Page Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-web-page-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"129515\":{\"title\":\"Editing the .htaccess file Using All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/editing-the-htaccess-file-using-all-in-one-seo\\/\",\"categories\":[\"file-editor\",\"tools\"]},\"124292\":{\"title\":\"Using the Emojis in Titles and Descriptions\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-emojis-in-titles-and-descriptions\\/\",\"categories\":[\"facebook-settings\",\"post-page-settings\",\"search-appearance\",\"social-networks\",\"twitter-settings\"]},\"123164\":{\"title\":\"Google Permissions for the AIOSEO Google Search Console Integration\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/google-permissions-for-oauth\\/\",\"categories\":[\"google-search-console\",\"search-statistics\"]},\"112137\":{\"title\":\"Setting the Schema Type for Individual Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-schema-type-for-individual-content\\/\",\"categories\":[\"schema-settings\"]},\"112145\":{\"title\":\"Configuring the Schema Settings in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/configuring-the-schema-settings-in-all-in-one-seo\\/\",\"categories\":[\"schema-settings\"]},\"112153\":{\"title\":\"A Guide to Schema.org Markup for Rich Snippets\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/a-guide-to-schema-org-markup-for-rich-snippets\\/\",\"categories\":[\"schema-settings\"]},\"112438\":{\"title\":\"Creating Reusable Schema Templates in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/creating-reusable-schema-templates-in-all-in-one-seo\\/\",\"categories\":[\"schema-settings\"]},\"112428\":{\"title\":\"Creating Custom Schema Markup with All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/creating-custom-schema-markup-with-all-in-one-seo\\/\",\"categories\":[\"schema-settings\"]},\"112889\":{\"title\":\"Setting Event Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-event-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112735\":{\"title\":\"Setting Dataset Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-dataset-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112711\":{\"title\":\"Setting Article Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-article-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112164\":{\"title\":\"Setting Course Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-course-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112933\":{\"title\":\"Setting Job Posting Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-job-posting-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112926\":{\"title\":\"Setting How-To Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-how-to-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112916\":{\"title\":\"Setting Fact Check Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-fact-check-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112727\":{\"title\":\"Setting Book Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-book-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112243\":{\"title\":\"Setting FAQ Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-faq-page-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112958\":{\"title\":\"Setting Service Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-service-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112949\":{\"title\":\"Setting Person Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-person-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112944\":{\"title\":\"Setting Music Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-music-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112941\":{\"title\":\"Setting Movie Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-movie-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112212\":{\"title\":\"Setting Recipe Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-recipe-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112962\":{\"title\":\"Setting Video Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-video-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112403\":{\"title\":\"Testing Your Schema in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/testing-your-schema-in-all-in-one-seo\\/\",\"categories\":[\"schema-settings\"]},\"112226\":{\"title\":\"Setting Software Application Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-software-application-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"112197\":{\"title\":\"Setting Product Schema Markup in Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-product-schema-markup-in-your-content\\/\",\"categories\":[\"schema-settings\"]},\"119555\":{\"title\":\"How to Use the AIOSEO Feature Manager on a Multisite Network\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-use-the-aioseo-feature-manager-on-a-multisite-network\\/\",\"categories\":[\"feature-manager\",\"multisite-networks\"]},\"119550\":{\"title\":\"How to Reset the AIOSEO Site Settings on a Multisite Network\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-reset-the-aioseo-site-settings-on-a-multisite-network\\/\",\"categories\":[\"multisite-networks\",\"network-tools\"]},\"119543\":{\"title\":\"How to Backup and Restore AIOSEO Site Settings on a Multisite Network\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-backup-and-restore-aioseo-site-settings-on-a-multisite-network\\/\",\"categories\":[\"multisite-networks\",\"network-tools\"]},\"119531\":{\"title\":\"How to Import Settings from Other Plugins on a Multisite Network\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-import-settings-from-other-plugins-on-a-multisite-network\\/\",\"categories\":[\"multisite-networks\",\"network-tools\"]},\"119519\":{\"title\":\"How to Import and Export AIOSEO Settings and Meta Data on a Multisite Network\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-import-and-export-aioseo-settings-and-meta-data-on-a-multisite-network\\/\",\"categories\":[\"multisite-networks\",\"network-tools\"]},\"119497\":{\"title\":\"How to Add Your AIOSEO License Key on a WordPress Multisite Network\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-add-your-aioseo-license-key-on-a-wordpress-multisite-network\\/\",\"categories\":[\"multisite-networks\",\"network-settings\"]},\"111476\":{\"title\":\"Displaying a List of Locations on Your Site\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/displaying-a-list-of-locations-on-your-site\\/\",\"categories\":[\"content-blocks\",\"local-business-seo\"]},\"111473\":{\"title\":\"Displaying Your Business Location Information on Your Site\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/displaying-your-business-location-information-on-your-site\\/\",\"categories\":[\"content-blocks\",\"local-business-seo\"]},\"111459\":{\"title\":\"Displaying Opening Hours on Your Site\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/displaying-opening-hours-on-your-site\\/\",\"categories\":[\"content-blocks\",\"local-business-seo\"]},\"111455\":{\"title\":\"Adding a Map of Your Location to Your Site\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-a-map-of-your-location-to-your-site\\/\",\"categories\":[\"content-blocks\",\"local-business-seo\"]},\"111450\":{\"title\":\"Adding Breadcrumbs to Your Site Using the AIOSEO Breadcrumbs Block\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-breadcrumbs-to-your-site-using-the-aioseo-breadcrumbs-block\\/\",\"categories\":[\"breadcrumbs\",\"content-blocks\"]},\"109878\":{\"title\":\"Adding a Redirect When You Delete Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-a-redirect-when-you-delete-content\\/\",\"categories\":[\"redirection-manager\"]},\"109829\":{\"title\":\"Redirecting 404 Content Not Found Using All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/redirecting-404-content-not-found-using-all-in-one-seo\\/\",\"categories\":[\"redirection-manager\"]},\"109916\":{\"title\":\"Using the Image SEO Features in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-image-seo-features-in-all-in-one-seo\\/\",\"categories\":[\"image-seo\"]},\"104857\":{\"title\":\"Adding a Table of Contents to Your Site Using All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-a-table-of-contents-to-your-site-using-all-in-one-seo\\/\",\"categories\":[\"content-blocks\"]},\"104616\":{\"title\":\"Adding FAQs to Your Site Using All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-faqs-to-your-site-using-all-in-one-seo\\/\",\"categories\":[\"content-blocks\"]},\"104595\":{\"title\":\"Automatic Redirects When Changing the Post Slug\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/automatic-redirects-when-changing-the-post-slug\\/\",\"categories\":[\"redirection-manager\"]},\"103415\":{\"title\":\"Removing Published Date from Article Schema\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/removing-published-date-from-article-schema\\/\",\"categories\":[\"developer-documentation\"]},\"101250\":{\"title\":\"Outputting AIOSEO\'s data in the HEAD without using wp_head()\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/outputting-aioseos-data-in-the-head-without-using-wp_head\\/\",\"categories\":[\"developer-documentation\"]},\"100154\":{\"title\":\"Automatic Redirects When You Delete Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/automatic-redirects-when-you-delete-content\\/\",\"categories\":[\"redirection-manager\"]},\"98532\":{\"title\":\"Localizing AIOSEO Data via the Translations API\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/localizing-aioseo-data-via-the-translations-api\\/\",\"categories\":[\"developer-documentation\"]},\"98576\":{\"title\":\"aioseo_sitemap_term\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_sitemap_term\\/\",\"categories\":[\"filter-hooks\"]},\"98575\":{\"title\":\"aioseo_sitemap_post\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_sitemap_post\\/\",\"categories\":[\"filter-hooks\"]},\"98566\":{\"title\":\"aioseo_save_term\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_save_term\\/\",\"categories\":[\"filter-hooks\"]},\"98565\":{\"title\":\"aioseo_save_post\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_save_post\\/\",\"categories\":[\"filter-hooks\"]},\"98557\":{\"title\":\"aioseo_get_term\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_get_term\\/\",\"categories\":[\"filter-hooks\"]},\"98554\":{\"title\":\"aioseo_get_post\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_get_post\\/\",\"categories\":[\"filter-hooks\"]},\"93967\":{\"title\":\"Importing URLs into the XML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/importing-urls-into-the-xml-sitemap\\/\",\"categories\":[\"xml-sitemap\"]},\"93822\":{\"title\":\"How to Use Crawl Cleanup to Increase Search Engine Crawl Quota\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/crawl-cleanup-best-practices\\/\",\"categories\":[\"advanced-settings\"]},\"90584\":{\"title\":\"How to Add a Temporary Administrator Login to Your Site\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-add-a-temporary-administrator-login-to-your-site\\/\",\"categories\":[\"frequently-asked-questions\",\"troubleshooting\"]},\"88927\":{\"title\":\"Dashboard Widgets in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/dashboard-widgets-in-all-in-one-seo\\/\",\"categories\":[\"dashboard\"]},\"86198\":{\"title\":\"How to Strip the Category Base in WordPress\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-strip-the-category-base-in-wordpress\\/\",\"categories\":[\"category-tag-settings\"]},\"84322\":{\"title\":\"Running shortcodes in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/running-shortcodes\\/\",\"categories\":[\"advanced-settings\"]},\"84156\":{\"title\":\"Translating Your SEO with WPML\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/translating-your-seo-with-wpml\\/\",\"categories\":[\"post-page-settings\"]},\"80219\":{\"title\":\"How to Verify Your Site with Microsoft Clarity\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-verify-your-site-with-microsoft-clarity\\/\",\"categories\":[\"webmaster-tools\"]},\"79928\":{\"title\":\"How to Handle Issues With Installing All in One SEO Pro\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-handle-issues-with-installing-all-in-one-seo-pro\\/\",\"categories\":[\"installation\"]},\"79149\":{\"title\":\"Fetching &amp; Updating AIOSEO Data via the WordPress REST API\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/fetching-updating-aioseo-data-via-the-wordpress-rest-api\\/\",\"categories\":[\"developer-documentation\",\"rest-api\"]},\"77593\":{\"title\":\"How To Fix JavaScript Errors\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-fix-javascript-errors\\/\",\"categories\":[\"troubleshooting\"]},\"77589\":{\"title\":\"Browser Support Policy\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/browser-support-policy\\/\",\"categories\":[\"frequently-asked-questions\"]},\"75143\":{\"title\":\"How to Redirect a Post from the Edit Post Screen\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-redirect-a-post-from-the-edit-post-screen\\/\",\"categories\":[\"post-page-settings\",\"redirection-manager\"]},\"75686\":{\"title\":\"Preventing the Modified Date for Content from Changing\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/preventing-the-modified-date-for-content-from-changing\\/\",\"categories\":[\"post-page-settings\"]},\"73002\":{\"title\":\"Page Builder Integrations\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/page-builder-integrations\\/\",\"categories\":[\"home-page-settings\",\"post-page-settings\",\"third-party-integrations\",\"truseo\"]},\"73003\":{\"title\":\"Integrating with IndexNow to Instantly Re-index Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/integrating-with-indexnow-to-instantly-re-index-your-content\\/\",\"categories\":[\"indexnow\",\"webmaster-tools\"]},\"72711\":{\"title\":\"aioseo_page_builder_integration_disable\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_page_builder_integration_disable\\/\",\"categories\":[\"filter-hooks\"]},\"68444\":{\"title\":\"An Introduction to Link Assistant \\u2014 The Easy Way to Manage Onsite Links\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/introduction-to-link-assistant\\/\",\"categories\":[\"link-assistant\"]},\"69559\":{\"title\":\"Using the Link Assistant in All in One SEO Pro\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/link-assistant\\/\",\"categories\":[\"link-assistant\"]},\"69594\":{\"title\":\"Internal Links in the Links Report in Link Assistant\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/internal-links-in-the-links-report-in-link-assistant\\/\",\"categories\":[\"link-assistant\"]},\"69596\":{\"title\":\"External Links in the Links Report in Link Assistant\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/external-links-in-the-links-report-in-link-assistant\\/\",\"categories\":[\"link-assistant\"]},\"69921\":{\"title\":\"Link Suggestions in the Links Report in Link Assistant\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/link-suggestions-in-the-links-report-in-link-assistant\\/\",\"categories\":[\"link-assistant\"]},\"69602\":{\"title\":\"Affiliate Links in the Links Report in Link Assistant\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/affiliate-links-in-the-links-report-in-link-assistant\\/\",\"categories\":[\"link-assistant\"]},\"69761\":{\"title\":\"Using the Domains Report in Link Assistant\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-domains-report-in-link-assistant\\/\",\"categories\":[\"link-assistant\"]},\"69770\":{\"title\":\"Link Assistant Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/link-assistant-settings\\/\",\"categories\":[\"link-assistant\"]},\"68431\":{\"title\":\"aioseo_sitemap_images\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_sitemap_images\\/\",\"categories\":[\"filter-hooks\"]},\"66833\":{\"title\":\"Why Is N\\/A Displayed Instead of a Score For My Content?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/why-is-na-displayed-instead-of-a-score-for-my-content\\/\",\"categories\":[\"frequently-asked-questions\",\"truseo\"]},\"18824\":{\"title\":\"Local Business SEO for a Single Location\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/local-business-seo-for-a-single-location\\/\",\"categories\":[\"local-business-seo\",\"schema-settings\"]},\"35828\":{\"title\":\"Local Business SEO for Multiple Locations\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/local-business-seo-for-multiple-locations\\/\",\"categories\":[\"local-business-seo\"]},\"58476\":{\"title\":\"aioseo_public_taxonomies\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_public_taxonomies\\/\",\"categories\":[\"filter-hooks\"]},\"58475\":{\"title\":\"aioseo_public_post_types\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_public_post_types\\/\",\"categories\":[\"filter-hooks\"]},\"64776\":{\"title\":\"How Long Does it Take For My Content to Appear on Google?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-long-does-it-take-for-my-content-to-appear-on-google\\/\",\"categories\":[\"frequently-asked-questions\"]},\"35926\":{\"title\":\"Adding a Location in Local SEO Addon\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-a-location-in-local-seo-addon\\/\",\"categories\":[\"local-business-seo\"]},\"61020\":{\"title\":\"How to Display a Favicon in Search Results\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-display-a-favicon-in-search-results\\/\",\"categories\":[\"frequently-asked-questions\",\"general-seo-topics\"]},\"35956\":{\"title\":\"Displaying Locations on Your Site\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/displaying-locations-on-your-site\\/\",\"categories\":[\"local-business-seo\"]},\"56330\":{\"title\":\"aioseo_sitemap_indexes\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_sitemap_indexes\\/\",\"categories\":[\"filter-hooks\"]},\"56011\":{\"title\":\"Redirect Manager - Configuration Reload\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/redirect-manager-configuration-reload\\/\",\"categories\":[\"redirection-manager\"]},\"52689\":{\"title\":\"aioseo_flyout_menu_enable\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_flyout_menu_disable\\/\",\"categories\":[\"filter-hooks\"]},\"45698\":{\"title\":\"Displaying your Business Information and Star Ratings on a Map\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-places-on-your-maps\\/\",\"categories\":[\"local-business-seo\"]},\"49268\":{\"title\":\"aioseo_access_control_excluded_roles\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_access_control_excluded_roles\\/\",\"categories\":[\"filter-hooks\"]},\"44555\":{\"title\":\"Setting up Google Maps for Local SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-up-google-maps\\/\",\"categories\":[\"local-business-seo\"]},\"48189\":{\"title\":\"How to Create an HTML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/html-sitemap\\/\",\"categories\":[\"html-sitemap\"]},\"48365\":{\"title\":\"Using a Widget to Display Your HTML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-a-widget-to-display-your-html-sitemap\\/\",\"categories\":[\"html-sitemap\"]},\"48361\":{\"title\":\"Using PHP Code to Display Your HTML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/function-html-sitemap\\/\",\"categories\":[\"html-sitemap\"]},\"48260\":{\"title\":\"Using a Block to Display Your HTML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-a-block-to-display-your-html-sitemap\\/\",\"categories\":[\"content-blocks\",\"html-sitemap\"]},\"48222\":{\"title\":\"aioseo_breadcrumbs_separator_symbol\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_breadcrumbs_separator_symbol\\/\",\"categories\":[\"filter-hooks\"]},\"48227\":{\"title\":\"aioseo_breadcrumbs_template\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_breadcrumbs_template\\/\",\"categories\":[\"filter-hooks\"]},\"48231\":{\"title\":\"aioseo_breadcrumbs_trail\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_breadcrumbs_trail\\/\",\"categories\":[\"filter-hooks\"]},\"48232\":{\"title\":\"aioseo_breadcrumbs_link_current_item\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_breadcrumbs_link_current_item\\/\",\"categories\":[\"filter-hooks\"]},\"48233\":{\"title\":\"aioseo_breadcrumbs_show_current_item\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_breadcrumbs_show_current_item\\/\",\"categories\":[\"filter-hooks\"]},\"48219\":{\"title\":\"aioseo_breadcrumbs_output\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_breadcrumbs_output\\/\",\"categories\":[\"filter-hooks\"]},\"48223\":{\"title\":\"aioseo_breadcrumbs_separator\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_breadcrumbs_separator\\/\",\"categories\":[\"filter-hooks\"]},\"48238\":{\"title\":\"Using a Shortcode to Display Your HTML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/shortcode-html-sitemap\\/\",\"categories\":[\"html-sitemap\"]},\"45805\":{\"title\":\"aioseo_sitemap_exclude_terms\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_sitemap_exclude_terms\\/\",\"categories\":[\"filter-hooks\"]},\"45804\":{\"title\":\"aioseo_sitemap_exclude_posts\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_sitemap_exclude_posts\\/\",\"categories\":[\"filter-hooks\"]},\"61002\":{\"title\":\"How to Create a Google Maps API Key\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-a-google-maps-api-key\\/\",\"categories\":[\"local-business-seo\"]},\"45528\":{\"title\":\"aioseo_schema_output\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_schema_output\\/\",\"categories\":[\"filter-hooks\"]},\"42995\":{\"title\":\"Using the Headline Analyzer in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-headline-analyzer-in-all-in-one-seo\\/\",\"categories\":[\"headline-analyzer\"]},\"42683\":{\"title\":\"How to Perform a Full Site Redirect\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/full-site-redirects\\/\",\"categories\":[\"redirection-manager\"]},\"50988\":{\"title\":\"Displaying Maps on Your Site\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/displaying-maps-on-your-site\\/\",\"categories\":[\"local-business-seo\"]},\"42999\":{\"title\":\"How to Disable the Headline Analyzer\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-disable-the-headline-analyzer\\/\",\"categories\":[\"advanced-settings\",\"headline-analyzer\"]},\"42975\":{\"title\":\"Installing Addons for All in One SEO Pro\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/installing-addons-for-all-in-one-seo-pro\\/\",\"categories\":[\"installation\"]},\"42854\":{\"title\":\"Creating a Pass Through Redirect\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/creating-a-pass-through-redirect\\/\",\"categories\":[\"redirection-manager\"]},\"41800\":{\"title\":\"Using Custom Rules in the Redirection Manager\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/redirection-manager-custom-rules\\/\",\"categories\":[\"redirection-manager\"]},\"42224\":{\"title\":\"Resetting the Settings in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/resetting-the-settings-in-all-in-one-seo\\/\",\"categories\":[\"database-tools\",\"tools\"]},\"41884\":{\"title\":\"Setting the Site Name for Facebook\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-site-name-for-facebook\\/\",\"categories\":[\"facebook-settings\",\"social-networks\"]},\"41862\":{\"title\":\"How to Get Google to Display the Sitelinks Search Box\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-get-google-to-display-the-sitelinks-search-box\\/\",\"categories\":[\"schema-settings\"]},\"41851\":{\"title\":\"Setting the SEO Title and Description Format for the Search Results Page\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-title-and-description-format-for-the-search-results-page\\/\",\"categories\":[\"content-type-settings\",\"search-appearance\"]},\"41811\":{\"title\":\"SEO Analysis Unable to Connect to Your Site\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/seo-analysis-unable-to-connect-to-your-site\\/\",\"categories\":[\"seo-analysis\",\"troubleshooting\"]},\"41280\":{\"title\":\"How to Renew Your AIOSEO License\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-renew-your-aioseo-license\\/\",\"categories\":[\"frequently-asked-questions\",\"getting-started\"]},\"41077\":{\"title\":\"Update WordPress: WordPress Versions Supported by AIOSEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/update-wordpress\\/\",\"categories\":[\"troubleshooting\"]},\"40587\":{\"title\":\"How to Open the Browser Error Console\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-open-the-browser-error-console\\/\",\"categories\":[\"troubleshooting\"]},\"40582\":{\"title\":\"How to Enable Debugging in WordPress\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-enable-debugging-in-wordpress\\/\",\"categories\":[\"troubleshooting\"]},\"40148\":{\"title\":\"What is TruSEO?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/what-is-truseo\\/\",\"categories\":[\"frequently-asked-questions\",\"truseo\"]},\"39494\":{\"title\":\"Redirecting Attachment Pages\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/redirecting-attachment-pages\\/\",\"categories\":[\"media-settings\",\"search-appearance\"]},\"66310\":{\"title\":\"Selecting the Google Maps APIs to use with All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/selecting-the-google-maps-apis-to-use-with-all-in-one-seo\\/\",\"categories\":[\"local-business-seo\"]},\"38915\":{\"title\":\"Setting Up and Using Breadcrumbs Templates\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-up-and-using-breadcrumbs-templates\\/\",\"categories\":[\"breadcrumbs\"]},\"38610\":{\"title\":\"Displaying Breadcrumbs On Your Site\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/displaying-breadcrumbs-on-your-site\\/\",\"categories\":[\"breadcrumbs\"]},\"36048\":{\"title\":\"Function: aioseo_breadcrumbs()\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/function-aioseo_breadcrumbs\\/\",\"categories\":[\"breadcrumbs\"]},\"36047\":{\"title\":\"Shortcode: [aioseo_breadcrumbs]\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/shortcode-aioseo_breadcrumbs\\/\",\"categories\":[\"breadcrumbs\"]},\"38240\":{\"title\":\"aioseo_social_image_ignore_cover_block\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_social_image_ignore_cover_block\\/\",\"categories\":[\"filter-hooks\"]},\"34923\":{\"title\":\"How to Redirect a Post or Page in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-redirect-a-post-or-page-in-all-in-one-seo\\/\",\"categories\":[\"redirection-manager\"]},\"34977\":{\"title\":\"How to Redirect Multiple URLs to the Same Destination\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-redirect-multiple-urls-to-the-same-destination\\/\",\"categories\":[\"redirection-manager\"]},\"35604\":{\"title\":\"Automatic Redirects When URLs Change in Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/automatic-redirects-when-urls-change-in-content\\/\",\"categories\":[\"redirection-manager\"]},\"31460\":{\"title\":\"Enhanced Search Query Conflict\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/enhanced-search-query-conflict\\/\",\"categories\":[\"local-business-seo\"]},\"30850\":{\"title\":\"aioseo_local_business_info_email_icon\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_info_email_icon\\/\",\"categories\":[\"filter-hooks\"]},\"30839\":{\"title\":\"aioseo_local_business_info_location_icon\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_info_location_icon\\/\",\"categories\":[\"filter-hooks\"]},\"30759\":{\"title\":\"aioseo_local_business_output_business_info_instance\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_output_business_info_instance\\/\",\"categories\":[\"filter-hooks\"]},\"30760\":{\"title\":\"aioseo_local_business_output_business_info_location_data\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_output_business_info_location_data\\/\",\"categories\":[\"filter-hooks\"]},\"30765\":{\"title\":\"aioseo_local_business_output_opening_hours_instance\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_output_opening_hours_instance\\/\",\"categories\":[\"filter-hooks\"]},\"30766\":{\"title\":\"aioseo_local_business_output_opening_hours_data\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_output_opening_hours_data\\/\",\"categories\":[\"filter-hooks\"]},\"30849\":{\"title\":\"aioseo_local_business_info_phone_icon\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_info_phone_icon\\/\",\"categories\":[\"filter-hooks\"]},\"30851\":{\"title\":\"aioseo_local_business_opening_hours_icon\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_opening_hours_icon\\/\",\"categories\":[\"filter-hooks\"]},\"30398\":{\"title\":\"aioseo_local_business_post_type_name\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_post_type_name\\/\",\"categories\":[\"filter-hooks\"]},\"30551\":{\"title\":\"aioseo_local_business_post_type_slug\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_post_type_slug\\/\",\"categories\":[\"filter-hooks\"]},\"30556\":{\"title\":\"aioseo_local_business_post_type_single_label\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_post_type_single_label\\/\",\"categories\":[\"filter-hooks\"]},\"30559\":{\"title\":\"aioseo_local_business_post_type_plural_label\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_post_type_plural_label\\/\",\"categories\":[\"filter-hooks\"]},\"30560\":{\"title\":\"aioseo_local_business_post_type\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_post_type\\/\",\"categories\":[\"filter-hooks\"]},\"30563\":{\"title\":\"aioseo_local_business_taxonomy_name\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_taxonomy_name\\/\",\"categories\":[\"filter-hooks\"]},\"30564\":{\"title\":\"aioseo_local_business_taxonomy_slug\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_taxonomy_slug\\/\",\"categories\":[\"filter-hooks\"]},\"35609\":{\"title\":\"Choosing Which Redirect Type to Use\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/choosing-which-redirect-type-to-use\\/\",\"categories\":[\"redirection-manager\"]},\"35599\":{\"title\":\"Importing Redirects From Other Plugins\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/importing-redirects-from-other-plugins\\/\",\"categories\":[\"redirection-manager\"]},\"35588\":{\"title\":\"Exporting and Importing Redirects\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/exporting-and-importing-redirects\\/\",\"categories\":[\"redirection-manager\"]},\"35579\":{\"title\":\"Logging 404 Errors in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/logging-404-errors-in-all-in-one-seo\\/\",\"categories\":[\"redirection-manager\"]},\"35552\":{\"title\":\"Logging Redirects in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/logging-redirects-in-all-in-one-seo\\/\",\"categories\":[\"redirection-manager\"]},\"35570\":{\"title\":\"Redirect GDPR Privacy Information\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/redirect-gdpr-privacy-information\\/\",\"categories\":[\"redirection-manager\"]},\"30863\":{\"title\":\"Local Business SEO - Template overrides\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/local-business-seo-template-overrides\\/\",\"categories\":[\"local-business-seo\"]},\"35133\":{\"title\":\"aioseo_twitter_tags\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_twitter_tags\\/\",\"categories\":[\"filter-hooks\"]},\"35132\":{\"title\":\"aioseo_facebook_tags\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_facebook_tags\\/\",\"categories\":[\"filter-hooks\"]},\"34993\":{\"title\":\"Ignoring Case Sensitivity in Redirects\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/ignoring-case-sensitivity-in-redirects\\/\",\"categories\":[\"redirection-manager\"]},\"34983\":{\"title\":\"Ignoring the Trailing Slash in Redirects\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/ignoring-the-trailing-slash-in-redirects\\/\",\"categories\":[\"redirection-manager\"]},\"36104\":{\"title\":\"Using Query Parameters With Redirects\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-query-parameters-with-redirects\\/\",\"categories\":[\"redirection-manager\"]},\"30565\":{\"title\":\"aioseo_local_business_taxonomy\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_taxonomy\\/\",\"categories\":[\"filter-hooks\"]},\"36115\":{\"title\":\"Caching of Redirects in the Browser\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/caching-of-redirects-in-the-browser\\/\",\"categories\":[\"redirection-manager\"]},\"34701\":{\"title\":\"Adding WooCommerce Product Attributes to SEO Title or Description\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-woocommerce-product-attributes-to-seo-title-or-description\\/\",\"categories\":[\"post-page-settings\",\"search-appearance\",\"woocommerce\"]},\"36111\":{\"title\":\"Selecting the Redirect Method in Redirects\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/selecting-the-redirect-method-in-redirects\\/\",\"categories\":[\"redirection-manager\"]},\"40115\":{\"title\":\"Redirect Manager Cannot Detect Your Server\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/redirect-manager-unknown-web-server\\/\",\"categories\":[\"redirection-manager\"]},\"36369\":{\"title\":\"Using Regex in the Redirection Manager\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/redirect-manager-regex\\/\",\"categories\":[\"redirection-manager\"]},\"31442\":{\"title\":\"Shortcode: [aioseo_local_opening_hours]\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/shortcode-aioseo_local_opening_hours\\/\",\"categories\":[\"local-business-seo\"]},\"31443\":{\"title\":\"Shortcode: [aioseo_local_locations]\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/shortcode-aioseo_local_locations\\/\",\"categories\":[\"local-business-seo\"]},\"34179\":{\"title\":\"Using the Smart Tags in Titles and Descriptions\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-smart-tags-in-titles-and-descriptions\\/\",\"categories\":[\"post-page-settings\",\"search-appearance\"]},\"31441\":{\"title\":\"Shortcode: [aioseo_local_business_info]\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/shortcode-aioseo_local_business_info\\/\",\"categories\":[\"local-business-seo\"]},\"46122\":{\"title\":\"Shortcode: [aioseo_local_map]\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/shortcode-aioseo_local_map\\/\",\"categories\":[\"local-business-seo\"]},\"33507\":{\"title\":\"What\'s The Difference Between TruSEO and Page Analysis?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/whats-the-difference-between-truseo-and-page-analysis\\/\",\"categories\":[\"frequently-asked-questions\",\"post-page-settings\",\"truseo\"]},\"33310\":{\"title\":\"Setting Noindex for RSS Feeds\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-noindex-for-rss-feeds\\/\",\"categories\":[\"advanced-settings\",\"search-appearance\"]},\"33130\":{\"title\":\"aioseo_disable_shortcode_parsing\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_disable_shortcode_parsing\\/\",\"categories\":[\"filter-hooks\"]},\"32085\":{\"title\":\"aioseo_conflicting_shortcodes\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_conflicting_shortcodes\\/\",\"categories\":[\"filter-hooks\"]},\"31992\":{\"title\":\"aioseo_schema_graphs\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_schema_graphs\\/\",\"categories\":[\"filter-hooks\"]},\"31589\":{\"title\":\"Understanding the TruSEO Page Analysis Recommendations\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/understanding-the-truseo-page-analysis-recommendations\\/\",\"categories\":[\"post-page-settings\",\"truseo\"]},\"31456\":{\"title\":\"Function: aioseo_local_locations()\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/function-aioseo_local_locations\\/\",\"categories\":[\"local-business-seo\"]},\"31455\":{\"title\":\"Function: aioseo_local_opening_hours()\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/function-aioseo_local_opening_hours\\/\",\"categories\":[\"local-business-seo\"]},\"31451\":{\"title\":\"Function: aioseo_local_business_info()\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/function-aioseo_local_business_info\\/\",\"categories\":[\"local-business-seo\"]},\"46123\":{\"title\":\"Function: aioseo_local_map()\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/function-aioseo_local_map\\/\",\"categories\":[\"local-business-seo\"]},\"31042\":{\"title\":\"Getting Keyphrase Suggestions From Semrush\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/getting-keyphrase-suggestions-from-semrush\\/\",\"categories\":[\"post-page-settings\",\"truseo\"]},\"30773\":{\"title\":\"aioseo_local_business_address_tag_value\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_address_tag_value\\/\",\"categories\":[\"filter-hooks\"]},\"30770\":{\"title\":\"aioseo_local_business_address_tags\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_address_tags\\/\",\"categories\":[\"filter-hooks\"]},\"30752\":{\"title\":\"aioseo_local_business_get_location\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_local_business_get_location\\/\",\"categories\":[\"filter-hooks\"]},\"30728\":{\"title\":\"Unable to Save Settings Due to Cloudflare Firewall Rules\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/unable-to-save-settings-due-to-cloudflare-firewall-rules\\/\",\"categories\":[\"troubleshooting\"]},\"30318\":{\"title\":\"aioseo_flush_output_buffer\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_flush_output_buffer\\/\",\"categories\":[\"filter-hooks\"]},\"18813\":{\"title\":\"Installing All in One SEO Pro\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/installing-all-in-one-seo-pro\\/\",\"categories\":[\"getting-started\",\"installation\"]},\"18973\":{\"title\":\"Beginners Guide for All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/quick-start-guide\\/\",\"categories\":[\"getting-started\"]},\"18820\":{\"title\":\"Setting the SEO Title and Description for Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-title-and-description-for-your-content\\/\",\"categories\":[\"getting-started\",\"post-page-settings\"]},\"18902\":{\"title\":\"How to Create an XML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-an-xml-sitemap\\/\",\"categories\":[\"getting-started\",\"xml-sitemap\"]},\"18859\":{\"title\":\"Beginners Guide to Social Networks Settings for Facebook\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/beginners-guide-to-social-networks-settings-for-facebook\\/\",\"categories\":[\"facebook-settings\",\"getting-started\",\"social-networks\"]},\"18857\":{\"title\":\"Beginners Guide to Social Networks Settings for Twitter\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/beginners-guide-to-social-networks-settings-for-twitter\\/\",\"categories\":[\"getting-started\",\"social-networks\",\"twitter-settings\"]},\"29991\":{\"title\":\"aioseo_disable_link_format\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_disable_link_format\\/\",\"categories\":[\"filter-hooks\"]},\"27841\":{\"title\":\"aioseo_thumbnail_size\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_thumbnail_size\\/\",\"categories\":[\"filter-hooks\"]},\"27844\":{\"title\":\"Displaying Additional Data for Written By and Reading Time\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/displaying-additional-data-for-written-by-and-reading-time\\/\",\"categories\":[\"social-networks\"]},\"27494\":{\"title\":\"aioseo_meta_views\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_meta_views\\/\",\"categories\":[\"filter-hooks\"]},\"27363\":{\"title\":\"Using the SEO Analysis Tool\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-seo-analysis-tool\\/\",\"categories\":[\"seo-analysis\"]},\"27272\":{\"title\":\"Importing Settings From Other Plugins\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/importing-settings-from-other-plugins\\/\",\"categories\":[\"importer-exporter\",\"seo-data-importer\",\"tools\"]},\"27268\":{\"title\":\"Backing Up and Restoring AIOSEO Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/backing-up-and-restoring-aioseo-settings\\/\",\"categories\":[\"importer-exporter\",\"tools\"]},\"27259\":{\"title\":\"Importing and Exporting AIOSEO Settings and Meta Data\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/importing-and-exporting-aioseo-settings-and-meta-data\\/\",\"categories\":[\"importer-exporter\",\"tools\"]},\"26450\":{\"title\":\"Blank Title Formats Have Been Detected\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/blank-title-formats-detected\\/\",\"categories\":[\"troubleshooting\"]},\"25802\":{\"title\":\"aioseo_sitemap_additional_pages\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_sitemap_additional_pages\\/\",\"categories\":[\"filter-hooks\"]},\"24928\":{\"title\":\"Including Custom Fields in the TruSEO Page Analysis\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/including-custom-fields-in-the-seo-page-analysis\\/\",\"categories\":[\"content-type-settings\",\"search-appearance\",\"truseo\"]},\"24285\":{\"title\":\"aioseo_prev_link\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_prev_link\\/\",\"categories\":[\"filter-hooks\"]},\"24284\":{\"title\":\"aioseo_next_link\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_next_link\\/\",\"categories\":[\"filter-hooks\"]},\"23717\":{\"title\":\"aioseo_canonical_url\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_canonical_url\\/\",\"categories\":[\"filter-hooks\"]},\"23604\":{\"title\":\"aioseo_schema_breadcrumbs_home\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_schema_breadcrumbs_home\\/\",\"categories\":[\"filter-hooks\"]},\"23448\":{\"title\":\"aioseo_schema_disable\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_schema_disable\\/\",\"categories\":[\"filter-hooks\"]},\"23447\":{\"title\":\"aioseo_robots_meta\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_robots_meta\\/\",\"categories\":[\"filter-hooks\"]},\"23446\":{\"title\":\"aioseo_disable\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_disable\\/\",\"categories\":[\"filter-hooks\"]},\"23438\":{\"title\":\"aioseo_disable_title_rewrites\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_disable_title_rewrites\\/\",\"categories\":[\"filter-hooks\"]},\"23437\":{\"title\":\"aioseo_post_metabox_priority\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_post_metabox_priority\\/\",\"categories\":[\"filter-hooks\"]},\"23436\":{\"title\":\"aioseo_show_seo_news\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_show_seo_news\\/\",\"categories\":[\"filter-hooks\"]},\"23433\":{\"title\":\"aioseo_show_in_admin_bar\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_show_in_admin_bar\\/\",\"categories\":[\"filter-hooks\"]},\"23423\":{\"title\":\"aioseo_keywords\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_keywords\\/\",\"categories\":[\"filter-hooks\"]},\"23350\":{\"title\":\"aioseo_title\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_title\\/\",\"categories\":[\"filter-hooks\"]},\"23351\":{\"title\":\"aioseo_description\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo_description\\/\",\"categories\":[\"filter-hooks\"]},\"23415\":{\"title\":\"Troubleshooting Action Scheduler issues with AIOSEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/troubleshooting-action-scheduler-issues\\/\",\"categories\":[\"troubleshooting\"]},\"20504\":{\"title\":\"Where Did my SEO Keywords go in All in One SEO v4.0?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/where-did-my-seo-keywords-go-in-all-in-one-seo-v4-0\\/\",\"categories\":[\"advanced-settings\",\"frequently-asked-questions\",\"post-page-settings\",\"search-appearance\"]},\"18792\":{\"title\":\"Sitemap rewrite rules for NGINX\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/xml-sitemap-rewrite-rules-for-nginx\\/\",\"categories\":[\"rss-sitemap\",\"video-sitemap\",\"xml-sitemap\"]},\"18793\":{\"title\":\"Unfiltered HTML Capability is Required\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/unfiltered-html-capability\\/\",\"categories\":[\"troubleshooting\"]},\"18794\":{\"title\":\"Deprecated Open Graph Settings in All in One SEO version 4.0\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/deprecated-opengraph-settings\\/\",\"categories\":[\"social-networks\"]},\"18795\":{\"title\":\"Why does the character counter for SEO titles show a different count?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/why-does-the-character-counter-for-seo-titles-show-a-different-count\\/\",\"categories\":[\"frequently-asked-questions\",\"post-page-settings\"]},\"18796\":{\"title\":\"Adding nofollow, sponsored, UGC and title attributes to links\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-nofollow-sponsored-and-title-attributes-to-links\\/\",\"categories\":[\"post-page-settings\"]},\"18797\":{\"title\":\"Setting the SEO for WooCommerce Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-for-woocommerce-content\\/\",\"categories\":[\"search-appearance\",\"woocommerce\"]},\"18798\":{\"title\":\"All in One SEO uses the WordPress REST API\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/aioseo-uses-rest-api\\/\",\"categories\":[\"frequently-asked-questions\"]},\"18799\":{\"title\":\"How to Remove All Settings and Data When you Uninstall All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-remove-all-settings-and-data-when-you-uninstall-all-in-one-seo\\/\",\"categories\":[\"advanced-settings\",\"general-settings\"]},\"18800\":{\"title\":\"How to Disable TruSEO Content Analysis\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-disable-truseo-content-analysis\\/\",\"categories\":[\"advanced-settings\",\"general-settings\",\"truseo\"]},\"18801\":{\"title\":\"Enabling Automatic Updates for All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/enabling-automatic-updates-for-all-in-one-seo\\/\",\"categories\":[\"advanced-settings\",\"general-settings\"]},\"18802\":{\"title\":\"Hiding Plugin Notifications in the Notifications Center\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/hiding-plugin-notifications-in-the-notifications-center\\/\",\"categories\":[\"advanced-settings\",\"general-settings\"]},\"18803\":{\"title\":\"How to Hide the AIOSEO Settings on the Edit Content Screens in WordPress\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-hide-the-aioseo-settings-on-the-edit-content-screens-in-wordpress\\/\",\"categories\":[\"advanced-settings\",\"content-type-settings\",\"post-page-settings\",\"search-appearance\"]},\"18804\":{\"title\":\"Setting Noindex and Nofollow on Paginated Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-noindex-and-nofollow-on-paginated-content\\/\",\"categories\":[\"advanced-settings\",\"search-appearance\"]},\"18805\":{\"title\":\"Setting Unique SEO Titles and Descriptions for Paginated Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-unique-seo-titles-and-descriptions-for-paginated-content\\/\",\"categories\":[\"advanced-settings\",\"search-appearance\"]},\"18806\":{\"title\":\"Setting the SEO Title and Description Format for Custom Post Type Archives\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-title-and-description-format-for-custom-post-type-archives\\/\",\"categories\":[\"archive-settings\",\"search-appearance\"]},\"18807\":{\"title\":\"Meta Keyword Settings in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/keyword-settings\\/\",\"categories\":[\"advanced-settings\",\"search-appearance\"]},\"18808\":{\"title\":\"Using the Quick Edit Feature in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-quick-edit-feature-in-all-in-one-seo\\/\",\"categories\":[\"post-page-settings\"]},\"18809\":{\"title\":\"How to FTP to your web server\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-ftp-to-your-web-server\\/\",\"categories\":[\"frequently-asked-questions\"]},\"18810\":{\"title\":\"How to manually install All in One SEO Pro when the file is too big\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-manually-install-all-in-one-seo-pro-when-the-file-is-too-big\\/\",\"categories\":[\"frequently-asked-questions\",\"installation\"]},\"18811\":{\"title\":\"How to Upgrade From All in One SEO Lite to Pro\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-upgrade-from-all-in-one-seo-lite-to-pro\\/\",\"categories\":[\"getting-started\",\"installation\"]},\"18812\":{\"title\":\"Installation instructions for WordPress.com Users\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/installation-instructions-for-wordpress-com-users\\/\",\"categories\":[\"installation\"]},\"18814\":{\"title\":\"Configuring the Twitter Settings for Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/configuring-the-twitter-settings-for-your-content\\/\",\"categories\":[\"post-page-settings\",\"social-networks\",\"twitter-settings\"]},\"18815\":{\"title\":\"Configuring the Facebook Settings for Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/configuring-the-facebook-settings-for-your-content\\/\",\"categories\":[\"facebook-settings\",\"post-page-settings\",\"social-networks\"]},\"18816\":{\"title\":\"Hiding the AIOSEO Column on Taxonomy Screens\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/hiding-the-aioseo-column-on-taxonomy-screens\\/\",\"categories\":[\"advanced-settings\",\"category-tag-settings\",\"general-settings\"]},\"18818\":{\"title\":\"Setting the Sitemap Priority and Frequency for Individual Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-sitemap-priority-and-frequency-for-individual-content\\/\",\"categories\":[\"post-page-settings\",\"xml-sitemap\"]},\"18819\":{\"title\":\"Setting the Robots Meta for Individual Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-robots-meta-for-individual-content\\/\",\"categories\":[\"post-page-settings\"]},\"18821\":{\"title\":\"Individual Post\\/Page Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/post-settings\\/\",\"categories\":[\"post-page-settings\"]},\"18822\":{\"title\":\"Bad Bot Blocker\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/bad-bot-blocker\\/\",\"categories\":[\"bad-bot-blocker\"]},\"18823\":{\"title\":\"How to Fix a 404 Error When Viewing Your Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-fix-a-404-error-when-viewing-your-sitemap\\/\",\"categories\":[\"frequently-asked-questions\",\"google-news-sitemap\",\"rss-sitemap\",\"troubleshooting\",\"video-sitemap\",\"xml-sitemap\"]},\"18825\":{\"title\":\"When to use NOINDEX or the robots.txt?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/when-to-use-noindex-or-the-robots-txt\\/\",\"categories\":[\"frequently-asked-questions\",\"robots-txt\",\"search-appearance\",\"tools\"]},\"18826\":{\"title\":\"Support for Videos Embedded Using the Media Library\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/support-for-videos-embedded-using-the-media-library\\/\",\"categories\":[\"video-sitemap\"]},\"18827\":{\"title\":\"Supported Videos\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/supported-videos\\/\",\"categories\":[\"video-sitemap\"]},\"18828\":{\"title\":\"Performance Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/performance-settings\\/\",\"categories\":[\"performance\"]},\"18830\":{\"title\":\"Setting the SEO Title and Description Format for Author and Date Archives\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-title-and-description-format-for-author-and-date-archives\\/\",\"categories\":[\"archive-settings\",\"search-appearance\"]},\"18831\":{\"title\":\"Using Custom Fields in Titles and Descriptions\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/custom-fields-in-titles-and-descriptions\\/\",\"categories\":[\"content-type-settings\",\"post-page-settings\",\"search-appearance\"]},\"18832\":{\"title\":\"Using the Focus Keyphrase to Analyze Your Content\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-focus-keyphrase-to-analyze-your-content\\/\",\"categories\":[\"frequently-asked-questions\",\"post-page-settings\",\"truseo\"]},\"18833\":{\"title\":\"Using the Robots.txt Tool in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-robots-txt-tool-in-all-in-one-seo\\/\",\"categories\":[\"robots-txt\",\"tools\"]},\"18834\":{\"title\":\"Using the Robots Meta Settings in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-robots-meta-settings-in-all-in-one-seo\\/\",\"categories\":[\"advanced-settings\",\"archive-settings\",\"category-tag-settings\",\"content-type-settings\",\"media-settings\",\"post-page-settings\",\"search-appearance\",\"taxonomy-settings\"]},\"18835\":{\"title\":\"Noindex Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/noindex-settings\\/\",\"categories\":[\"search-appearance\"]},\"18838\":{\"title\":\"Hiding the AIOSEO Admin Bar Menu\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/hiding-the-aioseo-admin-bar-menu\\/\",\"categories\":[\"advanced-settings\",\"general-settings\"]},\"18839\":{\"title\":\"Hiding the AIOSEO Dashboard Widgets\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/hiding-the-aioseo-dashboard-widget\\/\",\"categories\":[\"advanced-settings\",\"general-settings\"]},\"18840\":{\"title\":\"Hiding the AIOSEO Column on All Posts Screens\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/hiding-the-aioseo-column-on-all-posts-screens\\/\",\"categories\":[\"advanced-settings\",\"general-settings\"]},\"18841\":{\"title\":\"Display Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/display-settings\\/\",\"categories\":[\"display-settings\"]},\"18842\":{\"title\":\"Setting the SEO Title and Description Format for Media Attachments\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-title-and-description-format-for-media-attachments\\/\",\"categories\":[\"media-settings\",\"search-appearance\"]},\"18843\":{\"title\":\"Showing or Hiding Your Content in Search Results\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/showing-or-hiding-your-content-in-search-results\\/\",\"categories\":[\"archive-settings\",\"category-tag-settings\",\"content-type-settings\",\"media-settings\",\"post-page-settings\",\"search-appearance\",\"taxonomy-settings\"]},\"18844\":{\"title\":\"Content Type Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/custom-post-type-settings\\/\",\"categories\":[\"content-type-settings\",\"search-appearance\"]},\"18845\":{\"title\":\"What Are Media Attachments and Should I Submit Them to Search Engines?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/what-are-media-attachments-and-should-i-submit-them-to-search-engines\\/\",\"categories\":[\"frequently-asked-questions\",\"media-settings\"]},\"18846\":{\"title\":\"Setting the SEO Title and Description Format for Custom Taxonomies\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-title-and-description-format-for-custom-taxonomies\\/\",\"categories\":[\"category-tag-settings\",\"search-appearance\",\"taxonomy-settings\"]},\"18847\":{\"title\":\"Setting the SEO Title and Description Format for Custom Post Types\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-title-and-description-format-for-custom-post-types\\/\",\"categories\":[\"content-type-settings\",\"search-appearance\"]},\"18848\":{\"title\":\"Setting the SEO Title and Description Format for Tags\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-title-and-description-format-for-tags\\/\",\"categories\":[\"category-tag-settings\",\"search-appearance\",\"taxonomy-settings\"]},\"18849\":{\"title\":\"Setting the SEO Title and Description Format for Categories\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-title-and-description-format-for-categories\\/\",\"categories\":[\"category-tag-settings\",\"search-appearance\",\"taxonomy-settings\"]},\"18850\":{\"title\":\"Setting the SEO Title and Description Format for Pages\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-title-and-description-format-for-pages\\/\",\"categories\":[\"content-type-settings\",\"post-page-settings\",\"search-appearance\"]},\"18851\":{\"title\":\"Setting the SEO Title and Description Format for Posts\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-title-and-description-format-for-posts\\/\",\"categories\":[\"content-type-settings\",\"post-page-settings\",\"search-appearance\"]},\"18852\":{\"title\":\"Title Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/title-settings\\/\",\"categories\":[\"search-appearance\"]},\"18853\":{\"title\":\"Setting the SEO for Your Home Page\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-seo-for-your-home-page\\/\",\"categories\":[\"home-page-settings\",\"search-appearance\"]},\"18854\":{\"title\":\"General Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/general-settings\\/\",\"categories\":[\"general-settings\"]},\"18855\":{\"title\":\"How to Add Your License Key for All in One SEO Pro\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-add-your-license-key-in-all-in-one-seo-pro\\/\",\"categories\":[\"general-settings\",\"getting-started\"]},\"18856\":{\"title\":\"Canonical URLs in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/canonical-urls-in-all-in-one-seo\\/\",\"categories\":[\"advanced-settings\",\"search-appearance\"]},\"18858\":{\"title\":\"Adding non-WordPress Content to the Video Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-non-wordpress-content-to-the-video-sitemap\\/\",\"categories\":[\"video-sitemap\"]},\"18860\":{\"title\":\"Troubleshooting Problems With Sharing Content on Twitter\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/troubleshooting-problems-with-sharing-content-on-twitter\\/\",\"categories\":[\"social-networks\",\"troubleshooting\",\"twitter-settings\"]},\"18861\":{\"title\":\"Troubleshooting Problems With Sharing Content on Facebook\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/troubleshooting-problems-with-sharing-content-on-facebook\\/\",\"categories\":[\"facebook-settings\",\"social-networks\",\"troubleshooting\"]},\"18862\":{\"title\":\"Getting Started With Pinterest Rich Pins\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-social-meta-for-pinterest-rich-pins\\/\",\"categories\":[\"pinterest-settings\",\"social-networks\"]},\"18863\":{\"title\":\"Setting the Content Publisher for Twitter\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-content-publisher-for-twitter\\/\",\"categories\":[\"social-networks\",\"twitter-settings\"]},\"18865\":{\"title\":\"Submitting a Sitemap to Yandex\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/submitting-a-sitemap-to-yandex\\/\",\"categories\":[\"rss-sitemap\",\"video-sitemap\",\"xml-sitemap\"]},\"18866\":{\"title\":\"Submitting a Sitemap to Bing\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/submitting-a-sitemap-to-bing\\/\",\"categories\":[\"bing-webmaster-tools\",\"rss-sitemap\",\"video-sitemap\",\"xml-sitemap\"]},\"18867\":{\"title\":\"Submitting a Sitemap to Google\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/submitting-a-sitemap-to-google\\/\",\"categories\":[\"google-news-sitemap\",\"google-search-console\",\"rss-sitemap\",\"video-sitemap\",\"xml-sitemap\"]},\"18868\":{\"title\":\"Including Date and Author Archives in Your XML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/including-date-and-author-archives-in-your-xml-sitemap\\/\",\"categories\":[\"xml-sitemap\"]},\"18869\":{\"title\":\"Choosing Which Content to Include in Your Video Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/choosing-which-content-to-include-in-your-video-sitemap\\/\",\"categories\":[\"video-sitemap\"]},\"18870\":{\"title\":\"Choosing Which Content to Include in Your XML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/choosing-which-content-to-include-in-your-xml-sitemap\\/\",\"categories\":[\"xml-sitemap\"]},\"18871\":{\"title\":\"Using Sitemap Indexes and Pagination\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-sitemap-indexes-and-pagination\\/\",\"categories\":[\"video-sitemap\",\"xml-sitemap\"]},\"18872\":{\"title\":\"How to Disable Sitemaps in All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-disable-sitemaps-in-all-in-one-seo\\/\",\"categories\":[\"google-news-sitemap\",\"rss-sitemap\",\"video-sitemap\",\"xml-sitemap\"]},\"18873\":{\"title\":\"Baidu Webmaster Tools Verification\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/baidu-webmaster-tools-verification\\/\",\"categories\":[\"webmaster-tools\",\"webmaster-verification\"]},\"18874\":{\"title\":\"Setting Twitter Social Meta for Your Homepage\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-twitter-social-meta-for-your-homepage\\/\",\"categories\":[\"home-page-settings\",\"social-networks\",\"twitter-settings\"]},\"18875\":{\"title\":\"Setting Facebook Social Meta for Your Homepage\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-facebook-social-meta-for-your-homepage\\/\",\"categories\":[\"facebook-settings\",\"home-page-settings\",\"social-networks\"]},\"18876\":{\"title\":\"Setting the Card Type for Twitter\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-card-type-for-twitter\\/\",\"categories\":[\"social-networks\",\"twitter-settings\"]},\"18877\":{\"title\":\"Setting the Object Types for Facebook\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-object-types-for-facebook\\/\",\"categories\":[\"facebook-settings\",\"social-networks\"]},\"18879\":{\"title\":\"Setting the Priority and Frequency for Content in the Video Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-priority-and-frequency-for-content-in-the-video-sitemap\\/\",\"categories\":[\"video-sitemap\"]},\"18880\":{\"title\":\"Setting the Priority and Frequency for Content in the XML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-priority-and-frequency-for-content-in-the-xml-sitemap\\/\",\"categories\":[\"xml-sitemap\"]},\"18881\":{\"title\":\"How to Exclude Content from Your RSS Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-exclude-content-from-your-rss-sitemap\\/\",\"categories\":[\"rss-sitemap\"]},\"18882\":{\"title\":\"How to Exclude Content from Your Google News Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-exclude-content-from-your-google-news-sitemap\\/\",\"categories\":[\"google-news-sitemap\"]},\"18883\":{\"title\":\"How to Exclude Content from Your Video Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-exclude-content-from-your-video-sitemap\\/\",\"categories\":[\"video-sitemap\"]},\"18884\":{\"title\":\"How to Exclude Content from Your XML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-exclude-content-from-your-xml-sitemap\\/\",\"categories\":[\"xml-sitemap\"]},\"18885\":{\"title\":\"Setting Article Tags for Facebook\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-article-tags-for-facebook\\/\",\"categories\":[\"facebook-settings\",\"social-networks\"]},\"18886\":{\"title\":\"Setting the Content Author for Twitter\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-content-author-for-twitter\\/\",\"categories\":[\"social-networks\",\"twitter-settings\"]},\"18887\":{\"title\":\"Setting the Content Author for Facebook\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-content-author-for-facebook\\/\",\"categories\":[\"facebook-settings\",\"social-networks\"]},\"18888\":{\"title\":\"Setting the Content Publisher for Facebook\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-the-content-publisher-for-facebook\\/\",\"categories\":[\"facebook-settings\",\"social-networks\"]},\"18889\":{\"title\":\"How to Create a Google News Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-a-google-news-sitemap\\/\",\"categories\":[\"google-news-sitemap\"]},\"18890\":{\"title\":\"Including Videos in Custom Fields in Your Video Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/including-videos-in-custom-fields-in-your-video-sitemap\\/\",\"categories\":[\"video-sitemap\"]},\"18891\":{\"title\":\"What is a Dynamically Generated Sitemap and Why is it Better to Use?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/what-is-a-dynamically-generated-sitemap-and-why-is-it-better-to-use\\/\",\"categories\":[\"frequently-asked-questions\",\"video-sitemap\",\"xml-sitemap\"]},\"18892\":{\"title\":\"How to Create a Video Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-a-video-sitemap\\/\",\"categories\":[\"video-sitemap\"]},\"18893\":{\"title\":\"Adding Your Facebook Admin ID\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-your-facebook-admin-id\\/\",\"categories\":[\"facebook-settings\",\"social-networks\"]},\"18894\":{\"title\":\"Adding Your Facebook App ID\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-your-facebook-app-id\\/\",\"categories\":[\"facebook-settings\",\"social-networks\"]},\"18895\":{\"title\":\"Access Control Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/access-control-settings\\/\",\"categories\":[\"access-control-settings\"]},\"18896\":{\"title\":\"Advanced Settings for Google Analytics\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/advanced-settings-for-google-analytics\\/\",\"categories\":[\"google-analytics\"]},\"18897\":{\"title\":\"Miscellaneous Site Verification\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/miscellaneous-site-verification\\/\",\"categories\":[\"webmaster-tools\",\"webmaster-verification\"]},\"18898\":{\"title\":\"Displaying Your Social Media Profiles in Knowledge Panel\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/displaying-your-social-media-profiles-in-knowledge-panel\\/\",\"categories\":[\"schema-settings\",\"social-networks\"]},\"18899\":{\"title\":\"How to Create an RSS Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-an-rss-sitemap\\/\",\"categories\":[\"rss-sitemap\"]},\"18900\":{\"title\":\"Excluding Images from the XML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/excluding-images-from-the-xml-sitemap\\/\",\"categories\":[\"xml-sitemap\"]},\"18901\":{\"title\":\"Adding non-WordPress Content to the XML Sitemap\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/adding-non-wordpress-content-to-the-xml-sitemap\\/\",\"categories\":[\"xml-sitemap\"]},\"18903\":{\"title\":\"Setting a Default Image for Twitter\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-a-default-image-for-twitter\\/\",\"categories\":[\"social-networks\",\"twitter-settings\"]},\"18904\":{\"title\":\"Setting a Default Image for Facebook\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-a-default-image-for-facebook\\/\",\"categories\":[\"facebook-settings\",\"social-networks\"]},\"18905\":{\"title\":\"Setting a Title Separator\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-a-title-separator\\/\",\"categories\":[\"search-appearance\"]},\"18906\":{\"title\":\"How to Protect Your Content With RSS Content Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-protect-your-content-with-rss-content-settings\\/\",\"categories\":[\"rss-content-settings\"]},\"18907\":{\"title\":\"How to Connect Your Site with Google Tag Manager\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-connect-your-site-with-google-tag-manager\\/\",\"categories\":[\"google-analytics\"]},\"18908\":{\"title\":\"How to Connect Your Site with Google Analytics\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-connect-your-site-with-google-analytics\\/\",\"categories\":[\"google-analytics\"]},\"18909\":{\"title\":\"How to Verify Your Site with Pinterest\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-verify-your-site-with-pinterest\\/\",\"categories\":[\"pinterest-settings\",\"social-networks\",\"webmaster-tools\",\"webmaster-verification\"]},\"18910\":{\"title\":\"How to Verify Your Site with Yandex Webmaster Tools\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-verify-your-site-with-yandex-webmaster-tools\\/\",\"categories\":[\"webmaster-tools\",\"webmaster-verification\"]},\"18911\":{\"title\":\"How to Verify Your Site with Bing Webmaster Tools\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-verify-your-site-with-bing-webmaster-tools\\/\",\"categories\":[\"bing-webmaster-tools\",\"webmaster-tools\",\"webmaster-verification\"]},\"18912\":{\"title\":\"How to Verify Your Site with Google Search Console\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-verify-your-site-with-google-search-console\\/\",\"categories\":[\"google-search-console\",\"webmaster-tools\",\"webmaster-verification\"]},\"18913\":{\"title\":\"Usage Tracking\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/usage-tracking\\/\",\"categories\":[\"frequently-asked-questions\"]},\"18915\":{\"title\":\"How do I use All in One SEO in my language?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-do-i-use-all-in-one-seo-in-my-language\\/\",\"categories\":[\"frequently-asked-questions\"]},\"18920\":{\"title\":\"NGINX rewrite rules for Robots.txt\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/nginx-rewrite-rules-for-robots-txt\\/\",\"categories\":[\"robots-txt\",\"tools\"]},\"18927\":{\"title\":\"Supported PHP Versions for All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/supported-php-version\\/\",\"categories\":[\"troubleshooting\"]},\"18929\":{\"title\":\"Using a different CDN for script enqueuing\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/using-a-different-cdn-for-script-enqueuing\\/\",\"categories\":[\"troubleshooting\"]},\"18930\":{\"title\":\"How do I get Google to show sitelinks for my site?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-do-i-get-google-to-show-sitelinks-for-my-site\\/\",\"categories\":[\"frequently-asked-questions\"]},\"18954\":{\"title\":\"How does the import process for SEO data work?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-does-the-import-process-for-seo-data-work\\/\",\"categories\":[\"frequently-asked-questions\",\"importer-exporter\",\"tools\"]},\"18960\":{\"title\":\"Robots.txt Editor for Multisite Networks\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/robots-txt-editor-for-multisite-networks\\/\",\"categories\":[\"multisite-networks\",\"robots-txt\"]},\"18961\":{\"title\":\"What are the minimum requirements for All in One SEO?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/what-are-the-minimum-requirements-for-all-in-one-seo-pack\\/\",\"categories\":[\"frequently-asked-questions\"]},\"18964\":{\"title\":\"How do I use your API code examples?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-do-i-use-your-api-code-examples\\/\",\"categories\":[\"frequently-asked-questions\"]},\"18969\":{\"title\":\"XML Parsing Error - This page contains the following errors\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/this-page-contains-the-following-errors\\/\",\"categories\":[\"google-news-sitemap\",\"troubleshooting\",\"video-sitemap\",\"xml-sitemap\"]},\"18972\":{\"title\":\"The File Editor or Robots.txt modules are missing\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/the-file-editor-or-robots-txt-modules-are-missing\\/\",\"categories\":[\"frequently-asked-questions\"]},\"18977\":{\"title\":\"Excluding the XML Sitemap from caching\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/excluding-the-xml-sitemap-from-caching\\/\",\"categories\":[\"xml-sitemap\"]},\"18982\":{\"title\":\"Why doesn\'t the title and description I set appear in search results?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/why-doesnt-the-title-and-description-i-set-appear-in-search-results\\/\",\"categories\":[\"frequently-asked-questions\",\"post-page-settings\"]},\"18983\":{\"title\":\"Can I remove the date from Google search results?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/can-i-remove-the-date-from-google-search-results\\/\",\"categories\":[\"frequently-asked-questions\"]},\"18985\":{\"title\":\"Setting up HTTPS SSL\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/setting-up-https-ssl\\/\",\"categories\":[\"general-seo-topics\"]},\"18995\":{\"title\":\"How to Increase the WordPress PHP Memory Limit\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/increase-wordpress-php-memory-limit\\/\",\"categories\":[\"troubleshooting\"]},\"19002\":{\"title\":\"Checking Index Status in Google Search Results\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/checking-index-status-in-google-search-results\\/\",\"categories\":[\"general-seo-topics\"]},\"19006\":{\"title\":\"SEO Data Importer\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/seo-data-importer\\/\",\"categories\":[\"seo-data-importer\"]},\"19008\":{\"title\":\"How to troubleshoot issues with All in One SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-troubleshoot-issues-with-all-in-one-seo-pack\\/\",\"categories\":[\"troubleshooting\"]},\"19010\":{\"title\":\"Quality Guidelines for SEO Titles and Descriptions\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/quality-guidelines-for-seo-titles-and-descriptions\\/\",\"categories\":[\"general-seo-topics\"]},\"19016\":{\"title\":\"Top Tips for Good On-Page SEO\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/top-tips-for-good-on-page-seo\\/\",\"categories\":[\"general-seo-topics\"]},\"19017\":{\"title\":\"Meta Descriptions\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/meta-descriptions\\/\",\"categories\":[\"general-seo-topics\"]},\"19028\":{\"title\":\"What is SEO meta?\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/what-is-seo-meta\\/\",\"categories\":[\"getting-started\"]},\"19029\":{\"title\":\"Social Meta Settings - Individual Page\\/Post Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/social-meta-settings-individual-pagepost-settings\\/\",\"categories\":[\"post-page-settings\",\"social-networks\"]},\"19030\":{\"title\":\"File Editor Module\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/file-editor-module\\/\",\"categories\":[\"file-editor\"]},\"19031\":{\"title\":\"Social Meta Settings\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/social-meta-module\\/\",\"categories\":[\"social-networks\"]},\"19032\":{\"title\":\"Importer &amp; Exporter Module\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/importer-exporter-module\\/\",\"categories\":[\"importer-exporter\",\"tools\"]},\"19034\":{\"title\":\"Feature Manager\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/feature-manager\\/\",\"categories\":[\"feature-manager\"]},\"19035\":{\"title\":\"Advanced Settings for All in One SEO Pack\",\"url\":\"https:\\/\\/aioseo.com\\/docs\\/all-in-one-seo-pack-advanced-settings\\/\",\"categories\":[\"advanced-settings\"]}}}\";", "2025-12-30 11:37:24", "2025-11-06 03:19:37", "2025-12-23 11:37:24");
INSERT INTO `wp_aioseo_cache` VALUES("4234", "aioseo_sitemap_news-sitemap.xml", "a:3:{s:6:\"counts\";a:0:{}s:8:\"datetime\";a:0:{}s:10:\"pagination\";a:2:{s:7:\"showing\";i:0;s:5:\"total\";i:0;}}", "2026-01-16 02:56:45", "2025-11-27 15:57:53", "2025-12-17 02:56:45");

/* INSERT TABLE DATA: wp_aioseo_notifications */
INSERT INTO `wp_aioseo_notifications` VALUES("1", "676aef6c56829", NULL, "Have you connected your site to Google Search Console?", "All in One SEO can now verify whether your site is correctly verified with Google Search Console and that your sitemaps have been submitted correctly. Connect with Google Search Console now to ensure your content is being added to Google as soon as possible for increased rankings.", "warning", "[\"all\"]", NULL, "search-console-site-not-connected", "2024-12-24 17:29:16", NULL, "Connect to Google Search Console", "https://route#aioseo-settings&aioseo-scroll=google-search-console-settings&aioseo-highlight=google-search-console-settings:webmaster-tools?activetool=googleSearchConsole", NULL, NULL, "0", "0", "2024-12-24 17:29:16", "2024-12-24 17:29:16");
INSERT INTO `wp_aioseo_notifications` VALUES("2", "676aef6e0b517", NULL, "Advanced WooCommerce Support", "We have detected you are running WooCommerce. Upgrade to AIOSEO Pro to unlock our advanced eCommerce SEO features, including SEO for Product Categories and more.", "info", "[\"all\"]", NULL, "woo-upsell", "2024-12-24 17:29:18", NULL, "Upgrade to Pro", "https://shareasale.com/r.cfm?b=1491200&u=3909268&m=94778&urllink=https%3A%2F%2Faioseo.com%2Flite-upgrade%2F%3Futm_source%3DWordPress%26%23038%3Butm_campaign%3Dliteplugin%26%23038%3Butm_medium%3Dwoo-notification-upsell&afftrack=amp99182h9", NULL, NULL, "0", "0", "2024-12-24 17:29:18", "2024-12-24 17:29:18");
INSERT INTO `wp_aioseo_notifications` VALUES("3", "677d69b130ba0", NULL, "Email Reports", "Stay ahead in SEO with our new email digest! Get the latest tips, trends, and tools delivered right to your inbox, helping you optimize smarter and faster. Enable it today and never miss an update that can take your rankings to the next level.", "info", "[\"all\"]", NULL, "email-reports-enable-reminder", "2025-01-07 17:51:45", NULL, "Enable Email Reports", "https://route#aioseo-settings&aioseo-scroll=aioseo-email-summary-row&aioseo-highlight=aioseo-email-summary-row:advanced", "All Good, I\'m already getting it", "http://action#notification/email-reports-enable", "0", "0", "2025-01-07 17:51:45", "2025-01-07 17:51:45");
INSERT INTO `wp_aioseo_notifications` VALUES("4", "6795267d7dade", NULL, "❄️ Winter Sale is Here! AIOSEO Up to 70% Off ☃️", "<img src=\"data:image/webp;base64,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\" alt=\"\" class=\"wp-image-1207\"/>\n\n<p>⛷️ Winter Savings Alert!&nbsp;</p>\n\n<p>Save up to 70% on AIOSEO and give your site the SEO boost it deserves!&nbsp;</p>\n\n<p>Need a new plan, or thinking of upgrading?&nbsp;</p>\n\n<p>🔓 Unlock powerful pro-level features and dominate search results! Don’t miss out—start the year right—save BIG!</p>\n\n<p></p>", "success", "[\"4-x\",\"lite\"]", "1201", NULL, "2025-01-20 00:00:00", "2025-01-27 00:00:00", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=winter-sale-25-v4-x-lite", NULL, NULL, "0", "0", "2025-01-25 17:59:25", "2025-01-26 18:29:11");
INSERT INTO `wp_aioseo_notifications` VALUES("5", "67a265cde4076", NULL, "[New] Smarter Keyword Rank Tracking &amp; WooCommerce SEO Made Easy!🤩", "<p>We just released AIOSEO 4.7.8 and it’s loaded with some exciting updates!</p>\n\n<p>The top ones include:</p>\n\n<p>👉🏼 <strong>Smarter Keyword Rank Tracker</strong>: Our Keyword Rank Tracker just got some massive upgrades you don’t want to miss. Now you can get related keywords, import keywords from GSC and more.</p>\n\n<p>👉🏼 <strong>Support for WooCommerce Product Attributes</strong>: Setting product attributes in WordPress just got way easier. Plus, you can also export product attributes! </p>\n\n<p>Update to AIOSEO 4.7.8 now and take your SEO to another level.</p>", "success", "[\"4-x\",\"lite\"]", "1213", NULL, "2025-01-28 00:00:00", NULL, "Learn More", "https://aioseo.com/smarter-keyword-rank-tracking-woocommerce-seo-made-easy/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=478-v4-x-lite", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=478-v4-x-lite", "0", "0", "2025-02-04 19:09:01", "2025-09-26 17:40:20");
INSERT INTO `wp_aioseo_notifications` VALUES("6", "67d47100319d8", NULL, "[New] Supercharged Crawl Cleanup and Query Arg Monitoring! 🚀", "<p>Is your WordPress site slowing down? Or are AI bots scraping your content? 🧐</p>\n\n<p><strong>AIOSEO 4.8.0 puts you in control with</strong>:<br>🧹 <strong>Supercharged Crawl Cleanup</strong> – Stop search engines from indexing unnecessary URLs.<br>📊 <strong>Advanced Query Monitoring</strong> – Optimize UTM parameters automatically.<br>🛡️ <strong>Bot Control</strong> – Block unauthorized AI crawlers.<br>🔍 <strong>Internal Search Optimization</strong> – Prevent spam &amp; boost performance.<br><br>🔥 Keep your site fast, secure, and SEO-friendly. Update now! 🚀</p>", "success", "[\"4-x\",\"lite\"]", "1222", NULL, "2025-03-11 00:00:00", NULL, "Learn More", "https://aioseo.com/introducing-aioseo-4-8-0-advanced-crawl-features/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=480-v4-x-lite", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=480-v4-x-lite", "0", "0", "2025-03-14 18:10:08", "2025-09-26 17:40:20");
INSERT INTO `wp_aioseo_notifications` VALUES("7", "6817a9fece3d5", NULL, "Spring Sale 2025! Get Up to 70% Off AIOSEO", "<img src=\"data:image/webp;base64,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\" alt=\"\" class=\"wp-image-1240\"/>\n\n<p>Save up to 70% OFF on AIOSEO &amp; give your website a vibrant boost this spring!&nbsp;</p>\n\n<p>Ready for new growth? Whether you need a fresh plan or a powerful upgrade...</p>\n\n<p>🔓 Unlock pro-level features and cultivate top search rankings! Don\'t let this season of savings pass you by!</p>", "success", "[\"4-x\",\"lite\"]", "1239", NULL, "2025-05-01 00:00:00", "2025-05-08 00:00:00", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=spring-sale-2025-v4-x-lite", NULL, NULL, "0", "0", "2025-05-04 17:55:10", "2025-05-05 18:02:20");
INSERT INTO `wp_aioseo_notifications` VALUES("8", "68335ab988b4d", NULL, "[New] Get Indexing Data Right Inside WordPress!", "<p>Worried Google\'s not seeing your amazing WordPress content? 🤔&nbsp;</p>\n\n<p>AIOSEO 4.8.2 introduces the <strong>Index Status Report</strong>, giving you crystal-clear visibility into what <strong>Google\'s indexing</strong> (and what it\'s missing!). <strong>Uncover hidden indexing issues</strong>, see post-level details, and track your rich results—all within your familiar WordPress dashboard.&nbsp;</p>\n\n<p>Stop losing traffic and ensure your hard work gets seen.&nbsp;</p>\n\n<p>Update to AIOSEO 4.8.2 today and take control of your website’s visibility! 🚀</p>", "success", "[\"4-x\",\"lite\"]", "1249", NULL, "2025-05-22 15:19:11", NULL, "Learn More", "https://aioseo.com/introducing-index-status-report/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=aioseo-482-v4-x-lite", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=aioseo-482-v4-x-lite", "0", "0", "2025-05-25 18:00:25", "2025-09-26 17:40:20");
INSERT INTO `wp_aioseo_notifications` VALUES("9", "6871523e858fe", NULL, "[New] AI Content Generator: Supercharge Your Content Creation!", "<img src=\"data:image/webp;base64,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\" alt=\"\" class=\"wp-image-1276\" style=\"object-fit:cover\"/>\n\n<p>Tired of the endless grind of crafting content, SEO titles, meta descriptions, social media posts, and FAQs?&nbsp;</p>\n\n<p>We get it! Creating high-quality, optimized content can be challenging and time-consuming. That\'s why we\'re thrilled to introduce AIOSEO\'s new <strong>AI Content Generator</strong>!</p>\n\n<p>Automatically generate content snippets like:</p>\n\n<p>✅ FAQs<br>✅ Key points<br>✅ Social media posts<br>✅ Email copy<br>✅ SEO titles and meta descriptions&nbsp;</p>\n\n<p>... and much more to come!</p>\n\n<p>Update to AIOSEO 4.8.4 now to unlock these powerful AI features and transform your content creation process! 🚀</p>", "success", "[\"4-x\",\"lite\"]", "1270", NULL, "2025-07-09 13:36:07", NULL, "Learn More", "https://aioseo.com/new-ai-content-generator/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=aioseo-484-v4-x-lite", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=aioseo-484-v4-x-lite", "0", "0", "2025-07-11 18:04:46", "2025-09-26 17:40:20");
INSERT INTO `wp_aioseo_notifications` VALUES("10", "688bb06262740", NULL, "☀️ Summer Sale - Up to 70% Off AIOSEO Plans!", "<img src=\"data:image/webp;base64,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\" alt=\"Summer sale\" class=\"wp-image-1288\"/>\n\n<p>🔥 It’s the Hottest Sale of the Summer! 🔥</p>\n\n<p>Get up to <strong>70% off</strong> AIOSEO, whether you\'re grabbing a new plan or upgrading your current one.</p>\n\n<p>This summer special is only here for a short time, so don’t miss your chance to SAVE BIG!</p>\n\n<p>☀️ Grab your discount before it’s gone!</p>", "success", "[\"4-x\",\"lite\"]", "1286", NULL, "2025-08-01 00:00:00", "2025-08-08 00:00:00", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=summer-sale-2025-v4-x-lite", NULL, NULL, "0", "0", "2025-07-31 18:05:22", "2025-08-07 18:26:55");
INSERT INTO `wp_aioseo_notifications` VALUES("11", "68b1f3fe70fe6", NULL, "Introducing Site Audit in AIOSEO 4.8.6", "<p>Tired of guessing why your website isn’t ranking higher? Or frustrated by SEO tools that give you too much data but no clear answers?</p>\n\n<p>We’ve supercharged our SEO Analyzer to give you crystal-clear insights and action steps—right inside your WordPress dashboard!</p>\n\n<p>Now you can:</p>\n\n<p>✅ Scan your <strong>entire site</strong> for common SEO issues.</p>\n\n<p>✅ View issues <strong>page-by-page</strong> or <strong>by issue type</strong>.</p>\n\n<p>✅ <strong>Get instant tooltips</strong>, 1-click fixes, and quick keyword additions.</p>\n\n<p>✅ <strong>Track progress</strong> with satisfying visual checkmarks.</p>\n\n<p>Update to AIOSEO 4.8.6 today and take the guesswork out of SEO!</p>", "success", "[\"4-x\",\"lite\"]", "1298", NULL, "2025-08-27 00:00:00", NULL, "Learn More", "https://aioseo.com/site-audit-announcement/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=486-v4-x-lite", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=486-v4-x-lite", "0", "0", "2025-08-29 18:39:58", "2025-09-26 17:40:20");
INSERT INTO `wp_aioseo_notifications` VALUES("12", "68b72a8d18331", NULL, "🚀 Labor Day Sale: Up to 60% OFF 💰", "<img src=\"data:image/webp;base64,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\" alt=\"\" class=\"wp-image-1307\" />\n\n<p>Happy Labor Day! 🇺🇸 Today, your hard work deserves a reward. We’re giving you up to <strong>60% OFF new AIOSEO plans and upgrades</strong>—but only for a limited time.</p>\n\n<p>Unlock advanced SEO features to:</p>\n\n<p>✅ Rank higher with ease.</p>\n\n<p>✅ Grow your traffic faster.</p>\n\n<p>✅ Reach your sales + conversion goals.</p>\n\n<p>Don’t wait—this exclusive Labor Day deal vanishes <strong>tonight at 11:59 PM EST!</strong> ⏰</p>", "success", "[\"4-x\",\"lite\"]", "1306", NULL, "2025-09-01 00:00:00", "2025-09-02 23:59:59", "Get AIOSEO Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-notification&utm_campaign=aioseo-plugin-notification", NULL, NULL, "0", "0", "2025-09-02 17:34:05", "2025-09-02 17:34:05");

/* INSERT TABLE DATA: wp_aioseo_posts */
INSERT INTO `wp_aioseo_posts` VALUES("57", "11899", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", NULL, NULL, NULL, "default", NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:45:43", "2024-12-24 17:45:59");
INSERT INTO `wp_aioseo_posts` VALUES("58", "2", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final1.jpg\"}]", "2024-12-24 17:52:06", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:52:06", "2024-12-24 17:52:06");
INSERT INTO `wp_aioseo_posts` VALUES("59", "70", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, "2024-12-24 17:52:06", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:52:06", "2024-12-24 17:52:06");
INSERT INTO `wp_aioseo_posts` VALUES("60", "2311", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final4.jpg\"}]", "2024-12-24 17:52:06", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:52:06", "2024-12-24 17:52:06");
INSERT INTO `wp_aioseo_posts` VALUES("61", "2359", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final2.jpg\"}]", "2024-12-24 17:52:06", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:52:06", "2024-12-24 17:52:06");
INSERT INTO `wp_aioseo_posts` VALUES("62", "2374", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final3.jpg\"}]", "2024-12-24 17:52:06", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:52:06", "2024-12-24 17:52:06");
INSERT INTO `wp_aioseo_posts` VALUES("63", "2384", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final1.jpg\"}]", "2024-12-24 17:52:06", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:52:06", "2024-12-24 17:52:06");
INSERT INTO `wp_aioseo_posts` VALUES("64", "2386", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final7.jpg\"}]", "2024-12-24 17:52:06", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:52:06", "2024-12-24 17:52:06");
INSERT INTO `wp_aioseo_posts` VALUES("65", "2387", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final6.jpg\"}]", "2024-12-24 17:52:06", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:52:06", "2024-12-24 17:52:06");
INSERT INTO `wp_aioseo_posts` VALUES("66", "2389", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final4.jpg\"}]", "2024-12-24 17:52:06", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:52:06", "2024-12-24 17:52:06");
INSERT INTO `wp_aioseo_posts` VALUES("67", "2397", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final5.jpg\"}]", "2024-12-24 17:52:06", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:52:06", "2024-12-24 17:52:06");
INSERT INTO `wp_aioseo_posts` VALUES("68", "2399", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final8.jpg\"}]", "2024-12-24 17:53:03", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:03", "2024-12-24 17:53:03");
INSERT INTO `wp_aioseo_posts` VALUES("69", "6911", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"http:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/2018\\/02\\/work22-2.jpg\"},{\"image:loc\":\"http:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/2018\\/02\\/work22-1.jpg\"}]", "2024-12-24 17:53:03", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:03", "2024-12-24 17:53:03");
INSERT INTO `wp_aioseo_posts` VALUES("70", "6925", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, "2024-12-24 17:53:03", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:03", "2024-12-24 17:53:03");
INSERT INTO `wp_aioseo_posts` VALUES("71", "6936", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, "2024-12-24 17:53:03", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:03", "2024-12-24 17:53:03");
INSERT INTO `wp_aioseo_posts` VALUES("72", "6941", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, "2024-12-24 17:53:03", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:03", "2024-12-24 17:53:03");
INSERT INTO `wp_aioseo_posts` VALUES("73", "6962", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, "2024-12-24 17:53:03", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:03", "2024-12-24 17:53:03");
INSERT INTO `wp_aioseo_posts` VALUES("74", "6988", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, "2024-12-24 17:53:03", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:03", "2024-12-24 17:53:03");
INSERT INTO `wp_aioseo_posts` VALUES("75", "6990", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, "2024-12-24 17:53:03", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:03", "2024-12-24 17:53:03");
INSERT INTO `wp_aioseo_posts` VALUES("76", "6997", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, "2024-12-24 17:53:03", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:03", "2024-12-24 17:53:03");
INSERT INTO `wp_aioseo_posts` VALUES("77", "6998", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, "2024-12-24 17:53:03", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:03", "2024-12-24 17:53:03");
INSERT INTO `wp_aioseo_posts` VALUES("78", "8341", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":4},\"title\":{\"titleLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":2}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "77", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final7.jpg\"}]", "2025-04-04 15:41:45", NULL, "default", NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:34", "2025-04-04 15:41:45");
INSERT INTO `wp_aioseo_posts` VALUES("79", "8375", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final2.jpg\"}]", "2024-12-24 17:53:34", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:34", "2024-12-24 17:53:34");
INSERT INTO `wp_aioseo_posts` VALUES("80", "8401", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final3.jpg\"}]", "2024-12-24 17:53:34", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:34", "2024-12-24 17:53:34");
INSERT INTO `wp_aioseo_posts` VALUES("81", "8402", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final5.jpg\"}]", "2024-12-24 17:53:34", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:34", "2024-12-24 17:53:34");
INSERT INTO `wp_aioseo_posts` VALUES("82", "8403", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final6.jpg\"}]", "2024-12-24 17:53:34", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:34", "2024-12-24 17:53:34");
INSERT INTO `wp_aioseo_posts` VALUES("83", "8412", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final1.jpg\"}]", "2024-12-24 17:53:34", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:34", "2024-12-24 17:53:34");
INSERT INTO `wp_aioseo_posts` VALUES("84", "8413", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final4.jpg\"}]", "2024-12-24 17:53:34", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:34", "2024-12-24 17:53:34");
INSERT INTO `wp_aioseo_posts` VALUES("85", "8414", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final8.jpg\"}]", "2024-12-24 17:53:34", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:34", "2024-12-24 17:53:34");
INSERT INTO `wp_aioseo_posts` VALUES("86", "8468", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-BG2.jpg\"}]", "2024-12-24 17:53:34", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:34", "2024-12-24 17:53:34");
INSERT INTO `wp_aioseo_posts` VALUES("87", "8754", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"metadescriptionLength\":{\"score\":6,\"maxScore\":9,\"error\":1},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":9,\"maxScore\":9,\"error\":0},\"isExternalLink\":{\"score\":3,\"maxScore\":9,\"error\":1},\"errors\":3},\"title\":{\"titleLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":[],\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":1}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "86", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", NULL, "2024-12-24 19:29:08", NULL, "default", NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:53:34", "2024-12-24 19:29:08");
INSERT INTO `wp_aioseo_posts` VALUES("88", "11095", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-BG2.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/IMG_1818-fc-gold.jpg\"}]", "2025-01-09 11:53:05", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:54:09", "2025-01-09 11:53:05");
INSERT INTO `wp_aioseo_posts` VALUES("89", "11332", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"http:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/2018\\/02\\/work3.jpg\"}]", "2024-12-24 17:54:09", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:54:09", "2024-12-24 17:54:09");
INSERT INTO `wp_aioseo_posts` VALUES("90", "11333", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"http:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/2018\\/02\\/work41.jpg\"}]", "2024-12-24 17:54:09", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:54:09", "2024-12-24 17:54:09");
INSERT INTO `wp_aioseo_posts` VALUES("91", "11348", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"http:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/2018\\/02\\/work5.jpg\"}]", "2024-12-24 17:54:09", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:54:09", "2024-12-24 17:54:09");
INSERT INTO `wp_aioseo_posts` VALUES("92", "11356", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"http:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/2018\\/02\\/work61.jpg\"},{\"image:loc\":\"http:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/2018\\/02\\/work6.jpg\"}]", "2024-12-24 17:54:09", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:54:09", "2024-12-24 17:54:09");
INSERT INTO `wp_aioseo_posts` VALUES("93", "11362", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"http:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/2018\\/02\\/work72.jpg\"},{\"image:loc\":\"http:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/2018\\/02\\/work71.jpg\"}]", "2024-12-24 17:54:09", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:54:09", "2024-12-24 17:54:09");
INSERT INTO `wp_aioseo_posts` VALUES("94", "11441", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-photo3.jpg\"}]", "2024-12-24 17:54:09", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:54:09", "2024-12-24 17:54:09");
INSERT INTO `wp_aioseo_posts` VALUES("95", "11448", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-photo4.jpg\"}]", "2024-12-24 17:54:09", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:54:09", "2024-12-24 17:54:09");
INSERT INTO `wp_aioseo_posts` VALUES("96", "11449", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-photo5.jpg\"}]", "2024-12-24 17:54:09", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:54:09", "2024-12-24 17:54:09");
INSERT INTO `wp_aioseo_posts` VALUES("97", "11450", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-photo6.jpg\"}]", "2024-12-24 17:54:09", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:54:09", "2024-12-24 17:54:09");
INSERT INTO `wp_aioseo_posts` VALUES("98", "11542", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-BG2.jpg\"}]", "2024-12-24 17:55:05", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:55:05", "2024-12-24 17:55:05");
INSERT INTO `wp_aioseo_posts` VALUES("99", "11551", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-free-about3.jpg\"}]", "2024-12-24 17:55:05", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:55:05", "2024-12-24 17:55:05");
INSERT INTO `wp_aioseo_posts` VALUES("100", "11565", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/camera.jpg\"}]", "2024-12-24 17:55:05", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:55:05", "2024-12-24 17:55:05");
INSERT INTO `wp_aioseo_posts` VALUES("101", "11596", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/events.jpg\"}]", "2024-12-24 17:55:05", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:55:05", "2024-12-24 17:55:05");
INSERT INTO `wp_aioseo_posts` VALUES("102", "11600", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/social.jpg\"}]", "2024-12-24 17:55:05", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:55:05", "2024-12-24 17:55:05");
INSERT INTO `wp_aioseo_posts` VALUES("103", "11601", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/thinking.jpg\"}]", "2024-12-24 17:55:05", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:55:05", "2024-12-24 17:55:05");
INSERT INTO `wp_aioseo_posts` VALUES("104", "11633", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/Company_Logos3.png\"}]", "2024-12-24 17:55:05", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:55:05", "2024-12-24 17:55:05");
INSERT INTO `wp_aioseo_posts` VALUES("105", "11634", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/Company_Logos4.png\"}]", "2024-12-24 17:55:05", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:55:05", "2024-12-24 17:55:05");
INSERT INTO `wp_aioseo_posts` VALUES("106", "11635", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/Company_Logos5.png\"}]", "2024-12-24 17:55:05", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:55:05", "2024-12-24 17:55:05");
INSERT INTO `wp_aioseo_posts` VALUES("107", "11636", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/Company_Logos6.png\"}]", "2024-12-24 17:55:05", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:55:05", "2024-12-24 17:55:05");
INSERT INTO `wp_aioseo_posts` VALUES("108", "11637", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/Company_Logos7.png\"}]", "2024-12-24 17:56:11", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:56:11", "2024-12-24 17:56:11");
INSERT INTO `wp_aioseo_posts` VALUES("109", "11673", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-footer.png\"}]", "2024-12-24 17:56:11", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:56:11", "2024-12-24 17:56:11");
INSERT INTO `wp_aioseo_posts` VALUES("110", "11732", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/logo-cropps-color2.png\"}]", "2024-12-24 17:56:11", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:56:11", "2024-12-24 17:56:11");
INSERT INTO `wp_aioseo_posts` VALUES("111", "11738", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropped-favicon2.png\"}]", "2024-12-24 17:56:11", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:56:11", "2024-12-24 17:56:11");
INSERT INTO `wp_aioseo_posts` VALUES("112", "11741", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final1.jpg\"}]", "2024-12-24 17:56:11", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:56:11", "2024-12-24 17:56:11");
INSERT INTO `wp_aioseo_posts` VALUES("113", "11742", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final2.jpg\"}]", "2024-12-24 17:56:11", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:56:11", "2024-12-24 17:56:11");
INSERT INTO `wp_aioseo_posts` VALUES("114", "11743", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final3.jpg\"}]", "2024-12-24 17:56:11", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:56:11", "2024-12-24 17:56:11");
INSERT INTO `wp_aioseo_posts` VALUES("115", "11744", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final4.jpg\"}]", "2024-12-24 17:56:11", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:56:11", "2024-12-24 17:56:11");
INSERT INTO `wp_aioseo_posts` VALUES("116", "11745", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final5.jpg\"}]", "2024-12-24 17:56:11", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:56:11", "2024-12-24 17:56:11");
INSERT INTO `wp_aioseo_posts` VALUES("117", "11746", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final6.jpg\"}]", "2024-12-24 17:56:11", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:56:11", "2024-12-24 17:56:11");
INSERT INTO `wp_aioseo_posts` VALUES("118", "11747", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final7.jpg\"}]", "2024-12-24 17:57:15", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:57:15", "2024-12-24 17:57:15");
INSERT INTO `wp_aioseo_posts` VALUES("119", "11748", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final8.jpg\"}]", "2024-12-24 17:57:15", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:57:15", "2024-12-24 17:57:15");
INSERT INTO `wp_aioseo_posts` VALUES("120", "11827", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-free-about5.jpg\"}]", "2024-12-24 17:57:15", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:57:15", "2024-12-24 17:57:15");
INSERT INTO `wp_aioseo_posts` VALUES("121", "11835", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/logo-cropps-color2-HDPI.png\"}]", "2024-12-24 17:57:15", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:57:15", "2024-12-24 17:57:15");
INSERT INTO `wp_aioseo_posts` VALUES("122", "11837", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/worldmap-cropps.png\"}]", "2024-12-24 17:57:15", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:57:15", "2024-12-24 17:57:15");
INSERT INTO `wp_aioseo_posts` VALUES("123", "11874", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-photo4.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-photo3.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-photo5.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-photo6.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/worldmap-cropps.png\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-free-about3.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/camera.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/events.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/social.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/thinking.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/apollo13_images\\/cropps-album-final7-l4wpf36iuv480kau4f43vd7ulle34dbb9m2.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/apollo13_images\\/cropps-album-final4-l4wpf0yyzfw08ktibz8decpxmjo5eom5isq.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/apollo13_images\\/cropps-album-final1-l4wpey0whjl1v9iem2223o21ntdkgfolv1m.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/apollo13_images\\/cropps-album-final8-l4wpf3x1hc6ylw4m1weop1dtl9yqcxjp6ju.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/apollo13_images\\/cropps-album-final6-l4wpf2g08e1hf8h26xtj1p1vlwtfvt2xcoa.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/apollo13_images\\/cropps-album-final5-l4wpf1phlwyqtwna9giy80vwm88sn8ujfqi.jpg\"},{\"image:loc\":\"https:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/2018\\/02\\/face-free.jpg\"},{\"image:loc\":\"https:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/2018\\/02\\/face-free5.jpg\"},{\"image:loc\":\"https:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/2018\\/02\\/face-free7.jpg\"},{\"image:loc\":\"https:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/elementor\\/thumbs\\/Company_Logos3-nm8x5wvlus901jrgwte5yj534cmh328av5nnyk4m4k.png\"},{\"image:loc\":\"https:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/elementor\\/thumbs\\/Company_Logos4-nm8x5xtg1maad5q3rbssj0wjpqhuarc17ab5fu37yc.png\"},{\"image:loc\":\"https:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/elementor\\/thumbs\\/Company_Logos5-nm8x5xtg1maad5q3rbssj0wjpqhuarc17ab5fu37yc.png\"},{\"image:loc\":\"https:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/elementor\\/thumbs\\/Company_Logos6-nm8x5yra8gbkoroqlu7f3io0b4d7igfrjeymx41ts4.png\"},{\"image:loc\":\"https:\\/\\/rifetheme.com\\/wp-content\\/uploads\\/elementor\\/thumbs\\/Company_Logos7-nm8x5yra8gbkoroqlu7f3io0b4d7igfrjeymx41ts4.png\"}]", "2024-12-24 17:57:16", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:57:16", "2024-12-24 17:57:16");
INSERT INTO `wp_aioseo_posts` VALUES("124", "11876", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2018\\/02\\/cropps-free-about5.jpg\"}]", "2024-12-24 17:57:16", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:57:16", "2024-12-24 17:57:16");
INSERT INTO `wp_aioseo_posts` VALUES("125", "11898", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, "2024-12-25 19:14:22", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 17:57:16", "2024-12-25 19:14:22");
INSERT INTO `wp_aioseo_posts` VALUES("126", "11902", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/sd-00.jpg\"}]", "2024-12-24 19:13:33", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 19:13:33", "2024-12-24 19:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("127", "11903", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/sd-02.jpg\"}]", "2024-12-24 19:13:33", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 19:13:33", "2024-12-24 19:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("128", "11904", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/sd-03.jpg\"}]", "2024-12-24 19:13:33", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 19:13:33", "2024-12-24 19:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("129", "11905", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/sd-04.jpg\"}]", "2024-12-24 19:13:33", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 19:13:33", "2024-12-24 19:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("130", "11906", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/sd-05.jpg\"}]", "2024-12-24 19:13:33", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 19:13:33", "2024-12-24 19:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("131", "11907", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/sd-06.jpg\"}]", "2024-12-24 19:13:33", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 19:13:33", "2024-12-24 19:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("132", "11908", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/sd-01.jpg\"}]", "2024-12-24 19:13:33", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 19:13:33", "2024-12-24 19:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("133", "11918", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2020\\/04\\/fc_logo.png\"}]", "2024-12-24 20:11:55", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-24 20:11:55", "2024-12-24 20:11:55");
INSERT INTO `wp_aioseo_posts` VALUES("134", "11923", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2020\\/04\\/cropped-fc_logo.png\"}]", "2024-12-25 17:51:10", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-25 17:51:10", "2024-12-25 17:51:10");
INSERT INTO `wp_aioseo_posts` VALUES("135", "11926", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2024\\/12\\/fc_logo_.png\"}]", "2024-12-25 18:11:36", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-25 18:11:36", "2024-12-25 18:11:36");
INSERT INTO `wp_aioseo_posts` VALUES("136", "11927", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2024\\/12\\/cropped-fc_logo_.png\"}]", "2024-12-25 18:11:36", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-25 18:11:36", "2024-12-25 18:11:36");
INSERT INTO `wp_aioseo_posts` VALUES("138", "11934", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/cropps-album-final1.jpg\"}]", "2024-12-24 17:52:06", NULL, "default", NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2024-12-25 19:04:50", "2024-12-25 19:05:27");
INSERT INTO `wp_aioseo_posts` VALUES("139", "11936", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"lengthContent\":{\"error\":1,\"maxScore\":9,\"score\":6}},\"title\":{\"titleLength\":{\"error\":1,\"maxScore\":9,\"score\":1}},\"readability\":{\"contentHasAssets\":{\"error\":1,\"maxScore\":5,\"score\":0}}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", NULL, NULL, NULL, "default", NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 14:31:30", "2025-01-08 14:31:30");
INSERT INTO `wp_aioseo_posts` VALUES("140", "11944", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"lengthContent\":{\"error\":1,\"score\":1,\"maxScore\":5}},\"title\":{\"titleLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5}}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "100", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", NULL, "2025-03-20 01:39:07", NULL, "default", NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 14:34:54", "2025-03-20 01:39:07");
INSERT INTO `wp_aioseo_posts` VALUES("142", "11964", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"lengthContent\":{\"error\":1,\"score\":1,\"maxScore\":5}},\"title\":{\"titleLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5}}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "100", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino.show-dancer-dancers-red-rojo-technique-performance-professionals.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/04\\/81f5ff221711071.67d9624449faf___edited.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-tanguera-argentina-bailar-ballroom-ballet.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/pareja-baile-danca-romantico-amor-casal-paixao-casamento-show.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/tango-argentino-got-talent-portugal-02-edited.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/sd-02.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/argentine-tango-roxanne-modern-tanguera-lift-fernando-carolina-dance.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/argentine-tango-roxanne-modern-tanguera-lift-fernando-carolina.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/sd-04.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino-black-and-white-01.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino-black-and-white-02.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino-black-and-white-03.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino-black-and-white-04.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/sd-03.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/03\\/48912a221711071.67d962444b437.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/04\\/067f6e221711071.67d9624446bcd.jpg\"}]", "2025-04-04 15:41:46", NULL, "default", NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 17:28:58", "2025-04-04 15:41:46");
INSERT INTO `wp_aioseo_posts` VALUES("143", "11973", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/Tango-Argentino-Show-Pose-Bailar-Pareja-Baile-scaled.jpeg\"}]", "2025-01-08 17:50:07", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 17:50:07", "2025-01-08 17:50:07");
INSERT INTO `wp_aioseo_posts` VALUES("144", "11974", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/FC-Poster-01-IMG_6109-scaled.jpg\"}]", "2025-01-08 17:50:07", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 17:50:07", "2025-01-08 17:50:07");
INSERT INTO `wp_aioseo_posts` VALUES("145", "11975", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino.show-dancer-dancers-red-rojo-technique-performance-professionals.jpg\"}]", "2025-01-08 17:50:07", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 17:50:07", "2025-01-08 17:50:07");
INSERT INTO `wp_aioseo_posts` VALUES("146", "11976", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-moderno-piazzolla-gotan-project-bajofondo-buenos-aires.jpg\"}]", "2025-01-08 17:50:07", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 17:50:07", "2025-01-08 17:50:07");
INSERT INTO `wp_aioseo_posts` VALUES("147", "11977", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/argentine-tango-roxanne-modern-tanguera-lift-fernando-carolina.jpg\"}]", "2025-01-08 17:50:07", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 17:50:07", "2025-01-08 17:50:07");
INSERT INTO `wp_aioseo_posts` VALUES("148", "11978", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-tanguera-argentina-bailar-ballroom-ballet.jpg\"}]", "2025-01-08 17:50:55", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 17:50:55", "2025-01-08 17:50:55");
INSERT INTO `wp_aioseo_posts` VALUES("149", "11979", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/argentine-tango-roxanne-modern-tanguera-lift-fernando-carolina-dance.jpg\"}]", "2025-01-08 18:07:35", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 18:07:35", "2025-01-08 18:07:35");
INSERT INTO `wp_aioseo_posts` VALUES("150", "11980", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/dance-move-red-tango-pantone-events-casamentos.jpg\"}]", "2025-01-08 18:07:35", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 18:07:35", "2025-01-08 18:07:35");
INSERT INTO `wp_aioseo_posts` VALUES("151", "11981", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/dance-love-romantic-couple-passion-weddings.jpg\"}]", "2025-01-08 18:07:35", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 18:07:35", "2025-01-08 18:07:35");
INSERT INTO `wp_aioseo_posts` VALUES("152", "11982", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino-black-and-white-01.jpg\"}]", "2025-01-08 18:23:21", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 18:23:21", "2025-01-08 18:23:21");
INSERT INTO `wp_aioseo_posts` VALUES("153", "11983", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino-black-and-white-02.jpg\"}]", "2025-01-08 18:23:21", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 18:23:21", "2025-01-08 18:23:21");
INSERT INTO `wp_aioseo_posts` VALUES("154", "11984", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino-black-and-white-03.jpg\"}]", "2025-01-08 18:23:21", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 18:23:21", "2025-01-08 18:23:21");
INSERT INTO `wp_aioseo_posts` VALUES("155", "11985", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino-black-and-white-04.jpg\"}]", "2025-01-08 18:23:21", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 18:23:21", "2025-01-08 18:23:21");
INSERT INTO `wp_aioseo_posts` VALUES("156", "11986", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/pareja-baile-danca-romantico-amor-casal-paixao-casamento-show.jpg\"}]", "2025-01-08 18:40:17", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-08 18:40:17", "2025-01-08 18:40:17");
INSERT INTO `wp_aioseo_posts` VALUES("157", "12000", NULL, NULL, NULL, "{\"focus\":{\"keyphrase\":\"\",\"score\":0,\"analysis\":{\"keyphraseInTitle\":{\"score\":0,\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"lengthContent\":{\"error\":1,\"score\":1,\"maxScore\":5}},\"title\":{\"titleLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0},\"readability\":{\"contentHasAssets\":{\"error\":1,\"score\":1,\"maxScore\":5}}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "100", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino-dance-couple-casamentos-aulas-shows-eventos.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/sd-03.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino.show-dancer-dancers-red-rojo-technique-performance-professionals.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/soy-tango-show-argentina-pasion.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-moderno-show-argentina.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/mundia-tango-buenos-aires-escenario.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/casino-lusitania-show-gold.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/fuego-pasion-romantic-couple-love-dancers-inspiration.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/431510944_939734414798895_3808521738284224921_n-2.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/casino-lusitania-carolina-branco-gold.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/428_NPS_7912.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/03\\/81f5ff221711071.67d9624449faf___.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/03\\/b7a841221711071.67d9624448e2a.jpg\"},{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/03\\/07bc4e221711071.67d9624447d3e.jpg\"}]", "2025-03-20 02:28:03", NULL, "default", NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 01:54:36", "2025-03-20 02:28:03");
INSERT INTO `wp_aioseo_posts` VALUES("158", "12002", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-argentino-dance-couple-casamentos-aulas-shows-eventos.jpg\"}]", "2025-01-09 02:22:21", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 02:22:21", "2025-01-09 02:22:21");
INSERT INTO `wp_aioseo_posts` VALUES("159", "12007", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/casino-lusitania-show-gold.jpg\"}]", "2025-01-09 03:11:12", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 03:11:12", "2025-01-09 03:11:12");
INSERT INTO `wp_aioseo_posts` VALUES("160", "12008", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/431510944_939734414798895_3808521738284224921_n-2.jpg\"}]", "2025-01-09 03:27:08", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 03:27:08", "2025-01-09 03:27:08");
INSERT INTO `wp_aioseo_posts` VALUES("161", "12009", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/428_NPS_7912.jpg\"}]", "2025-01-09 03:27:08", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 03:27:08", "2025-01-09 03:27:08");
INSERT INTO `wp_aioseo_posts` VALUES("162", "12010", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/6718B4A3-727A-4820-97E0-0E02A3439BA0.jpg\"}]", "2025-01-09 03:27:08", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 03:27:08", "2025-01-09 03:27:08");
INSERT INTO `wp_aioseo_posts` VALUES("163", "12011", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/casino-lusitania-f-blue.jpg\"}]", "2025-01-09 03:27:08", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 03:27:08", "2025-01-09 03:27:08");
INSERT INTO `wp_aioseo_posts` VALUES("164", "12012", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/431551763_939734171465586_7508573654117127113_n.jpg\"}]", "2025-01-09 03:27:08", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 03:27:08", "2025-01-09 03:27:08");
INSERT INTO `wp_aioseo_posts` VALUES("165", "12013", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/casino-lusitania-carolina-branco-gold.jpg\"}]", "2025-01-09 03:27:08", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 03:27:08", "2025-01-09 03:27:08");
INSERT INTO `wp_aioseo_posts` VALUES("166", "12017", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/IMG_6138-scaled.jpg\"}]", "2025-01-09 03:59:14", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 03:59:14", "2025-01-09 03:59:14");
INSERT INTO `wp_aioseo_posts` VALUES("167", "12019", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/mundia-tango-buenos-aires-escenario.jpg\"}]", "2025-01-09 03:59:14", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 03:59:14", "2025-01-09 03:59:14");
INSERT INTO `wp_aioseo_posts` VALUES("168", "12027", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/soy-tango-show-argentina-pasion.jpg\"}]", "2025-01-09 11:34:55", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 11:34:55", "2025-01-09 11:34:55");
INSERT INTO `wp_aioseo_posts` VALUES("169", "12028", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/tango-moderno-show-argentina.jpg\"}]", "2025-01-09 11:34:55", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 11:34:55", "2025-01-09 11:34:55");
INSERT INTO `wp_aioseo_posts` VALUES("170", "12029", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/sd-03.jpg\"}]", "2025-01-09 11:52:24", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 11:52:24", "2025-01-09 11:52:24");
INSERT INTO `wp_aioseo_posts` VALUES("171", "12046", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/IMG_1818-fc-gold-scaled.jpg\"}]", "2025-01-09 11:53:05", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 11:53:05", "2025-01-09 11:53:05");
INSERT INTO `wp_aioseo_posts` VALUES("172", "12053", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/JVF_1745.jpg\"}]", "2025-01-09 12:08:43", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 12:08:43", "2025-01-09 12:08:43");
INSERT INTO `wp_aioseo_posts` VALUES("173", "12054", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/01\\/fuego-pasion-romantic-couple-love-dancers-inspiration.jpg\"}]", "2025-01-09 12:08:43", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-01-09 12:08:43", "2025-01-09 12:08:43");
INSERT INTO `wp_aioseo_posts` VALUES("174", "12072", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/03\\/81f5ff221711071.67d9624449faf___.jpg\"}]", "2025-03-20 01:39:07", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-03-20 01:39:07", "2025-03-20 01:39:07");
INSERT INTO `wp_aioseo_posts` VALUES("175", "12073", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/03\\/07bc4e221711071.67d9624447d3e.jpg\"}]", "2025-03-20 01:39:07", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-03-20 01:39:07", "2025-03-20 01:39:07");
INSERT INTO `wp_aioseo_posts` VALUES("176", "12077", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/03\\/48912a221711071.67d962444b437.jpg\"}]", "2025-03-20 01:39:07", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-03-20 01:39:07", "2025-03-20 01:39:07");
INSERT INTO `wp_aioseo_posts` VALUES("177", "12082", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/03\\/bc33d1221711071.67d962446eb1e.jpg\"}]", "2025-03-20 01:40:09", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-03-20 01:40:09", "2025-03-20 01:40:09");
INSERT INTO `wp_aioseo_posts` VALUES("178", "12083", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/03\\/b7a841221711071.67d9624448e2a.jpg\"}]", "2025-03-20 01:41:06", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-03-20 01:41:06", "2025-03-20 01:41:06");
INSERT INTO `wp_aioseo_posts` VALUES("179", "12088", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/04\\/81f5ff221711071.67d9624449faf___edited.jpg\"}]", "2025-04-01 15:47:53", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-04-01 15:47:53", "2025-04-01 15:47:53");
INSERT INTO `wp_aioseo_posts` VALUES("180", "12089", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2025\\/04\\/067f6e221711071.67d9624446bcd.jpg\"}]", "2025-04-01 15:47:53", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-04-01 15:47:53", "2025-04-01 15:47:53");
INSERT INTO `wp_aioseo_posts` VALUES("181", "12094", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/tango-argentino-got-talent-portugal-01.jpg\"}]", "2025-04-04 14:53:14", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-04-04 14:53:14", "2025-04-04 14:53:14");
INSERT INTO `wp_aioseo_posts` VALUES("182", "12096", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/uploads\\/2017\\/01\\/tango-argentino-got-talent-portugal-02-edited-scaled.jpg\"}]", "2025-04-04 15:41:45", NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "2025-04-04 15:41:45", "2025-04-04 15:41:45");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "2359", "Roger Black", "apollofake2@interia.pl", "", "83.31.197.63", "2016-03-29 09:13:11", "2016-03-29 09:13:11", "Pitch series A financing innovator venture supply chain market business-to-consumer startup gamification product management success first mover advantage direct mailing return on investment. Monetization user experience bootstrapping success pivot research &amp; development.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "2359", "Mike Smith", "dynia2000@interia.pl", "", "83.31.197.63", "2016-03-29 09:14:14", "2016-03-29 09:14:14", "Tellus ut aenean. Veni tellus hendrerit quam. Elit justo etiam sit. Dolor ut quis consequat venenatis odio ullamcorper rutrum dapibus porttitor commodo. Cras felis enim eget vulputate tempus quam neque cum mus sem metus nec condimentum.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "2359", "Mary Klein", "apollofake@interia.pl", "", "83.31.197.63", "2016-03-29 09:15:07", "2016-03-29 09:15:07", "Penatibus nisi ante donec lorem quis ut amet elementum sem eu. Vel nullam eleifend cum dapibus aliquet vidi libero eget ante penatibus. Consequat et nulla condimentum. Imperdiet ipsum nascetur nisi.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "2359", "Mary Klein", "apollofake@interia.pl", "", "83.31.197.63", "2016-03-29 09:16:29", "2016-03-29 09:16:29", "Fringilla etiam maecenas ligula justo nec pretium felis nisi. Pretium eget aliquam augue commodo cras semper sem nullam. Ut semper nec id adipiscing dui lorem. Pretium dapibus eget in sem donec et. Metus etiam ipsum sit. Quis blandit ut ante pulvinar adipiscing dis vel montes amet. Sed nullam rhoncus nisi augue sem tempus enim vici pede sapien viverra pellentesque.", "0", "1", "", "comment", "2", "0");
INSERT INTO `wp_comments` VALUES("6", "2359", "Daniel", "info@apollo13.eu", "", "88.156.136.35", "2017-01-26 10:45:40", "2017-01-26 10:45:40", "Sed efficitur congue dolor, et rhoncus ipsum rutrum nec. Ut ac mollis risus, bibendum molestie tortor. Fusce magna dui, pharetra eget pellentesque vehicula, consequat vel nisl. Donec auctor ex a laoreet egestas.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "2359", "Daniel", "info@apollo13.eu", "", "88.156.136.35", "2017-01-26 10:45:57", "2017-01-26 10:45:57", "Nulla laoreet vestibulum turpis non finibus. Proin interdum a tortor sit amet mollis.", "0", "1", "", "comment", "2", "0");
INSERT INTO `wp_comments` VALUES("8", "2399", "Daniel", "info@apollo13.eu", "", "88.156.136.35", "2017-01-26 10:46:12", "2017-01-26 10:46:12", "Nulla laoreet vestibulum turpis non finibus. Proin interdum a tortor sit amet mollis.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "2399", "Jennis Blix", "apollofake@interia.pl", "", "88.156.136.35", "2017-01-26 10:48:04", "2017-01-26 10:48:04", "Sed efficitur congue dolor, et rhoncus ipsum rutrum nec. Ut ac mollis risus, bibendum molestie tortor. Fusce magna dui, pharetra eget pellentesque vehicula, consequat vel nisl.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "2399", "Mark Smith", "dynia2000@interia.pl", "", "88.156.136.35", "2017-01-26 10:48:48", "2017-01-26 10:48:48", "Donec auctor ex a laoreet egestas. Donec tempor porttitor neque, vel tincidunt metus congue eget. Mauris non maximus nisi.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "2399", "John Black", "apollofake2@interia.pl", "", "88.156.136.35", "2017-01-26 10:50:04", "2017-01-26 10:50:04", "Quisque dui ex, sagittis vitae faucibus ut, consectetur et metus. Aliquam iaculis imperdiet ligula, rhoncus convallis turpis.", "0", "1", "", "comment", "8", "0");
INSERT INTO `wp_comments` VALUES("12", "2399", "MarkDap", "kbkhqilvvq@rambler.ru", "https://b-import.ru/", "109.172.85.135", "2025-01-16 12:27:06", "2025-01-16 12:27:06", "Всем привет! Может кто знает, где найтиполезные блоги о недвижимости? Пока нашел - https://b-import.ru/", "0", "0", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.66 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "2399", "Лепесток", "prohor10111974@yandex.ru", "https://lepestok.su", "95.142.46.92", "2025-02-03 09:08:10", "2025-02-03 09:08:10", "оптовая продажа посадочного материала в Волгограде -  https://lepestok.su", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "2359", "Lepestok", "prohor10111974@yandex.ru", "https://lepestok.su/optovaya-prodaja-semyan-online", "95.142.46.92", "2025-02-09 01:22:42", "2025-02-09 01:22:42", "оптовая продажа  рассады цветов в Волгограде -  https://lepestok.su/optovaya-prodaja-semyan-online", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("15", "2359", "Lee1354", "Lee1354@gmail.com", "", "45.180.8.249", "2025-04-14 00:05:44", "2025-04-14 00:05:44", "<a href=\"https://myteana.ru/forums/index.php?autocom=gallery&amp;req=si&amp;img=6604\" rel=\"nofollow ugc\">https://myteana.ru/forums/index.php?autocom=gallery&amp;req=si&amp;img=6604</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "2359", "Roland2236", "Roland2236@gmail.com", "", "190.60.56.51", "2025-04-21 04:23:50", "2025-04-21 04:23:50", "Very good <a href=\"https://is.gd/tpjNyL\" rel=\"nofollow ugc\">https://is.gd/tpjNyL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20251223_fernandoycarolinatangoargen", "6541b2a8d4ffcb727893_20251223113819", "22", "2025-12-23 11:38:36", "fernandoycarolina", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-23 11:38:19\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.2.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:36:\"20251223_fernandoycarolinatangoargen\";s:4:\"Hash\";s:35:\"6541b2a8d4ffcb727893_20251223113819\";s:8:\"NameHash\";s:72:\"20251223_fernandoycarolinatangoargen_6541b2a8d4ffcb727893_20251223113819\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:82:\"20251223_fernandoycarolinatangoargen_6541b2a8d4ffcb727893_20251223113819_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.2\";s:6:\"WPUser\";s:17:\"fernandoycarolina\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:84:\"20251223_fernandoycarolinatangoargen_6541b2a8d4ffcb727893_20251223113819_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:35:\"/data/sites/web/tangoandmorecom/www\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2530;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:15986;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-23 11:38:19\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.2.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:36:\"20251223_fernandoycarolinatangoargen\";s:4:\"Hash\";s:35:\"6541b2a8d4ffcb727893_20251223113819\";s:8:\"NameHash\";s:72:\"20251223_fernandoycarolinatangoargen_6541b2a8d4ffcb727893_20251223113819\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:90:\"20251223_fernandoycarolinatangoargen_6541b2a8d4ffcb727893_20251223113819_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:49:\"/data/sites/web/tangoandmorecom/www/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:85:\"20251223_fernandoycarolinatangoargen_6541b2a8d4ffcb727893_20251223113819_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:56:\"Percona Server (GPL), Release \'28\', Revision \'47601f19\'$\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:153:\"/data/sites/web/tangoandmorecom/www/wp-content/backups-dup-lite/tmp/20251223_fernandoycarolinatangoargen_6541b2a8d4ffcb727893_20251223113819_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:44:\"/data/sites/web/tangoandmorecom/www/wp-admin\";i:1;s:47:\"/data/sites/web/tangoandmorecom/www/wp-includes\";i:2;s:56:\"/data/sites/web/tangoandmorecom/www/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:35:\"/data/sites/web/tangoandmorecom/www\";i:1;s:35:\"/data/sites/web/tangoandmorecom/www\";i:2;s:46:\"/data/sites/web/tangoandmorecom/www/wp-content\";i:3;s:54:\"/data/sites/web/tangoandmorecom/www/wp-content/uploads\";i:4;s:54:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins\";i:5;s:57:\"/data/sites/web/tangoandmorecom/www/wp-content/mu-plugins\";i:6;s:53:\"/data/sites/web/tangoandmorecom/www/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:67:\"/data/sites/web/tangoandmorecom/www/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:30:{i:1766966400;a:1:{s:33:\"wpforms_weekly_entries_count_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1768100594;a:1:{s:36:\"iubenda_schedule_reload_radar_config\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1768842664;a:1:{s:20:\"extendify_cache_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"every_month\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}i:1836275357;a:2:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1836275358;a:1:{s:28:\"wp_1_wc_privacy_cleanup_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:37:\"wp_1_wc_privacy_cleanup_cron_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1836275363;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1836275403;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1836277842;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1836278439;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1836279001;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1836281441;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1836283241;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1836285041;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1836300555;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1836321042;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1836321065;a:1:{s:18:\"extendify_insights\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1836321639;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1836321640;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1836322155;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1836322157;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1836322165;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1836322631;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1836332955;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1836345600;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1836568800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1836649024;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1836666644;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1836753042;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1837445415;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://tangoandmore.com", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://tangoandmore.com", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "Fernando y Carolina Tango Argentino", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "Tango Show Performances", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "fernandoycarolinatango@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:261:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:55:\"e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"categoria-produto/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:51:\"categoria-produto/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:32:\"categoria-produto/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:44:\"categoria-produto/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:26:\"categoria-produto/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:57:\"produto-etiqueta/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:52:\"produto-etiqueta/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:33:\"produto-etiqueta/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:45:\"produto-etiqueta/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:27:\"produto-etiqueta/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"produto/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"produto/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"produto/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"produto/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"produto/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"produto/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"produto/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"produto/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"produto/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"produto/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"produto/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"produto/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"produto/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"produto/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"produto/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"produto/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"produto/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"produto/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"produto/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"produto/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"produto/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"produto/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"produto/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"produto/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"produto/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"album/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"album/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"album/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"album/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"album/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"album/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"album/([^/]+)/embed/?$\";s:38:\"index.php?album=$matches[1]&embed=true\";s:26:\"album/([^/]+)/trackback/?$\";s:32:\"index.php?album=$matches[1]&tb=1\";s:34:\"album/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?album=$matches[1]&paged=$matches[2]\";s:41:\"album/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?album=$matches[1]&cpage=$matches[2]\";s:42:\"album/([^/]+)/wc/file/transient(/(.*))?/?$\";s:57:\"index.php?album=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"album/([^/]+)/wc-api(/(.*))?/?$\";s:46:\"index.php?album=$matches[1]&wc-api=$matches[3]\";s:48:\"album/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:59:\"album/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"album/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"album/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:30:\"album/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?album=$matches[1]&page=$matches[2]\";s:22:\"album/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"album/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"album/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"album/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"album/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"album/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"genre/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?genre=$matches[1]&feed=$matches[2]\";s:39:\"genre/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?genre=$matches[1]&feed=$matches[2]\";s:20:\"genre/(.+?)/embed/?$\";s:38:\"index.php?genre=$matches[1]&embed=true\";s:32:\"genre/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?genre=$matches[1]&paged=$matches[2]\";s:14:\"genre/(.+?)/?$\";s:27:\"index.php?genre=$matches[1]\";s:32:\"work/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"work/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"work/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"work/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"work/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"work/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"work/([^/]+)/embed/?$\";s:37:\"index.php?work=$matches[1]&embed=true\";s:25:\"work/([^/]+)/trackback/?$\";s:31:\"index.php?work=$matches[1]&tb=1\";s:33:\"work/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?work=$matches[1]&paged=$matches[2]\";s:40:\"work/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?work=$matches[1]&cpage=$matches[2]\";s:41:\"work/([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?work=$matches[1]&wc/file/transient=$matches[3]\";s:30:\"work/([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?work=$matches[1]&wc-api=$matches[3]\";s:47:\"work/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:58:\"work/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"work/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"work/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:29:\"work/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?work=$matches[1]&page=$matches[2]\";s:21:\"work/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"work/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"work/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"work/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"work/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"work/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:49:\"work_genre/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?work_genre=$matches[1]&feed=$matches[2]\";s:44:\"work_genre/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?work_genre=$matches[1]&feed=$matches[2]\";s:25:\"work_genre/(.+?)/embed/?$\";s:43:\"index.php?work_genre=$matches[1]&embed=true\";s:37:\"work_genre/(.+?)/page/?([0-9]{1,})/?$\";s:50:\"index.php?work_genre=$matches[1]&paged=$matches[2]\";s:19:\"work_genre/(.+?)/?$\";s:32:\"index.php?work_genre=$matches[1]\";s:46:\"group/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?group=$matches[1]&feed=$matches[2]\";s:41:\"group/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?group=$matches[1]&feed=$matches[2]\";s:22:\"group/([^/]+)/embed/?$\";s:38:\"index.php?group=$matches[1]&embed=true\";s:34:\"group/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?group=$matches[1]&paged=$matches[2]\";s:16:\"group/([^/]+)/?$\";s:27:\"index.php?group=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=8754&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:12:{i:0;s:31:\"01-ext-amenpt/01-ext-amenpt.php\";i:1;s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";i:2;s:63:\"apollo13-framework-extensions/apollo13-framework-extensions.php\";i:3;s:33:\"duplicate-post/duplicate-post.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:23:\"elementor/elementor.php\";i:6;s:23:\"extendify/extendify.php\";i:7;s:55:\"iubenda-cookie-law-solution/iubenda_cookie_solution.php\";i:8;s:55:\"rife-elementor-extensions/rife-elementor-extensions.php\";i:9;s:55:\"searchwp-live-ajax-search/searchwp-live-ajax-search.php\";i:10;s:27:\"woocommerce/woocommerce.php\";i:11;s:24:\"wpforms-lite/wpforms.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "rife-free", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "rife-free", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60421", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:6:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:5;a:0:{}s:12:\"_multiwidget\";i:1;i:7;a:0:{}i:9;a:0:{}i:11;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:1;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:12:{i:1;a:0:{}i:4;a:3:{s:5:\"title\";s:18:\"About This Sidebar\";s:4:\"text\";s:87:\"You can quickly hide this sidebar by removing widgets from the Hidden Sidebar Settings.\";s:6:\"filter\";b:0;}i:6;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:114:\"<div style=\"margin: 38px 0 18px 0;\"><img src=\"http://rifetheme.com/wp-content/uploads/2017/02/footer.png\" /></div>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:7;a:3:{s:5:\"title\";s:14:\"About The Blog\";s:4:\"text\";s:140:\"Nulla laoreet vestibulum turpis non finibus. Proin interdum a tortor sit amet mollis. Maecenas sollicitudin accumsan enim, ut aliquet risus.\";s:6:\"filter\";b:0;}i:8;a:3:{s:5:\"title\";s:8:\"About Us\";s:4:\"text\";s:140:\"Nulla laoreet vestibulum turpis non finibus. Proin interdum a tortor sit amet mollis. Maecenas sollicitudin accumsan enim, ut aliquet risus.\";s:6:\"filter\";b:0;}i:10;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:90:\"4rd Avenue, New York\r\n+22 564 656 78\r\n<a href=\"mailto:info@domain.com\">info@domain.com</a>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:11;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:128:\"<strong><a href=\"#\">About Us</a></strong>\r\n<strong> <a href=\"#\">Services</a></strong>\r\n<strong> <a href=\"#\">Contact</a></strong>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:12;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:127:\"<strong><a href=\"#\">Facebook</a></strong>\r\n<strong> <a href=\"#\">Twitter</a></strong>\r\n<strong> <a href=\"#\">Behance</a></strong>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:14;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:185:\"<img src=\"http://rifetheme.com/wp-content/uploads/2018/02/Rife-Unicorn-Logo-White1.png\" />\r\n\r\nAliquam nec ullamcorper nunc. Ut porta finibus nislenem, at volutpat mauris porttitor quis.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:15;a:4:{s:5:\"title\";s:12:\"Why Unicorn?\";s:4:\"text\";s:323:\"Unicorn is a <a href=\"https://apollo13themes.com/rife/designs/\" target=\"_blank\" rel=\"noopener\">design</a> prepared especially for the free version of <a href=\"https://apollo13themes.com/rife/\" target=\"_blank\" rel=\"noopener\">Rife WordPress Theme</a>.\r\n\r\nYou can use this design for free. Create your splendind website today!\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:17;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:54:\"John Knox\r\n3088 Newton Street\r\nSullivan Lake, MN 56345\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:4:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;i:3;a:0:{}i:5;a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "2311", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "8754", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1766748799", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:121:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"aioseo_manage_seo\";b:1;s:20:\"aioseo_page_analysis\";b:1;s:28:\"aioseo_page_general_settings\";b:1;s:29:\"aioseo_page_advanced_settings\";b:1;s:27:\"aioseo_page_schema_settings\";b:1;s:27:\"aioseo_page_social_settings\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:20:\"aioseo_page_analysis\";b:1;s:28:\"aioseo_page_general_settings\";b:1;s:29:\"aioseo_page_advanced_settings\";b:1;s:27:\"aioseo_page_schema_settings\";b:1;s:27:\"aioseo_page_social_settings\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:15:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"aioseo_page_analysis\";b:1;s:28:\"aioseo_page_general_settings\";b:1;s:29:\"aioseo_page_advanced_settings\";b:1;s:27:\"aioseo_page_schema_settings\";b:1;s:27:\"aioseo_page_social_settings\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:10:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:20:\"aioseo_page_analysis\";b:1;s:28:\"aioseo_page_general_settings\";b:1;s:29:\"aioseo_page_advanced_settings\";b:1;s:27:\"aioseo_page_schema_settings\";b:1;s:27:\"aioseo_page_social_settings\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:12:{s:19:\"wp_inactive_widgets\";a:46:{i:0;s:15:\"media_gallery-3\";i:1;s:7:\"meta-13\";i:2;s:6:\"text-6\";i:3;s:7:\"text-10\";i:4;s:7:\"text-11\";i:5;s:7:\"text-12\";i:6;s:7:\"text-14\";i:7;s:17:\"recent-comments-4\";i:8;s:5:\"rss-5\";i:9;s:15:\"popular-posts-4\";i:10;s:7:\"meta-11\";i:11;s:6:\"meta-7\";i:12;s:5:\"rss-3\";i:13;s:10:\"nav_menu-5\";i:14;s:14:\"recent-works-3\";i:15;s:18:\"a13-social-icons-5\";i:16;s:18:\"a13-social-icons-6\";i:17;s:18:\"a13-social-icons-4\";i:18;s:10:\"archives-2\";i:19;s:17:\"recent-comments-2\";i:20;s:11:\"tag_cloud-6\";i:21;s:10:\"nav_menu-3\";i:22;s:11:\"tag_cloud-8\";i:23;s:8:\"search-2\";i:24;s:11:\"tag_cloud-9\";i:25;s:14:\"recent-posts-7\";i:26;s:12:\"categories-7\";i:27;s:12:\"tag_cloud-13\";i:28;s:19:\"a13-social-icons-12\";i:29;s:18:\"a13-social-icons-7\";i:30;s:18:\"a13-social-icons-8\";i:31;s:10:\"nav_menu-7\";i:32;s:12:\"tag_cloud-15\";i:33;s:15:\"popular-posts-3\";i:34;s:13:\"media_image-3\";i:35;s:12:\"tag_cloud-17\";i:36;s:13:\"media_image-6\";i:37;s:7:\"text-17\";i:38;s:19:\"a13-social-icons-14\";i:39;s:19:\"a13-social-icons-15\";i:40;s:19:\"a13-social-icons-16\";i:41;s:18:\"a13-social-icons-3\";i:42;s:6:\"text-4\";i:43;s:14:\"recent-posts-5\";i:44;s:12:\"categories-5\";i:45;s:6:\"meta-5\";}s:16:\"blog-widget-area\";a:6:{i:0;s:6:\"text-8\";i:1;s:19:\"a13-social-icons-10\";i:2;s:14:\"recent-posts-2\";i:3;s:12:\"categories-2\";i:4;s:6:\"meta-2\";i:5;s:11:\"tag_cloud-4\";}s:16:\"post-widget-area\";a:6:{i:0;s:6:\"text-7\";i:1;s:18:\"a13-social-icons-9\";i:2;s:14:\"recent-posts-9\";i:3;s:12:\"categories-9\";i:4;s:6:\"meta-9\";i:5;s:12:\"tag_cloud-11\";}s:16:\"page-widget-area\";a:0:{}s:16:\"shop-widget-area\";a:0:{}s:16:\"side-widget-area\";a:0:{}s:18:\"basket-widget-area\";a:0:{}s:18:\"header-widget-area\";a:1:{i:0;s:8:\"filter-6\";}s:18:\"footer-widget-area\";a:0:{}s:18:\"apollo13-sidebar_1\";a:0:{}s:18:\"apollo13-sidebar_2\";a:0:{}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:4:{i:3;a:15:{s:13:\"attachment_id\";i:11134;s:3:\"url\";s:76:\"http://rifetheme.com/wp-content/uploads/2018/02/Rife-Unicorn-Logo-White1.png\";s:5:\"title\";s:0:\"\";s:4:\"size\";s:4:\"full\";s:5:\"width\";i:171;s:6:\"height\";i:39;s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:9:\"link_type\";s:6:\"custom\";s:8:\"link_url\";s:0:\"\";s:13:\"image_classes\";s:0:\"\";s:12:\"link_classes\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";s:17:\"link_target_blank\";b:0;s:11:\"image_title\";s:0:\"\";}i:4;a:15:{s:13:\"attachment_id\";i:11141;s:3:\"url\";s:76:\"http://rifetheme.com/wp-content/uploads/2018/02/Rife-Unicorn-Logo-White2.png\";s:5:\"title\";s:0:\"\";s:4:\"size\";s:4:\"full\";s:5:\"width\";i:171;s:6:\"height\";i:39;s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:9:\"link_type\";s:6:\"custom\";s:8:\"link_url\";s:0:\"\";s:13:\"image_classes\";s:0:\"\";s:12:\"link_classes\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";s:17:\"link_target_blank\";b:0;s:11:\"image_title\";s:0:\"\";}i:6;a:15:{s:13:\"attachment_id\";i:11623;s:3:\"url\";s:76:\"http://rifetheme.com/wp-content/uploads/2018/02/Rife-Free-Cropps-LogoBW2.png\";s:5:\"title\";s:0:\"\";s:4:\"size\";s:4:\"full\";s:5:\"width\";i:171;s:6:\"height\";i:44;s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:9:\"link_type\";s:6:\"custom\";s:8:\"link_url\";s:0:\"\";s:13:\"image_classes\";s:0:\"\";s:12:\"link_classes\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";s:17:\"link_target_blank\";b:0;s:11:\"image_title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:2:{s:12:\"_multiwidget\";i:1;i:3;a:6:{s:5:\"title\";s:7:\"Gallery\";s:7:\"columns\";i:3;s:4:\"size\";s:9:\"thumbnail\";s:9:\"link_type\";s:4:\"post\";s:14:\"orderby_random\";b:0;s:3:\"ids\";a:4:{i:0;i:10879;i:1;i:10878;i:2;i:10873;i:3;i:10872;}}}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:7:{i:2;a:1:{s:5:\"title\";s:0:\"\";}i:5;a:0:{}s:12:\"_multiwidget\";i:1;i:7;a:0:{}i:9;a:0:{}i:11;a:0:{}i:13;a:1:{s:5:\"title\";s:4:\"Meta\";}}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:7:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}i:5;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:9:\"show_date\";b:0;}s:12:\"_multiwidget\";i:1;i:7;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:9:\"show_date\";b:0;}i:9;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:9:\"show_date\";b:0;}i:11;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:9:\"show_date\";b:0;}i:13;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:9:\"show_date\";b:0;}}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:3:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;i:4;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:9:{i:4;a:0:{}i:6;a:0:{}s:12:\"_multiwidget\";i:1;i:8;a:0:{}i:9;a:0:{}i:11;a:0:{}i:13;a:0:{}i:15;a:0:{}i:17;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:5:{i:3;a:0:{}i:5;a:0:{}i:7;a:0:{}i:8;a:2:{s:5:\"title\";s:8:\"Discover\";s:8:\"nav_menu\";i:46;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.7.1\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("125", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("126", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1735060277;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("127", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"f6ec2408dfa2f576bf9773bbd64079d9\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("129", "WPLANG", "pt_PT", "auto");
INSERT INTO `wp_options` VALUES("136", "extendify_site_id", "54d73a8e-9575-4053-97d5-5df8f55b4c87", "auto");
INSERT INTO `wp_options` VALUES("137", "extendify_run_migrations", "a:1:{s:6:\"1.14.2\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("139", "extendify_insights_checkedin_once", "2024-12-24 17:11:06", "auto");
INSERT INTO `wp_options` VALUES("145", "iubenda_cookie_law_solution", "a:22:{s:5:\"parse\";b:1;s:12:\"skip_parsing\";b:0;s:5:\"ctype\";b:1;s:13:\"parser_engine\";s:3:\"new\";s:11:\"output_feed\";b:1;s:11:\"output_post\";b:1;s:9:\"block_gtm\";b:0;s:12:\"code_default\";b:0;s:13:\"menu_position\";s:7:\"topmenu\";s:11:\"amp_support\";b:0;s:10:\"amp_source\";s:5:\"local\";s:17:\"amp_template_done\";b:0;s:12:\"amp_template\";s:0:\"\";s:14:\"custom_scripts\";a:0:{}s:14:\"custom_iframes\";a:0:{}s:12:\"deactivation\";b:0;s:10:\"configured\";b:0;s:18:\"configuration_type\";s:6:\"manual\";s:22:\"us_legislation_handled\";b:0;s:26:\"stop_showing_cs_for_admins\";b:0;s:29:\"integrate_with_wp_consent_api\";b:1;s:10:\"simplified\";a:9:{s:8:\"position\";s:16:\"float-top-center\";s:18:\"background_overlay\";b:0;s:12:\"banner_style\";s:4:\"dark\";s:11:\"legislation\";a:4:{s:4:\"gdpr\";b:1;s:4:\"uspr\";b:0;s:4:\"lgpd\";b:0;s:3:\"all\";b:0;}s:15:\"require_consent\";s:9:\"worldwide\";s:15:\"explicit_accept\";b:1;s:15:\"explicit_reject\";b:1;s:3:\"tcf\";b:1;s:22:\"frontend_auto_blocking\";a:0:{}}}", "off");
INSERT INTO `wp_options` VALUES("146", "iubenda_cookie_law_version", "3.11.3", "auto");
INSERT INTO `wp_options` VALUES("147", "iubenda_activation_data", "a:4:{s:14:\"update_version\";i:10;s:13:\"update_notice\";b:1;s:11:\"update_date\";i:1735060839;s:17:\"update_delay_date\";i:1735665639;}", "off");
INSERT INTO `wp_options` VALUES("148", "widget_iubenda_legal_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("153", "current_theme", "Rife Free", "auto");
INSERT INTO `wp_options` VALUES("154", "theme_mods_extendable", "a:4:{s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1735061597;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("155", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("160", "extendify_login_count", "14", "auto");
INSERT INTO `wp_options` VALUES("161", "extendify_first_installed_version", "1.16.0", "auto");
INSERT INTO `wp_options` VALUES("164", "extendify_partner_data_v2", "a:55:{s:16:\"showDomainBanner\";b:0;s:14:\"showDomainTask\";b:0;s:25:\"showSecondaryDomainBanner\";b:0;s:23:\"showSecondaryDomainTask\";b:0;s:10:\"domainTLDs\";a:2:{i:0;s:3:\"com\";i:1;s:3:\"net\";}s:12:\"stagingSites\";a:1:{i:0;s:9:\"wordpress\";}s:15:\"domainSearchURL\";s:0:\"\";s:9:\"showDraft\";s:1:\"1\";s:13:\"aiChatEnabled\";b:0;s:25:\"enableImageImports-1-14-6\";b:0;s:22:\"disableLibraryAutoOpen\";b:0;s:16:\"enableApexDomain\";b:0;s:19:\"allowedPluginsSlugs\";a:3:{i:0;s:12:\"wpforms-lite\";i:1;s:11:\"woocommerce\";i:2;s:10:\"simplybook\";}s:15:\"requiredPlugins\";a:1:{i:0;a:4:{s:2:\"id\";s:17:\"recJs2aAtCcM5qk44\";s:4:\"name\";s:22:\"Really Simple Security\";s:13:\"wordpressSlug\";s:17:\"really-simple-ssl\";s:7:\"heading\";s:0:\"\";}}s:4:\"Name\";s:21:\"team.blue - Amen PT 2\";s:15:\"backgroundColor\";s:7:\"#222222\";s:18:\"suggestedSEOPlugin\";a:1:{i:0;s:17:\"reciRW83M63UbCMqp\";}s:15:\"foregroundColor\";s:7:\"#ffffff\";s:24:\"suggestedDonationsPlugin\";a:1:{i:0;s:17:\"recDnFu2Q8UvC6uKI\";}s:27:\"suggestedAppointmentsPlugin\";a:1:{i:0;s:17:\"recBVwUyyNLOkkjV3\";}s:21:\"suggestedEventsPlugin\";a:1:{i:0;s:17:\"recQLbfGdxMUbwLQD\";}s:23:\"suggestedProductsPlugin\";a:1:{i:0;s:17:\"recU1hAv8zbrqOu37\";}s:20:\"suggestedEmailPlugin\";a:1:{i:0;s:17:\"rec35Bt1fzdt2GLbS\";}s:23:\"suggestedServicesPlugin\";a:1:{i:0;s:17:\"recU1hAv8zbrqOu37\";}s:9:\"PartnerID\";s:10:\"amp99182h9\";s:5:\"logo2\";s:57:\"https://images.extendify-cdn.com/partner-logos/amenpt.png\";s:22:\"disableRecommendations\";s:1:\"1\";s:6:\"status\";a:1:{i:0;s:6:\"active\";}s:14:\"secondaryColor\";s:7:\"#222222\";s:13:\"showAIConsent\";s:1:\"1\";s:15:\"consentTermsUrl\";s:33:\"https://tcs.tb-hosting.com/amenpt\";s:27:\"blockAffiliate_wpforms-lite\";s:1:\"1\";s:34:\"blockAffiliate_all-in-one-seo-pack\";s:1:\"1\";s:45:\"blockAffiliate_google-analytics-for-wordpress\";s:1:\"1\";s:10:\"showAICopy\";s:1:\"1\";s:17:\"showLocalizedCopy\";s:1:\"1\";s:16:\"consentTermsHTML\";s:197:\"Ao utilizar funcionalidades de IA, concorda com os &lt;a href=&quot;https://tcs.tb-hosting.com/amenpt&quot; target=&quot;_blank&quot; rel=&quot;noopener noreferrer&quot;&gt;Termos de Uso&lt;/a&gt;.\";s:14:\"allowedPlugins\";a:3:{i:0;s:17:\"rec35Bt1fzdt2GLbS\";i:1;s:17:\"recU1hAv8zbrqOu37\";i:2;s:17:\"recBVwUyyNLOkkjV3\";}s:11:\"goalsCustom\";a:1:{i:0;s:17:\"reclojGKEFYudgsqN\";}s:29:\"productRecommendationDisabled\";a:1:{i:0;s:17:\"reclohE7MPg8JhLAQ\";}s:27:\"productRecommendationCustom\";a:1:{i:0;s:17:\"recZ1beHkMj25vyjy\";}s:26:\"showProductRecommendations\";s:1:\"1\";s:18:\"showAIPageCreation\";s:1:\"1\";s:34:\"productRecommendationDisabledSlugs\";a:1:{i:0;s:12:\"rankingcoach\";}s:32:\"productRecommendationCustomSlugs\";a:1:{i:0;s:17:\"really-simple-ssl\";}s:10:\"showLaunch\";s:1:\"1\";s:10:\"showAILogo\";s:1:\"1\";s:12:\"showAIAgents\";s:1:\"1\";s:19:\"showLaunchQuestions\";s:1:\"1\";s:11:\"showImprint\";a:2:{i:0;s:5:\"de_DE\";i:1;s:5:\"fr_FR\";}s:11:\"pluginGroup\";a:1:{i:0;s:17:\"recNzJze8UEaZGfM9\";}s:13:\"Key Decisions\";a:4:{s:5:\"state\";s:5:\"error\";s:9:\"errorType\";s:15:\"emptyDependency\";s:5:\"value\";s:0:\"\";s:7:\"isStale\";s:0:\"\";}s:4:\"logo\";a:1:{i:0;a:1:{s:10:\"thumbnails\";a:1:{s:5:\"large\";a:1:{s:3:\"url\";s:57:\"https://images.extendify-cdn.com/partner-logos/amenpt.png\";}}}}s:11:\"deactivated\";s:0:\"\";s:7:\"license\";s:6:\"active\";}", "auto");
INSERT INTO `wp_options` VALUES("166", "extendify_attempted_redirect_count", "2", "auto");
INSERT INTO `wp_options` VALUES("167", "extendify_attempted_redirect", "2024-12-24 17:20:41", "auto");
INSERT INTO `wp_options` VALUES("177", "extendify_launch_loaded", "2024-12-24T17:20:41.010Z", "auto");
INSERT INTO `wp_options` VALUES("178", "extendify_user_selections", "a:2:{s:5:\"state\";a:9:{s:8:\"siteType\";a:2:{s:4:\"slug\";s:8:\"0default\";s:4:\"name\";s:7:\"Default\";}s:13:\"siteStructure\";s:10:\"multi-page\";s:11:\"siteProfile\";a:3:{s:10:\"aiSiteType\";s:26:\"Dance Performance Services\";s:13:\"aiDescription\";s:539:\"Fernando y Carolina Tango Argentino offers captivating Tango performances for weddings, corporate events, and more. Specializing in blending traditional Argentine Tango with modern styles and acrobatics, this professional dance duo creates unforgettable moments with tailored shows. Their performances are perfect for various events, delivering high-energy and visually stunning spectacles. Visitors can explore their services, watch show videos, and book their unique Tango entertainment that combines tradition, innovation, and artistry.\";s:10:\"aiKeywords\";a:5:{i:0;s:11:\"Tango dance\";i:1;s:15:\"Argentine Tango\";i:2;s:17:\"dance performance\";i:3;s:21:\"wedding entertainment\";i:4;s:16:\"corporate events\";}}s:11:\"siteStrings\";a:2:{s:9:\"aiHeaders\";a:10:{i:0;s:43:\"Tango: Tradição e Modernidade em Harmonia\";i:1;s:47:\"Encantadores Espetáculos de Tango para Eventos\";i:2;s:45:\"Fernando e Carolina: Magia do Tango Argentino\";i:3;s:54:\"Performances de Tango Personalizadas para o Seu Evento\";i:4;s:44:\"Surpreenda com Shows de Tango Inesquecíveis\";i:5;s:44:\"Tango Argentino: Arte e Energia em Movimento\";i:6;s:46:\"Espetáculos de Tango: Tradição e Acrobacias\";i:7;s:47:\"Transforme Seu Evento com Tango de Alto Impacto\";i:8;s:49:\"Fernando e Carolina: Mesclando Tango e Inovação\";i:9;s:45:\"Shows de Tango que Deixam uma Marca Duradoura\";}s:12:\"aiBlogTitles\";a:8:{i:0;s:54:\"Como o Tango Argentino Transforma Eventos Corporativos\";i:1;s:56:\"A Evolução do Tango: Tradição e Modernidade no Palco\";i:2;s:46:\"Tango para Casamentos: Encantamento e Emoção\";i:3;s:49:\"O Impacto Cultural do Tango Argentino nos Eventos\";i:4;s:53:\"A Arte do Tango: Entre o Clássico e o Contemporâneo\";i:5;s:45:\"Tango Acrobático: Desafios e Beleza no Palco\";i:6;s:48:\"Por Que Escolher Tango para Seu Próximo Evento?\";i:7;s:48:\"Conectando Emoções Através do Tango Argentino\";}}s:10:\"siteImages\";a:1:{s:10:\"siteImages\";a:5:{i:0;s:169:\"https://images.unsplash.com/photo-1717011969223-0217a302ec6f?ixid=M3w0MzUxNjF8MHwxfHNlYXJjaHwyfHxkYW5jZSUyMHBlcmZvcm1hbmNlfGVufDB8fHx8MTczMzk4MDQ3MXww&amp;ixlib=rb-4.0.3\";i:1;s:169:\"https://images.unsplash.com/photo-1661899566773-f65dc6054d6d?ixid=M3w0MzUxNjF8MHwxfHNlYXJjaHw2fHxkYW5jZSUyMHBlcmZvcm1hbmNlfGVufDB8fHx8MTczMzk4MDQ3MXww&amp;ixlib=rb-4.0.3\";i:2;s:171:\"https://images.unsplash.com/photo-1524580477099-d6ef682e2a2c?ixid=M3w0MzUxNjF8MHwxfHNlYXJjaHwxMXx8ZGFuY2UlMjBwZXJmb3JtYW5jZXxlbnwwfHx8fDE3MzM5ODA0NzF8MA&amp;ixlib=rb-4.0.3\";i:3;s:171:\"https://images.unsplash.com/photo-1522642888367-8d98750c243c?ixid=M3w0MzUxNjF8MHwxfHNlYXJjaHwxOHx8ZGFuY2UlMjBwZXJmb3JtYW5jZXxlbnwwfHx8fDE3MzM5ODA0NzF8MA&amp;ixlib=rb-4.0.3\";i:4;s:171:\"https://images.unsplash.com/photo-1533993010187-6a08e5a05ec9?ixid=M3w0MzUxNjF8MHwxfHNlYXJjaHwyMHx8ZGFuY2UlMjBwZXJmb3JtYW5jZXxlbnwwfHx8fDE3MzM5ODA0NzF8MA&amp;ixlib=rb-4.0.3\";}}s:15:\"siteInformation\";a:1:{s:5:\"title\";s:35:\"Fernando y Carolina Tango Argentino\";}s:19:\"businessInformation\";a:3:{s:11:\"description\";s:695:\"Captivating Tango Performances for Weddings, Corporate Events, and More\n\nExperience the passion and elegance of Argentine Tango with Fernando &amp; Carolina, a professional dance duo blending traditional Tango with modern styles and acrobatics. Our tailored Tango shows are perfect for weddings, corporate events, themed parties, and theatrical productions, creating unforgettable moments for every audience.\n\nFrom breathtaking Tango performances to innovative choreographies, we deliver high-energy and visually stunning spectacles that leave a lasting impression.\n\nExplore our services, watch videos of our shows, and book Tango entertainment that combines tradition, innovation, and artistry.\";s:5:\"tones\";a:2:{i:0;a:2:{s:5:\"label\";s:12:\"Profissional\";s:5:\"value\";s:12:\"professional\";}i:1;a:2:{s:5:\"label\";s:10:\"Inspirador\";s:5:\"value\";s:13:\"inspirational\";}}s:11:\"acceptTerms\";s:0:\"\";}s:5:\"goals\";a:2:{i:0;a:8:{s:2:\"id\";s:17:\"recuS4Beno2Too7uT\";s:4:\"name\";s:13:\"SEO (Default)\";s:4:\"slug\";s:3:\"seo\";s:6:\"parent\";s:0:\"\";s:5:\"title\";s:27:\"Aumentar o tráfego do site\";s:11:\"description\";s:76:\"Certifique-se de que o seu novo site está optimizado para motores de busca.\";s:4:\"icon\";s:8:\"BarChart\";s:7:\"plugins\";a:1:{i:0;a:4:{s:2:\"id\";s:17:\"reciRW83M63UbCMqp\";s:4:\"name\";s:14:\"All in One SEO\";s:13:\"wordpressSlug\";s:19:\"all-in-one-seo-pack\";s:7:\"heading\";s:3:\"SEO\";}}}i:1;a:8:{s:2:\"id\";s:17:\"reclGeahXJM1wAksf\";s:4:\"name\";s:18:\"SERVICES (Default)\";s:4:\"slug\";s:8:\"services\";s:6:\"parent\";s:0:\"\";s:5:\"title\";s:16:\"Vender serviços\";s:11:\"description\";s:58:\"Permita que os clientes reservem os seus serviços online.\";s:4:\"icon\";s:6:\"Design\";s:7:\"plugins\";a:1:{i:0;a:4:{s:2:\"id\";s:17:\"recU1hAv8zbrqOu37\";s:4:\"name\";s:11:\"WooCommerce\";s:13:\"wordpressSlug\";s:11:\"woocommerce\";s:7:\"heading\";s:9:\"eCommerce\";}}}}s:9:\"variation\";a:5:{s:5:\"title\";s:8:\"Santa Fe\";s:7:\"version\";i:3;s:8:\"settings\";a:2:{s:5:\"color\";a:2:{s:7:\"duotone\";a:1:{s:5:\"theme\";a:5:{i:0;a:3:{s:6:\"colors\";a:2:{i:0;s:7:\"#111111\";i:1;s:7:\"#ffffff\";}s:4:\"slug\";s:25:\"foreground-and-background\";s:4:\"name\";s:25:\"Foreground and background\";}i:1;a:3:{s:6:\"colors\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#1f033b\";}s:4:\"slug\";s:22:\"background-and-primary\";s:4:\"name\";s:22:\"Background and primary\";}i:2;a:3:{s:6:\"colors\";a:2:{i:0;s:7:\"#1f033b\";i:1;s:7:\"#d5dce3\";}s:4:\"slug\";s:21:\"primary-and-secondary\";s:4:\"name\";s:21:\"Primary and secondary\";}i:3;a:3:{s:6:\"colors\";a:2:{i:0;s:7:\"#1f033b\";i:1;s:7:\"#f0ede4\";}s:4:\"slug\";s:20:\"primary-and-tertiary\";s:4:\"name\";s:20:\"Primary and tertiary\";}i:4;a:3:{s:6:\"colors\";a:2:{i:0;s:7:\"#1f033b\";i:1;s:7:\"#111111\";}s:4:\"slug\";s:18:\"primary-foreground\";s:4:\"name\";s:22:\"Primary and Foreground\";}}}s:7:\"palette\";a:1:{s:5:\"theme\";a:5:{i:0;a:3:{s:4:\"slug\";s:10:\"foreground\";s:5:\"color\";s:7:\"#111111\";s:4:\"name\";s:10:\"Foreground\";}i:1;a:3:{s:4:\"slug\";s:10:\"background\";s:5:\"color\";s:7:\"#ffffff\";s:4:\"name\";s:10:\"Background\";}i:2;a:3:{s:4:\"slug\";s:7:\"primary\";s:5:\"color\";s:7:\"#2c0453\";s:4:\"name\";s:7:\"Primary\";}i:3;a:3:{s:4:\"slug\";s:9:\"secondary\";s:5:\"color\";s:7:\"#d5dce3\";s:4:\"name\";s:9:\"Secondary\";}i:4;a:3:{s:4:\"slug\";s:8:\"tertiary\";s:5:\"color\";s:7:\"#f0ede4\";s:4:\"name\";s:8:\"Tertiary\";}}}}s:6:\"custom\";a:1:{s:10:\"typography\";a:1:{s:13:\"fontSmoothing\";a:2:{s:3:\"moz\";s:4:\"auto\";s:6:\"webkit\";s:4:\"auto\";}}}}s:6:\"styles\";a:3:{s:6:\"blocks\";a:3:{s:14:\"core/pullquote\";a:1:{s:6:\"border\";a:2:{s:5:\"color\";s:33:\"var(--wp--preset--color--primary)\";s:5:\"width\";s:5:\"2px 0\";}}s:10:\"core/quote\";a:1:{s:6:\"border\";a:1:{s:5:\"width\";s:9:\"0 0 0 2px\";}}s:15:\"core/site-title\";a:1:{s:10:\"typography\";a:2:{s:10:\"fontWeight\";s:50:\"var(--wp--custom--typography--font-weight--medium)\";s:13:\"letterSpacing\";s:7:\"-0.02em\";}}}s:8:\"elements\";a:6:{s:2:\"h1\";a:1:{s:10:\"typography\";a:2:{s:10:\"fontWeight\";s:50:\"var(--wp--custom--typography--font-weight--medium)\";s:13:\"letterSpacing\";s:0:\"\";}}s:2:\"h2\";a:1:{s:10:\"typography\";a:2:{s:10:\"fontWeight\";s:50:\"var(--wp--custom--typography--font-weight--medium)\";s:13:\"letterSpacing\";s:7:\"-0.01em\";}}s:2:\"h3\";a:1:{s:10:\"typography\";a:1:{s:10:\"fontWeight\";s:50:\"var(--wp--custom--typography--font-weight--medium)\";}}s:2:\"h4\";a:1:{s:10:\"typography\";a:1:{s:10:\"fontWeight\";s:50:\"var(--wp--custom--typography--font-weight--medium)\";}}s:2:\"h6\";a:1:{s:10:\"typography\";a:1:{s:10:\"fontWeight\";s:48:\"var(--wp--custom--typography--font-weight--bold)\";}}s:7:\"heading\";a:1:{s:10:\"typography\";a:1:{s:10:\"fontFamily\";s:50:\"var(--wp--preset--font-family--noto-serif-display)\";}}}s:10:\"typography\";a:1:{s:10:\"fontFamily\";s:44:\"var(--wp--preset--font-family--radio-canada)\";}}s:4:\"slug\";s:8:\"santa-fe\";}}s:7:\"version\";i:0;}", "auto");
INSERT INTO `wp_options` VALUES("179", "extendify_site_profile", "a:3:{s:10:\"aiSiteType\";s:26:\"Dance Performance Services\";s:13:\"aiDescription\";s:539:\"Fernando y Carolina Tango Argentino offers captivating Tango performances for weddings, corporate events, and more. Specializing in blending traditional Argentine Tango with modern styles and acrobatics, this professional dance duo creates unforgettable moments with tailored shows. Their performances are perfect for various events, delivering high-energy and visually stunning spectacles. Visitors can explore their services, watch show videos, and book their unique Tango entertainment that combines tradition, innovation, and artistry.\";s:10:\"aiKeywords\";a:5:{i:0;s:11:\"Tango dance\";i:1;s:15:\"Argentine Tango\";i:2;s:17:\"dance performance\";i:3;s:21:\"wedding entertainment\";i:4;s:16:\"corporate events\";}}", "auto");
INSERT INTO `wp_options` VALUES("185", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("186", "extendify_siteType", "a:2:{s:4:\"slug\";s:8:\"0default\";s:4:\"name\";s:26:\"Dance Performance Services\";}", "auto");
INSERT INTO `wp_options` VALUES("189", "action_scheduler_hybrid_store_demarkation", "11", "auto");
INSERT INTO `wp_options` VALUES("190", "schema-ActionScheduler_StoreSchema", "7.0.1735061343", "auto");
INSERT INTO `wp_options` VALUES("191", "schema-ActionScheduler_LoggerSchema", "3.0.1735061343", "auto");
INSERT INTO `wp_options` VALUES("192", "aioseo_options_internal", "{\"internal\":{\"validLicenseKey\":null,\"lastActiveVersion\":\"4.7.7\",\"migratedVersion\":null,\"siteAnalysis\":{\"connectToken\":null,\"score\":0,\"results\":\"\",\"competitors\":[]},\"headlineAnalysis\":{\"headlines\":[]},\"wizard\":null,\"category\":null,\"categoryOther\":null,\"deprecatedOptions\":[],\"searchStatistics\":{\"profile\":[],\"trustToken\":null,\"rolling\":\"last28Days\",\"site\":{\"verified\":false,\"lastFetch\":0},\"sitemap\":{\"list\":[],\"ignored\":[],\"lastFetch\":0}}},\"integrations\":{\"semrush\":{\"accessToken\":null,\"tokenType\":null,\"expires\":null,\"refreshToken\":null}},\"database\":{\"installedTables\":\"{\\\"wp_aioseo_posts\\\":[\\\"id\\\",\\\"post_id\\\",\\\"title\\\",\\\"description\\\",\\\"keywords\\\",\\\"keyphrases\\\",\\\"page_analysis\\\",\\\"primary_term\\\",\\\"canonical_url\\\",\\\"og_title\\\",\\\"og_description\\\",\\\"og_object_type\\\",\\\"og_image_type\\\",\\\"og_image_url\\\",\\\"og_image_width\\\",\\\"og_image_height\\\",\\\"og_image_custom_url\\\",\\\"og_image_custom_fields\\\",\\\"og_video\\\",\\\"og_custom_url\\\",\\\"og_article_section\\\",\\\"og_article_tags\\\",\\\"twitter_use_og\\\",\\\"twitter_card\\\",\\\"twitter_image_type\\\",\\\"twitter_image_url\\\",\\\"twitter_image_custom_url\\\",\\\"twitter_image_custom_fields\\\",\\\"twitter_title\\\",\\\"twitter_description\\\",\\\"seo_score\\\",\\\"schema\\\",\\\"schema_type\\\",\\\"schema_type_options\\\",\\\"pillar_content\\\",\\\"robots_default\\\",\\\"robots_noindex\\\",\\\"robots_noarchive\\\",\\\"robots_nosnippet\\\",\\\"robots_nofollow\\\",\\\"robots_noimageindex\\\",\\\"robots_noodp\\\",\\\"robots_notranslate\\\",\\\"robots_max_snippet\\\",\\\"robots_max_videopreview\\\",\\\"robots_max_imagepreview\\\",\\\"images\\\",\\\"image_scan_date\\\",\\\"priority\\\",\\\"frequency\\\",\\\"videos\\\",\\\"video_thumbnail\\\",\\\"video_scan_date\\\",\\\"local_seo\\\",\\\"limit_modified_date\\\",\\\"options\\\",\\\"created\\\",\\\"updated\\\"],\\\"wp_actionscheduler_actions\\\":[],\\\"wp_actionscheduler_logs\\\":[],\\\"wp_actionscheduler_groups\\\":[],\\\"wp_actionscheduler_claims\\\":[],\\\"wp_aioseo_notifications\\\":[]}\"}}", "auto");
INSERT INTO `wp_options` VALUES("193", "aioseo_options_internal_lite", "{\"internal\":{\"activated\":1735061343,\"firstActivated\":1735061343,\"installed\":0,\"connect\":{\"key\":null,\"time\":0,\"network\":false,\"token\":null}}}", "auto");
INSERT INTO `wp_options` VALUES("196", "aioseo_options_dynamic_localized", "a:4:{s:42:\"searchAppearance_taxonomies_category_title\";s:41:\"#taxonomy_title #separator_sa #site_title\";s:52:\"searchAppearance_taxonomies_category_metaDescription\";s:21:\"#taxonomy_description\";s:42:\"searchAppearance_taxonomies_post_tag_title\";s:41:\"#taxonomy_title #separator_sa #site_title\";s:52:\"searchAppearance_taxonomies_post_tag_metaDescription\";s:21:\"#taxonomy_description\";}", "auto");
INSERT INTO `wp_options` VALUES("199", "aioseo_dynamic_settings_backup", "{}", "auto");
INSERT INTO `wp_options` VALUES("200", "aioseo_options", "{\"internal\":[],\"webmasterTools\":{\"google\":null,\"bing\":null,\"yandex\":null,\"baidu\":null,\"pinterest\":null,\"microsoftClarityProjectId\":null,\"norton\":null,\"miscellaneousVerification\":null},\"breadcrumbs\":{\"separator\":\"&raquo;\",\"homepageLink\":true,\"homepageLabel\":\"Home\",\"breadcrumbPrefix\":\"\",\"archiveFormat\":\"Archives for #breadcrumb_archive_post_type_name\",\"searchResultFormat\":\"Search Results for \'#breadcrumb_search_string\'\",\"errorFormat404\":\"404 - Page Not Found\",\"showCurrentItem\":true,\"linkCurrentItem\":false,\"categoryFullHierarchy\":false,\"showBlogHome\":false},\"rssContent\":{\"before\":null,\"after\":\"&lt;p&gt;The post #post_link first appeared on #site_link.&lt;\\/p&gt;\"},\"advanced\":{\"truSeo\":true,\"headlineAnalyzer\":true,\"seoAnalysis\":true,\"dashboardWidgets\":[\"seoSetup\",\"seoOverview\",\"seoNews\"],\"announcements\":true,\"postTypes\":{\"all\":true,\"included\":[\"post\",\"page\",\"product\"]},\"taxonomies\":{\"all\":true,\"included\":[\"category\",\"post_tag\",\"product_cat\",\"product_tag\"]},\"uninstall\":false,\"emailSummary\":{\"enable\":false,\"recipients\":[{\"email\":\"fernandoycarolinatango@gmail.com\",\"frequency\":\"monthly\"}]}},\"sitemap\":{\"general\":{\"enable\":true,\"filename\":\"sitemap\",\"indexes\":true,\"linksPerIndex\":1000,\"postTypes\":{\"all\":true,\"included\":[\"post\",\"page\",\"attachment\",\"product\"]},\"taxonomies\":{\"all\":true,\"included\":[\"category\",\"post_tag\",\"product_cat\",\"product_tag\"]},\"author\":false,\"date\":false,\"additionalPages\":{\"enable\":false,\"pages\":[]},\"advancedSettings\":{\"enable\":false,\"excludeImages\":false,\"excludePosts\":[],\"excludeTerms\":[],\"priority\":{\"homePage\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"postTypes\":{\"grouped\":true,\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"taxonomies\":{\"grouped\":true,\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"archive\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"author\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"}}}},\"rss\":{\"enable\":true,\"linksPerIndex\":50,\"postTypes\":{\"all\":true,\"included\":[\"post\",\"page\",\"product\"]}},\"html\":{\"enable\":true,\"pageUrl\":\"\",\"postTypes\":{\"all\":true,\"included\":[\"post\",\"page\",\"product\"]},\"taxonomies\":{\"all\":true,\"included\":[\"category\",\"post_tag\",\"product_cat\",\"product_tag\"]},\"sortOrder\":\"publish_date\",\"sortDirection\":\"asc\",\"publicationDate\":true,\"compactArchives\":false,\"advancedSettings\":{\"enable\":false,\"nofollowLinks\":false,\"excludePosts\":[],\"excludeTerms\":[]}}},\"social\":{\"profiles\":{\"sameUsername\":{\"enable\":false,\"username\":null,\"included\":[\"facebookPageUrl\",\"twitterUrl\",\"tiktokUrl\",\"pinterestUrl\",\"instagramUrl\",\"youtubeUrl\",\"linkedinUrl\"]},\"urls\":{\"facebookPageUrl\":null,\"twitterUrl\":null,\"instagramUrl\":null,\"tiktokUrl\":null,\"pinterestUrl\":null,\"youtubeUrl\":null,\"linkedinUrl\":null,\"tumblrUrl\":null,\"yelpPageUrl\":null,\"soundCloudUrl\":null,\"wikipediaUrl\":null,\"myspaceUrl\":null,\"googlePlacesUrl\":null,\"wordPressUrl\":null},\"additionalUrls\":null},\"facebook\":{\"general\":{\"enable\":true,\"defaultImageSourcePosts\":\"default\",\"customFieldImagePosts\":null,\"defaultImagePosts\":\"\",\"defaultImagePostsWidth\":\"\",\"defaultImagePostsHeight\":\"\",\"showAuthor\":true,\"siteName\":\"#site_title #separator_sa #tagline\"},\"homePage\":{\"image\":\"\",\"title\":\"\",\"description\":\"\",\"imageWidth\":\"\",\"imageHeight\":\"\",\"objectType\":\"website\"},\"advanced\":{\"enable\":false,\"adminId\":\"\",\"appId\":\"\",\"authorUrl\":\"\",\"generateArticleTags\":false,\"useKeywordsInTags\":true,\"useCategoriesInTags\":true,\"usePostTagsInTags\":true}},\"twitter\":{\"general\":{\"enable\":true,\"useOgData\":false,\"defaultCardType\":\"summary_large_image\",\"defaultImageSourcePosts\":\"default\",\"customFieldImagePosts\":null,\"defaultImagePosts\":\"\",\"showAuthor\":true,\"additionalData\":false},\"homePage\":{\"image\":\"\",\"title\":\"\",\"description\":\"\",\"cardType\":\"summary\"}}},\"searchAppearance\":{\"global\":{\"separator\":\"&#45;\",\"siteTitle\":\"#site_title #separator_sa #tagline\",\"metaDescription\":\"#tagline\",\"keywords\":null,\"schema\":{\"websiteName\":\"#site_title\",\"websiteAlternateName\":null,\"siteRepresents\":\"organization\",\"person\":null,\"organizationName\":\"#site_title\",\"organizationDescription\":\"#tagline\",\"organizationLogo\":\"\",\"personName\":null,\"personLogo\":null,\"phone\":null,\"email\":null,\"foundingDate\":null,\"numberOfEmployees\":{\"isRange\":null,\"from\":null,\"to\":null,\"number\":null}}},\"advanced\":{\"globalRobotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noindexPaginated\":true,\"nofollowPaginated\":true,\"noindexFeed\":true,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"sitelinks\":true,\"noIndexEmptyCat\":true,\"removeStopWords\":false,\"useKeywords\":false,\"keywordsLooking\":true,\"useCategoriesForMetaKeywords\":false,\"useTagsForMetaKeywords\":false,\"dynamicallyGenerateKeywords\":false,\"pagedFormat\":\"#separator_sa Page #page_number\",\"runShortcodes\":false,\"crawlCleanup\":{\"enable\":false,\"feeds\":{\"global\":true,\"globalComments\":false,\"staticBlogPage\":true,\"authors\":true,\"postComments\":false,\"search\":false,\"attachments\":false,\"archives\":{\"all\":false,\"included\":[]},\"taxonomies\":{\"all\":false,\"included\":[\"category\"]},\"atom\":false,\"rdf\":false,\"paginated\":false}},\"blockArgs\":{\"enable\":false,\"logsRetention\":\"{\\\"label\\\":\\\"1 week\\\",\\\"value\\\":\\\"week\\\"}\"},\"removeCategoryBase\":false},\"archives\":{\"author\":{\"show\":true,\"title\":\"#author_name #separator_sa #site_title\",\"metaDescription\":\"#author_bio\",\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true,\"keywords\":null}},\"date\":{\"show\":true,\"title\":\"#archive_date #separator_sa #site_title\",\"metaDescription\":\"\",\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true,\"keywords\":null}},\"search\":{\"show\":false,\"title\":\"#search_term #separator_sa #site_title\",\"metaDescription\":\"\",\"advanced\":{\"robotsMeta\":{\"default\":false,\"noindex\":true,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true,\"keywords\":null}}}},\"searchStatistics\":{\"postTypes\":{\"all\":true,\"included\":[\"post\",\"page\"]}},\"tools\":{\"robots\":{\"enable\":false,\"rules\":[],\"robotsDetected\":true},\"importExport\":{\"backup\":{\"lastTime\":null,\"data\":null}}},\"deprecated\":{\"breadcrumbs\":{\"enable\":true},\"searchAppearance\":{\"global\":{\"descriptionFormat\":null,\"schema\":{\"enableSchemaMarkup\":true}},\"advanced\":{\"autogenerateDescriptions\":true,\"runShortcodesInDescription\":true,\"useContentForAutogeneratedDescriptions\":false,\"excludePosts\":[],\"excludeTerms\":[],\"noPaginationForCanonical\":true}},\"sitemap\":{\"general\":{\"advancedSettings\":{\"dynamic\":true}}},\"tools\":{\"blocker\":{\"blockBots\":null,\"blockReferer\":null,\"track\":null,\"custom\":{\"enable\":null,\"bots\":\"Abonti\\naggregator\\nAhrefsBot\\nasterias\\nBDCbot\\nBLEXBot\\nBuiltBotTough\\nBullseye\\nBunnySlippers\\nca-crawler\\nCCBot\\nCegbfeieh\\nCheeseBot\\nCherryPicker\\nCopyRightCheck\\ncosmos\\nCrescent\\ndiscobot\\nDittoSpyder\\nDotBot\\nDownload Ninja\\nEasouSpider\\nEmailCollector\\nEmailSiphon\\nEmailWolf\\nEroCrawler\\nExtractorPro\\nFasterfox\\nFeedBooster\\nFoobot\\nGenieo\\ngrub-client\\nHarvest\\nhloader\\nhttplib\\nHTTrack\\nhumanlinks\\nieautodiscovery\\nInfoNaviRobot\\nIstellaBot\\nJava\\/1.\\nJennyBot\\nk2spider\\nKenjin Spider\\nKeyword Density\\/0.9\\nlarbin\\nLexiBot\\nlibWeb\\nlibwww\\nLinkextractorPro\\nlinko\\nLinkScan\\/8.1a Unix\\nLinkWalker\\nLNSpiderguy\\nlwp-trivial\\nmagpie\\nMata Hari\\nMaxPointCrawler\\nMegaIndex\\nMicrosoft URL Control\\nMIIxpc\\nMippin\\nMissigua Locator\\nMister PiX\\nMJ12bot\\nmoget\\nMSIECrawler\\nNetAnts\\nNICErsPRO\\nNiki-Bot\\nNPBot\\nNutch\\nOffline Explorer\\nOpenfind\\npanscient.com\\nPHP\\/5.{\\nProPowerBot\\/2.14\\nProWebWalker\\nPython-urllib\\nQueryN Metasearch\\nRepoMonkey\\nSISTRIX\\nsitecheck.Internetseer.com\\nSiteSnagger\\nSnapPreviewBot\\nSogou\\nSpankBot\\nspanner\\nspbot\\nSpinn3r\\nsuzuran\\nSzukacz\\/1.4\\nTeleport\\nTelesoft\\nThe Intraformant\\nTheNomad\\nTightTwatBot\\nTitan\\ntoCrawl\\/UrlDispatcher\\nTrue_Robot\\nturingos\\nTurnitinBot\\nUbiCrawler\\nUnisterBot\\nURLy Warning\\nVCI\\nWBSearchBot\\nWeb Downloader\\/6.9\\nWeb Image Collector\\nWebAuto\\nWebBandit\\nWebCopier\\nWebEnhancer\\nWebmasterWorldForumBot\\nWebReaper\\nWebSauger\\nWebsite Quester\\nWebster Pro\\nWebStripper\\nWebZip\\nWotbox\\nwsr-agent\\nWWW-Collector-E\\nXenu\\nZao\\nZeus\\nZyBORG\\ncoccoc\\nIncutio\\nlmspider\\nmemoryBot\\nserf\\nUnknown\\nuptime files\",\"referer\":\"semalt.com\\nkambasoft.com\\nsavetubevideo.com\\nbuttons-for-website.com\\nsharebutton.net\\nsoundfrost.org\\nsrecorder.com\\nsoftomix.com\\nsoftomix.net\\nmyprintscreen.com\\njoinandplay.me\\nfbfreegifts.com\\nopenmediasoft.com\\nzazagames.org\\nextener.org\\nopenfrost.com\\nopenfrost.net\\ngooglsucks.com\\nbest-seo-offer.com\\nbuttons-for-your-website.com\\nwww.Get-Free-Traffic-Now.com\\nbest-seo-solution.com\\nbuy-cheap-online.info\\nsite3.free-share-buttons.com\\nwebmaster-traffic.com\"}}}},\"writingAssistant\":{\"postTypes\":{\"all\":true,\"included\":[\"post\",\"page\"]}}}", "auto");
INSERT INTO `wp_options` VALUES("201", "aioseo_options_lite", "{\"advanced\":{\"usageTracking\":false}}", "auto");
INSERT INTO `wp_options` VALUES("202", "aioseo_options_dynamic", "{\"sitemap\":{\"priority\":{\"postTypes\":{\"post\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"page\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"attachment\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"}},\"taxonomies\":{\"category\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"},\"post_tag\":{\"priority\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\",\"frequency\":\"{\\\"label\\\":\\\"default\\\",\\\"value\\\":\\\"default\\\"}\"}}}},\"social\":{\"facebook\":{\"general\":{\"postTypes\":{\"post\":{\"objectType\":\"article\"},\"page\":{\"objectType\":\"article\"},\"attachment\":{\"objectType\":\"article\"}}}}},\"searchAppearance\":{\"postTypes\":{\"post\":{\"show\":true,\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true,\"bulkEditing\":\"enabled\"},\"title\":\"#post_title #separator_sa #site_title\",\"metaDescription\":\"#post_excerpt\",\"schemaType\":\"Article\",\"webPageType\":\"WebPage\",\"articleType\":\"BlogPosting\",\"customFields\":null},\"page\":{\"show\":true,\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true,\"bulkEditing\":\"enabled\"},\"title\":\"#post_title #separator_sa #site_title\",\"metaDescription\":\"#post_content\",\"schemaType\":\"WebPage\",\"webPageType\":\"WebPage\",\"articleType\":\"BlogPosting\",\"customFields\":null},\"attachment\":{\"show\":true,\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true,\"bulkEditing\":\"enabled\"},\"title\":\"#post_title #separator_sa #site_title\",\"metaDescription\":\"#attachment_caption\",\"schemaType\":\"ItemPage\",\"webPageType\":\"ItemPage\",\"articleType\":\"BlogPosting\",\"customFields\":null,\"redirectAttachmentUrls\":\"attachment\"}},\"taxonomies\":{\"category\":{\"show\":true,\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true},\"title\":\"#taxonomy_title #separator_sa #site_title\",\"metaDescription\":\"#taxonomy_description\"},\"post_tag\":{\"show\":true,\"advanced\":{\"robotsMeta\":{\"default\":true,\"noindex\":false,\"nofollow\":false,\"noarchive\":false,\"noimageindex\":false,\"notranslate\":false,\"nosnippet\":false,\"noodp\":false,\"maxSnippet\":-1,\"maxVideoPreview\":-1,\"maxImagePreview\":\"large\"},\"showDateInGooglePreview\":true,\"showPostThumbnailInSearch\":true,\"showMetaBox\":true},\"title\":\"#taxonomy_title #separator_sa #site_title\",\"metaDescription\":\"#taxonomy_description\"}},\"archives\":[]}}", "auto");
INSERT INTO `wp_options` VALUES("208", "woocommerce_newly_installed", "no", "auto");
INSERT INTO `wp_options` VALUES("209", "woocommerce_schema_version", "920", "auto");
INSERT INTO `wp_options` VALUES("210", "woocommerce_store_address", "", "on");
INSERT INTO `wp_options` VALUES("211", "woocommerce_store_address_2", "", "on");
INSERT INTO `wp_options` VALUES("212", "woocommerce_store_city", "", "on");
INSERT INTO `wp_options` VALUES("213", "woocommerce_default_country", "US:CA", "on");
INSERT INTO `wp_options` VALUES("214", "woocommerce_store_postcode", "", "on");
INSERT INTO `wp_options` VALUES("215", "woocommerce_allowed_countries", "all", "on");
INSERT INTO `wp_options` VALUES("216", "woocommerce_all_except_countries", "", "on");
INSERT INTO `wp_options` VALUES("217", "woocommerce_specific_allowed_countries", "", "on");
INSERT INTO `wp_options` VALUES("218", "woocommerce_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("219", "woocommerce_specific_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("220", "woocommerce_default_customer_address", "base", "on");
INSERT INTO `wp_options` VALUES("221", "woocommerce_calc_taxes", "no", "on");
INSERT INTO `wp_options` VALUES("222", "woocommerce_enable_coupons", "yes", "on");
INSERT INTO `wp_options` VALUES("223", "woocommerce_calc_discounts_sequentially", "no", "off");
INSERT INTO `wp_options` VALUES("224", "woocommerce_currency", "USD", "on");
INSERT INTO `wp_options` VALUES("225", "woocommerce_currency_pos", "left", "on");
INSERT INTO `wp_options` VALUES("226", "woocommerce_price_thousand_sep", ",", "on");
INSERT INTO `wp_options` VALUES("227", "woocommerce_price_decimal_sep", ".", "on");
INSERT INTO `wp_options` VALUES("228", "woocommerce_price_num_decimals", "2", "on");
INSERT INTO `wp_options` VALUES("229", "woocommerce_shop_page_id", "12", "on");
INSERT INTO `wp_options` VALUES("230", "woocommerce_cart_redirect_after_add", "no", "on");
INSERT INTO `wp_options` VALUES("231", "woocommerce_enable_ajax_add_to_cart", "yes", "on");
INSERT INTO `wp_options` VALUES("232", "woocommerce_placeholder_image", "11", "on");
INSERT INTO `wp_options` VALUES("233", "woocommerce_weight_unit", "kg", "on");
INSERT INTO `wp_options` VALUES("234", "woocommerce_dimension_unit", "cm", "on");
INSERT INTO `wp_options` VALUES("235", "woocommerce_enable_reviews", "yes", "on");
INSERT INTO `wp_options` VALUES("236", "woocommerce_review_rating_verification_label", "yes", "off");
INSERT INTO `wp_options` VALUES("237", "woocommerce_review_rating_verification_required", "no", "off");
INSERT INTO `wp_options` VALUES("238", "woocommerce_enable_review_rating", "yes", "on");
INSERT INTO `wp_options` VALUES("239", "woocommerce_review_rating_required", "yes", "off");
INSERT INTO `wp_options` VALUES("240", "woocommerce_manage_stock", "yes", "on");
INSERT INTO `wp_options` VALUES("241", "woocommerce_hold_stock_minutes", "60", "off");
INSERT INTO `wp_options` VALUES("242", "woocommerce_notify_low_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("243", "woocommerce_notify_no_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("244", "woocommerce_stock_email_recipient", "fernandoycarolinatango@gmail.com", "off");
INSERT INTO `wp_options` VALUES("245", "woocommerce_notify_low_stock_amount", "2", "off");
INSERT INTO `wp_options` VALUES("246", "woocommerce_notify_no_stock_amount", "0", "on");
INSERT INTO `wp_options` VALUES("247", "woocommerce_hide_out_of_stock_items", "no", "on");
INSERT INTO `wp_options` VALUES("248", "woocommerce_stock_format", "", "on");
INSERT INTO `wp_options` VALUES("249", "woocommerce_file_download_method", "force", "off");
INSERT INTO `wp_options` VALUES("250", "woocommerce_downloads_redirect_fallback_allowed", "no", "off");
INSERT INTO `wp_options` VALUES("251", "woocommerce_downloads_require_login", "no", "off");
INSERT INTO `wp_options` VALUES("252", "woocommerce_downloads_grant_access_after_payment", "yes", "off");
INSERT INTO `wp_options` VALUES("253", "woocommerce_downloads_deliver_inline", "", "off");
INSERT INTO `wp_options` VALUES("254", "woocommerce_downloads_add_hash_to_filename", "yes", "on");
INSERT INTO `wp_options` VALUES("255", "woocommerce_downloads_count_partial", "yes", "on");
INSERT INTO `wp_options` VALUES("257", "woocommerce_attribute_lookup_direct_updates", "no", "on");
INSERT INTO `wp_options` VALUES("258", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `wp_options` VALUES("259", "woocommerce_product_match_featured_image_by_sku", "no", "on");
INSERT INTO `wp_options` VALUES("260", "woocommerce_prices_include_tax", "no", "on");
INSERT INTO `wp_options` VALUES("261", "woocommerce_tax_based_on", "shipping", "on");
INSERT INTO `wp_options` VALUES("262", "woocommerce_shipping_tax_class", "inherit", "on");
INSERT INTO `wp_options` VALUES("263", "woocommerce_tax_round_at_subtotal", "no", "on");
INSERT INTO `wp_options` VALUES("264", "woocommerce_tax_classes", "", "on");
INSERT INTO `wp_options` VALUES("265", "woocommerce_tax_display_shop", "excl", "on");
INSERT INTO `wp_options` VALUES("266", "woocommerce_tax_display_cart", "excl", "on");
INSERT INTO `wp_options` VALUES("267", "woocommerce_price_display_suffix", "", "on");
INSERT INTO `wp_options` VALUES("268", "woocommerce_tax_total_display", "itemized", "off");
INSERT INTO `wp_options` VALUES("269", "woocommerce_enable_shipping_calc", "yes", "off");
INSERT INTO `wp_options` VALUES("270", "woocommerce_shipping_cost_requires_address", "no", "on");
INSERT INTO `wp_options` VALUES("271", "woocommerce_ship_to_destination", "billing", "off");
INSERT INTO `wp_options` VALUES("272", "woocommerce_shipping_debug_mode", "no", "on");
INSERT INTO `wp_options` VALUES("273", "woocommerce_enable_guest_checkout", "yes", "off");
INSERT INTO `wp_options` VALUES("274", "woocommerce_enable_checkout_login_reminder", "no", "off");
INSERT INTO `wp_options` VALUES("275", "woocommerce_enable_signup_and_login_from_checkout", "no", "off");
INSERT INTO `wp_options` VALUES("276", "woocommerce_enable_delayed_account_creation", "no", "off");
INSERT INTO `wp_options` VALUES("277", "woocommerce_enable_myaccount_registration", "no", "off");
INSERT INTO `wp_options` VALUES("278", "woocommerce_registration_generate_password", "yes", "off");
INSERT INTO `wp_options` VALUES("279", "woocommerce_registration_generate_username", "yes", "off");
INSERT INTO `wp_options` VALUES("280", "woocommerce_erasure_request_removes_order_data", "no", "off");
INSERT INTO `wp_options` VALUES("281", "woocommerce_erasure_request_removes_download_data", "no", "off");
INSERT INTO `wp_options` VALUES("282", "woocommerce_allow_bulk_remove_personal_data", "no", "off");
INSERT INTO `wp_options` VALUES("283", "woocommerce_registration_privacy_policy_text", "Os seus dados pessoais serão utilizados para melhorar a sua experiência por toda a loja, para gerir o acesso à sua conta e para os propósitos descritos na nossa [privacy_policy].", "on");
INSERT INTO `wp_options` VALUES("284", "woocommerce_checkout_privacy_policy_text", "Os seus dados pessoais serão utilizados para processar a sua encomenda, para melhorar a sua experiência em toda a loja e para os propósitos descritos na nossa [privacy_policy].", "on");
INSERT INTO `wp_options` VALUES("285", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("286", "woocommerce_trash_pending_orders", "", "off");
INSERT INTO `wp_options` VALUES("287", "woocommerce_trash_failed_orders", "", "off");
INSERT INTO `wp_options` VALUES("288", "woocommerce_trash_cancelled_orders", "", "off");
INSERT INTO `wp_options` VALUES("289", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("290", "woocommerce_email_from_name", "Fernando y Carolina Tango Argentino", "off");
INSERT INTO `wp_options` VALUES("291", "woocommerce_email_from_address", "fernandoycarolinatango@gmail.com", "off");
INSERT INTO `wp_options` VALUES("292", "woocommerce_email_header_image", "", "off");
INSERT INTO `wp_options` VALUES("293", "woocommerce_email_base_color", "#7f54b3", "off");
INSERT INTO `wp_options` VALUES("294", "woocommerce_email_background_color", "#f7f7f7", "off");
INSERT INTO `wp_options` VALUES("295", "woocommerce_email_body_background_color", "#ffffff", "off");
INSERT INTO `wp_options` VALUES("296", "woocommerce_email_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("297", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "off");
INSERT INTO `wp_options` VALUES("298", "woocommerce_email_footer_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("299", "woocommerce_merchant_email_notifications", "no", "off");
INSERT INTO `wp_options` VALUES("300", "woocommerce_cart_page_id", "13", "off");
INSERT INTO `wp_options` VALUES("301", "woocommerce_checkout_page_id", "14", "off");
INSERT INTO `wp_options` VALUES("302", "woocommerce_myaccount_page_id", "15", "off");
INSERT INTO `wp_options` VALUES("303", "woocommerce_terms_page_id", "", "off");
INSERT INTO `wp_options` VALUES("304", "woocommerce_checkout_pay_endpoint", "order-pay", "on");
INSERT INTO `wp_options` VALUES("305", "woocommerce_checkout_order_received_endpoint", "order-received", "on");
INSERT INTO `wp_options` VALUES("306", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "on");
INSERT INTO `wp_options` VALUES("307", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "on");
INSERT INTO `wp_options` VALUES("308", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "on");
INSERT INTO `wp_options` VALUES("309", "woocommerce_myaccount_orders_endpoint", "orders", "on");
INSERT INTO `wp_options` VALUES("310", "woocommerce_myaccount_view_order_endpoint", "view-order", "on");
INSERT INTO `wp_options` VALUES("311", "woocommerce_myaccount_downloads_endpoint", "downloads", "on");
INSERT INTO `wp_options` VALUES("312", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "on");
INSERT INTO `wp_options` VALUES("313", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "on");
INSERT INTO `wp_options` VALUES("314", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "on");
INSERT INTO `wp_options` VALUES("315", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "on");
INSERT INTO `wp_options` VALUES("316", "woocommerce_logout_endpoint", "customer-logout", "on");
INSERT INTO `wp_options` VALUES("317", "woocommerce_api_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("318", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("319", "woocommerce_show_marketplace_suggestions", "yes", "off");
INSERT INTO `wp_options` VALUES("320", "woocommerce_custom_orders_table_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("321", "woocommerce_analytics_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("322", "woocommerce_feature_order_attribution_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("323", "woocommerce_feature_site_visibility_badge_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("324", "woocommerce_feature_product_block_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("325", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("326", "woocommerce_feature_cost_of_goods_sold_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("327", "woocommerce_single_image_width", "600", "on");
INSERT INTO `wp_options` VALUES("328", "woocommerce_thumbnail_image_width", "300", "on");
INSERT INTO `wp_options` VALUES("329", "woocommerce_checkout_highlight_required_fields", "yes", "on");
INSERT INTO `wp_options` VALUES("330", "woocommerce_demo_store", "no", "off");
INSERT INTO `wp_options` VALUES("331", "wc_downloads_approved_directories_mode", "enabled", "auto");
INSERT INTO `wp_options` VALUES("332", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"produto\";s:13:\"category_base\";s:17:\"categoria-produto\";s:8:\"tag_base\";s:16:\"produto-etiqueta\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("333", "current_theme_supports_woocommerce", "yes", "auto");
INSERT INTO `wp_options` VALUES("334", "woocommerce_queue_flush_rewrite_rules", "no", "auto");
INSERT INTO `wp_options` VALUES("335", "_transient_wc_attribute_taxonomies", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("339", "default_product_cat", "18", "auto");
INSERT INTO `wp_options` VALUES("342", "woocommerce_refund_returns_page_id", "16", "auto");
INSERT INTO `wp_options` VALUES("345", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:84:\"Pagar com PayPal; pode pagar com cartão de crédito se não tiver uma conta PayPal.\";s:5:\"email\";s:32:\"fernandoycarolinatango@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:32:\"fernandoycarolinatango@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "on");
INSERT INTO `wp_options` VALUES("346", "woocommerce_version", "9.5.1", "auto");
INSERT INTO `wp_options` VALUES("347", "woocommerce_db_version", "9.5.1", "auto");
INSERT INTO `wp_options` VALUES("348", "woocommerce_store_id", "118918b1-e6c2-4cde-840c-105718ff509a", "auto");
INSERT INTO `wp_options` VALUES("349", "woocommerce_admin_install_timestamp", "1735061357", "auto");
INSERT INTO `wp_options` VALUES("350", "woocommerce_inbox_variant_assignment", "11", "auto");
INSERT INTO `wp_options` VALUES("351", "woocommerce_remote_variant_assignment", "41", "auto");
INSERT INTO `wp_options` VALUES("352", "woocommerce_attribute_lookup_enabled", "no", "auto");
INSERT INTO `wp_options` VALUES("356", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "on");
INSERT INTO `wp_options` VALUES("357", "woocommerce_admin_notices", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("358", "action_scheduler_lock_async-request-runner", "6d73569e5c4219.23495939|1836275418", "auto");
INSERT INTO `wp_options` VALUES("359", "wc_blocks_version", "11.8.0-dev", "auto");
INSERT INTO `wp_options` VALUES("360", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"dT7OKfRROLAUzcrxEbAoSlo4O8BhOqsw\";}", "on");
INSERT INTO `wp_options` VALUES("361", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("362", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("363", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("364", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("365", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("366", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("367", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("368", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("369", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("370", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("371", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("372", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("373", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("382", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("383", "jetpack_options", "a:1:{s:14:\"last_heartbeat\";i:1836275358;}", "auto");
INSERT INTO `wp_options` VALUES("386", "woocommerce_hooked_blocks_version", "9.5.1", "auto");
INSERT INTO `wp_options` VALUES("387", "woocommerce_custom_orders_table_created", "yes", "auto");
INSERT INTO `wp_options` VALUES("388", "woocommerce_coming_soon", "no", "auto");
INSERT INTO `wp_options` VALUES("389", "woocommerce_initial_installed_version", "9.5.1", "off");
INSERT INTO `wp_options` VALUES("390", "wc_blocks_db_schema_version", "260", "auto");
INSERT INTO `wp_options` VALUES("393", "wpforms_settings", "a:9:{s:11:\"disable-css\";s:1:\"2\";s:13:\"global-assets\";b:0;s:18:\"hide-announcements\";b:0;s:14:\"hide-admin-bar\";b:0;s:14:\"uninstall-data\";b:0;s:22:\"usage-tracking-enabled\";b:0;s:23:\"email-summaries-disable\";b:1;s:13:\"modern-markup\";s:1:\"0\";s:20:\"modern-markup-is-set\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("394", "wpforms_version", "1.9.2.3", "auto");
INSERT INTO `wp_options` VALUES("395", "wpforms_version_lite", "1.9.2.3", "auto");
INSERT INTO `wp_options` VALUES("396", "wpforms_activated", "a:1:{s:4:\"lite\";i:1735061365;}", "auto");
INSERT INTO `wp_options` VALUES("402", "jetpack_connection_active_plugins", "a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:11:\"WooCommerce\";}}", "auto");
INSERT INTO `wp_options` VALUES("403", "widget_wpforms-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("405", "wpforms_versions_lite", "a:14:{s:5:\"1.5.9\";i:0;s:7:\"1.6.7.2\";i:0;s:5:\"1.6.8\";i:0;s:5:\"1.7.5\";i:0;s:7:\"1.7.5.1\";i:0;s:5:\"1.7.7\";i:0;s:5:\"1.8.2\";i:0;s:5:\"1.8.3\";i:0;s:5:\"1.8.4\";i:0;s:5:\"1.8.6\";i:0;s:5:\"1.8.7\";i:0;s:5:\"1.9.1\";i:0;s:5:\"1.9.2\";i:0;s:7:\"1.9.2.3\";i:1735061365;}", "auto");
INSERT INTO `wp_options` VALUES("407", "wpforms_forms_first_created", "1735061366", "off");
INSERT INTO `wp_options` VALUES("411", "wpforms_crypto_secret_key", "oDTpO4ZE8NpDKsNJIXQqsknEOTlqURH46vuNzRT85BY=", "auto");
INSERT INTO `wp_options` VALUES("412", "_transient_product_query-transient-version", "1752239051", "on");
INSERT INTO `wp_options` VALUES("450", "extendify_wc_import_results", "a:18:{i:0;a:3:{s:2:\"id\";i:23;s:3:\"sku\";s:13:\"woo-vneck-tee\";s:6:\"status\";s:7:\"success\";}i:1;a:3:{s:2:\"id\";i:27;s:3:\"sku\";s:10:\"woo-hoodie\";s:6:\"status\";s:7:\"success\";}i:2;a:3:{s:2:\"id\";i:32;s:3:\"sku\";s:20:\"woo-hoodie-with-logo\";s:6:\"status\";s:7:\"success\";}i:3;a:3:{s:2:\"id\";i:34;s:3:\"sku\";s:10:\"woo-tshirt\";s:6:\"status\";s:7:\"success\";}i:4;a:3:{s:2:\"id\";i:36;s:3:\"sku\";s:10:\"woo-beanie\";s:6:\"status\";s:7:\"success\";}i:5;a:3:{s:2:\"id\";i:38;s:3:\"sku\";s:8:\"woo-belt\";s:6:\"status\";s:7:\"success\";}i:6;a:3:{s:2:\"id\";i:40;s:3:\"sku\";s:7:\"woo-cap\";s:6:\"status\";s:7:\"success\";}i:7;a:3:{s:2:\"id\";i:42;s:3:\"sku\";s:14:\"woo-sunglasses\";s:6:\"status\";s:7:\"success\";}i:8;a:3:{s:2:\"id\";i:44;s:3:\"sku\";s:22:\"woo-hoodie-with-pocket\";s:6:\"status\";s:7:\"success\";}i:9;a:3:{s:2:\"id\";i:46;s:3:\"sku\";s:22:\"woo-hoodie-with-zipper\";s:6:\"status\";s:7:\"success\";}i:10;a:3:{s:2:\"id\";i:48;s:3:\"sku\";s:19:\"woo-long-sleeve-tee\";s:6:\"status\";s:7:\"success\";}i:11;a:3:{s:2:\"id\";i:50;s:3:\"sku\";s:8:\"woo-polo\";s:6:\"status\";s:7:\"success\";}i:12;a:3:{s:2:\"id\";i:52;s:3:\"sku\";s:9:\"woo-album\";s:6:\"status\";s:7:\"success\";}i:13;a:3:{s:2:\"id\";i:54;s:3:\"sku\";s:10:\"woo-single\";s:6:\"status\";s:7:\"success\";}i:14;a:3:{s:2:\"id\";i:56;s:3:\"sku\";s:15:\"Woo-tshirt-logo\";s:6:\"status\";s:7:\"success\";}i:15;a:3:{s:2:\"id\";i:58;s:3:\"sku\";s:15:\"Woo-beanie-logo\";s:6:\"status\";s:7:\"success\";}i:16;a:3:{s:2:\"id\";i:60;s:3:\"sku\";s:15:\"logo-collection\";s:6:\"status\";s:7:\"success\";}i:17;a:3:{s:2:\"id\";i:65;s:3:\"sku\";s:10:\"wp-pennant\";s:6:\"status\";s:7:\"success\";}}", "auto");
INSERT INTO `wp_options` VALUES("451", "wpforms_activation_redirect", "skip", "auto");
INSERT INTO `wp_options` VALUES("452", "aioseo_activation_redirect", "skip", "auto");
INSERT INTO `wp_options` VALUES("454", "extendify_onboarding_completed", "2024-12-24T17:30:00.924Z", "auto");
INSERT INTO `wp_options` VALUES("455", "extendify_check_for_image_imports", "1", "off");
INSERT INTO `wp_options` VALUES("459", "wcpay_was_in_use", "no", "auto");
INSERT INTO `wp_options` VALUES("467", "wpforms_admin_notices", "a:1:{s:14:\"review_request\";a:2:{s:4:\"time\";i:1735061403;s:9:\"dismissed\";b:0;}}", "auto");
INSERT INTO `wp_options` VALUES("470", "extendify_assist_router", "a:2:{s:5:\"state\";a:1:{s:11:\"viewedPages\";a:1:{i:0;a:4:{s:4:\"slug\";s:9:\"dashboard\";s:13:\"firstViewedAt\";s:24:\"2024-12-24T17:30:03.754Z\";s:12:\"lastViewedAt\";s:24:\"2025-12-23T11:33:21.460Z\";s:5:\"count\";i:15;}}}s:7:\"version\";i:0;}", "auto");
INSERT INTO `wp_options` VALUES("471", "extendify_shared_activity", "a:2:{s:5:\"state\";a:1:{s:7:\"actions\";a:4:{s:16:\"assist-dashboard\";i:15;s:30:\"hc-close-button-when-minimized\";i:2;s:21:\"hc-toggle-button-open\";i:1;s:26:\"hc-toggle-button-minimized\";i:1;}}s:7:\"version\";i:0;}", "auto");
INSERT INTO `wp_options` VALUES("472", "extendify_help_center_router", "a:1:{s:5:\"state\";a:1:{s:11:\"viewedPages\";a:1:{i:0;a:4:{s:4:\"slug\";s:9:\"dashboard\";s:13:\"firstViewedAt\";s:24:\"2025-12-23T11:38:19.548Z\";s:12:\"lastViewedAt\";s:24:\"2025-12-23T11:38:19.548Z\";s:5:\"count\";i:1;}}}}", "auto");
INSERT INTO `wp_options` VALUES("473", "_transient_timeout_woocommerce_marketplace_promotions_v2", "1836361755", "off");
INSERT INTO `wp_options` VALUES("474", "_transient_woocommerce_marketplace_promotions_v2", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("475", "action_scheduler_migration_status", "complete", "auto");
INSERT INTO `wp_options` VALUES("476", "_transient_shipping-transient-version", "1735061447", "on");
INSERT INTO `wp_options` VALUES("480", "wpforms_process_forms_locator_status", "completed", "auto");
INSERT INTO `wp_options` VALUES("484", "wpforms_notifications", "a:4:{s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}s:6:\"update\";i:1752500709;}", "auto");
INSERT INTO `wp_options` VALUES("493", "theme_mods_rife-free", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:11:\"header-menu\";i:48;}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";i:11918;}", "on");
INSERT INTO `wp_options` VALUES("496", "woocommerce_maybe_regenerate_images_hash", "991b1ca641921cf0f5baf7a2fe85861b", "auto");
INSERT INTO `wp_options` VALUES("499", "a13_rife-free_rating", "1735061599", "auto");
INSERT INTO `wp_options` VALUES("565", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("566", "a13_force_to_flush", "off", "auto");
INSERT INTO `wp_options` VALUES("568", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("569", "a13_user_css_update", "off", "auto");
INSERT INTO `wp_options` VALUES("570", "widget_popular-posts", "a:4:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;i:3;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:7:\"content\";b:0;}i:4;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:7:\"content\";b:0;}}", "auto");
INSERT INTO `wp_options` VALUES("571", "widget_related-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("572", "widget_recent-albums", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("573", "widget_recent-works", "a:3:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;i:3;a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("574", "widget_filter", "a:2:{i:6;a:1:{s:6:\"filter\";s:6:\"albums\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("575", "widget_contact-info", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("576", "widget_a13-shortcodes", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("577", "widget_a13-social-icons", "a:14:{i:1;a:0:{}i:3;a:3:{s:5:\"title\";s:0:\"\";s:11:\"icons_color\";s:5:\"color\";s:17:\"icons_color_hover\";s:5:\"black\";}i:4;a:3:{s:5:\"title\";s:0:\"\";s:11:\"icons_color\";s:5:\"black\";s:17:\"icons_color_hover\";s:5:\"color\";}i:5;a:3:{s:5:\"title\";s:0:\"\";s:11:\"icons_color\";s:5:\"color\";s:17:\"icons_color_hover\";s:5:\"color\";}i:6;a:3:{s:5:\"title\";s:0:\"\";s:11:\"icons_color\";s:5:\"black\";s:17:\"icons_color_hover\";s:5:\"color\";}i:7;a:3:{s:5:\"title\";s:0:\"\";s:11:\"icons_color\";s:5:\"color\";s:17:\"icons_color_hover\";s:5:\"black\";}i:8;a:3:{s:5:\"title\";s:0:\"\";s:11:\"icons_color\";s:5:\"black\";s:17:\"icons_color_hover\";s:5:\"color\";}i:9;a:3:{s:5:\"title\";s:0:\"\";s:11:\"icons_color\";s:5:\"color\";s:17:\"icons_color_hover\";s:5:\"black\";}i:10;a:3:{s:5:\"title\";s:0:\"\";s:11:\"icons_color\";s:5:\"black\";s:17:\"icons_color_hover\";s:5:\"black\";}s:12:\"_multiwidget\";i:1;i:12;a:0:{}i:14;a:3:{s:5:\"title\";s:0:\"\";s:11:\"icons_color\";s:5:\"black\";s:17:\"icons_color_hover\";s:5:\"black\";}i:15;a:3:{s:5:\"title\";s:0:\"\";s:11:\"icons_color\";s:5:\"black\";s:17:\"icons_color_hover\";s:5:\"black\";}i:16;a:3:{s:5:\"title\";s:0:\"\";s:11:\"icons_color\";s:5:\"black\";s:17:\"icons_color_hover\";s:5:\"black\";}}", "auto");
INSERT INTO `wp_options` VALUES("578", "_transient_woocommerce_reports-transient-version", "1735061646", "on");
INSERT INTO `wp_options` VALUES("586", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("588", "elementor_active_kit", "11898", "auto");
INSERT INTO `wp_options` VALUES("589", "elementor_font_display", "swap", "auto");
INSERT INTO `wp_options` VALUES("593", "elementor_checklist", "{\"last_opened_timestamp\":1735067227,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":true}", "auto");
INSERT INTO `wp_options` VALUES("594", "elementor_version", "3.26.3", "auto");
INSERT INTO `wp_options` VALUES("595", "elementor_install_history", "a:1:{s:6:\"3.26.3\";i:1735061832;}", "auto");
INSERT INTO `wp_options` VALUES("596", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `wp_options` VALUES("597", "widget_aioseo-breadcrumb-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("598", "widget_aioseo-html-sitemap-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("603", "searchwp_live_search_last_update", "1735061838", "auto");
INSERT INTO `wp_options` VALUES("604", "searchwp_live_search_version", "1.8.3", "auto");
INSERT INTO `wp_options` VALUES("608", "widget_searchwp_live_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("610", "searchwp_lite_admin_notifications", "a:3:{s:10:\"updated_at\";i:1766489600;s:13:\"dismissed_ids\";a:0:{}s:13:\"notifications\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("612", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("613", "elementor_library_category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("614", "product_cat_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("615", "genre_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("616", "work_genre_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("618", "elementor_cpt_support", "a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:4:\"work\";}", "auto");
INSERT INTO `wp_options` VALUES("619", "elementor_scheme_color", "a:4:{i:1;s:7:\"#141414\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#3957ff\";}", "auto");
INSERT INTO `wp_options` VALUES("620", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:0:\"\";s:11:\"font_weight\";s:4:\"bold\";}i:2;a:2:{s:11:\"font_family\";s:0:\"\";s:11:\"font_weight\";s:4:\"bold\";}i:3;a:2:{s:11:\"font_family\";s:0:\"\";s:11:\"font_weight\";s:0:\"\";}i:4;a:2:{s:11:\"font_family\";s:0:\"\";s:11:\"font_weight\";s:6:\"normal\";}}", "auto");
INSERT INTO `wp_options` VALUES("621", "apollo13_option_rife", "a:468:{s:8:\"compiler\";s:0:\"\";s:13:\"redux-section\";s:2:\"17\";s:8:\"last_tab\";s:0:\"\";s:10:\"fp_variant\";s:4:\"page\";s:8:\"fp_album\";s:4:\"8413\";s:7:\"fp_work\";s:0:\"\";s:21:\"appearance_body_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:25:\"appearance_body_image_fit\";s:5:\"cover\";s:24:\"appearance_body_bg_color\";s:7:\"#000000\";s:11:\"layout_type\";s:4:\"full\";s:13:\"custom_cursor\";s:7:\"default\";s:13:\"cursor_select\";s:21:\"empty_black_white.png\";s:12:\"cursor_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:9:\"preloader\";s:2:\"on\";s:20:\"preloader_hide_event\";s:5:\"ready\";s:18:\"preloader_bg_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:22:\"preloader_bg_image_fit\";s:5:\"cover\";s:18:\"preloader_bg_color\";a:3:{s:5:\"color\";s:7:\"#0c0c0c\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(12,12,12,1)\";}s:14:\"preloader_type\";s:5:\"flash\";s:15:\"preloader_color\";a:3:{s:5:\"color\";s:7:\"#9f9f9f\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(159,159,159,1)\";}s:13:\"footer_switch\";s:3:\"off\";s:21:\"footer_unravel_effect\";s:3:\"off\";s:22:\"footer_widgets_columns\";s:1:\"3\";s:11:\"footer_text\";s:0:\"\";s:14:\"footer_socials\";s:3:\"off\";s:20:\"footer_socials_color\";s:5:\"black\";s:26:\"footer_socials_color_hover\";s:5:\"color\";s:20:\"footer_content_width\";s:4:\"full\";s:20:\"footer_content_style\";s:8:\"centered\";s:15:\"footer_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:21:\"footer_lower_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:20:\"footer_widgets_color\";s:13:\"light-sidebar\";s:16:\"footer_separator\";s:3:\"off\";s:22:\"footer_separator_color\";a:3:{s:5:\"color\";s:7:\"#e6e6e6\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(230,230,230,1)\";}s:16:\"footer_font_size\";s:2:\"15\";s:24:\"footer_widgets_font_size\";s:2:\"15\";s:17:\"footer_font_color\";a:3:{s:5:\"color\";s:7:\"#888888\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(136,136,136,1)\";}s:17:\"footer_link_color\";a:3:{s:5:\"color\";s:7:\"#888888\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(136,136,136,1)\";}s:18:\"footer_hover_color\";a:3:{s:5:\"color\";s:7:\"#1b1b1b\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(27,27,27,1)\";}s:23:\"hidden_sidebar_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:24:\"hidden_sidebar_font_size\";s:2:\"12\";s:28:\"hidden_sidebar_widgets_color\";s:13:\"light-sidebar\";s:19:\"hidden_sidebar_side\";s:5:\"right\";s:21:\"hidden_sidebar_effect\";s:1:\"1\";s:14:\"nav_menu_fonts\";a:6:{s:11:\"font-family\";s:7:\"Raleway\";s:12:\"font-options\";s:0:\"\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:3:\"1px\";s:7:\"subsets\";a:0:{}s:8:\"variants\";a:4:{i:0;s:3:\"200\";i:1;s:3:\"400\";i:2;s:3:\"700\";i:3;s:3:\"900\";}}s:12:\"titles_fonts\";a:5:{s:11:\"font-family\";s:7:\"Raleway\";s:12:\"font-options\";s:0:\"\";s:16:\"font-multi-style\";s:25:\"[\"200\",\"400\",\"700\",\"900\"]\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:3:\"1px\";}s:12:\"normal_fonts\";a:5:{s:11:\"font-family\";s:83:\"-apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Helvetica, Arial, sans-serif\";s:12:\"font-options\";s:0:\"\";s:16:\"font-multi-style\";s:25:\"[\"200\",\"400\",\"700\",\"900\"]\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";}s:14:\"headings_color\";s:7:\"#af0000\";s:20:\"headings_color_hover\";s:7:\"#8e0000\";s:15:\"headings_weight\";s:3:\"900\";s:18:\"headings_transform\";s:4:\"none\";s:20:\"page_title_font_size\";s:2:\"60\";s:24:\"page_title_font_size_768\";s:2:\"32\";s:16:\"content_bg_color\";s:7:\"#000000\";s:13:\"content_color\";s:7:\"#ffffff\";s:18:\"content_link_color\";s:7:\"#ffffff\";s:24:\"content_link_color_hover\";s:7:\"#ffffff\";s:17:\"content_font_size\";s:2:\"15\";s:15:\"first_paragraph\";s:2:\"on\";s:21:\"first_paragraph_color\";s:7:\"#ffffff\";s:15:\"socials_variant\";s:10:\"icons-only\";s:15:\"social_services\";a:44:{s:5:\"500px\";s:0:\"\";s:7:\"behance\";s:0:\"\";s:9:\"bitbucket\";s:0:\"\";s:7:\"codepen\";s:0:\"\";s:9:\"delicious\";s:0:\"\";s:10:\"deviantart\";s:0:\"\";s:4:\"digg\";s:0:\"\";s:7:\"dropbox\";s:0:\"\";s:6:\"mailto\";s:0:\"\";s:8:\"facebook\";s:42:\"https://www.facebook.com/zalazarfernandok/\";s:6:\"flickr\";s:0:\"\";s:10:\"foursquare\";s:0:\"\";s:6:\"github\";s:0:\"\";s:10:\"googleplus\";s:0:\"\";s:9:\"instagram\";s:41:\"https://www.instagram.com/fernandozalazar\";s:6:\"lastfm\";s:0:\"\";s:8:\"dribbble\";s:0:\"\";s:8:\"linkedin\";s:0:\"\";s:6:\"paypal\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:6:\"reddit\";s:0:\"\";s:3:\"rss\";s:0:\"\";s:9:\"sharethis\";s:0:\"\";s:5:\"skype\";s:0:\"\";s:5:\"slack\";s:0:\"\";s:8:\"snapchat\";s:0:\"\";s:7:\"spotify\";s:0:\"\";s:5:\"steam\";s:0:\"\";s:11:\"stumbleupon\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:7:\"twitter\";s:0:\"\";s:6:\"viadeo\";s:0:\"\";s:5:\"vimeo\";s:28:\"https://vimeo.com/1045061381\";s:4:\"vine\";s:0:\"\";s:9:\"vkontakte\";s:0:\"\";s:8:\"whatsapp\";s:0:\"\";s:9:\"wordpress\";s:0:\"\";s:4:\"xing\";s:0:\"\";s:5:\"yahoo\";s:0:\"\";s:4:\"yelp\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:9:\"messenger\";s:0:\"\";s:8:\"telegram\";s:0:\"\";s:11:\"tripadvisor\";s:0:\"\";}s:15:\"apollo_lightbox\";s:12:\"lightGallery\";s:18:\"widgets_top_margin\";s:2:\"on\";s:22:\"widget_title_font_size\";s:2:\"13\";s:16:\"widget_font_size\";s:2:\"12\";s:15:\"to_top_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:3:\"0.1\";s:4:\"rgba\";s:15:\"rgba(0,0,0,0.1)\";}s:21:\"to_top_bg_hover_color\";a:3:{s:5:\"color\";s:7:\"#3957ff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(57,87,255,1)\";}s:12:\"to_top_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:18:\"to_top_hover_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:16:\"to_top_font_size\";s:2:\"22\";s:11:\"to_top_icon\";s:8:\"angle-up\";s:22:\"button_submit_bg_color\";a:3:{s:5:\"color\";s:7:\"#222222\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(34,34,34,1)\";}s:28:\"button_submit_bg_hover_color\";a:3:{s:5:\"color\";s:7:\"#dd174a\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(221,23,74,1)\";}s:19:\"button_submit_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:25:\"button_submit_hover_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:23:\"button_submit_font_size\";s:2:\"13\";s:20:\"button_submit_weight\";s:3:\"600\";s:23:\"button_submit_transform\";s:4:\"none\";s:21:\"button_submit_padding\";a:3:{s:13:\"padding-right\";s:4:\"30px\";s:12:\"padding-left\";s:4:\"30px\";s:5:\"units\";s:2:\"px\";}s:20:\"button_submit_radius\";s:2:\"20\";s:11:\"header_type\";s:10:\"horizontal\";s:24:\"header_horizontal_sticky\";s:18:\"no-sticky no-fixed\";s:25:\"header_horizontal_variant\";s:8:\"one_line\";s:21:\"header_color_variants\";s:0:\"\";s:20:\"header_content_width\";s:4:\"full\";s:30:\"header_content_width_narrow_bg\";s:3:\"off\";s:15:\"header_bg_color\";a:3:{s:5:\"color\";s:7:\"#101010\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:16:\"rgba(16,16,16,0)\";}s:21:\"header_bg_hover_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:13:\"rgba(0,0,0,0)\";}s:27:\"header_mobile_menu_bg_color\";s:7:\"#0c0c0c\";s:13:\"header_border\";s:3:\"off\";s:13:\"header_shadow\";s:3:\"off\";s:23:\"header_separators_color\";a:3:{s:5:\"color\";s:7:\"#3a3a3a\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:16:\"rgba(58,58,58,0)\";}s:14:\"header_socials\";s:2:\"on\";s:20:\"header_socials_color\";s:5:\"white\";s:26:\"header_socials_color_hover\";s:5:\"color\";s:32:\"header_socials_display_on_mobile\";s:3:\"off\";s:18:\"logo_from_variants\";s:3:\"off\";s:9:\"logo_type\";s:5:\"image\";s:10:\"logo_image\";a:4:{s:2:\"id\";i:11927;s:3:\"url\";s:72:\"https://tangoandmore.com/wp-content/uploads/2024/12/cropped-fc_logo_.png\";s:6:\"height\";i:88;s:5:\"width\";i:342;}s:19:\"logo_image_high_dpi\";a:4:{s:2:\"id\";i:11927;s:3:\"url\";s:72:\"https://tangoandmore.com/wp-content/uploads/2024/12/cropped-fc_logo_.png\";s:6:\"height\";i:88;s:5:\"width\";i:342;}s:28:\"logo_image_max_desktop_width\";s:3:\"200\";s:27:\"logo_image_max_mobile_width\";s:3:\"200\";s:17:\"logo_image_height\";s:1:\"0\";s:18:\"logo_image_opacity\";s:2:\"50\";s:9:\"logo_text\";s:9:\"Rife Free\";s:10:\"logo_color\";s:7:\"#ffffff\";s:16:\"logo_color_hover\";s:7:\"#ffffff\";s:14:\"logo_font_size\";s:2:\"26\";s:11:\"logo_weight\";s:6:\"normal\";s:12:\"logo_padding\";a:3:{s:11:\"padding-top\";s:4:\"20px\";s:14:\"padding-bottom\";s:4:\"20px\";s:5:\"units\";s:2:\"px\";}s:19:\"logo_padding_mobile\";a:3:{s:11:\"padding-top\";s:4:\"15px\";s:14:\"padding-bottom\";s:4:\"15px\";s:5:\"units\";s:2:\"px\";}s:16:\"header_main_menu\";s:2:\"on\";s:17:\"menu_hover_effect\";s:4:\"none\";s:31:\"menu_close_mobile_menu_on_click\";s:2:\"on\";s:22:\"menu_allow_mobile_menu\";s:2:\"on\";s:14:\"menu_font_size\";s:2:\"15\";s:10:\"menu_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:3:\"0.5\";s:4:\"rgba\";s:21:\"rgba(255,255,255,0.5)\";}s:16:\"menu_hover_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:19:\"menu_hover_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:13:\"rgba(0,0,0,0)\";}s:11:\"menu_weight\";s:3:\"300\";s:14:\"menu_transform\";s:4:\"none\";s:16:\"submenu_bg_color\";a:3:{s:5:\"color\";s:7:\"#101010\";s:5:\"alpha\";s:3:\"0.9\";s:4:\"rgba\";s:18:\"rgba(16,16,16,0.9)\";}s:23:\"submenu_separator_color\";a:3:{s:5:\"color\";s:7:\"#f0f0f0\";s:5:\"alpha\";s:3:\"0.1\";s:4:\"rgba\";s:21:\"rgba(240,240,240,0.1)\";}s:18:\"submenu_open_icons\";s:2:\"on\";s:14:\"submenu_opener\";s:10:\"angle-down\";s:14:\"submenu_closer\";s:8:\"angle-up\";s:24:\"submenu_third_lvl_opener\";s:11:\"angle-right\";s:24:\"submenu_third_lvl_closer\";s:10:\"angle-left\";s:13:\"submenu_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:4:\"0.35\";s:4:\"rgba\";s:22:\"rgba(255,255,255,0.35)\";}s:19:\"submenu_color_hover\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:17:\"submenu_font_size\";s:2:\"13\";s:14:\"submenu_weight\";s:6:\"normal\";s:17:\"submenu_transform\";s:4:\"none\";s:24:\"header_sticky_logo_image\";a:9:{s:3:\"url\";s:73:\"https://tangoandmore.com/wp-content/uploads/2018/02/Rife-Unicorn-Logo.png\";s:2:\"id\";s:5:\"11061\";s:6:\"height\";s:2:\"44\";s:5:\"width\";s:3:\"171\";s:9:\"thumbnail\";s:80:\"https://tangoandmore.com/wp-content/uploads/2018/02/Rife-Unicorn-Logo-150x44.png\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:33:\"header_sticky_logo_image_high_dpi\";a:9:{s:3:\"url\";s:78:\"https://tangoandmore.com/wp-content/uploads/2018/02/Rife-Unicorn-Logo-HDPI.png\";s:2:\"id\";s:5:\"11062\";s:6:\"height\";s:2:\"88\";s:5:\"width\";s:3:\"342\";s:9:\"thumbnail\";s:85:\"https://tangoandmore.com/wp-content/uploads/2018/02/Rife-Unicorn-Logo-HDPI-150x88.png\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:24:\"header_sticky_logo_color\";s:7:\"#000000\";s:30:\"header_sticky_logo_color_hover\";s:7:\"#000000\";s:24:\"header_sticky_menu_color\";a:3:{s:5:\"color\";s:7:\"#222222\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(34,34,34,1)\";}s:30:\"header_sticky_menu_hover_color\";a:3:{s:5:\"color\";s:7:\"#3957ff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(57,87,255,1)\";}s:33:\"header_sticky_menu_hover_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:13:\"rgba(0,0,0,0)\";}s:22:\"header_sticky_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:34:\"header_sticky_mobile_menu_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:20:\"header_sticky_shadow\";s:2:\"on\";s:30:\"header_sticky_separators_color\";a:3:{s:5:\"color\";s:7:\"#3a3a3a\";s:5:\"alpha\";s:4:\"0.08\";s:4:\"rgba\";s:19:\"rgba(58,58,58,0.08)\";}s:26:\"header_sticky_logo_padding\";a:3:{s:11:\"padding-top\";s:4:\"20px\";s:14:\"padding-bottom\";s:4:\"20px\";s:5:\"units\";s:2:\"px\";}s:25:\"header_sticky_tools_color\";a:3:{s:5:\"color\";s:7:\"#222222\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(34,34,34,1)\";}s:31:\"header_sticky_tools_color_hover\";a:3:{s:5:\"color\";s:7:\"#dd174a\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(221,23,74,1)\";}s:29:\"header_sticky_button_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:35:\"header_sticky_button_bg_color_hover\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:33:\"header_sticky_button_border_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:39:\"header_sticky_button_border_color_hover\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:27:\"header_sticky_socials_color\";s:16:\"semi-transparent\";s:33:\"header_sticky_socials_color_hover\";s:5:\"color\";s:18:\"header_tools_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:3:\"0.7\";s:4:\"rgba\";s:21:\"rgba(255,255,255,0.7)\";}s:24:\"header_tools_color_hover\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:13:\"header_search\";s:3:\"off\";s:13:\"header_button\";s:0:\"\";s:18:\"header_button_link\";s:0:\"\";s:25:\"header_button_link_target\";s:3:\"off\";s:23:\"header_button_font_size\";s:2:\"12\";s:20:\"header_button_weight\";s:6:\"normal\";s:22:\"header_button_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:28:\"header_button_bg_color_hover\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:26:\"header_button_border_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:32:\"header_button_border_color_hover\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:31:\"header_button_display_on_mobile\";s:2:\"on\";s:22:\"blog_custom_background\";s:3:\"off\";s:15:\"blog_body_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"blog_body_image_fit\";s:5:\"cover\";s:18:\"blog_body_bg_color\";a:3:{s:5:\"color\";s:7:\"#ececec\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(236,236,236,1)\";}s:25:\"blog_content_under_header\";s:7:\"content\";s:19:\"blog_content_layout\";s:10:\"full_fixed\";s:20:\"blog_content_padding\";s:4:\"both\";s:12:\"blog_sidebar\";s:3:\"off\";s:14:\"blog_post_look\";s:10:\"horizontal\";s:16:\"blog_layout_mode\";s:7:\"packery\";s:18:\"blog_brick_columns\";s:1:\"2\";s:21:\"blog_bricks_max_width\";s:4:\"1920\";s:17:\"blog_brick_margin\";s:2:\"30\";s:14:\"blog_lazy_load\";s:2:\"on\";s:19:\"blog_lazy_load_mode\";s:6:\"button\";s:17:\"blog_excerpt_type\";s:4:\"auto\";s:19:\"blog_excerpt_length\";s:2:\"30\";s:10:\"blog_media\";s:2:\"on\";s:11:\"blog_videos\";s:3:\"off\";s:9:\"blog_date\";s:2:\"on\";s:11:\"blog_author\";s:3:\"off\";s:13:\"blog_comments\";s:3:\"off\";s:9:\"blog_cats\";s:3:\"off\";s:9:\"blog_tags\";s:3:\"off\";s:10:\"blog_title\";s:2:\"on\";s:22:\"blog_title_bar_variant\";s:8:\"centered\";s:20:\"blog_title_bar_width\";s:4:\"full\";s:20:\"blog_title_bar_image\";a:9:{s:3:\"url\";s:66:\"https://tangoandmore.com/wp-content/uploads/2018/02/cropps-BG2.jpg\";s:2:\"id\";s:5:\"11542\";s:6:\"height\";s:4:\"1036\";s:5:\"width\";s:4:\"2000\";s:9:\"thumbnail\";s:74:\"https://tangoandmore.com/wp-content/uploads/2018/02/cropps-BG2-150x150.jpg\";s:5:\"title\";s:12:\"Nice Old Man\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:82:\"Morbi purus massa, rhoncus ut diam et, ornare ornare mi. Cras ac fermentum tellus.\";}s:24:\"blog_title_bar_image_fit\";s:5:\"cover\";s:23:\"blog_title_bar_parallax\";s:2:\"on\";s:28:\"blog_title_bar_parallax_type\";s:2:\"bt\";s:29:\"blog_title_bar_parallax_speed\";s:4:\"1.00\";s:23:\"blog_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:3:\"0.1\";s:4:\"rgba\";s:15:\"rgba(0,0,0,0.1)\";}s:26:\"blog_title_bar_title_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:22:\"blog_title_bar_color_1\";a:3:{s:5:\"color\";s:7:\"#1b1b1b\";s:5:\"alpha\";s:3:\"0.7\";s:4:\"rgba\";s:18:\"rgba(27,27,27,0.7)\";}s:26:\"blog_title_bar_space_width\";s:3:\"150\";s:16:\"blog_breadcrumbs\";s:3:\"off\";s:25:\"post_content_under_header\";s:7:\"content\";s:19:\"post_content_layout\";s:10:\"full_fixed\";s:12:\"post_sidebar\";s:13:\"right-sidebar\";s:10:\"post_media\";s:2:\"on\";s:16:\"post_author_info\";s:2:\"on\";s:9:\"post_date\";s:2:\"on\";s:11:\"post_author\";s:2:\"on\";s:13:\"post_comments\";s:3:\"off\";s:9:\"post_cats\";s:3:\"off\";s:9:\"post_tags\";s:3:\"off\";s:15:\"post_navigation\";s:2:\"on\";s:10:\"post_title\";s:2:\"on\";s:23:\"post_title_bar_position\";s:7:\"outside\";s:22:\"post_title_bar_variant\";s:8:\"centered\";s:20:\"post_title_bar_width\";s:4:\"full\";s:20:\"post_title_bar_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:24:\"post_title_bar_image_fit\";s:5:\"cover\";s:23:\"post_title_bar_parallax\";s:2:\"on\";s:28:\"post_title_bar_parallax_type\";s:2:\"tb\";s:29:\"post_title_bar_parallax_speed\";s:4:\"1.00\";s:23:\"post_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#0b0b0b\";s:5:\"alpha\";s:3:\"0.5\";s:4:\"rgba\";s:18:\"rgba(11,11,11,0.5)\";}s:26:\"post_title_bar_title_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:22:\"post_title_bar_color_1\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:3:\"0.7\";s:4:\"rgba\";s:21:\"rgba(255,255,255,0.7)\";}s:26:\"post_title_bar_space_width\";s:3:\"230\";s:22:\"shop_custom_background\";s:3:\"off\";s:15:\"shop_body_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"shop_body_image_fit\";s:5:\"cover\";s:18:\"shop_body_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:11:\"shop_search\";s:3:\"off\";s:25:\"shop_content_under_header\";s:3:\"off\";s:19:\"shop_content_layout\";s:4:\"full\";s:12:\"shop_sidebar\";s:13:\"right-sidebar\";s:21:\"shop_products_variant\";s:7:\"overlay\";s:24:\"shop_products_subvariant\";s:6:\"center\";s:26:\"shop_products_second_image\";s:3:\"off\";s:25:\"shop_products_layout_mode\";s:7:\"packery\";s:21:\"shop_products_columns\";s:1:\"3\";s:22:\"shop_products_per_page\";s:2:\"12\";s:17:\"shop_brick_margin\";s:1:\"0\";s:14:\"shop_lazy_load\";s:2:\"on\";s:19:\"shop_lazy_load_mode\";s:4:\"auto\";s:10:\"shop_title\";s:2:\"on\";s:22:\"shop_title_bar_variant\";s:8:\"centered\";s:20:\"shop_title_bar_width\";s:4:\"full\";s:20:\"shop_title_bar_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:24:\"shop_title_bar_image_fit\";s:6:\"repeat\";s:23:\"shop_title_bar_parallax\";s:3:\"off\";s:28:\"shop_title_bar_parallax_type\";s:2:\"tb\";s:29:\"shop_title_bar_parallax_speed\";s:4:\"1.00\";s:23:\"shop_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#ededed\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(237,237,237,1)\";}s:26:\"shop_title_bar_title_color\";a:3:{s:5:\"color\";s:7:\"#202020\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(32,32,32,1)\";}s:22:\"shop_title_bar_color_1\";a:3:{s:5:\"color\";s:7:\"#7d7d7d\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(125,125,125,1)\";}s:26:\"shop_title_bar_space_width\";s:3:\"150\";s:16:\"shop_breadcrumbs\";s:2:\"on\";s:22:\"product_content_layout\";s:10:\"full_fixed\";s:15:\"product_sidebar\";s:3:\"off\";s:21:\"product_custom_thumbs\";s:2:\"on\";s:34:\"shop_no_major_pages_content_layout\";s:10:\"full_fixed\";s:25:\"shop_no_major_pages_title\";s:2:\"on\";s:37:\"shop_no_major_pages_title_bar_variant\";s:8:\"centered\";s:35:\"shop_no_major_pages_title_bar_width\";s:4:\"full\";s:35:\"shop_no_major_pages_title_bar_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:39:\"shop_no_major_pages_title_bar_image_fit\";s:6:\"repeat\";s:38:\"shop_no_major_pages_title_bar_parallax\";s:3:\"off\";s:43:\"shop_no_major_pages_title_bar_parallax_type\";s:2:\"tb\";s:44:\"shop_no_major_pages_title_bar_parallax_speed\";s:4:\"1.00\";s:38:\"shop_no_major_pages_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:41:\"shop_no_major_pages_title_bar_title_color\";a:3:{s:5:\"color\";s:7:\"#202020\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(32,32,32,1)\";}s:37:\"shop_no_major_pages_title_bar_color_1\";a:3:{s:5:\"color\";s:7:\"#1f1f1f\";s:5:\"alpha\";s:3:\"0.6\";s:4:\"rgba\";s:18:\"rgba(31,31,31,0.6)\";}s:41:\"shop_no_major_pages_title_bar_space_width\";s:2:\"80\";s:31:\"shop_no_major_pages_breadcrumbs\";s:2:\"on\";s:23:\"basket_sidebar_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:24:\"basket_sidebar_font_size\";s:2:\"13\";s:28:\"basket_sidebar_widgets_color\";s:13:\"light-sidebar\";s:20:\"button_shop_bg_color\";a:3:{s:5:\"color\";s:7:\"#222222\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(34,34,34,1)\";}s:26:\"button_shop_bg_hover_color\";a:3:{s:5:\"color\";s:7:\"#dd174a\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(221,23,74,1)\";}s:17:\"button_shop_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:23:\"button_shop_hover_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:24:\"button_shop_alt_bg_color\";a:3:{s:5:\"color\";s:7:\"#222222\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(34,34,34,1)\";}s:30:\"button_shop_alt_bg_hover_color\";a:3:{s:5:\"color\";s:7:\"#dd174a\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(221,23,74,1)\";}s:21:\"button_shop_alt_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:27:\"button_shop_alt_hover_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:21:\"button_shop_font_size\";s:2:\"13\";s:18:\"button_shop_weight\";s:3:\"600\";s:21:\"button_shop_transform\";s:4:\"none\";s:19:\"button_shop_padding\";a:3:{s:13:\"padding-right\";s:4:\"30px\";s:12:\"padding-left\";s:4:\"30px\";s:5:\"units\";s:2:\"px\";}s:13:\"page_comments\";s:3:\"off\";s:25:\"page_content_under_header\";s:3:\"off\";s:19:\"page_content_layout\";s:6:\"center\";s:12:\"page_sidebar\";s:3:\"off\";s:22:\"page_custom_background\";s:3:\"off\";s:15:\"page_body_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"page_body_image_fit\";s:5:\"cover\";s:18:\"page_body_bg_color\";a:3:{s:5:\"color\";s:0:\"\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:10:\"page_title\";s:2:\"on\";s:23:\"page_title_bar_position\";s:7:\"outside\";s:22:\"page_title_bar_variant\";s:7:\"classic\";s:20:\"page_title_bar_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:24:\"page_title_bar_image_fit\";s:6:\"repeat\";s:23:\"page_title_bar_parallax\";s:3:\"off\";s:28:\"page_title_bar_parallax_type\";s:2:\"tb\";s:29:\"page_title_bar_parallax_speed\";s:4:\"1.00\";s:23:\"page_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:26:\"page_title_bar_title_color\";a:3:{s:5:\"color\";s:0:\"\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:22:\"page_title_bar_color_1\";a:3:{s:5:\"color\";s:0:\"\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:26:\"page_title_bar_space_width\";s:2:\"40\";s:16:\"page_breadcrumbs\";s:2:\"on\";s:22:\"page_404_template_type\";s:7:\"default\";s:17:\"page_404_bg_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:27:\"page_password_template_type\";s:7:\"default\";s:22:\"page_password_bg_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:23:\"works_custom_background\";s:3:\"off\";s:16:\"works_body_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:20:\"works_body_image_fit\";s:5:\"cover\";s:19:\"works_body_bg_color\";a:3:{s:5:\"color\";s:7:\"#060606\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(6,6,6,1)\";}s:15:\"works_list_page\";s:4:\"2320\";s:31:\"works_list_content_under_header\";s:3:\"off\";s:27:\"works_list_work_how_to_open\";s:6:\"normal\";s:20:\"works_list_work_look\";s:7:\"overlay\";s:38:\"works_list_work_overlay_title_position\";s:10:\"mid_center\";s:29:\"works_list_work_overlay_cover\";s:3:\"off\";s:35:\"works_list_work_overlay_cover_hover\";s:2:\"on\";s:32:\"works_list_work_overlay_gradient\";s:3:\"off\";s:38:\"works_list_work_overlay_gradient_hover\";s:3:\"off\";s:29:\"works_list_work_overlay_texts\";s:3:\"off\";s:35:\"works_list_work_overlay_texts_hover\";s:2:\"on\";s:36:\"works_list_work_under_title_position\";s:6:\"center\";s:23:\"works_list_bricks_hover\";s:4:\"drop\";s:25:\"works_list_items_per_page\";s:2:\"12\";s:22:\"works_list_layout_mode\";s:7:\"packery\";s:24:\"works_list_brick_columns\";s:1:\"3\";s:27:\"works_list_bricks_max_width\";s:4:\"2000\";s:23:\"works_list_brick_margin\";s:1:\"0\";s:34:\"works_list_bricks_proportions_size\";s:3:\"4/3\";s:20:\"works_list_lazy_load\";s:2:\"on\";s:25:\"works_list_lazy_load_mode\";s:6:\"button\";s:21:\"works_list_categories\";s:3:\"off\";s:16:\"works_list_title\";s:3:\"off\";s:28:\"works_list_title_bar_variant\";s:8:\"centered\";s:26:\"works_list_title_bar_width\";s:4:\"full\";s:26:\"works_list_title_bar_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:30:\"works_list_title_bar_image_fit\";s:5:\"cover\";s:29:\"works_list_title_bar_parallax\";s:2:\"on\";s:34:\"works_list_title_bar_parallax_type\";s:2:\"tb\";s:35:\"works_list_title_bar_parallax_speed\";s:4:\"1.00\";s:29:\"works_list_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:32:\"works_list_title_bar_title_color\";a:3:{s:5:\"color\";s:7:\"#101010\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(16,16,16,1)\";}s:28:\"works_list_title_bar_color_1\";a:3:{s:5:\"color\";s:7:\"#727272\";s:5:\"alpha\";s:3:\"0.6\";s:4:\"rgba\";s:21:\"rgba(114,114,114,0.6)\";}s:32:\"works_list_title_bar_space_width\";s:3:\"100\";s:22:\"works_list_breadcrumbs\";s:2:\"on\";s:17:\"works_list_filter\";s:2:\"on\";s:25:\"works_list_filter_padding\";a:3:{s:11:\"padding-top\";s:4:\"40px\";s:14:\"padding-bottom\";s:4:\"40px\";s:5:\"units\";s:2:\"px\";}s:26:\"works_list_filter_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:19:\"rgba(255,255,255,0)\";}s:23:\"works_list_filter_color\";a:3:{s:5:\"color\";s:7:\"#c4c4c4\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(196,196,196,1)\";}s:29:\"works_list_filter_hover_color\";a:3:{s:5:\"color\";s:7:\"#333333\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(51,51,51,1)\";}s:24:\"works_list_filter_weight\";s:4:\"bold\";s:27:\"works_list_filter_transform\";s:9:\"uppercase\";s:28:\"works_list_filter_text_align\";s:6:\"center\";s:25:\"work_content_under_header\";s:3:\"off\";s:19:\"work_content_layout\";s:10:\"full_fixed\";s:23:\"work_content_categories\";s:2:\"on\";s:15:\"work_navigation\";s:2:\"on\";s:27:\"work_navigate_by_categories\";s:3:\"off\";s:18:\"work_similar_works\";s:3:\"off\";s:23:\"work_bricks_thumb_video\";s:3:\"off\";s:10:\"work_title\";s:2:\"on\";s:23:\"work_title_bar_position\";s:7:\"outside\";s:22:\"work_title_bar_variant\";s:8:\"centered\";s:20:\"work_title_bar_width\";s:4:\"full\";s:20:\"work_title_bar_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:24:\"work_title_bar_image_fit\";s:5:\"cover\";s:23:\"work_title_bar_parallax\";s:2:\"on\";s:28:\"work_title_bar_parallax_type\";s:2:\"tb\";s:29:\"work_title_bar_parallax_speed\";s:4:\"0.80\";s:23:\"work_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:3:\"0.7\";s:4:\"rgba\";s:15:\"rgba(0,0,0,0.7)\";}s:26:\"work_title_bar_title_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:22:\"work_title_bar_color_1\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:3:\"0.6\";s:4:\"rgba\";s:21:\"rgba(255,255,255,0.6)\";}s:26:\"work_title_bar_space_width\";s:3:\"200\";s:16:\"work_breadcrumbs\";s:3:\"off\";s:20:\"work_slider_autoplay\";s:2:\"on\";s:26:\"work_slider_slide_interval\";s:4:\"7000\";s:27:\"work_slider_transition_type\";s:1:\"2\";s:27:\"work_slider_transition_time\";s:3:\"600\";s:18:\"work_slider_thumbs\";s:2:\"on\";s:18:\"cpt_post_type_work\";s:4:\"work\";s:24:\"albums_custom_background\";s:2:\"on\";s:17:\"albums_body_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:21:\"albums_body_image_fit\";s:5:\"cover\";s:20:\"albums_body_bg_color\";a:3:{s:5:\"color\";s:7:\"#080808\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(8,8,8,1)\";}s:16:\"albums_list_page\";s:1:\"2\";s:32:\"albums_list_content_under_header\";s:3:\"off\";s:22:\"albums_list_album_look\";s:7:\"overlay\";s:40:\"albums_list_album_overlay_title_position\";s:11:\"bottom_left\";s:31:\"albums_list_album_overlay_cover\";s:3:\"off\";s:37:\"albums_list_album_overlay_cover_hover\";s:3:\"off\";s:34:\"albums_list_album_overlay_gradient\";s:3:\"off\";s:40:\"albums_list_album_overlay_gradient_hover\";s:2:\"on\";s:31:\"albums_list_album_overlay_texts\";s:3:\"off\";s:37:\"albums_list_album_overlay_texts_hover\";s:2:\"on\";s:38:\"albums_list_album_under_title_position\";s:6:\"center\";s:24:\"albums_list_bricks_hover\";s:5:\"shift\";s:26:\"albums_list_items_per_page\";s:2:\"12\";s:23:\"albums_list_layout_mode\";s:7:\"packery\";s:25:\"albums_list_brick_columns\";s:1:\"3\";s:28:\"albums_list_bricks_max_width\";s:4:\"2000\";s:24:\"albums_list_brick_margin\";s:1:\"0\";s:35:\"albums_list_bricks_proportions_size\";s:4:\"16/9\";s:21:\"albums_list_lazy_load\";s:2:\"on\";s:26:\"albums_list_lazy_load_mode\";s:4:\"auto\";s:22:\"albums_list_categories\";s:3:\"off\";s:17:\"albums_list_title\";s:3:\"off\";s:29:\"albums_list_title_bar_variant\";s:8:\"centered\";s:27:\"albums_list_title_bar_width\";s:4:\"full\";s:27:\"albums_list_title_bar_image\";a:9:{s:3:\"url\";s:70:\"https://tangoandmore.com/wp-content/uploads/2017/01/cropps-album13.jpg\";s:2:\"id\";s:5:\"11739\";s:6:\"height\";s:4:\"1218\";s:5:\"width\";s:4:\"1700\";s:9:\"thumbnail\";s:78:\"https://tangoandmore.com/wp-content/uploads/2017/01/cropps-album13-150x150.jpg\";s:5:\"title\";s:14:\"cropps-album13\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:31:\"albums_list_title_bar_image_fit\";s:5:\"cover\";s:30:\"albums_list_title_bar_parallax\";s:3:\"off\";s:35:\"albums_list_title_bar_parallax_type\";s:2:\"tb\";s:36:\"albums_list_title_bar_parallax_speed\";s:4:\"1.00\";s:30:\"albums_list_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:3:\"0.7\";s:4:\"rgba\";s:15:\"rgba(0,0,0,0.7)\";}s:33:\"albums_list_title_bar_title_color\";a:3:{s:5:\"color\";s:0:\"\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:29:\"albums_list_title_bar_color_1\";a:3:{s:5:\"color\";s:0:\"\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:33:\"albums_list_title_bar_space_width\";s:3:\"130\";s:23:\"albums_list_breadcrumbs\";s:2:\"on\";s:18:\"albums_list_filter\";s:2:\"on\";s:26:\"albums_list_filter_padding\";a:3:{s:11:\"padding-top\";s:4:\"40px\";s:14:\"padding-bottom\";s:4:\"40px\";s:5:\"units\";s:2:\"px\";}s:27:\"albums_list_filter_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:19:\"rgba(255,255,255,0)\";}s:24:\"albums_list_filter_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:4:\"0.35\";s:4:\"rgba\";s:22:\"rgba(255,255,255,0.35)\";}s:30:\"albums_list_filter_hover_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:25:\"albums_list_filter_weight\";s:6:\"normal\";s:28:\"albums_list_filter_transform\";s:4:\"none\";s:29:\"albums_list_filter_text_align\";s:5:\"right\";s:26:\"album_content_under_header\";s:3:\"off\";s:13:\"album_content\";s:5:\"right\";s:19:\"album_content_title\";s:2:\"on\";s:24:\"album_content_categories\";s:2:\"on\";s:16:\"album_navigation\";s:2:\"on\";s:28:\"album_navigate_by_categories\";s:3:\"off\";s:24:\"album_bricks_thumb_video\";s:3:\"off\";s:19:\"album_bricks_filter\";s:2:\"on\";s:27:\"album_bricks_filter_padding\";a:3:{s:11:\"padding-top\";s:4:\"40px\";s:14:\"padding-bottom\";s:4:\"40px\";s:5:\"units\";s:2:\"px\";}s:28:\"album_bricks_filter_bg_color\";s:7:\"#0f0f0f\";s:25:\"album_bricks_filter_color\";s:7:\"#7a7a7a\";s:31:\"album_bricks_filter_hover_color\";s:7:\"#ffffff\";s:26:\"album_bricks_filter_weight\";s:4:\"bold\";s:29:\"album_bricks_filter_transform\";s:9:\"uppercase\";s:30:\"album_bricks_filter_text_align\";s:6:\"center\";s:21:\"album_slider_autoplay\";s:2:\"on\";s:27:\"album_slider_slide_interval\";i:2613;s:28:\"album_slider_transition_type\";s:1:\"2\";s:28:\"album_slider_transition_time\";s:3:\"600\";s:19:\"album_slider_thumbs\";s:2:\"on\";s:18:\"album_social_icons\";s:2:\"on\";s:16:\"album_share_type\";s:5:\"album\";s:19:\"cpt_post_type_album\";s:5:\"album\";s:10:\"custom_css\";s:77:\".elementor-counter .elementor-counter-number-suffix {\r\n    font-size: 55%;\r\n}\";s:15:\"custom_sidebars\";a:2:{i:0;s:16:\"Socials (Colors)\";i:1;s:14:\"Socials (Dark)\";}s:20:\"people_socials_color\";s:5:\"white\";s:26:\"people_socials_color_hover\";s:5:\"color\";s:19:\"a13ir_image_quality\";s:2:\"90\";s:14:\"anchors_in_bar\";s:3:\"off\";s:21:\"writing_effect_mobile\";s:3:\"off\";s:11:\"import_code\";s:0:\"\";s:11:\"import_link\";s:0:\"\";s:20:\"writing_effect_speed\";i:10;}", "on");
INSERT INTO `wp_options` VALUES("626", "elementor_connect_site_key", "d276f2fbc506ffc314a72887e9feb77d", "auto");
INSERT INTO `wp_options` VALUES("627", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("628", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:100:\"Introducing Elementor 3.30: new Editor V4 capabilities, full Website Templates in the cloud, & more!\";s:7:\"excerpt\";s:361:\"Elementor 3.30 is here and it includes upgrades that accelerate your workflow, bring you a step closer to the full power of Editor V4, and help you deliver beautiful, accessible websites faster than ever. From advanced styling tools and smarter editing to full Website Templates in the cloud, this release enhances both the way you design and the way you scale.\";s:7:\"created\";i:1751974442;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-330-v4-alpha-website-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("634", "_elementor_installed_time", "1735062137", "auto");
INSERT INTO `wp_options` VALUES("649", "duplicate_post_show_notice", "1", "auto");
INSERT INTO `wp_options` VALUES("650", "duplicate_post_copytitle", "1", "auto");
INSERT INTO `wp_options` VALUES("651", "duplicate_post_copydate", "0", "auto");
INSERT INTO `wp_options` VALUES("652", "duplicate_post_copystatus", "0", "auto");
INSERT INTO `wp_options` VALUES("653", "duplicate_post_copyslug", "0", "auto");
INSERT INTO `wp_options` VALUES("654", "duplicate_post_copyexcerpt", "1", "auto");
INSERT INTO `wp_options` VALUES("655", "duplicate_post_copycontent", "1", "auto");
INSERT INTO `wp_options` VALUES("656", "duplicate_post_copythumbnail", "1", "auto");
INSERT INTO `wp_options` VALUES("657", "duplicate_post_copytemplate", "1", "auto");
INSERT INTO `wp_options` VALUES("658", "duplicate_post_copyformat", "1", "auto");
INSERT INTO `wp_options` VALUES("659", "duplicate_post_copyauthor", "0", "auto");
INSERT INTO `wp_options` VALUES("660", "duplicate_post_copypassword", "0", "auto");
INSERT INTO `wp_options` VALUES("661", "duplicate_post_copyattachments", "0", "auto");
INSERT INTO `wp_options` VALUES("662", "duplicate_post_copychildren", "0", "auto");
INSERT INTO `wp_options` VALUES("663", "duplicate_post_copycomments", "0", "auto");
INSERT INTO `wp_options` VALUES("664", "duplicate_post_copymenuorder", "1", "auto");
INSERT INTO `wp_options` VALUES("665", "duplicate_post_taxonomies_blacklist", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("666", "duplicate_post_blacklist", "", "auto");
INSERT INTO `wp_options` VALUES("667", "duplicate_post_types_enabled", "a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}", "auto");
INSERT INTO `wp_options` VALUES("668", "duplicate_post_show_original_column", "0", "auto");
INSERT INTO `wp_options` VALUES("669", "duplicate_post_show_original_in_post_states", "0", "auto");
INSERT INTO `wp_options` VALUES("670", "duplicate_post_show_original_meta_box", "0", "auto");
INSERT INTO `wp_options` VALUES("671", "duplicate_post_show_link", "a:3:{s:9:\"new_draft\";s:1:\"1\";s:5:\"clone\";s:1:\"1\";s:17:\"rewrite_republish\";s:1:\"1\";}", "auto");
INSERT INTO `wp_options` VALUES("672", "duplicate_post_show_link_in", "a:4:{s:3:\"row\";s:1:\"1\";s:8:\"adminbar\";s:1:\"1\";s:9:\"submitbox\";s:1:\"1\";s:11:\"bulkactions\";s:1:\"1\";}", "auto");
INSERT INTO `wp_options` VALUES("673", "duplicate_post_version", "4.5", "auto");
INSERT INTO `wp_options` VALUES("677", "e_editor_counter", "35", "auto");
INSERT INTO `wp_options` VALUES("678", "_elementor_free_to_pro_upsell", "a:2:{s:7:\"timeout\";i:1763471118;s:5:\"value\";s:723:\"[{\"id\":\"animated_headline\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg\"},{\"id\":\"video_playlist\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg\"},{\"id\":\"cta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg\"},{\"id\":\"testimonial_widget\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg\"},{\"id\":\"image_carousel\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg\"},{\"id\":\"connect-pro-upgrade\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/connect-pro-upgrade.jpg\"}]\";}", "off");
INSERT INTO `wp_options` VALUES("679", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1763471118;s:5:\"value\";s:10799:\"[{\"id\":\"variables-manager-3.33\",\"title\":\"Variables Manager\",\"description\":\"Centralize and control all your color, typography, and size tokens for consistent, scalable design systems.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-variables-manager.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"custom-css-3.33\",\"title\":\"Custom CSS\",\"description\":\"Write isolated, responsive, and state-based CSS directly inside atomic elements for pixel-perfect control.\",\"topic\":\"Elementor Pro 3.33\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-custom-css.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"custom-css-3.33\",\"title\":\"Custom CSS\",\"description\":\"Write isolated, responsive, and state-based CSS directly inside atomic elements for pixel-perfect control.\",\"topic\":\"Elementor Pro 3.33\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-custom-css.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-custom-css\\/\"},{\"id\":\"blend-mode-3.33\",\"title\":\"Blend Mode\",\"description\":\"Layer and blend visuals to create depth, contrast, and cinematic design effects.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-blend.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"transform-3.32\",\"title\":\"Design with depth using Transform\",\"description\":\"Move, scale, rotate, and skew any element with ease. Transform controls add depth, stacked effects, and seamless States for hover, focus, and active micro-interactions.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transform.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-size-variable\\/\"},{\"id\":\"transitions-3.32\",\"title\":\"Smooth interactions with Transitions\",\"description\":\"Bring polish to every interaction. Transitions let you animate style changes smoothly between states. In Pro, layer multiple transitions by property for refined, modern micro-animations.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transition.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `wp_options` VALUES("682", "elementor_log", "a:7:{s:32:\"38d2745972e53e9e3b57c783bf055a52\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2024-12-24 17:46:17\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type bool\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2024-12-24 17:46:17\";i:1;s:19:\"2024-12-24 19:07:06\";i:2;s:19:\"2025-01-09 03:06:37\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:51:\"Trying to access array offset on value of type bool\";s:4:\"file\";s:92:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/elementor/includes/managers/image.php\";s:4:\"line\";i:113;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:92:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/elementor/includes/managers/image.php\";s:7:\"\0*\0line\";i:113;}s:32:\"2e9e0624a56723223a834a12c8688618\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-01-08 18:20:21\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:136:\"this.model.isValidChild is not a function. (In &#039;this.model.isValidChild(C)&#039;, &#039;this.model.isValidChild&#039; is undefined)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-01-08 18:20:21\";i:1;s:19:\"2025-03-20 01:29:00\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1736360421\";s:7:\"message\";s:116:\"this.model.isValidChild is not a function. (In \'this.model.isValidChild(C)\', \'this.model.isValidChild\' is undefined)\";s:3:\"url\";s:88:\"https://tangoandmore.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.26.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"682493\";}s:7:\"\0*\0file\";s:88:\"https://tangoandmore.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.26.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"682493\";}s:32:\"5d79a9d2c6e7625537f31e0e875aec4e\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-01-08 19:03:42\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:91:\"undefined is not an object (evaluating &#039;elementor.getCurrentElement().model.get&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-08 19:03:42\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1736363022\";s:7:\"message\";s:81:\"undefined is not an object (evaluating \'elementor.getCurrentElement().model.get\')\";s:3:\"url\";s:88:\"https://tangoandmore.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.26.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"780893\";}s:7:\"\0*\0file\";s:88:\"https://tangoandmore.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.26.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"780893\";}s:32:\"57f82d5404186840506e2eee07085cdd\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-01-09 02:31:46\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:59:\"undefined is not an object (evaluating &#039;T.split&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-01-09 02:31:46\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1736389906\";s:7:\"message\";s:49:\"undefined is not an object (evaluating \'T.split\')\";s:3:\"url\";s:88:\"https://tangoandmore.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.26.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"619177\";}s:7:\"\0*\0file\";s:88:\"https://tangoandmore.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.26.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"619177\";}s:32:\"03db1d0a0b407d839845d25d76334528\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-01-09 11:33:45\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:76:\"undefined is not an object (evaluating &#039;C.attributes.id.toString&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:7;s:14:\"\0*\0times_dates\";a:7:{i:0;s:19:\"2025-01-09 11:33:45\";i:1;s:19:\"2025-01-09 11:33:45\";i:2;s:19:\"2025-01-09 11:39:16\";i:3;s:19:\"2025-01-09 11:39:16\";i:4;s:19:\"2025-01-09 11:39:16\";i:5;s:19:\"2025-01-09 11:39:16\";i:6;s:19:\"2025-01-09 11:39:16\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1736422425\";s:7:\"message\";s:66:\"undefined is not an object (evaluating \'C.attributes.id.toString\')\";s:3:\"url\";s:100:\"https://tangoandmore.com/wp-admin/load-scripts.php?c=1&amp;loadchunk_0=react,react-dom&amp;ver=6.7.1\";s:4:\"line\";s:2:\"20\";s:6:\"column\";s:5:\"91929\";}s:7:\"\0*\0file\";s:100:\"https://tangoandmore.com/wp-admin/load-scripts.php?c=1&amp;loadchunk_0=react,react-dom&amp;ver=6.7.1\";s:7:\"\0*\0line\";s:2:\"20\";s:9:\"\0*\0column\";s:5:\"91929\";}s:32:\"1668ce165f32e38fa2bfc91636aad18b\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2028-03-10 04:29:15\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:52:\"Automatic conversion of false to array is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2028-03-10 04:29:15\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:52:\"Automatic conversion of false to array is deprecated\";s:4:\"file\";s:81:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/elementor/includes/api.php\";s:4:\"line\";i:185;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:81:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/elementor/includes/api.php\";s:7:\"\0*\0line\";i:185;}s:32:\"82952d85ee39aacbcaf61849da819747\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-11-07 14:38:27\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type null\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-07 14:38:27\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:51:\"Trying to access array offset on value of type null\";s:4:\"file\";s:83:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/elementor/includes/embed.php\";s:4:\"line\";i:186;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:83:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/elementor/includes/embed.php\";s:7:\"\0*\0line\";i:186;}}", "off");
INSERT INTO `wp_options` VALUES("686", "extendify_draft_router", "a:2:{s:5:\"state\";a:1:{s:11:\"viewedPages\";a:1:{i:0;a:4:{s:4:\"slug\";s:4:\"home\";s:13:\"firstViewedAt\";s:24:\"2025-11-07T02:58:16.344Z\";s:12:\"lastViewedAt\";s:24:\"2025-11-07T02:58:16.344Z\";s:5:\"count\";i:1;}}}s:7:\"version\";i:0;}", "auto");
INSERT INTO `wp_options` VALUES("691", "woocommerce_share_key", "FMilnCoM9o54K5dimUVUzc6nvSOpv3hm", "auto");
INSERT INTO `wp_options` VALUES("693", "_transient_woocommerce_shipping_task_zone_count_transient", "0", "on");
INSERT INTO `wp_options` VALUES("694", "woocommerce_task_list_tracked_completed_tasks", "a:1:{i:0;s:17:\"launch-your-store\";}", "auto");
INSERT INTO `wp_options` VALUES("787", "_elementor_home_screen_data", "a:2:{s:7:\"timeout\";i:1735072026;s:5:\"value\";s:8313:\"{\"top_with_licences\":[{\"license\":[\"free\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Start building your website with Elementor\'s no code drag & drop editor.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s\",\"youtube_embed_id\":\"le72grP_Q6k?si=g2akyWNODL6usu6u\"},{\"license\":[\"pro\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs\",\"youtube_embed_id\":\"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5\"}],\"get_started\":[{\"license\":[\"free\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&page=popup_templates\",\"is_relative_url\":true,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\",\"title_small_color\":\"text.tertiary\"}]},{\"license\":[\"pro\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\"}]}],\"add_ons\":{\"header\":{\"title\":\"Expand your design toolkit\",\"description\":\"These plugins, add-ons, and tools, have been selected to streamline your workflow and maximize your creativity.\"},\"repeater\":[{\"file_path\":\"site-mailer\\/site-mailer.php\",\"title\":\"Site Mailer\",\"url\":\"\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-mailer.svg\",\"type\":\"wporg\"},{\"file_path\":\"image-optimization\\/image-optimization.php\",\"title\":\"Image Optimizer\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-io\\/\",\"description\":\"Check out this incredibly useful plugin that will compress and optimize your images, giving you leaner, faster websites.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/image-optimizer.svg\",\"type\":\"wporg\"},{\"title\":\"Elementor AI\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-ai\\/\",\"description\":\"Boost creativity with Elementor AI. Craft & enhance copy, create custom CSS & Code, and generate images to elevate your website.\",\"button_label\":\"Let\'s go\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/elementor.svg\",\"type\":\"link\",\"condition\":{\"key\":\"introduction_meta\",\"value\":\"ai_get_started\"}}],\"footer\":{\"label\":\"Explore more add-ons\",\"file_path\":\"wp-admin\\/admin.php?page=elementor-apps\"}},\"sidebar_upgrade\":[{\"license\":[\"free\"],\"show\":\"true\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]},{\"license\":[\"pro\"],\"show\":\"false\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}],\"external_links\":[{\"label\":\"Help Center\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-question-mark.svg\",\"url\":\"https:\\/\\/elementor.com\\/help\\/\"},{\"label\":\"Youtube\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-youtube.svg\",\"url\":\"https:\\/\\/www.youtube.com\\/@Elementor\"},{\"label\":\"Facebook Community\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-community.svg\",\"url\":\"https:\\/\\/www.facebook.com\\/groups\\/Elementors\"},{\"label\":\"Blog\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-academic-hat.svg\",\"url\":\"https:\\/\\/elementor.com\\/blog\\/\"}]}\";}", "off");
INSERT INTO `wp_options` VALUES("1051", "_transient_health-check-site-status-result", "{\"good\":21,\"recommended\":6,\"critical\":1}", "on");
INSERT INTO `wp_options` VALUES("1078", "woocommerce_admin_customize_store_completed", "yes", "auto");
INSERT INTO `wp_options` VALUES("1097", "site_logo", "11918", "auto");
INSERT INTO `wp_options` VALUES("1152", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("1173", "_elementor_editor_upgrade_notice_dismissed", "1762399183", "auto");
INSERT INTO `wp_options` VALUES("4173", "apollo13_rife_cache", "a:3:{s:7:\"options\";a:520:{s:8:\"compiler\";s:0:\"\";s:13:\"redux-section\";s:2:\"17\";s:8:\"last_tab\";s:0:\"\";s:10:\"fp_variant\";s:4:\"page\";s:8:\"fp_album\";s:4:\"8413\";s:7:\"fp_work\";s:0:\"\";s:21:\"appearance_body_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:25:\"appearance_body_image_fit\";s:5:\"cover\";s:24:\"appearance_body_bg_color\";s:7:\"#000000\";s:11:\"layout_type\";s:4:\"full\";s:13:\"custom_cursor\";s:7:\"default\";s:13:\"cursor_select\";s:21:\"empty_black_white.png\";s:12:\"cursor_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:9:\"preloader\";s:2:\"on\";s:20:\"preloader_hide_event\";s:5:\"ready\";s:18:\"preloader_bg_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:22:\"preloader_bg_image_fit\";s:5:\"cover\";s:18:\"preloader_bg_color\";a:3:{s:5:\"color\";s:7:\"#0c0c0c\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(12,12,12,1)\";}s:14:\"preloader_type\";s:5:\"flash\";s:15:\"preloader_color\";a:3:{s:5:\"color\";s:7:\"#9f9f9f\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(159,159,159,1)\";}s:13:\"footer_switch\";s:3:\"off\";s:21:\"footer_unravel_effect\";s:3:\"off\";s:22:\"footer_widgets_columns\";s:1:\"3\";s:11:\"footer_text\";s:0:\"\";s:14:\"footer_socials\";s:3:\"off\";s:20:\"footer_socials_color\";s:5:\"black\";s:26:\"footer_socials_color_hover\";s:5:\"color\";s:20:\"footer_content_width\";s:4:\"full\";s:20:\"footer_content_style\";s:8:\"centered\";s:15:\"footer_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:21:\"footer_lower_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:20:\"footer_widgets_color\";s:13:\"light-sidebar\";s:16:\"footer_separator\";s:3:\"off\";s:22:\"footer_separator_color\";a:3:{s:5:\"color\";s:7:\"#e6e6e6\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(230,230,230,1)\";}s:16:\"footer_font_size\";s:2:\"15\";s:24:\"footer_widgets_font_size\";s:2:\"15\";s:17:\"footer_font_color\";a:3:{s:5:\"color\";s:7:\"#888888\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(136,136,136,1)\";}s:17:\"footer_link_color\";a:3:{s:5:\"color\";s:7:\"#888888\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(136,136,136,1)\";}s:18:\"footer_hover_color\";a:3:{s:5:\"color\";s:7:\"#1b1b1b\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(27,27,27,1)\";}s:23:\"hidden_sidebar_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:24:\"hidden_sidebar_font_size\";s:2:\"12\";s:28:\"hidden_sidebar_widgets_color\";s:13:\"light-sidebar\";s:19:\"hidden_sidebar_side\";s:5:\"right\";s:21:\"hidden_sidebar_effect\";s:1:\"1\";s:14:\"nav_menu_fonts\";a:6:{s:11:\"font-family\";s:7:\"Raleway\";s:12:\"font-options\";s:0:\"\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:3:\"1px\";s:7:\"subsets\";a:0:{}s:8:\"variants\";a:4:{i:0;s:3:\"200\";i:1;s:3:\"400\";i:2;s:3:\"700\";i:3;s:3:\"900\";}}s:12:\"titles_fonts\";a:5:{s:11:\"font-family\";s:7:\"Raleway\";s:12:\"font-options\";s:0:\"\";s:16:\"font-multi-style\";s:25:\"[\"200\",\"400\",\"700\",\"900\"]\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:3:\"1px\";}s:12:\"normal_fonts\";a:5:{s:11:\"font-family\";s:83:\"-apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Helvetica, Arial, sans-serif\";s:12:\"font-options\";s:0:\"\";s:16:\"font-multi-style\";s:25:\"[\"200\",\"400\",\"700\",\"900\"]\";s:12:\"word-spacing\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";}s:14:\"headings_color\";s:7:\"#af0000\";s:20:\"headings_color_hover\";s:7:\"#8e0000\";s:15:\"headings_weight\";s:3:\"900\";s:18:\"headings_transform\";s:4:\"none\";s:20:\"page_title_font_size\";s:2:\"60\";s:24:\"page_title_font_size_768\";s:2:\"32\";s:16:\"content_bg_color\";s:7:\"#000000\";s:13:\"content_color\";s:7:\"#ffffff\";s:18:\"content_link_color\";s:7:\"#ffffff\";s:24:\"content_link_color_hover\";s:7:\"#ffffff\";s:17:\"content_font_size\";s:2:\"15\";s:15:\"first_paragraph\";s:2:\"on\";s:21:\"first_paragraph_color\";s:7:\"#ffffff\";s:15:\"socials_variant\";s:10:\"icons-only\";s:15:\"social_services\";a:44:{s:5:\"500px\";s:0:\"\";s:7:\"behance\";s:0:\"\";s:9:\"bitbucket\";s:0:\"\";s:7:\"codepen\";s:0:\"\";s:9:\"delicious\";s:0:\"\";s:10:\"deviantart\";s:0:\"\";s:4:\"digg\";s:0:\"\";s:7:\"dropbox\";s:0:\"\";s:6:\"mailto\";s:0:\"\";s:8:\"facebook\";s:42:\"https://www.facebook.com/zalazarfernandok/\";s:6:\"flickr\";s:0:\"\";s:10:\"foursquare\";s:0:\"\";s:6:\"github\";s:0:\"\";s:10:\"googleplus\";s:0:\"\";s:9:\"instagram\";s:41:\"https://www.instagram.com/fernandozalazar\";s:6:\"lastfm\";s:0:\"\";s:8:\"dribbble\";s:0:\"\";s:8:\"linkedin\";s:0:\"\";s:6:\"paypal\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:6:\"reddit\";s:0:\"\";s:3:\"rss\";s:0:\"\";s:9:\"sharethis\";s:0:\"\";s:5:\"skype\";s:0:\"\";s:5:\"slack\";s:0:\"\";s:8:\"snapchat\";s:0:\"\";s:7:\"spotify\";s:0:\"\";s:5:\"steam\";s:0:\"\";s:11:\"stumbleupon\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:7:\"twitter\";s:0:\"\";s:6:\"viadeo\";s:0:\"\";s:5:\"vimeo\";s:28:\"https://vimeo.com/1045061381\";s:4:\"vine\";s:0:\"\";s:9:\"vkontakte\";s:0:\"\";s:8:\"whatsapp\";s:0:\"\";s:9:\"wordpress\";s:0:\"\";s:4:\"xing\";s:0:\"\";s:5:\"yahoo\";s:0:\"\";s:4:\"yelp\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:9:\"messenger\";s:0:\"\";s:8:\"telegram\";s:0:\"\";s:11:\"tripadvisor\";s:0:\"\";}s:15:\"apollo_lightbox\";s:12:\"lightGallery\";s:18:\"widgets_top_margin\";s:2:\"on\";s:22:\"widget_title_font_size\";s:2:\"13\";s:16:\"widget_font_size\";s:2:\"12\";s:15:\"to_top_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:3:\"0.1\";s:4:\"rgba\";s:15:\"rgba(0,0,0,0.1)\";}s:21:\"to_top_bg_hover_color\";a:3:{s:5:\"color\";s:7:\"#3957ff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(57,87,255,1)\";}s:12:\"to_top_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:18:\"to_top_hover_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:16:\"to_top_font_size\";s:2:\"22\";s:11:\"to_top_icon\";s:8:\"angle-up\";s:22:\"button_submit_bg_color\";a:3:{s:5:\"color\";s:7:\"#222222\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(34,34,34,1)\";}s:28:\"button_submit_bg_hover_color\";a:3:{s:5:\"color\";s:7:\"#dd174a\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(221,23,74,1)\";}s:19:\"button_submit_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:25:\"button_submit_hover_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:23:\"button_submit_font_size\";s:2:\"13\";s:20:\"button_submit_weight\";s:3:\"600\";s:23:\"button_submit_transform\";s:4:\"none\";s:21:\"button_submit_padding\";a:3:{s:13:\"padding-right\";s:4:\"30px\";s:12:\"padding-left\";s:4:\"30px\";s:5:\"units\";s:2:\"px\";}s:20:\"button_submit_radius\";s:2:\"20\";s:11:\"header_type\";s:10:\"horizontal\";s:24:\"header_horizontal_sticky\";s:18:\"no-sticky no-fixed\";s:25:\"header_horizontal_variant\";s:8:\"one_line\";s:21:\"header_color_variants\";s:0:\"\";s:20:\"header_content_width\";s:4:\"full\";s:30:\"header_content_width_narrow_bg\";s:3:\"off\";s:15:\"header_bg_color\";a:3:{s:5:\"color\";s:7:\"#101010\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:16:\"rgba(16,16,16,0)\";}s:21:\"header_bg_hover_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:13:\"rgba(0,0,0,0)\";}s:27:\"header_mobile_menu_bg_color\";s:7:\"#0c0c0c\";s:13:\"header_border\";s:3:\"off\";s:13:\"header_shadow\";s:3:\"off\";s:23:\"header_separators_color\";a:3:{s:5:\"color\";s:7:\"#3a3a3a\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:16:\"rgba(58,58,58,0)\";}s:14:\"header_socials\";s:2:\"on\";s:20:\"header_socials_color\";s:5:\"white\";s:26:\"header_socials_color_hover\";s:5:\"color\";s:32:\"header_socials_display_on_mobile\";s:3:\"off\";s:18:\"logo_from_variants\";s:3:\"off\";s:9:\"logo_type\";s:5:\"image\";s:10:\"logo_image\";a:4:{s:2:\"id\";i:11927;s:3:\"url\";s:72:\"https://tangoandmore.com/wp-content/uploads/2024/12/cropped-fc_logo_.png\";s:6:\"height\";i:88;s:5:\"width\";i:342;}s:19:\"logo_image_high_dpi\";a:4:{s:2:\"id\";i:11927;s:3:\"url\";s:72:\"https://tangoandmore.com/wp-content/uploads/2024/12/cropped-fc_logo_.png\";s:6:\"height\";i:88;s:5:\"width\";i:342;}s:28:\"logo_image_max_desktop_width\";s:3:\"200\";s:27:\"logo_image_max_mobile_width\";s:3:\"200\";s:17:\"logo_image_height\";s:1:\"0\";s:18:\"logo_image_opacity\";s:2:\"50\";s:9:\"logo_text\";s:9:\"Rife Free\";s:10:\"logo_color\";s:7:\"#ffffff\";s:16:\"logo_color_hover\";s:7:\"#ffffff\";s:14:\"logo_font_size\";s:2:\"26\";s:11:\"logo_weight\";s:6:\"normal\";s:12:\"logo_padding\";a:3:{s:11:\"padding-top\";s:4:\"20px\";s:14:\"padding-bottom\";s:4:\"20px\";s:5:\"units\";s:2:\"px\";}s:19:\"logo_padding_mobile\";a:3:{s:11:\"padding-top\";s:4:\"15px\";s:14:\"padding-bottom\";s:4:\"15px\";s:5:\"units\";s:2:\"px\";}s:16:\"header_main_menu\";s:2:\"on\";s:17:\"menu_hover_effect\";s:4:\"none\";s:31:\"menu_close_mobile_menu_on_click\";s:2:\"on\";s:22:\"menu_allow_mobile_menu\";s:2:\"on\";s:14:\"menu_font_size\";s:2:\"15\";s:10:\"menu_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:3:\"0.5\";s:4:\"rgba\";s:21:\"rgba(255,255,255,0.5)\";}s:16:\"menu_hover_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:19:\"menu_hover_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:13:\"rgba(0,0,0,0)\";}s:11:\"menu_weight\";s:3:\"300\";s:14:\"menu_transform\";s:4:\"none\";s:16:\"submenu_bg_color\";a:3:{s:5:\"color\";s:7:\"#101010\";s:5:\"alpha\";s:3:\"0.9\";s:4:\"rgba\";s:18:\"rgba(16,16,16,0.9)\";}s:23:\"submenu_separator_color\";a:3:{s:5:\"color\";s:7:\"#f0f0f0\";s:5:\"alpha\";s:3:\"0.1\";s:4:\"rgba\";s:21:\"rgba(240,240,240,0.1)\";}s:18:\"submenu_open_icons\";s:2:\"on\";s:14:\"submenu_opener\";s:10:\"angle-down\";s:14:\"submenu_closer\";s:8:\"angle-up\";s:24:\"submenu_third_lvl_opener\";s:11:\"angle-right\";s:24:\"submenu_third_lvl_closer\";s:10:\"angle-left\";s:13:\"submenu_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:4:\"0.35\";s:4:\"rgba\";s:22:\"rgba(255,255,255,0.35)\";}s:19:\"submenu_color_hover\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:17:\"submenu_font_size\";s:2:\"13\";s:14:\"submenu_weight\";s:6:\"normal\";s:17:\"submenu_transform\";s:4:\"none\";s:24:\"header_sticky_logo_image\";a:9:{s:3:\"url\";s:73:\"https://tangoandmore.com/wp-content/uploads/2018/02/Rife-Unicorn-Logo.png\";s:2:\"id\";s:5:\"11061\";s:6:\"height\";s:2:\"44\";s:5:\"width\";s:3:\"171\";s:9:\"thumbnail\";s:80:\"https://tangoandmore.com/wp-content/uploads/2018/02/Rife-Unicorn-Logo-150x44.png\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:33:\"header_sticky_logo_image_high_dpi\";a:9:{s:3:\"url\";s:78:\"https://tangoandmore.com/wp-content/uploads/2018/02/Rife-Unicorn-Logo-HDPI.png\";s:2:\"id\";s:5:\"11062\";s:6:\"height\";s:2:\"88\";s:5:\"width\";s:3:\"342\";s:9:\"thumbnail\";s:85:\"https://tangoandmore.com/wp-content/uploads/2018/02/Rife-Unicorn-Logo-HDPI-150x88.png\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:24:\"header_sticky_logo_color\";s:7:\"#000000\";s:30:\"header_sticky_logo_color_hover\";s:7:\"#000000\";s:24:\"header_sticky_menu_color\";a:3:{s:5:\"color\";s:7:\"#222222\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(34,34,34,1)\";}s:30:\"header_sticky_menu_hover_color\";a:3:{s:5:\"color\";s:7:\"#3957ff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(57,87,255,1)\";}s:33:\"header_sticky_menu_hover_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:13:\"rgba(0,0,0,0)\";}s:22:\"header_sticky_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:34:\"header_sticky_mobile_menu_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:20:\"header_sticky_shadow\";s:2:\"on\";s:30:\"header_sticky_separators_color\";a:3:{s:5:\"color\";s:7:\"#3a3a3a\";s:5:\"alpha\";s:4:\"0.08\";s:4:\"rgba\";s:19:\"rgba(58,58,58,0.08)\";}s:26:\"header_sticky_logo_padding\";a:3:{s:11:\"padding-top\";s:4:\"20px\";s:14:\"padding-bottom\";s:4:\"20px\";s:5:\"units\";s:2:\"px\";}s:25:\"header_sticky_tools_color\";a:3:{s:5:\"color\";s:7:\"#222222\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(34,34,34,1)\";}s:31:\"header_sticky_tools_color_hover\";a:3:{s:5:\"color\";s:7:\"#dd174a\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(221,23,74,1)\";}s:29:\"header_sticky_button_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:35:\"header_sticky_button_bg_color_hover\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:33:\"header_sticky_button_border_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:39:\"header_sticky_button_border_color_hover\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:27:\"header_sticky_socials_color\";s:16:\"semi-transparent\";s:33:\"header_sticky_socials_color_hover\";s:5:\"color\";s:18:\"header_tools_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:3:\"0.7\";s:4:\"rgba\";s:21:\"rgba(255,255,255,0.7)\";}s:24:\"header_tools_color_hover\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:13:\"header_search\";s:3:\"off\";s:13:\"header_button\";s:0:\"\";s:18:\"header_button_link\";s:0:\"\";s:25:\"header_button_link_target\";s:3:\"off\";s:23:\"header_button_font_size\";s:2:\"12\";s:20:\"header_button_weight\";s:6:\"normal\";s:22:\"header_button_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:28:\"header_button_bg_color_hover\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:26:\"header_button_border_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:32:\"header_button_border_color_hover\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:31:\"header_button_display_on_mobile\";s:2:\"on\";s:22:\"blog_custom_background\";s:3:\"off\";s:15:\"blog_body_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"blog_body_image_fit\";s:5:\"cover\";s:18:\"blog_body_bg_color\";a:3:{s:5:\"color\";s:7:\"#ececec\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(236,236,236,1)\";}s:25:\"blog_content_under_header\";s:7:\"content\";s:19:\"blog_content_layout\";s:10:\"full_fixed\";s:20:\"blog_content_padding\";s:4:\"both\";s:12:\"blog_sidebar\";s:3:\"off\";s:14:\"blog_post_look\";s:10:\"horizontal\";s:16:\"blog_layout_mode\";s:7:\"packery\";s:18:\"blog_brick_columns\";s:1:\"2\";s:21:\"blog_bricks_max_width\";s:4:\"1920\";s:17:\"blog_brick_margin\";s:2:\"30\";s:14:\"blog_lazy_load\";s:2:\"on\";s:19:\"blog_lazy_load_mode\";s:6:\"button\";s:17:\"blog_excerpt_type\";s:4:\"auto\";s:19:\"blog_excerpt_length\";s:2:\"30\";s:10:\"blog_media\";s:2:\"on\";s:11:\"blog_videos\";s:3:\"off\";s:9:\"blog_date\";s:2:\"on\";s:11:\"blog_author\";s:3:\"off\";s:13:\"blog_comments\";s:3:\"off\";s:9:\"blog_cats\";s:3:\"off\";s:9:\"blog_tags\";s:3:\"off\";s:10:\"blog_title\";s:2:\"on\";s:22:\"blog_title_bar_variant\";s:8:\"centered\";s:20:\"blog_title_bar_width\";s:4:\"full\";s:20:\"blog_title_bar_image\";a:9:{s:3:\"url\";s:66:\"https://tangoandmore.com/wp-content/uploads/2018/02/cropps-BG2.jpg\";s:2:\"id\";s:5:\"11542\";s:6:\"height\";s:4:\"1036\";s:5:\"width\";s:4:\"2000\";s:9:\"thumbnail\";s:74:\"https://tangoandmore.com/wp-content/uploads/2018/02/cropps-BG2-150x150.jpg\";s:5:\"title\";s:12:\"Nice Old Man\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:82:\"Morbi purus massa, rhoncus ut diam et, ornare ornare mi. Cras ac fermentum tellus.\";}s:24:\"blog_title_bar_image_fit\";s:5:\"cover\";s:23:\"blog_title_bar_parallax\";s:2:\"on\";s:28:\"blog_title_bar_parallax_type\";s:2:\"bt\";s:29:\"blog_title_bar_parallax_speed\";s:4:\"1.00\";s:23:\"blog_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:3:\"0.1\";s:4:\"rgba\";s:15:\"rgba(0,0,0,0.1)\";}s:26:\"blog_title_bar_title_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:22:\"blog_title_bar_color_1\";a:3:{s:5:\"color\";s:7:\"#1b1b1b\";s:5:\"alpha\";s:3:\"0.7\";s:4:\"rgba\";s:18:\"rgba(27,27,27,0.7)\";}s:26:\"blog_title_bar_space_width\";s:3:\"150\";s:16:\"blog_breadcrumbs\";s:3:\"off\";s:25:\"post_content_under_header\";s:7:\"content\";s:19:\"post_content_layout\";s:10:\"full_fixed\";s:12:\"post_sidebar\";s:13:\"right-sidebar\";s:10:\"post_media\";s:2:\"on\";s:16:\"post_author_info\";s:2:\"on\";s:9:\"post_date\";s:2:\"on\";s:11:\"post_author\";s:2:\"on\";s:13:\"post_comments\";s:3:\"off\";s:9:\"post_cats\";s:3:\"off\";s:9:\"post_tags\";s:3:\"off\";s:15:\"post_navigation\";s:2:\"on\";s:10:\"post_title\";s:2:\"on\";s:23:\"post_title_bar_position\";s:7:\"outside\";s:22:\"post_title_bar_variant\";s:8:\"centered\";s:20:\"post_title_bar_width\";s:4:\"full\";s:20:\"post_title_bar_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:24:\"post_title_bar_image_fit\";s:5:\"cover\";s:23:\"post_title_bar_parallax\";s:2:\"on\";s:28:\"post_title_bar_parallax_type\";s:2:\"tb\";s:29:\"post_title_bar_parallax_speed\";s:4:\"1.00\";s:23:\"post_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#0b0b0b\";s:5:\"alpha\";s:3:\"0.5\";s:4:\"rgba\";s:18:\"rgba(11,11,11,0.5)\";}s:26:\"post_title_bar_title_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:22:\"post_title_bar_color_1\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:3:\"0.7\";s:4:\"rgba\";s:21:\"rgba(255,255,255,0.7)\";}s:26:\"post_title_bar_space_width\";s:3:\"230\";s:22:\"shop_custom_background\";s:3:\"off\";s:15:\"shop_body_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"shop_body_image_fit\";s:5:\"cover\";s:18:\"shop_body_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:11:\"shop_search\";s:3:\"off\";s:25:\"shop_content_under_header\";s:3:\"off\";s:19:\"shop_content_layout\";s:4:\"full\";s:12:\"shop_sidebar\";s:13:\"right-sidebar\";s:21:\"shop_products_variant\";s:7:\"overlay\";s:24:\"shop_products_subvariant\";s:6:\"center\";s:26:\"shop_products_second_image\";s:3:\"off\";s:25:\"shop_products_layout_mode\";s:7:\"packery\";s:21:\"shop_products_columns\";s:1:\"3\";s:22:\"shop_products_per_page\";s:2:\"12\";s:17:\"shop_brick_margin\";s:1:\"0\";s:14:\"shop_lazy_load\";s:2:\"on\";s:19:\"shop_lazy_load_mode\";s:4:\"auto\";s:10:\"shop_title\";s:2:\"on\";s:22:\"shop_title_bar_variant\";s:8:\"centered\";s:20:\"shop_title_bar_width\";s:4:\"full\";s:20:\"shop_title_bar_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:24:\"shop_title_bar_image_fit\";s:6:\"repeat\";s:23:\"shop_title_bar_parallax\";s:3:\"off\";s:28:\"shop_title_bar_parallax_type\";s:2:\"tb\";s:29:\"shop_title_bar_parallax_speed\";s:4:\"1.00\";s:23:\"shop_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#ededed\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(237,237,237,1)\";}s:26:\"shop_title_bar_title_color\";a:3:{s:5:\"color\";s:7:\"#202020\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(32,32,32,1)\";}s:22:\"shop_title_bar_color_1\";a:3:{s:5:\"color\";s:7:\"#7d7d7d\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(125,125,125,1)\";}s:26:\"shop_title_bar_space_width\";s:3:\"150\";s:16:\"shop_breadcrumbs\";s:2:\"on\";s:22:\"product_content_layout\";s:10:\"full_fixed\";s:15:\"product_sidebar\";s:3:\"off\";s:21:\"product_custom_thumbs\";s:2:\"on\";s:34:\"shop_no_major_pages_content_layout\";s:10:\"full_fixed\";s:25:\"shop_no_major_pages_title\";s:2:\"on\";s:37:\"shop_no_major_pages_title_bar_variant\";s:8:\"centered\";s:35:\"shop_no_major_pages_title_bar_width\";s:4:\"full\";s:35:\"shop_no_major_pages_title_bar_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:39:\"shop_no_major_pages_title_bar_image_fit\";s:6:\"repeat\";s:38:\"shop_no_major_pages_title_bar_parallax\";s:3:\"off\";s:43:\"shop_no_major_pages_title_bar_parallax_type\";s:2:\"tb\";s:44:\"shop_no_major_pages_title_bar_parallax_speed\";s:4:\"1.00\";s:38:\"shop_no_major_pages_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:41:\"shop_no_major_pages_title_bar_title_color\";a:3:{s:5:\"color\";s:7:\"#202020\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(32,32,32,1)\";}s:37:\"shop_no_major_pages_title_bar_color_1\";a:3:{s:5:\"color\";s:7:\"#1f1f1f\";s:5:\"alpha\";s:3:\"0.6\";s:4:\"rgba\";s:18:\"rgba(31,31,31,0.6)\";}s:41:\"shop_no_major_pages_title_bar_space_width\";s:2:\"80\";s:31:\"shop_no_major_pages_breadcrumbs\";s:2:\"on\";s:23:\"basket_sidebar_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:24:\"basket_sidebar_font_size\";s:2:\"13\";s:28:\"basket_sidebar_widgets_color\";s:13:\"light-sidebar\";s:20:\"button_shop_bg_color\";a:3:{s:5:\"color\";s:7:\"#222222\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(34,34,34,1)\";}s:26:\"button_shop_bg_hover_color\";a:3:{s:5:\"color\";s:7:\"#dd174a\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(221,23,74,1)\";}s:17:\"button_shop_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:23:\"button_shop_hover_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:24:\"button_shop_alt_bg_color\";a:3:{s:5:\"color\";s:7:\"#222222\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(34,34,34,1)\";}s:30:\"button_shop_alt_bg_hover_color\";a:3:{s:5:\"color\";s:7:\"#dd174a\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:17:\"rgba(221,23,74,1)\";}s:21:\"button_shop_alt_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:27:\"button_shop_alt_hover_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:21:\"button_shop_font_size\";s:2:\"13\";s:18:\"button_shop_weight\";s:3:\"600\";s:21:\"button_shop_transform\";s:4:\"none\";s:19:\"button_shop_padding\";a:3:{s:13:\"padding-right\";s:4:\"30px\";s:12:\"padding-left\";s:4:\"30px\";s:5:\"units\";s:2:\"px\";}s:13:\"page_comments\";s:3:\"off\";s:25:\"page_content_under_header\";s:3:\"off\";s:19:\"page_content_layout\";s:6:\"center\";s:12:\"page_sidebar\";s:3:\"off\";s:22:\"page_custom_background\";s:3:\"off\";s:15:\"page_body_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"page_body_image_fit\";s:5:\"cover\";s:18:\"page_body_bg_color\";a:3:{s:5:\"color\";s:0:\"\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:10:\"page_title\";s:2:\"on\";s:23:\"page_title_bar_position\";s:7:\"outside\";s:22:\"page_title_bar_variant\";s:7:\"classic\";s:20:\"page_title_bar_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:24:\"page_title_bar_image_fit\";s:6:\"repeat\";s:23:\"page_title_bar_parallax\";s:3:\"off\";s:28:\"page_title_bar_parallax_type\";s:2:\"tb\";s:29:\"page_title_bar_parallax_speed\";s:4:\"1.00\";s:23:\"page_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:26:\"page_title_bar_title_color\";a:3:{s:5:\"color\";s:0:\"\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:22:\"page_title_bar_color_1\";a:3:{s:5:\"color\";s:0:\"\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:26:\"page_title_bar_space_width\";s:2:\"40\";s:16:\"page_breadcrumbs\";s:2:\"on\";s:22:\"page_404_template_type\";s:7:\"default\";s:17:\"page_404_bg_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:27:\"page_password_template_type\";s:7:\"default\";s:22:\"page_password_bg_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:23:\"works_custom_background\";s:3:\"off\";s:16:\"works_body_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:20:\"works_body_image_fit\";s:5:\"cover\";s:19:\"works_body_bg_color\";a:3:{s:5:\"color\";s:7:\"#060606\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(6,6,6,1)\";}s:15:\"works_list_page\";s:4:\"2320\";s:31:\"works_list_content_under_header\";s:3:\"off\";s:27:\"works_list_work_how_to_open\";s:6:\"normal\";s:20:\"works_list_work_look\";s:7:\"overlay\";s:38:\"works_list_work_overlay_title_position\";s:10:\"mid_center\";s:29:\"works_list_work_overlay_cover\";s:3:\"off\";s:35:\"works_list_work_overlay_cover_hover\";s:2:\"on\";s:32:\"works_list_work_overlay_gradient\";s:3:\"off\";s:38:\"works_list_work_overlay_gradient_hover\";s:3:\"off\";s:29:\"works_list_work_overlay_texts\";s:3:\"off\";s:35:\"works_list_work_overlay_texts_hover\";s:2:\"on\";s:36:\"works_list_work_under_title_position\";s:6:\"center\";s:23:\"works_list_bricks_hover\";s:4:\"drop\";s:25:\"works_list_items_per_page\";s:2:\"12\";s:22:\"works_list_layout_mode\";s:7:\"packery\";s:24:\"works_list_brick_columns\";s:1:\"3\";s:27:\"works_list_bricks_max_width\";s:4:\"2000\";s:23:\"works_list_brick_margin\";s:1:\"0\";s:34:\"works_list_bricks_proportions_size\";s:3:\"4/3\";s:20:\"works_list_lazy_load\";s:2:\"on\";s:25:\"works_list_lazy_load_mode\";s:6:\"button\";s:21:\"works_list_categories\";s:3:\"off\";s:16:\"works_list_title\";s:3:\"off\";s:28:\"works_list_title_bar_variant\";s:8:\"centered\";s:26:\"works_list_title_bar_width\";s:4:\"full\";s:26:\"works_list_title_bar_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:30:\"works_list_title_bar_image_fit\";s:5:\"cover\";s:29:\"works_list_title_bar_parallax\";s:2:\"on\";s:34:\"works_list_title_bar_parallax_type\";s:2:\"tb\";s:35:\"works_list_title_bar_parallax_speed\";s:4:\"1.00\";s:29:\"works_list_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:32:\"works_list_title_bar_title_color\";a:3:{s:5:\"color\";s:7:\"#101010\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(16,16,16,1)\";}s:28:\"works_list_title_bar_color_1\";a:3:{s:5:\"color\";s:7:\"#727272\";s:5:\"alpha\";s:3:\"0.6\";s:4:\"rgba\";s:21:\"rgba(114,114,114,0.6)\";}s:32:\"works_list_title_bar_space_width\";s:3:\"100\";s:22:\"works_list_breadcrumbs\";s:2:\"on\";s:17:\"works_list_filter\";s:2:\"on\";s:25:\"works_list_filter_padding\";a:3:{s:11:\"padding-top\";s:4:\"40px\";s:14:\"padding-bottom\";s:4:\"40px\";s:5:\"units\";s:2:\"px\";}s:26:\"works_list_filter_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:19:\"rgba(255,255,255,0)\";}s:23:\"works_list_filter_color\";a:3:{s:5:\"color\";s:7:\"#c4c4c4\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(196,196,196,1)\";}s:29:\"works_list_filter_hover_color\";a:3:{s:5:\"color\";s:7:\"#333333\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:16:\"rgba(51,51,51,1)\";}s:24:\"works_list_filter_weight\";s:4:\"bold\";s:27:\"works_list_filter_transform\";s:9:\"uppercase\";s:28:\"works_list_filter_text_align\";s:6:\"center\";s:25:\"work_content_under_header\";s:3:\"off\";s:19:\"work_content_layout\";s:10:\"full_fixed\";s:23:\"work_content_categories\";s:2:\"on\";s:15:\"work_navigation\";s:2:\"on\";s:27:\"work_navigate_by_categories\";s:3:\"off\";s:18:\"work_similar_works\";s:3:\"off\";s:23:\"work_bricks_thumb_video\";s:3:\"off\";s:10:\"work_title\";s:2:\"on\";s:23:\"work_title_bar_position\";s:7:\"outside\";s:22:\"work_title_bar_variant\";s:8:\"centered\";s:20:\"work_title_bar_width\";s:4:\"full\";s:20:\"work_title_bar_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:24:\"work_title_bar_image_fit\";s:5:\"cover\";s:23:\"work_title_bar_parallax\";s:2:\"on\";s:28:\"work_title_bar_parallax_type\";s:2:\"tb\";s:29:\"work_title_bar_parallax_speed\";s:4:\"0.80\";s:23:\"work_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:3:\"0.7\";s:4:\"rgba\";s:15:\"rgba(0,0,0,0.7)\";}s:26:\"work_title_bar_title_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:22:\"work_title_bar_color_1\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:3:\"0.6\";s:4:\"rgba\";s:21:\"rgba(255,255,255,0.6)\";}s:26:\"work_title_bar_space_width\";s:3:\"200\";s:16:\"work_breadcrumbs\";s:3:\"off\";s:20:\"work_slider_autoplay\";s:2:\"on\";s:26:\"work_slider_slide_interval\";s:4:\"7000\";s:27:\"work_slider_transition_type\";s:1:\"2\";s:27:\"work_slider_transition_time\";s:3:\"600\";s:18:\"work_slider_thumbs\";s:2:\"on\";s:18:\"cpt_post_type_work\";s:4:\"work\";s:24:\"albums_custom_background\";s:2:\"on\";s:17:\"albums_body_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:21:\"albums_body_image_fit\";s:5:\"cover\";s:20:\"albums_body_bg_color\";a:3:{s:5:\"color\";s:7:\"#080808\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(8,8,8,1)\";}s:16:\"albums_list_page\";s:1:\"2\";s:32:\"albums_list_content_under_header\";s:3:\"off\";s:22:\"albums_list_album_look\";s:7:\"overlay\";s:40:\"albums_list_album_overlay_title_position\";s:11:\"bottom_left\";s:31:\"albums_list_album_overlay_cover\";s:3:\"off\";s:37:\"albums_list_album_overlay_cover_hover\";s:3:\"off\";s:34:\"albums_list_album_overlay_gradient\";s:3:\"off\";s:40:\"albums_list_album_overlay_gradient_hover\";s:2:\"on\";s:31:\"albums_list_album_overlay_texts\";s:3:\"off\";s:37:\"albums_list_album_overlay_texts_hover\";s:2:\"on\";s:38:\"albums_list_album_under_title_position\";s:6:\"center\";s:24:\"albums_list_bricks_hover\";s:5:\"shift\";s:26:\"albums_list_items_per_page\";s:2:\"12\";s:23:\"albums_list_layout_mode\";s:7:\"packery\";s:25:\"albums_list_brick_columns\";s:1:\"3\";s:28:\"albums_list_bricks_max_width\";s:4:\"2000\";s:24:\"albums_list_brick_margin\";s:1:\"0\";s:35:\"albums_list_bricks_proportions_size\";s:4:\"16/9\";s:21:\"albums_list_lazy_load\";s:2:\"on\";s:26:\"albums_list_lazy_load_mode\";s:4:\"auto\";s:22:\"albums_list_categories\";s:3:\"off\";s:17:\"albums_list_title\";s:3:\"off\";s:29:\"albums_list_title_bar_variant\";s:8:\"centered\";s:27:\"albums_list_title_bar_width\";s:4:\"full\";s:27:\"albums_list_title_bar_image\";a:9:{s:3:\"url\";s:70:\"https://tangoandmore.com/wp-content/uploads/2017/01/cropps-album13.jpg\";s:2:\"id\";s:5:\"11739\";s:6:\"height\";s:4:\"1218\";s:5:\"width\";s:4:\"1700\";s:9:\"thumbnail\";s:78:\"https://tangoandmore.com/wp-content/uploads/2017/01/cropps-album13-150x150.jpg\";s:5:\"title\";s:14:\"cropps-album13\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:31:\"albums_list_title_bar_image_fit\";s:5:\"cover\";s:30:\"albums_list_title_bar_parallax\";s:3:\"off\";s:35:\"albums_list_title_bar_parallax_type\";s:2:\"tb\";s:36:\"albums_list_title_bar_parallax_speed\";s:4:\"1.00\";s:30:\"albums_list_title_bar_bg_color\";a:3:{s:5:\"color\";s:7:\"#000000\";s:5:\"alpha\";s:3:\"0.7\";s:4:\"rgba\";s:15:\"rgba(0,0,0,0.7)\";}s:33:\"albums_list_title_bar_title_color\";a:3:{s:5:\"color\";s:0:\"\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:29:\"albums_list_title_bar_color_1\";a:3:{s:5:\"color\";s:0:\"\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:13:\"rgba(0,0,0,1)\";}s:33:\"albums_list_title_bar_space_width\";s:3:\"130\";s:23:\"albums_list_breadcrumbs\";s:2:\"on\";s:18:\"albums_list_filter\";s:2:\"on\";s:26:\"albums_list_filter_padding\";a:3:{s:11:\"padding-top\";s:4:\"40px\";s:14:\"padding-bottom\";s:4:\"40px\";s:5:\"units\";s:2:\"px\";}s:27:\"albums_list_filter_bg_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"0\";s:4:\"rgba\";s:19:\"rgba(255,255,255,0)\";}s:24:\"albums_list_filter_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:4:\"0.35\";s:4:\"rgba\";s:22:\"rgba(255,255,255,0.35)\";}s:30:\"albums_list_filter_hover_color\";a:3:{s:5:\"color\";s:7:\"#ffffff\";s:5:\"alpha\";s:1:\"1\";s:4:\"rgba\";s:19:\"rgba(255,255,255,1)\";}s:25:\"albums_list_filter_weight\";s:6:\"normal\";s:28:\"albums_list_filter_transform\";s:4:\"none\";s:29:\"albums_list_filter_text_align\";s:5:\"right\";s:26:\"album_content_under_header\";s:3:\"off\";s:13:\"album_content\";s:5:\"right\";s:19:\"album_content_title\";s:2:\"on\";s:24:\"album_content_categories\";s:2:\"on\";s:16:\"album_navigation\";s:2:\"on\";s:28:\"album_navigate_by_categories\";s:3:\"off\";s:24:\"album_bricks_thumb_video\";s:3:\"off\";s:19:\"album_bricks_filter\";s:2:\"on\";s:27:\"album_bricks_filter_padding\";a:3:{s:11:\"padding-top\";s:4:\"40px\";s:14:\"padding-bottom\";s:4:\"40px\";s:5:\"units\";s:2:\"px\";}s:28:\"album_bricks_filter_bg_color\";s:7:\"#0f0f0f\";s:25:\"album_bricks_filter_color\";s:7:\"#7a7a7a\";s:31:\"album_bricks_filter_hover_color\";s:7:\"#ffffff\";s:26:\"album_bricks_filter_weight\";s:4:\"bold\";s:29:\"album_bricks_filter_transform\";s:9:\"uppercase\";s:30:\"album_bricks_filter_text_align\";s:6:\"center\";s:21:\"album_slider_autoplay\";s:2:\"on\";s:27:\"album_slider_slide_interval\";i:2613;s:28:\"album_slider_transition_type\";s:1:\"2\";s:28:\"album_slider_transition_time\";s:3:\"600\";s:19:\"album_slider_thumbs\";s:2:\"on\";s:18:\"album_social_icons\";s:2:\"on\";s:16:\"album_share_type\";s:5:\"album\";s:19:\"cpt_post_type_album\";s:5:\"album\";s:10:\"custom_css\";s:77:\".elementor-counter .elementor-counter-number-suffix {\r\n    font-size: 55%;\r\n}\";s:15:\"custom_sidebars\";a:2:{i:0;a:2:{s:2:\"id\";s:18:\"apollo13-sidebar_1\";s:4:\"name\";s:16:\"Socials (Colors)\";}i:1;a:2:{s:2:\"id\";s:18:\"apollo13-sidebar_2\";s:4:\"name\";s:14:\"Socials (Dark)\";}}s:20:\"people_socials_color\";s:5:\"white\";s:26:\"people_socials_color_hover\";s:5:\"color\";s:19:\"a13ir_image_quality\";s:2:\"90\";s:14:\"anchors_in_bar\";s:3:\"off\";s:21:\"writing_effect_mobile\";s:3:\"off\";s:11:\"import_code\";s:0:\"\";s:11:\"import_link\";s:0:\"\";s:20:\"writing_effect_speed\";i:10;s:13:\"header_switch\";s:2:\"on\";s:11:\"top_message\";s:3:\"off\";s:25:\"header_menu_part_bg_color\";s:19:\"rgba(255,255,255,1)\";s:21:\"header_custom_sidebar\";s:3:\"off\";s:14:\"header_top_bar\";s:3:\"off\";s:19:\"header_menu_overlay\";s:3:\"off\";s:36:\"blog_horizontal_header_color_variant\";s:6:\"normal\";s:11:\"blog_filter\";s:3:\"off\";s:18:\"blog_filter_weight\";s:4:\"bold\";s:21:\"blog_filter_transform\";s:9:\"uppercase\";s:22:\"blog_filter_text_align\";s:6:\"center\";s:36:\"post_horizontal_header_color_variant\";s:6:\"normal\";s:36:\"shop_horizontal_header_color_variant\";s:6:\"normal\";s:26:\"shop_header_custom_sidebar\";s:3:\"off\";s:36:\"page_horizontal_header_color_variant\";s:6:\"normal\";s:42:\"works_list_horizontal_header_color_variant\";s:6:\"normal\";s:32:\"works_list_header_custom_sidebar\";s:3:\"off\";s:36:\"work_horizontal_header_color_variant\";s:6:\"normal\";s:43:\"albums_list_horizontal_header_color_variant\";s:6:\"normal\";s:33:\"albums_list_header_custom_sidebar\";s:3:\"off\";s:37:\"album_horizontal_header_color_variant\";s:6:\"normal\";s:32:\"header_sticky_menu_part_bg_color\";s:0:\"\";s:19:\"footer_privacy_link\";s:3:\"off\";s:10:\"logo_fonts\";a:3:{s:11:\"font-family\";s:83:\"-apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Helvetica, Arial, sans-serif\";s:12:\"word-spacing\";s:6:\"normal\";s:14:\"letter-spacing\";s:6:\"normal\";}s:20:\"lightbox_single_post\";s:3:\"off\";s:6:\"to_top\";s:2:\"on\";s:25:\"logo_image_normal_opacity\";s:4:\"1.00\";s:24:\"logo_image_hover_opacity\";s:4:\"0.50\";s:42:\"header_sticky_logo_image_max_desktop_width\";i:200;s:41:\"header_sticky_logo_image_max_mobile_width\";i:200;s:33:\"header_sticky_logo_padding_mobile\";a:3:{s:11:\"padding-top\";s:4:\"10px\";s:14:\"padding-bottom\";s:4:\"10px\";s:5:\"units\";s:2:\"px\";}s:14:\"blog_read_more\";s:2:\"on\";s:28:\"product_content_under_header\";s:3:\"off\";s:24:\"product_related_products\";s:2:\"on\";s:13:\"product_title\";s:2:\"on\";s:26:\"product_title_bar_position\";s:6:\"inside\";s:25:\"product_title_bar_variant\";s:7:\"classic\";s:23:\"product_title_bar_image\";s:0:\"\";s:27:\"product_title_bar_image_fit\";s:6:\"repeat\";s:26:\"product_title_bar_parallax\";s:3:\"off\";s:31:\"product_title_bar_parallax_type\";s:2:\"tb\";s:32:\"product_title_bar_parallax_speed\";s:4:\"1.00\";s:26:\"product_title_bar_bg_color\";s:0:\"\";s:29:\"product_title_bar_title_color\";s:0:\"\";s:25:\"product_title_bar_color_1\";s:0:\"\";s:29:\"product_title_bar_space_width\";s:2:\"40\";s:19:\"product_breadcrumbs\";s:2:\"on\";s:40:\"shop_no_major_pages_content_under_header\";s:3:\"off\";s:27:\"works_list_filter_font_size\";s:0:\"\";s:28:\"albums_list_filter_font_size\";s:0:\"\";s:29:\"album_bricks_filter_font_size\";s:0:\"\";s:16:\"scroll_to_anchor\";s:2:\"on\";}s:4:\"meta\";a:4:{s:4:\"post\";a:1:{s:20:\"content_under_header\";a:2:{s:12:\"global_value\";s:1:\"G\";s:13:\"parent_option\";s:25:\"post_content_under_header\";}}s:4:\"page\";a:3:{s:14:\"content_layout\";a:2:{s:12:\"global_value\";s:6:\"global\";s:13:\"parent_option\";s:19:\"page_content_layout\";}s:11:\"widget_area\";a:2:{s:12:\"global_value\";s:1:\"G\";s:13:\"parent_option\";s:12:\"page_sidebar\";}s:20:\"content_under_header\";a:2:{s:12:\"global_value\";s:1:\"G\";s:13:\"parent_option\";s:25:\"page_content_under_header\";}}s:5:\"album\";a:5:{s:13:\"album_content\";a:2:{s:12:\"global_value\";s:1:\"G\";s:13:\"parent_option\";s:13:\"album_content\";}s:8:\"autoplay\";a:2:{s:12:\"global_value\";s:1:\"G\";s:13:\"parent_option\";s:21:\"album_slider_autoplay\";}s:10:\"transition\";a:2:{s:12:\"global_value\";s:2:\"-1\";s:13:\"parent_option\";s:28:\"album_slider_transition_type\";}s:6:\"thumbs\";a:2:{s:12:\"global_value\";s:1:\"G\";s:13:\"parent_option\";s:19:\"album_slider_thumbs\";}s:20:\"content_under_header\";a:2:{s:12:\"global_value\";s:1:\"G\";s:13:\"parent_option\";s:26:\"album_content_under_header\";}}s:4:\"work\";a:6:{s:8:\"autoplay\";a:2:{s:12:\"global_value\";s:1:\"G\";s:13:\"parent_option\";s:20:\"work_slider_autoplay\";}s:10:\"transition\";a:2:{s:12:\"global_value\";s:2:\"-1\";s:13:\"parent_option\";s:27:\"work_slider_transition_type\";}s:6:\"thumbs\";a:2:{s:12:\"global_value\";s:1:\"G\";s:13:\"parent_option\";s:18:\"work_slider_thumbs\";}s:14:\"content_layout\";a:2:{s:12:\"global_value\";s:6:\"global\";s:13:\"parent_option\";s:19:\"work_content_layout\";}s:20:\"content_under_header\";a:2:{s:12:\"global_value\";s:1:\"G\";s:13:\"parent_option\";s:25:\"work_content_under_header\";}s:18:\"content_categories\";a:2:{s:12:\"global_value\";s:1:\"G\";s:13:\"parent_option\";s:23:\"work_content_categories\";}}}s:7:\"version\";s:6:\"2.4.21\";}", "auto");
INSERT INTO `wp_options` VALUES("4176", "_transient_woocommerce_product_task_product_count_transient", "0", "on");
INSERT INTO `wp_options` VALUES("4338", "_wpforms_transient_timeout_addons.json", "1836880155", "off");
INSERT INTO `wp_options` VALUES("4339", "_wpforms_transient_addons.json", "1836275355", "off");
INSERT INTO `wp_options` VALUES("4340", "_wpforms_transient_wpforms_htaccess_file", "a:3:{s:4:\"size\";i:754;s:5:\"mtime\";i:1736442027;s:5:\"ctime\";i:1736442027;}", "on");
INSERT INTO `wp_options` VALUES("4341", "_wpforms_transient_wpforms_/data/sites/web/tangoandmorecom/www/wp-content/uploads/wpforms/cache/.htaccess_file", "a:3:{s:4:\"size\";i:463;s:5:\"mtime\";i:1736442027;s:5:\"ctime\";i:1736442027;}", "on");
INSERT INTO `wp_options` VALUES("4342", "_wpforms_transient_timeout_docs.json", "1836880155", "off");
INSERT INTO `wp_options` VALUES("4343", "_wpforms_transient_docs.json", "1836275355", "off");
INSERT INTO `wp_options` VALUES("4344", "_wpforms_transient_timeout_templates.json", "1836880155", "off");
INSERT INTO `wp_options` VALUES("4345", "_wpforms_transient_templates.json", "1836275355", "off");
INSERT INTO `wp_options` VALUES("4346", "wpforms_builder_opened_date", "1736442029", "off");
INSERT INTO `wp_options` VALUES("4347", "wpforms_templates_hash", "ba539bede5ae2cea68b54794fecd5035", "auto");
INSERT INTO `wp_options` VALUES("5831", "woocommerce_task_list_reminder_bar_hidden", "yes", "auto");
INSERT INTO `wp_options` VALUES("7998", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:32:\"fernandoycarolinatango@gmail.com\";s:7:\"version\";s:5:\"6.8.2\";s:9:\"timestamp\";i:1752605005;}", "off");
INSERT INTO `wp_options` VALUES("29510", "_transient_wc_count_comments", "O:8:\"stdClass\":7:{s:14:\"total_comments\";i:15;s:3:\"all\";i:15;s:8:\"approved\";s:2:\"10\";s:9:\"moderated\";s:1:\"5\";s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "on");
INSERT INTO `wp_options` VALUES("30272", "duplicator_version_plugin", "1.5.12", "auto");
INSERT INTO `wp_options` VALUES("30274", "duplicator_install_info", "a:3:{s:7:\"version\";s:6:\"1.5.12\";s:4:\"time\";i:1752507452;s:10:\"updateTime\";i:1752507452;}", "off");
INSERT INTO `wp_options` VALUES("30275", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wp_options` VALUES("30276", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wp_options` VALUES("30277", "duplicator_settings", "a:20:{s:7:\"version\";s:6:\"1.5.12\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;s:14:\"usage_tracking\";b:0;i:0;b:0;}", "auto");
INSERT INTO `wp_options` VALUES("30278", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"_xu_nD1Z4JIu41UlEs3-rohlnuxXnT86KTBb1m+NQ1m7\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 328.52,\n    \"siteNumFiles\": 18516,\n    \"siteDbSizeMB\": 10.7,\n    \"siteDbNumTables\": 63\n}", "auto");
INSERT INTO `wp_options` VALUES("30280", "duplicator_notifications", "a:4:{s:6:\"update\";i:1836275358;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("30427", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("31287", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "auto");
INSERT INTO `wp_options` VALUES("42387", "_site_transient_timeout_woocommerce_blocks_patterns", "1838867354", "off");
INSERT INTO `wp_options` VALUES("42388", "_site_transient_woocommerce_blocks_patterns", "a:2:{s:7:\"version\";s:5:\"9.5.1\";s:8:\"patterns\";a:38:{i:0;a:11:{s:5:\"title\";s:6:\"Banner\";s:4:\"slug\";s:25:\"woocommerce-blocks/banner\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:86:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/banner.php\";}i:1;a:11:{s:5:\"title\";s:23:\"Coming Soon Entire Site\";s:4:\"slug\";s:35:\"woocommerce/coming-soon-entire-site\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:103:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/coming-soon-entire-site.php\";}i:2;a:11:{s:5:\"title\";s:22:\"Coming Soon Store Only\";s:4:\"slug\";s:34:\"woocommerce/coming-soon-store-only\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:102:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/coming-soon-store-only.php\";}i:3;a:11:{s:5:\"title\";s:11:\"Coming Soon\";s:4:\"slug\";s:23:\"woocommerce/coming-soon\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:91:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/coming-soon.php\";}i:4;a:11:{s:5:\"title\";s:29:\"Content right with image left\";s:4:\"slug\";s:48:\"woocommerce-blocks/content-right-with-image-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:104:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/content-right-image-left.php\";}i:5;a:11:{s:5:\"title\";s:29:\"Featured Category Cover Image\";s:4:\"slug\";s:48:\"woocommerce-blocks/featured-category-cover-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:109:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/featured-category-cover-image.php\";}i:6;a:11:{s:5:\"title\";s:24:\"Featured Category Triple\";s:4:\"slug\";s:43:\"woocommerce-blocks/featured-category-triple\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:104:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/featured-category-triple.php\";}i:7;a:11:{s:5:\"title\";s:15:\"Product Filters\";s:4:\"slug\";s:34:\"woocommerce-blocks/product-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:108:\"woocommerce/active-filters, woocommerce/price-filter, woocommerce/attribute-filter, woocommerce/stock-filter\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:87:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/filters.php\";}i:8;a:11:{s:5:\"title\";s:12:\"Large Footer\";s:4:\"slug\";s:31:\"woocommerce-blocks/footer-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:92:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/footer-large.php\";}i:9;a:11:{s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"slug\";s:37:\"woocommerce-blocks/footer-simple-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:98:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/footer-simple-menu.php\";}i:10;a:11:{s:5:\"title\";s:17:\"Footer with menus\";s:4:\"slug\";s:38:\"woocommerce-blocks/footer-with-3-menus\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:99:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/footer-with-3-menus.php\";}i:11;a:11:{s:5:\"title\";s:28:\"Four Image Grid Content Left\";s:4:\"slug\";s:47:\"woocommerce-blocks/form-image-grid-content-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:108:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/four-image-grid-content-left.php\";}i:12;a:11:{s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"slug\";s:39:\"woocommerce-blocks/header-centered-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:103:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/header-centered-pattern.php\";}i:13;a:11:{s:5:\"title\";s:23:\"Distraction Free Header\";s:4:\"slug\";s:42:\"woocommerce-blocks/header-distraction-free\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:103:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/header-distraction-free.php\";}i:14;a:11:{s:5:\"title\";s:16:\"Essential Header\";s:4:\"slug\";s:35:\"woocommerce-blocks/header-essential\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:96:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/header-essential.php\";}i:15;a:11:{s:5:\"title\";s:12:\"Large Header\";s:4:\"slug\";s:31:\"woocommerce-blocks/header-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:92:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/header-large.php\";}i:16;a:11:{s:5:\"title\";s:14:\"Minimal Header\";s:4:\"slug\";s:33:\"woocommerce-blocks/header-minimal\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:94:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/header-minimal.php\";}i:17;a:11:{s:5:\"title\";s:47:\"Heading with three columns of content with link\";s:4:\"slug\";s:66:\"woocommerce-blocks/heading-with-three-columns-of-content-with-link\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:127:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/heading-with-three-columns-of-content-with-link.php\";}i:18;a:11:{s:5:\"title\";s:20:\"Hero Product 3 Split\";s:4:\"slug\";s:39:\"woocommerce-blocks/hero-product-3-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:100:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/hero-product-3-split.php\";}i:19;a:11:{s:5:\"title\";s:23:\"Hero Product Chessboard\";s:4:\"slug\";s:42:\"woocommerce-blocks/hero-product-chessboard\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:103:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/hero-product-chessboard.php\";}i:20;a:11:{s:5:\"title\";s:18:\"Hero Product Split\";s:4:\"slug\";s:37:\"woocommerce-blocks/hero-product-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:98:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/hero-product-split.php\";}i:21;a:11:{s:5:\"title\";s:33:\"Centered content with image below\";s:4:\"slug\";s:52:\"woocommerce-blocks/centered-content-with-image-below\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:119:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/intro-centered-content-with-image-below.php\";}i:22;a:11:{s:5:\"title\";s:22:\"Just Arrived Full Hero\";s:4:\"slug\";s:41:\"woocommerce-blocks/just-arrived-full-hero\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:102:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/just-arrived-full-hero.php\";}i:23;a:11:{s:5:\"title\";s:33:\"No Products Found - Clear Filters\";s:4:\"slug\";s:43:\"woocommerce/no-products-found-clear-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:105:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/no-products-found-filters.php\";}i:24;a:11:{s:5:\"title\";s:17:\"No Products Found\";s:4:\"slug\";s:29:\"woocommerce/no-products-found\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:97:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/no-products-found.php\";}i:25;a:11:{s:5:\"title\";s:19:\"Default Coming Soon\";s:4:\"slug\";s:36:\"woocommerce/page-coming-soon-default\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:31:\"coming-soon-newsletter-template\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:104:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/page-coming-soon-default.php\";}i:26;a:11:{s:5:\"title\";s:34:\"Coming Soon With Header and Footer\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-with-header-footer\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:31:\"coming-soon-newsletter-template\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:115:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/page-coming-soon-with-header-footer.php\";}i:27;a:11:{s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:108:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/product-collection-3-columns.php\";}i:28;a:11:{s:5:\"title\";s:28:\"Product Collection 4 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-4-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:108:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/product-collection-4-columns.php\";}i:29;a:11:{s:5:\"title\";s:28:\"Product Collection 5 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:108:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/product-collection-5-columns.php\";}i:30;a:11:{s:5:\"title\";s:47:\"Product Collection: Featured Products 5 Columns\";s:4:\"slug\";s:65:\"woocommerce-blocks/product-collection-featured-products-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:126:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/product-collection-featured-products-5-columns.php\";}i:31;a:11:{s:5:\"title\";s:15:\"Product Gallery\";s:4:\"slug\";s:48:\"woocommerce-blocks/product-query-product-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:36:\"core/query/woocommerce/product-query\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:109:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/product-query-product-gallery.php\";}i:32;a:11:{s:5:\"title\";s:14:\"Product Search\";s:4:\"slug\";s:31:\"woocommerce/product-search-form\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:99:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/product-search-form.php\";}i:33;a:11:{s:5:\"title\";s:16:\"Related Products\";s:4:\"slug\";s:35:\"woocommerce-blocks/related-products\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:96:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/related-products.php\";}i:34;a:11:{s:5:\"title\";s:33:\"Social: Follow us on social media\";s:4:\"slug\";s:51:\"woocommerce-blocks/social-follow-us-in-social-media\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:25:\"WooCommerce, social-media\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:112:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/social-follow-us-in-social-media.php\";}i:35;a:11:{s:5:\"title\";s:22:\"Testimonials 3 Columns\";s:4:\"slug\";s:41:\"woocommerce-blocks/testimonials-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:102:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/testimonials-3-columns.php\";}i:36;a:11:{s:5:\"title\";s:19:\"Testimonials Single\";s:4:\"slug\";s:38:\"woocommerce-blocks/testimonials-single\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:99:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/testimonials-single.php\";}i:37;a:11:{s:5:\"title\";s:37:\"Three columns with images and content\";s:4:\"slug\";s:56:\"woocommerce-blocks/three-columns-with-images-and-content\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:117:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins/woocommerce/patterns/three-columns-with-images-and-content.php\";}}}", "off");
INSERT INTO `wp_options` VALUES("42390", "_transient_timeout_elementor_remote_info_api_data_3.26.3", "1836282555", "off");
INSERT INTO `wp_options` VALUES("42391", "_transient_elementor_remote_info_api_data_3.26.3", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("42395", "_transient_timeout__woocommerce_helper_subscriptions", "1836276255", "off");
INSERT INTO `wp_options` VALUES("42396", "_transient__woocommerce_helper_subscriptions", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("42397", "_site_transient_timeout_theme_roots", "1836277155", "off");
INSERT INTO `wp_options` VALUES("42398", "_site_transient_theme_roots", "a:5:{s:10:\"extendable\";s:7:\"/themes\";s:9:\"rife-free\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("42399", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1836275357;s:7:\"checked\";a:5:{s:10:\"extendable\";s:6:\"2.0.15\";s:9:\"rife-free\";s:6:\"2.4.21\";s:16:\"twentytwentyfive\";s:3:\"1.0\";s:16:\"twentytwentyfour\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.6\";}s:8:\"response\";a:2:{s:10:\"extendable\";a:6:{s:5:\"theme\";s:10:\"extendable\";s:11:\"new_version\";s:6:\"2.0.29\";s:3:\"url\";s:40:\"https://wordpress.org/themes/extendable/\";s:7:\"package\";s:58:\"http://downloads.wordpress.org/theme/extendable.2.0.29.zip\";s:8:\"requires\";s:3:\"6.6\";s:12:\"requires_php\";s:3:\"7.4\";}s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:61:\"http://downloads.wordpress.org/theme/twentytwentyfive.1.3.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}}s:9:\"no_update\";a:3:{s:9:\"rife-free\";a:6:{s:5:\"theme\";s:9:\"rife-free\";s:11:\"new_version\";s:6:\"2.4.21\";s:3:\"url\";s:39:\"https://wordpress.org/themes/rife-free/\";s:7:\"package\";s:57:\"http://downloads.wordpress.org/theme/rife-free.2.4.21.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.3.0\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:61:\"http://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:62:\"http://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("42400", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1836275357;s:8:\"response\";a:11:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"5.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:53:\"http://downloads.wordpress.org/plugin/akismet.5.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}}s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";O:8:\"stdClass\":14:{s:2:\"id\";s:33:\"w.org/plugins/all-in-one-seo-pack\";s:4:\"slug\";s:19:\"all-in-one-seo-pack\";s:6:\"plugin\";s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";s:11:\"new_version\";s:5:\"4.8.7\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/all-in-one-seo-pack/\";s:7:\"package\";s:61:\"http://downloads.wordpress.org/plugin/all-in-one-seo-pack.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:64:\"https://ps.w.org/all-in-one-seo-pack/assets/icon.svg?rev=2443290\";s:3:\"svg\";s:64:\"https://ps.w.org/all-in-one-seo-pack/assets/icon.svg?rev=2443290\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/all-in-one-seo-pack/assets/banner-1544x500.png?rev=3310686\";s:2:\"1x\";s:74:\"https://ps.w.org/all-in-one-seo-pack/assets/banner-772x250.png?rev=3310686\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.4\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}s:14:\"upgrade_notice\";s:57:\"<p>This update adds major improvements and bug fixes.</p>\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:8:\"1.5.13.3\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:61:\"http://downloads.wordpress.org/plugin/duplicator.1.5.13.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.32.2\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:58:\"http://downloads.wordpress.org/plugin/elementor.3.32.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:23:\"extendify/extendify.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/extendify\";s:4:\"slug\";s:9:\"extendify\";s:6:\"plugin\";s:23:\"extendify/extendify.php\";s:11:\"new_version\";s:5:\"2.0.5\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/extendify/\";s:7:\"package\";s:57:\"http://downloads.wordpress.org/plugin/extendify.2.0.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/extendify/assets/icon-256x256.png?rev=2653704\";s:2:\"1x\";s:62:\"https://ps.w.org/extendify/assets/icon-128x128.png?rev=2653704\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/extendify/assets/banner-1544x500.png?rev=2653704\";s:2:\"1x\";s:64:\"https://ps.w.org/extendify/assets/banner-772x250.png?rev=2653704\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"7.0\";s:16:\"requires_plugins\";a:0:{}}s:41:\"image-optimization/image-optimization.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:32:\"w.org/plugins/image-optimization\";s:4:\"slug\";s:18:\"image-optimization\";s:6:\"plugin\";s:41:\"image-optimization/image-optimization.php\";s:11:\"new_version\";s:5:\"1.6.8\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/image-optimization/\";s:7:\"package\";s:66:\"http://downloads.wordpress.org/plugin/image-optimization.1.6.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/image-optimization/assets/icon-256x256.gif?rev=3308421\";s:2:\"1x\";s:71:\"https://ps.w.org/image-optimization/assets/icon-256x256.gif?rev=3308421\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/image-optimization/assets/banner-1544x500.png?rev=3018769\";s:2:\"1x\";s:73:\"https://ps.w.org/image-optimization/assets/banner-772x250.png?rev=3018769\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.2\";s:6:\"tested\";s:5:\"6.7.3\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:55:\"iubenda-cookie-law-solution/iubenda_cookie_solution.php\";O:8:\"stdClass\":14:{s:2:\"id\";s:41:\"w.org/plugins/iubenda-cookie-law-solution\";s:4:\"slug\";s:27:\"iubenda-cookie-law-solution\";s:6:\"plugin\";s:55:\"iubenda-cookie-law-solution/iubenda_cookie_solution.php\";s:11:\"new_version\";s:6:\"3.12.4\";s:3:\"url\";s:58:\"https://wordpress.org/plugins/iubenda-cookie-law-solution/\";s:7:\"package\";s:76:\"http://downloads.wordpress.org/plugin/iubenda-cookie-law-solution.3.12.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/iubenda-cookie-law-solution/assets/icon-256x256.gif?rev=2728697\";s:2:\"1x\";s:80:\"https://ps.w.org/iubenda-cookie-law-solution/assets/icon-128x128.gif?rev=2728697\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:83:\"https://ps.w.org/iubenda-cookie-law-solution/assets/banner-1544x500.png?rev=2728697\";s:2:\"1x\";s:82:\"https://ps.w.org/iubenda-cookie-law-solution/assets/banner-772x250.png?rev=2728697\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:5:\"7.0.0\";s:16:\"requires_plugins\";a:0:{}s:14:\"upgrade_notice\";s:119:\"<ul>\n<li>Fixed: Prevented multiple unnecessary scans by enforcing a 3-week interval for configuration reload</li>\n</ul>\";}s:55:\"rife-elementor-extensions/rife-elementor-extensions.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:39:\"w.org/plugins/rife-elementor-extensions\";s:4:\"slug\";s:25:\"rife-elementor-extensions\";s:6:\"plugin\";s:55:\"rife-elementor-extensions/rife-elementor-extensions.php\";s:11:\"new_version\";s:5:\"1.2.7\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/rife-elementor-extensions/\";s:7:\"package\";s:67:\"http://downloads.wordpress.org/plugin/rife-elementor-extensions.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/rife-elementor-extensions/assets/icon-256x256.jpg?rev=1916344\";s:2:\"1x\";s:78:\"https://ps.w.org/rife-elementor-extensions/assets/icon-128x128.jpg?rev=1916344\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:81:\"https://ps.w.org/rife-elementor-extensions/assets/banner-1544x500.jpg?rev=1982742\";s:2:\"1x\";s:80:\"https://ps.w.org/rife-elementor-extensions/assets/banner-772x250.jpg?rev=1982742\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";s:6:\"tested\";s:5:\"6.7.3\";s:12:\"requires_php\";s:3:\"5.4\";s:16:\"requires_plugins\";a:0:{}}s:55:\"searchwp-live-ajax-search/searchwp-live-ajax-search.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:39:\"w.org/plugins/searchwp-live-ajax-search\";s:4:\"slug\";s:25:\"searchwp-live-ajax-search\";s:6:\"plugin\";s:55:\"searchwp-live-ajax-search/searchwp-live-ajax-search.php\";s:11:\"new_version\";s:5:\"1.8.6\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/searchwp-live-ajax-search/\";s:7:\"package\";s:73:\"http://downloads.wordpress.org/plugin/searchwp-live-ajax-search.1.8.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/searchwp-live-ajax-search/assets/icon-256x256.png?rev=3119393\";s:2:\"1x\";s:78:\"https://ps.w.org/searchwp-live-ajax-search/assets/icon-128x128.png?rev=3119393\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:81:\"https://ps.w.org/searchwp-live-ajax-search/assets/banner-1544x500.png?rev=3119393\";s:2:\"1x\";s:80:\"https://ps.w.org/searchwp-live-ajax-search/assets/banner-772x250.png?rev=3119393\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.8\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"5.6\";s:16:\"requires_plugins\";a:0:{}}s:27:\"woocommerce/woocommerce.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:25:\"w.org/plugins/woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:6:\"plugin\";s:27:\"woocommerce/woocommerce.php\";s:11:\"new_version\";s:6:\"10.2.1\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/woocommerce/\";s:7:\"package\";s:60:\"http://downloads.wordpress.org/plugin/woocommerce.10.2.1.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";s:3:\"svg\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=3234504\";s:2:\"1x\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=3234504\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.7\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:24:\"wpforms-lite/wpforms.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:26:\"w.org/plugins/wpforms-lite\";s:4:\"slug\";s:12:\"wpforms-lite\";s:6:\"plugin\";s:24:\"wpforms-lite/wpforms.php\";s:11:\"new_version\";s:7:\"1.9.8.1\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wpforms-lite/\";s:7:\"package\";s:62:\"http://downloads.wordpress.org/plugin/wpforms-lite.1.9.8.1.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:57:\"https://ps.w.org/wpforms-lite/assets/icon.svg?rev=3254748\";s:3:\"svg\";s:57:\"https://ps.w.org/wpforms-lite/assets/icon.svg?rev=3254748\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/wpforms-lite/assets/banner-1544x500.png?rev=3091364\";s:2:\"1x\";s:67:\"https://ps.w.org/wpforms-lite/assets/banner-772x250.png?rev=3091364\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/wpforms-lite/assets/banner-1544x500-rtl.png?rev=3254748\";s:2:\"1x\";s:71:\"https://ps.w.org/wpforms-lite/assets/banner-772x250-rtl.png?rev=3254748\";}s:8:\"requires\";s:3:\"5.5\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:3:{s:63:\"apollo13-framework-extensions/apollo13-framework-extensions.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:43:\"w.org/plugins/apollo13-framework-extensions\";s:4:\"slug\";s:29:\"apollo13-framework-extensions\";s:6:\"plugin\";s:63:\"apollo13-framework-extensions/apollo13-framework-extensions.php\";s:11:\"new_version\";s:5:\"1.9.8\";s:3:\"url\";s:60:\"https://wordpress.org/plugins/apollo13-framework-extensions/\";s:7:\"package\";s:71:\"http://downloads.wordpress.org/plugin/apollo13-framework-extensions.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:82:\"https://ps.w.org/apollo13-framework-extensions/assets/icon-256x256.png?rev=1854162\";s:2:\"1x\";s:82:\"https://ps.w.org/apollo13-framework-extensions/assets/icon-128x128.png?rev=1854162\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";}s:9:\"hello.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:59:\"http://downloads.wordpress.org/plugin/hello-dolly.1.7.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582\";s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}s:33:\"duplicate-post/duplicate-post.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/duplicate-post\";s:4:\"slug\";s:14:\"duplicate-post\";s:6:\"plugin\";s:33:\"duplicate-post/duplicate-post.php\";s:11:\"new_version\";s:3:\"4.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-post/\";s:7:\"package\";s:60:\"http://downloads.wordpress.org/plugin/duplicate-post.4.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-256x256.png?rev=2336666\";s:2:\"1x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-128x128.png?rev=2336666\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/duplicate-post/assets/banner-1544x500.png?rev=2336666\";s:2:\"1x\";s:69:\"https://ps.w.org/duplicate-post/assets/banner-772x250.png?rev=2336666\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}}s:7:\"checked\";a:15:{s:19:\"akismet/akismet.php\";s:5:\"5.3.5\";s:43:\"all-in-one-seo-pack/all_in_one_seo_pack.php\";s:5:\"4.7.7\";s:63:\"apollo13-framework-extensions/apollo13-framework-extensions.php\";s:5:\"1.9.8\";s:25:\"duplicator/duplicator.php\";s:6:\"1.5.12\";s:23:\"elementor/elementor.php\";s:6:\"3.26.3\";s:23:\"extendify/extendify.php\";s:6:\"1.16.0\";s:9:\"hello.php\";s:5:\"1.7.2\";s:41:\"image-optimization/image-optimization.php\";s:5:\"1.6.3\";s:55:\"iubenda-cookie-law-solution/iubenda_cookie_solution.php\";s:6:\"3.11.3\";s:55:\"rife-elementor-extensions/rife-elementor-extensions.php\";s:5:\"1.2.5\";s:55:\"searchwp-live-ajax-search/searchwp-live-ajax-search.php\";s:5:\"1.8.3\";s:31:\"01-ext-amenpt/01-ext-amenpt.php\";s:5:\"1.0.0\";s:27:\"woocommerce/woocommerce.php\";s:5:\"9.5.1\";s:24:\"wpforms-lite/wpforms.php\";s:7:\"1.9.2.3\";s:33:\"duplicate-post/duplicate-post.php\";s:3:\"4.5\";}}", "off");
INSERT INTO `wp_options` VALUES("42401", "_transient_timeout_woocommerce_admin_payment_gateway_suggestions_specs", "1836880157", "off");
INSERT INTO `wp_options` VALUES("42402", "_transient_woocommerce_admin_payment_gateway_suggestions_specs", "a:1:{s:5:\"pt_PT\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("42403", "_transient_timeout_woocommerce_admin_remote_free_extensions_specs", "1836880157", "off");
INSERT INTO `wp_options` VALUES("42404", "_transient_woocommerce_admin_remote_free_extensions_specs", "a:1:{s:5:\"pt_PT\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("42405", "_transient_timeout_woocommerce_admin_remote_inbox_notifications_specs", "1836880158", "off");
INSERT INTO `wp_options` VALUES("42406", "_transient_woocommerce_admin_remote_inbox_notifications_specs", "a:1:{s:5:\"pt_PT\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("42408", "_site_transient_timeout_wp_theme_files_patterns-28a642a5b8916315f6023e550105a04f", "1836277158", "off");
INSERT INTO `wp_options` VALUES("42409", "_site_transient_wp_theme_files_patterns-28a642a5b8916315f6023e550105a04f", "a:2:{s:7:\"version\";s:6:\"2.4.21\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("42414", "_elementor_assets_data", "a:1:{s:3:\"svg\";a:1:{s:9:\"font-icon\";a:2:{s:18:\"eicon-chevron-left\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"path\";s:281:\"M646 125C629 125 613 133 604 142L308 442C296 454 292 471 292 487 292 504 296 521 308 533L604 854C617 867 629 875 646 875 663 875 679 871 692 858 704 846 713 829 713 812 713 796 708 779 692 767L438 487 692 225C700 217 708 204 708 187 708 171 704 154 692 142 675 129 663 125 646 125Z\";s:3:\"key\";s:18:\"eicon-chevron-left\";}s:7:\"version\";s:6:\"5.13.0\";}s:19:\"eicon-chevron-right\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"path\";s:281:\"M696 533C708 521 713 504 713 487 713 471 708 454 696 446L400 146C388 133 375 125 354 125 338 125 325 129 313 142 300 154 292 171 292 187 292 204 296 221 308 233L563 492 304 771C292 783 288 800 288 817 288 833 296 850 308 863 321 871 338 875 354 875 371 875 388 867 400 854L696 533Z\";s:3:\"key\";s:19:\"eicon-chevron-right\";}s:7:\"version\";s:6:\"5.13.0\";}}}}", "auto");
INSERT INTO `wp_options` VALUES("42443", "_transient_timeout_extendify_recommendations", "1768932677", "off");
INSERT INTO `wp_options` VALUES("42444", "_transient_extendify_recommendations", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("42445", "_transient_timeout_extendify_supportArticles", "1768932677", "off");
INSERT INTO `wp_options` VALUES("42446", "_transient_extendify_supportArticles", "a:70:{i:0;a:5:{s:2:\"id\";i:281;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:22:\"wordpress-block-editor\";s:5:\"title\";s:26:\"Editor de Blocos WordPress\";s:7:\"summary\";s:446:\"O editor de blocos do WordPress, também conhecido como editor Gutenberg, é o editor por omissão no WordPress desde a versão 5.0. Permite aos utilizadores criar conteúdo usando blocos, que são diferentes elementos de conteúdo como parágrafos, imagens, vídeos e mais. O editor de blocos tem uma barra de ferramentas superior, uma barra lateral com opções, e uma área de conteúdo onde os utilizadores podem adicionar e organizar blocos.\";}i:1;a:5:{s:2:\"id\";i:295;s:4:\"cats\";a:1:{i:0;s:17:\"site-wide-changes\";}s:4:\"slug\";s:11:\"site-editor\";s:5:\"title\";s:14:\"Editor do site\";s:7:\"summary\";s:826:\"O Editor do site permite-lhe criar o design do seu site inteiro, incluindo o cabeçalho, rodapé e tudo o que está entre eles, utilizando blocos. Só está disponível quando instala e activa um tema de blocos no seu site. Para aceder ao Editor do site, vá a Aparência > Editor e selecione a opção Editor do site. A partir daí, pode procurar os seus menus, alterar estilos, editar páginas, avaliar modelos e gerir padrões. O Editor do site também inclui ferramentas como a Paleta de Comandos, Visualização em Lista e Padrões de Blocos para ajudá-lo a personalizar o seu site. Pode exportar o seu tema com as alterações que fez no Editor do site, e também existem ferramentas úteis como copiar e colar estilos, aplicar alterações de estilo globalmente e redimensionar a pré-visualização do Editor do site.\";}i:2;a:5:{s:2:\"id\";i:304;s:4:\"cats\";a:1:{i:0;s:6:\"themes\";}s:4:\"slug\";s:16:\"work-with-themes\";s:5:\"title\";s:22:\"Visão geral dos temas\";s:7:\"summary\";s:329:\"Um Tema WordPress é uma coleção de ficheiros que trabalham em conjunto para criar o design visual e o layout de um site. Inclui ficheiros de modelo, ficheiros de imagem, folhas de estilo e ficheiros de código. Os temas podem ser personalizados para criar diferentes aparências para diferentes páginas e categorias num site.\";}i:3;a:5:{s:2:\"id\";i:308;s:4:\"cats\";a:1:{i:0;s:8:\"blogging\";}s:4:\"slug\";s:24:\"introduction-to-blogging\";s:5:\"title\";s:24:\"Introdução ao Blogging\";s:7:\"summary\";s:443:\"Blogar é o ato de partilhar regularmente informações através de blogs na internet. Um blog é um site que apresenta comentários do tipo diário e ligações para artigos, e um blogger é uma pessoa que possui ou mantém um blog. A qualidade do blogar é determinada pelo conteúdo e pelos comentários, sendo importante para os bloggers atualizarem regularmente o seu conteúdo e interagirem com os seus leitores através de comentários.\";}i:4;a:5:{s:2:\"id\";i:282;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:11:\"blocks-list\";s:5:\"title\";s:23:\"Visão geral dos blocos\";s:7:\"summary\";s:354:\"O editor de blocos do WordPress permite que os utilizadores adicionem e personalizem conteúdo usando diferentes blocos. Existem vários tipos de blocos disponíveis, incluindo texto, multimédia, design, widgets, tema e incorporações. Os utilizadores também podem instalar blocos adicionais de terceiros a partir do diretório de blocos do WordPress.\";}i:5;a:5:{s:2:\"id\";i:296;s:4:\"cats\";a:1:{i:0;s:17:\"site-wide-changes\";}s:4:\"slug\";s:15:\"styles-overview\";s:5:\"title\";s:16:\"Editor de estilo\";s:7:\"summary\";s:728:\"Styles é um novo recurso no WordPress que permite definir a estética geral e o layout do seu site a um nível global. Pode personalizar as cores, a tipografia, o layout e o espaçamento para todo o site, bem como editar a apresentação de blocos individuais. Para aceder ao painel Styles, precisa de instalar e activar um tema de blocos e estar a usar o WordPress 5.9 ou superior. A partir daí, pode fazer alterações na tipografia, cores e layout do seu site, bem como personalizar a apresentação de blocos específicos. Também pode usar o painel Styles para adicionar cores e gradientes personalizados à paleta de cores do seu site. Além disso, pode usar o painel Styles para adicionar CSS personalizado ao seu site.\";}i:6;a:5:{s:2:\"id\";i:283;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:18:\"adding-a-new-block\";s:5:\"title\";s:18:\"Adicionando blocos\";s:7:\"summary\";s:558:\"Existem várias formas de adicionar um bloco ao seu artigo ou página no editor de blocos do WordPress. Pode usar o ícone + do painel de inserir blocos na barra de ferramentas superior, o ícone + do painel de inserir blocos à direita de um bloco vazio, ou o ícone + do painel de inserir blocos entre blocos. Também pode adicionar blocos utilizando um comando de barra de atalho ou as Mais opções na barra de ferramentas de um bloco. Adicionalmente, pode adicionar blocos dentro de blocos aninhados e procurar blocos utilizando o directório de blocos.\";}i:7;a:5:{s:2:\"id\";i:297;s:4:\"cats\";a:1:{i:0;s:17:\"site-wide-changes\";}s:4:\"slug\";s:15:\"template-editor\";s:5:\"title\";s:16:\"Editor de Modelo\";s:7:\"summary\";s:275:\"O Editor de Modelos permite-lhe editar e criar modelos usando blocos, que controlam o layout dos artigos, páginas ou tipos de página no seu site WordPress. Pode aceder ao Editor de Modelos através do Editor de Blocos WordPress ou do Editor do site, dependendo do seu tema.\";}i:8;a:5:{s:2:\"id\";i:305;s:4:\"cats\";a:1:{i:0;s:6:\"themes\";}s:4:\"slug\";s:12:\"block-themes\";s:5:\"title\";s:14:\"Temas de bloco\";s:7:\"summary\";s:302:\"Os temas de blocos são um novo tipo de tema no /wordpress que utilizam blocos para todas as partes de um site, permitindo uma fácil personalização sem alterar os temas. Substituem os widgets por blocos e não utilizam o Personalizador, oferecendo mais controlo sobre o design e o layout de um site.\";}i:9;a:5:{s:2:\"id\";i:309;s:4:\"cats\";a:1:{i:0;s:8:\"blogging\";}s:4:\"slug\";s:12:\"posts-screen\";s:5:\"title\";s:40:\"Menu de administração de publicações\";s:7:\"summary\";s:360:\"O Ecrã de Artigos num blog permite aos utilizadores gerir e editar artigos. Os utilizadores podem filtrar e procurar por artigos específicos, e existe um recurso de edição em massa que permite aos utilizadores editar vários artigos de uma vez. No entanto, não é possível alterar ou eliminar categorias ou etiquetas para um conjunto de artigos em massa.\";}i:10;a:5:{s:2:\"id\";i:284;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:13:\"block-pattern\";s:5:\"title\";s:17:\"Padrões de Bloco\";s:7:\"summary\";s:380:\"Os Padrões de Blocos são coleções pré-desenhadas de blocos que podem ser inseridos em artigos e páginas no WordPress. Podem ser personalizados com o seu próprio conteúdo e são uma forma de poupar tempo na criação de conteúdo interessante e visualmente apelativo. Pode encontrar mais padrões no Diretório de Padrões de Blocos e até criar os seus próprios padrões.\";}i:11;a:5:{s:2:\"id\";i:285;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:23:\"block-pattern-directory\";s:5:\"title\";s:31:\"Diretório de Padrões de Bloco\";s:7:\"summary\";s:339:\"O Diretório de Padrões de Blocos é um recurso para criadores de conteúdo encontrarem e usarem padrões de blocos nos seus sites. Os utilizadores podem pesquisar padrões, copiá-los para a sua área de transferência e personalizá-los conforme necessário. Existe também uma opção para reportar quaisquer problemas com os padrões.\";}i:12;a:5:{s:2:\"id\";i:286;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:15:\"block-directory\";s:5:\"title\";s:22:\"Diretório de Bloqueio\";s:7:\"summary\";s:388:\"O Diretório de Blocos é um novo recurso no editor de blocos que permite aos utilizadores descobrir e instalar novos blocos para o seu site. Os utilizadores podem pesquisar blocos, pré-visualizá-los e escolher quais adicionar à sua página. Os blocos do Diretório de Blocos são instalados como plugins, e os utilizadores podem desinstalá-los ou reinstalá-los conforme necessário.\";}i:13;a:5:{s:2:\"id\";i:287;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:13:\"moving-blocks\";s:5:\"title\";s:14:\"Blocos móveis\";s:7:\"summary\";s:549:\"Existem três formas de mover ou alterar a posição de um bloco no Editor de Blocos do WordPress: utilizando os identificadores de movimento, arrastar & largar, ou utilizando a opção Mover para na barra de ferramentas do Bloco. Os identificadores de movimento são as setas para cima e para baixo na barra de ferramentas do Bloco, arrastar & largar pode ser concluído ao clicar e segurar o retângulo de pontos na barra de ferramentas do Bloco, e a opção Mover para pode ser encontrada no menu de três pontos na barra de ferramentas do Bloco.\";}i:14;a:5:{s:2:\"id\";i:288;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:9:\"list-view\";s:5:\"title\";s:23:\"Visualização da lista\";s:7:\"summary\";s:364:\"A Visualização em Lista é uma nova ferramenta no editor do WordPress que permite aos utilizadores navegar entre camadas de conteúdo e blocos aninhados. Ajuda os utilizadores a selecionar e ver facilmente todos os blocos que compõem o seu conteúdo, e permite ações como arrastar e soltar blocos, fazer alterações a blocos individuais e colapsar secções.\";}i:15;a:5:{s:2:\"id\";i:289;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:31:\"how-to-use-the-preview-function\";s:5:\"title\";s:27:\"Pré-visualizar uma página\";s:7:\"summary\";s:273:\"O botão Ver no Editor de Blocos do WordPress e no Editor do site permite-lhe pré-visualizar as suas alterações em diferentes dispositivos, como desktop, tablet e telemóvel. Também pode optar por pré-visualizar a página ou o site num novo separador do seu navegador.\";}i:16;a:5:{s:2:\"id\";i:290;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:31:\"keyboard-shortcuts-block-editor\";s:5:\"title\";s:38:\"Atalhos de Teclado no Editor de Blocos\";s:7:\"summary\";s:403:\"O editor visual (de blocos) do WordPress oferece vários atalhos de teclado para realizar tarefas sem usar o rato. Estes atalhos incluem a mudança entre o editor visual e o editor de código, a ativação do modo de ecrã inteiro, a navegação pelo editor, a seleção e manipulação de blocos, e a formatação de texto. Os atalhos estão disponíveis tanto para utilizadores de Windows como de Mac.\";}i:17;a:5:{s:2:\"id\";i:298;s:4:\"cats\";a:1:{i:0;s:17:\"site-wide-changes\";}s:4:\"slug\";s:19:\"template-part-block\";s:5:\"title\";s:24:\"Bloco de Parte do Modelo\";s:7:\"summary\";s:345:\"O bloco Parte do Modelo é um bloco avançado introduzido no WordPress 5.9 que pode ser usado para organizar e exibir a estrutura do site. É melhor usado para criar áreas como cabeçalhos e rodapés do site, e quando altera blocos dentro de uma parte do modelo, o editor atualiza os blocos em cada modelo de bloco que inclui a parte do modelo.\";}i:18;a:5:{s:2:\"id\";i:291;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:20:\"preferences-overview\";s:5:\"title\";s:21:\"Menu de preferências\";s:7:\"summary\";s:362:\"A funcionalidade Preferências no Editor de Blocos do WordPress e no Editor do site permite aos utilizadores personalizar a sua experiência de edição, ativando/desativando várias opções. Os utilizadores podem personalizar opções de publicação, apresentação, interações de blocos e painéis para criar um layout que se adapte às suas preferências.\";}i:19;a:5:{s:2:\"id\";i:292;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:26:\"page-post-settings-sidebar\";s:5:\"title\";s:32:\"Barra lateral de configurações\";s:7:\"summary\";s:415:\"A barra lateral de opções de Página/Artigo no Editor de Blocos do WordPress permite aos utilizadores personalizar vários aspetos da sua página ou artigo, como a visibilidade, data de publicação, URL, modelo, e mais. Pode ser acedida clicando no ícone de engrenagem no canto superior direito do editor e pode variar dependendo de se estar a trabalhar numa página, artigo, ou tipo de conteúdo personalizado.\";}i:20;a:5:{s:2:\"id\";i:303;s:4:\"cats\";a:1:{i:0;s:17:\"site-wide-changes\";}s:4:\"slug\";s:26:\"create-a-static-front-page\";s:5:\"title\";s:34:\"Crie uma Página Inicial Estática\";s:7:\"summary\";s:435:\"Uma Página Inicial Estática é uma página específica usada como a página inicial de um site /wordpress, em vez de mostrar uma lista de artigos. Para configurar uma Página Inicial Estática, precisa de criar uma página para a página inicial e outra página vazia para a página de artigos, então vá a Configurações > Leitura e selecione a página estática para a página inicial e a página vazia para a página de artigos.\";}i:21;a:5:{s:2:\"id\";i:293;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:15:\"reusable-blocks\";s:5:\"title\";s:21:\"Blocos Reutilizáveis\";s:7:\"summary\";s:521:\"A funcionalidade Padrão Sincronizado no WordPress permite-lhe criar blocos reutilizáveis que podem ser editados e atualizados em múltiplas localizações. Pode criar um Padrão Sincronizado selecionando o bloco ou blocos que deseja transformar num padrão, clicando no menu de três pontos e escolhendo \"Criar padrão/bloco reutilizável\". Uma vez criado, pode usar o Padrão Sincronizado no seu conteúdo e fazer alterações a ele diretamente num artigo ou página ou através da interface Opções > Gerir Padrões.\";}i:22;a:5:{s:2:\"id\";i:306;s:4:\"cats\";a:1:{i:0;s:6:\"themes\";}s:4:\"slug\";s:10:\"customizer\";s:5:\"title\";s:23:\"Personalizador (legado)\";s:7:\"summary\";s:396:\"A versão 3.4 do WordPress introduziu o Personalizador de Temas, que permite aos utilizadores pré-visualizar e alterar a apresentação do seu site antes de a publicar. Os utilizadores podem personalizar vários aspetos, como cores, fundos e cabeçalhos de imagem. O Personalizador só está disponível se o tema ativo o suportar, e cada tema pode ter uma interface de Personalizador diferente.\";}i:23;a:5:{s:2:\"id\";i:307;s:4:\"cats\";a:1:{i:0;s:6:\"themes\";}s:4:\"slug\";s:24:\"manage-wordpress-widgets\";s:5:\"title\";s:16:\"Widgets (legado)\";s:7:\"summary\";s:342:\"Os Widgets do WordPress são ferramentas que permitem aos utilizadores adicionar conteúdo e funcionalidades às barras laterais do seu site. Podem ser facilmente adicionados, removidos e reorganizados através dos Ecrãs de Administração do WordPress, e podem ser personalizados para incluir formulários, imagens e outras funcionalidades.\";}i:24;a:5:{s:2:\"id\";i:294;s:4:\"cats\";a:1:{i:0;s:22:\"wordpress-block-editor\";}s:4:\"slug\";s:16:\"work-with-blocks\";s:5:\"title\";s:20:\"Trabalhar com blocos\";s:7:\"summary\";s:706:\"O Editor de Blocos do WordPress permite aos utilizadores criar páginas e artigos ricos em (conteúdo) multimédia através do uso de blocos, que são os elementos fundamentais do conteúdo. Cada bloco tem a sua própria barra de ferramentas e barra lateral de opções, permitindo uma fácil personalização e controlo sobre o layout e a apresentação do bloco. Os blocos podem ser adicionados em qualquer lugar num artigo ou página usando o painel de inserir blocos, e existem uma variedade de blocos disponíveis para diferentes tipos de conteúdo. Os utilizadores também podem bloquear e desbloquear blocos, remover blocos e encontrar blocos ou padrões de blocos usando o painel de inserir blocos.\";}i:25;a:5:{s:2:\"id\";i:310;s:4:\"cats\";a:1:{i:0;s:8:\"blogging\";}s:4:\"slug\";s:20:\"customize-permalinks\";s:5:\"title\";s:23:\"Personalizar Permalinks\";s:7:\"summary\";s:421:\"As ligações permanentes são os URLs permanentes dos seus artigos, páginas, categorias e outras páginas de arquivo no seu site. Elas ajudam a criar uma estrutura de URL que é fácil de entender e partilhar tanto por humanos como por motores de pesquisa. Existem três tipos de ligações permanentes do WordPress: Ligações Permanentes Simples, Ligações Permanentes Bonitas e Ligações Permanentes Quase Bonitas.\";}i:26;a:5:{s:2:\"id\";i:311;s:4:\"cats\";a:1:{i:0;s:8:\"blogging\";}s:4:\"slug\";s:21:\"comments-in-wordpress\";s:5:\"title\";s:12:\"Comentários\";s:7:\"summary\";s:336:\"O WordPress permite aos utilizadores activar comentários no seu site, o que permite aos visitantes terem discussões entre si e com o proprietário do site. Os comentários são mostrados no painel de /comments na área de administração do WordPress, onde o proprietário do site pode aprovar, responder a, ou editar os comentários.\";}i:27;a:5:{s:2:\"id\";i:312;s:4:\"cats\";a:1:{i:0;s:8:\"blogging\";}s:4:\"slug\";s:18:\"comment-moderation\";s:5:\"title\";s:27:\"Moderação de Comentários\";s:7:\"summary\";s:310:\"A moderação de comentários no WordPress permite-lhe aprovar ou eliminar manualmente os comentários antes de aparecerem no seu site. Pode controlar quais os comentários que são retidos para moderação, definindo regras com base em fatores como o número de hiperligações ou palavras-chave específicas.\";}i:28;a:5:{s:2:\"id\";i:313;s:4:\"cats\";a:1:{i:0;s:8:\"blogging\";}s:4:\"slug\";s:17:\"posts-tags-screen\";s:5:\"title\";s:25:\"Etiquetas de publicação\";s:7:\"summary\";s:1007:\"No WordPress, as etiquetas são usadas para categorizar artigos e auxiliar na navegação. Elas são mostradas abaixo de cada artigo e podem ser clicadas para ver todos os artigos com essa etiqueta. As etiquetas podem ser geridas no Ecrã de Etiquetas de Artigos, onde novas etiquetas podem ser criadas e as existentes podem ser editadas ou eliminadas. A secção Etiquetas Populares mostra as etiquetas mais usadas, e a secção Adicionar Nova Etiqueta permite a criação de novas etiquetas. A Tabela de Etiquetas lista todas as etiquetas alfabeticamente e fornece opções para editar e eliminar etiquetas. O separador Opções de Ecrã permite a personalização das colunas exibidas, e a caixa de pesquisa pode ser usada para procurar etiquetas específicas. Ações podem ser realizadas em etiquetas, como eliminação em massa ou edição imediata. A Edição Rápida permite alterações rápidas às informações da etiqueta, e o ecrã Editar Etiqueta fornece mais opções de edição detalhadas.\";}i:29;a:5:{s:2:\"id\";i:314;s:4:\"cats\";a:1:{i:0;s:8:\"blogging\";}s:4:\"slug\";s:12:\"create-pages\";s:5:\"title\";s:14:\"Criar Páginas\";s:7:\"summary\";s:493:\"No WordPress, pode criar conteúdo para o seu site na forma de uma Publicação ou uma Página. As publicações são para conteúdo dependente do tempo e aparecem em ordem cronológica inversa na página inicial do seu blog, enquanto as Páginas são para conteúdo não cronológico e são frequentemente usadas para informações atemporais sobre si mesmo ou sobre o seu site. As páginas podem ser organizadas em páginas pai e páginas filho, e pode criar tantas páginas quantas desejar.\";}i:30;a:5:{s:2:\"id\";i:315;s:4:\"cats\";a:1:{i:0;s:23:\"administrative-settings\";}s:4:\"slug\";s:25:\"users-your-profile-screen\";s:5:\"title\";s:12:\"O seu perfil\";s:7:\"summary\";s:326:\"O ecrã O Seu Perfil no WordPress permite aos utilizadores especificar o seu nome, endereço de email, informações pessoais e opções pessoais. A única informação obrigatória é o endereço de email e uma alcunha, e todas as outras informações são opcionais e não são partilhadas com qualquer outro site ou pessoa.\";}i:31;a:5:{s:2:\"id\";i:316;s:4:\"cats\";a:1:{i:0;s:23:\"administrative-settings\";}s:4:\"slug\";s:22:\"roles-and-capabilities\";s:5:\"title\";s:19:\"Papéis de usuário\";s:7:\"summary\";s:256:\"O WordPress utiliza um conceito de Papéis para controlar o que os utilizadores podem fazer num site. Existem seis papéis pré-definidos, cada um com um conjunto de capacidades, e capacidades adicionais podem ser atribuídas ou removidas usando funções.\";}i:32;a:5:{s:2:\"id\";i:317;s:4:\"cats\";a:1:{i:0;s:23:\"administrative-settings\";}s:4:\"slug\";s:23:\"settings-general-screen\";s:5:\"title\";s:23:\"Menu de configurações\";s:7:\"summary\";s:379:\"O ecrã de Configurações Gerais na administração do WordPress permite-lhe configurar as opções básicas para o seu site, como o título do site, descrição, URL, endereço de email, opções de adesão, idioma do site, fuso horário, formato da data e formato da hora. Pode alterar estas opções e guardá-las na sua base de dados clicando no botão Guardar Alterações.\";}i:33;a:5:{s:2:\"id\";i:318;s:4:\"cats\";a:1:{i:0;s:23:\"administrative-settings\";}s:4:\"slug\";s:23:\"settings-reading-screen\";s:5:\"title\";s:27:\"Menu de opções de leitura\";s:7:\"summary\";s:370:\"O Ecrã de Configurações de Leitura permite-lhe escolher se quer que os seus artigos mais recentes ou uma página estática sejam exibidos como a página inicial do seu site. Também pode ajustar o número de artigos exibidos na página inicial e personalizar como as informações do seu site são enviadas para os navegadores web ou outras aplicações dos leitores.\";}i:34;a:5:{s:2:\"id\";i:319;s:4:\"cats\";a:1:{i:0;s:23:\"administrative-settings\";}s:4:\"slug\";s:22:\"administration-screens\";s:5:\"title\";s:25:\"Ecrãs de Administração\";s:7:\"summary\";s:361:\"O Ecrã de Administração no WordPress permite o acesso aos recursos de controlo da sua instalação WordPress. Está dividido em secções, incluindo a barra de ferramentas, a navegação principal, a área de trabalho e o rodapé, e permite realizar várias funções administrativas, como criar novos artigos, gerir comentários e atualizar plugins e temas.\";}i:35;a:5:{s:2:\"id\";i:320;s:4:\"cats\";a:1:{i:0;s:23:\"administrative-settings\";}s:4:\"slug\";s:16:\"dashboard-screen\";s:5:\"title\";s:6:\"Painel\";s:7:\"summary\";s:350:\"O ecrã do Painel no WordPress oferece uma vista geral do conteúdo do seu site e permite-lhe aceder a diferentes áreas da comunidade WordPress. Inclui widgets por omissão como De Relance, Atividade, Rascunho Rápido, Eventos e Notícias WordPress, e Boas-vindas, mas também pode adicionar ou remover widgets utilizando o painel Opções de Ecrã.\";}i:36;a:5:{s:2:\"id\";i:299;s:4:\"cats\";a:1:{i:0;s:23:\"administrative-settings\";}s:4:\"slug\";s:23:\"two-step-authentication\";s:5:\"title\";s:29:\"Autenticação em Dois Passos\";s:7:\"summary\";s:349:\"A autenticação em duas etapas, também conhecida como Autenticação de Dois Fatores, está a tornar-se mais popular à medida que os sites procuram melhores formas de garantir os inícios de sessão. Envolve a utilização de dois dos três possíveis fatores para provar a sua identidade, como algo que sabe (senha) e algo que possui (telefone).\";}i:37;a:5:{s:2:\"id\";i:300;s:4:\"cats\";a:1:{i:0;s:5:\"media\";}s:4:\"slug\";s:20:\"media-library-screen\";s:5:\"title\";s:20:\"Biblioteca de mídia\";s:7:\"summary\";s:459:\"A Biblioteca Multimédia no WordPress é onde pode gerir e editar todos os ficheiros multimédia (imagens, vídeos, gravações, etc.) que carregou para o seu blog. Pode ver, eliminar e procurar itens multimédia, bem como realizar ações em massa, como eliminar vários itens de uma só vez. A Biblioteca Multimédia oferece duas visualizações: uma visualização em grelha com miniaturas e uma visualização em lista com uma tabela de itens multimédia.\";}i:38;a:5:{s:2:\"id\";i:301;s:4:\"cats\";a:1:{i:0;s:5:\"media\";}s:4:\"slug\";s:20:\"media-add-new-screen\";s:5:\"title\";s:36:\"Adicionar novo conteúdo multimédia\";s:7:\"summary\";s:282:\"O ecrã Adicionar Novo ao Multimédia permite-lhe carregar ficheiros multimédia para uso posterior nos seus artigos e páginas. Pode carregar ficheiros um de cada vez ou em massa, utilizando os métodos de Carregamento de Múltiplos Ficheiros ou Carregamento através do Navegador.\";}i:39;a:5:{s:2:\"id\";i:302;s:4:\"cats\";a:1:{i:0;s:7:\"plugins\";}s:4:\"slug\";s:14:\"manage-plugins\";s:5:\"title\";s:13:\"Gerir Plugins\";s:7:\"summary\";s:387:\"Os plugins do WordPress são scripts PHP que expandem a funcionalidade do WordPress, permitindo aos utilizadores personalizar os seus sites com recursos adicionais. Podem ser facilmente instalados e estão disponíveis gratuitamente no Diretório de Plugins do WordPress. Algumas categorias populares de plugins incluem controlo de spam, SEO, comércio eletrónico, segurança e caching.\";}i:40;a:5:{s:2:\"id\";i:321;s:4:\"cats\";a:1:{i:0;s:7:\"plugins\";}s:4:\"slug\";s:16:\"must-use-plugins\";s:5:\"title\";s:10:\"mu-plugins\";s:7:\"summary\";s:426:\"Os plugins de uso obrigatório são plugins que são automaticamente ativados em todos os sites numa instalação WordPress e não podem ser desativados exceto através da remoção do ficheiro do plugin do diretório de uso obrigatório. Estes plugins não aparecem na lista por omissão de plugins e têm algumas limitações, como não poderem usar hooks de ativação e não aparecerem nas notificações de atualização.\";}i:41;a:5:{s:2:\"id\";i:322;s:4:\"cats\";a:1:{i:0;s:8:\"advanced\";}s:4:\"slug\";s:20:\"assign-custom-fields\";s:5:\"title\";s:21:\"Campos Personalizados\";s:7:\"summary\";s:370:\"O WordPress permite aos autores de artigos atribuir campos personalizados, também conhecidos como metadados, a um artigo. Estes metadados podem incluir informações como humor, leitura atual e clima. Os utilizadores podem adicionar campos personalizados a um artigo ativando a opção Campos Personalizados no editor de artigos e digitando a chave e o valor desejados.\";}i:42;a:5:{s:2:\"id\";i:323;s:4:\"cats\";a:1:{i:0;s:8:\"advanced\";}s:4:\"slug\";s:17:\"what-is-post-type\";s:5:\"title\";s:22:\"Tipos de Publicações\";s:7:\"summary\";s:402:\"O WordPress tem diferentes tipos de conteúdo denominados tipos de conteúdo, incluindo artigos, páginas, anexos, revisões, menus, CSS personalizado e conjuntos de alterações. Os utilizadores também podem criar tipos de conteúdo personalizados para organizar o seu conteúdo, e podem personalizar a exibição destes tipos de conteúdo usando ficheiros de modelo e consultas de tipo de conteúdo.\";}i:43;a:5:{s:2:\"id\";i:324;s:4:\"cats\";a:1:{i:0;s:8:\"advanced\";}s:4:\"slug\";s:10:\"taxonomies\";s:5:\"title\";s:10:\"Taxonomias\";s:7:\"summary\";s:462:\"As taxonomias no WordPress são uma forma de agrupar artigos com base em relações. Por omissão, o WordPress tem duas taxonomias chamadas Categorias e Etiquetas, mas pode remover ou alterá-las e até adicionar mais. As taxonomias têm termos, que são como filhos, e pode criar as suas próprias taxonomias e termos no WordPress. Também pode expandir a funcionalidade das taxonomias e dos seus termos para melhorar as opções de categorização e filtragem.\";}i:44;a:5:{s:2:\"id\";i:325;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:15:\"paragraph-block\";s:5:\"title\";s:19:\"Bloco de parágrafo\";s:7:\"summary\";s:629:\"O bloco Parágrafo é um bloco básico no /wordpress que permite adicionar conteúdo de texto a um artigo ou página. Oferece várias opções de formatação, como negrito, itálico e rasurado, bem como a capacidade de adicionar ligações, imagens em linha e destacar texto. A barra de ferramentas do bloco Parágrafo inclui opções para transformar o bloco em diferentes tipos de blocos, mover o bloco dentro do editor, alterar o alinhamento do texto e aceder a mais opções de edição de texto rico. Adicionalmente, o bloco Parágrafo tem opções de opções para cor, tipografia, dimensões e personalização avançada.\";}i:45;a:5:{s:2:\"id\";i:326;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:13:\"heading-block\";s:5:\"title\";s:19:\"Bloco de cabeçalho\";s:7:\"summary\";s:708:\"Este artigo fornece instruções sobre como adicionar e personalizar blocos de cabeçalho no Editor de Blocos do WordPress. Explica como adicionar cabeçalhos usando o painel de inserir blocos ou digitando comandos específicos, e também abrange as várias opções disponíveis na barra de ferramentas do bloco de cabeçalho, como transformar o bloco, alterar o alinhamento e o nível do cabeçalho, e adicionar opções de formatação como negrito, itálico e ligações. Adicionalmente, o artigo discute as opções de bloco disponíveis na barra lateral do editor, incluindo personalização de cor, opções de tipografia, controlos de dimensão e opções avançadas como âncoras HTML e classes CSS.\";}i:46;a:5:{s:2:\"id\";i:327;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:10:\"list-block\";s:5:\"title\";s:17:\"Lista de bloqueio\";s:7:\"summary\";s:187:\"O Bloco de Lista no WordPress permite-lhe criar listas com marcadores ou numeradas. Pode personalizar os itens da lista utilizando opções como negrito, itálico, hiperligação e /more.\";}i:47;a:5:{s:2:\"id\";i:328;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:11:\"quote-block\";s:5:\"title\";s:18:\"Bloco de citação\";s:7:\"summary\";s:425:\"Este artigo fornece instruções sobre como usar o bloco Quote no WordPress. Explica como adicionar o bloco Quote a uma página, bem como os vários ícones da barra de ferramentas e opções disponíveis para manipular o bloco. Também aborda as opções do bloco, incluindo estilos, cor, tipografia, dimensões e opções avançadas. O artigo conclui com um registo de alterações das atualizações feitas ao bloco Quote.\";}i:48;a:5:{s:2:\"id\";i:329;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:13:\"classic-block\";s:5:\"title\";s:15:\"Bloco clássico\";s:7:\"summary\";s:231:\"O bloco clássico é uma versão em bloco do editor clássico, com botões personalizados TinyMCE. Pode adicionar um bloco clássico clicando no ícone do painel de inserir blocos ou digitando /classic num novo bloco de parágrafo.\";}i:49;a:5:{s:2:\"id\";i:330;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:10:\"code-block\";s:5:\"title\";s:16:\"Bloco de código\";s:7:\"summary\";s:473:\"O bloco de Código no WordPress permite-lhe adicionar e mostrar excertos de código. Pode adicionar o bloco de Código utilizando o inseridor de blocos ou digitando /code no editor. O bloco tem várias opções para personalização, incluindo a transformação em diferentes tipos de blocos, a negrito e a itálico no texto, adicionando ligações, e mais. Também pode personalizar a cor, a tipografia, as dimensões, a borda e as opções avançadas do bloco de Código.\";}i:50;a:5:{s:2:\"id\";i:331;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:18:\"preformatted-block\";s:5:\"title\";s:20:\"Bloco pré-formatado\";s:7:\"summary\";s:282:\"O Bloco Pré-formatado no WordPress permite-lhe mostrar o texto exatamente como o escreve, com espaçamento e quebras de linha preservados. Tem semelhanças com o Bloco de Parágrafo e o Bloco de Código, mas também inclui estilização e a capacidade de adicionar hiperligações.\";}i:51;a:5:{s:2:\"id\";i:332;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:15:\"pullquote-block\";s:5:\"title\";s:17:\"Bloco de destaque\";s:7:\"summary\";s:243:\"O bloco /pullquote no /wordpress permite-lhe adicionar ênfase ao texto, criando um excerto visualmente apelativo. Pode personalizar a apresentação do bloco /pullquote alterando o seu alinhamento, estilo, cor, tipografia, borda e muito mais.\";}i:52;a:5:{s:2:\"id\";i:333;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:11:\"table-block\";s:5:\"title\";s:15:\"Bloco de tabela\";s:7:\"summary\";s:492:\"O bloco Table no WordPress permite aos utilizadores criar facilmente tabelas nos seus artigos ou páginas. A barra de ferramentas do bloco Table inclui botões para transformar o bloco, movê-lo, alinhá-lo, alterar o alinhamento das colunas, colocar texto em negrito e itálico, adicionar ligações, e mais. Os utilizadores também podem personalizar o estilo da tabela, as opções, a cor, a tipografia, as dimensões, a borda, e adicionar âncora HTML avançada ou classes CSS adicionais.\";}i:53;a:5:{s:2:\"id\";i:334;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:11:\"verse-block\";s:5:\"title\";s:15:\"Bloco de versos\";s:7:\"summary\";s:275:\"O bloco /verse é utilizado para escrever poesia num site. Possui vários ícones na barra de ferramentas e controlos de utilizador para manipular o bloco, como alterar o alinhamento do texto, adicionar formatação em negrito ou itálico, adicionar hiperligações, e /more.\";}i:54;a:5:{s:2:\"id\";i:335;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:13:\"buttons-block\";s:5:\"title\";s:17:\"Blocos de botões\";s:7:\"summary\";s:224:\"O bloco Buttons no /wordpress permite-lhe adicionar um ou mais /buttons ao seu artigo ou página. Pode personalizar o texto, a ligação e o estilo de cada /button, e existem várias opções de layout e design disponíveis.\";}i:55;a:5:{s:2:\"id\";i:336;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:13:\"columns-block\";s:5:\"title\";s:16:\"Bloco de colunas\";s:7:\"summary\";s:299:\"O Bloco de Colunas no /wordpress permite-lhe criar um efeito de grelha ao inserir texto, (conteúdo) multimédia e outro conteúdo em colunas. Pode adicionar ou remover colunas, personalizar o alinhamento e o alinhamento vertical, e alterar a cor, a tipografia, as dimensões e as opções de borda.\";}i:56;a:5:{s:2:\"id\";i:337;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:11:\"group-block\";s:5:\"title\";s:14:\"Bloco de grupo\";s:7:\"summary\";s:253:\"O bloco de Grupo no WordPress permite agrupar diferentes blocos e personalizá-los com cores de fundo, espaçamento e mais. Pode adicionar um bloco de Grupo clicando no ícone do painel de inserir blocos ou digitando /group num novo bloco de parágrafo.\";}i:57;a:5:{s:2:\"id\";i:338;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:9:\"row-block\";s:5:\"title\";s:13:\"Bloco de fila\";s:7:\"summary\";s:358:\"O bloco Row no editor do /wordpress permite-lhe organizar blocos horizontalmente. Possui vários ícones na barra de ferramentas que permitem manipular o bloco, como transformá-lo em diferentes tipos de blocos, arrastar e mover, alterar a justificação e alinhamento, e personalizar as suas opções como cor, tipografia, dimensões, borda e CSS avançado.\";}i:58;a:5:{s:2:\"id\";i:339;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:11:\"stack-block\";s:5:\"title\";s:14:\"Bloco de pilha\";s:7:\"summary\";s:506:\"O bloco Stack é um bloco contentor que pode ser usado para aninhar outros blocos verticalmente. Pode ser transformado num bloco de Grupo ou de Linha sem alterar o conteúdo. A barra de ferramentas do bloco Stack inclui opções para transformar o bloco, movê-lo dentro do editor, alterar a justificação e alinhamento dos itens, e ajustar a largura. O painel de opções do bloco permite uma maior personalização do layout do bloco, posição, cor, tipografia, dimensões, borda e opções avançadas.\";}i:59;a:5:{s:2:\"id\";i:340;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:10:\"more-block\";s:5:\"title\";s:10:\"Mais bloco\";s:7:\"summary\";s:220:\"O bloco More é usado para mostrar uma ligação \"Ler Mais\" na página inicial do blog ou nas páginas de arquivo. Ele trunca as entradas do blog e direciona os leitores para o artigo completo quando clicam na ligação.\";}i:60;a:5:{s:2:\"id\";i:341;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:16:\"page-break-block\";s:5:\"title\";s:26:\"Bloco de quebra de página\";s:7:\"summary\";s:266:\"O bloco de quebra de página permite-lhe separar o seu conteúdo em várias páginas e adicionar paginação. Pode adicionar tantas quebras de página quantas desejar, e cada uma adiciona um novo número à ligação de várias páginas na parte inferior da página.\";}i:61;a:5:{s:2:\"id\";i:342;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:15:\"separator-block\";s:5:\"title\";s:15:\"Bloco separador\";s:7:\"summary\";s:648:\"O bloco separador no WordPress cria uma linha horizontal para separar o conteúdo. Pode ser adicionado usando o painel de inserir blocos ou digitando /separator num novo bloco de parágrafo. A barra de ferramentas do bloco permite transformar o bloco separador em colunas ou num bloco de grupo, alterar o estilo e o alinhamento, e aceder a mais opções como copiar e editar o bloco como HTML. As opções do bloco na barra lateral permitem personalizar o estilo, a cor, as dimensões, e adicionar opções avançadas como âncora HTML e classe CSS. O registo de alterações fornece informações sobre as atualizações feitas ao bloco separador.\";}i:62;a:5:{s:2:\"id\";i:343;s:4:\"cats\";a:1:{i:0;s:6:\"blocks\";}s:4:\"slug\";s:12:\"spacer-block\";s:5:\"title\";s:16:\"Bloco espaçador\";s:7:\"summary\";s:432:\"O bloco Spacer no /wordpress permite-lhe adicionar espaço entre dois blocos. Pode modificar o bloco Spacer utilizando a barra de ferramentas do bloco, que inclui opções para transformar o bloco, arrastá-lo para uma nova localização e movê-lo para cima e para baixo no seu documento. O painel de opções do bloco permite-lhe ajustar a altura do bloco Spacer e adicionar âncora HTML e classe(s) CSS para personalizar o bloco.\";}i:63;a:5:{s:2:\"id\";i:344;s:4:\"cats\";a:2:{i:0;s:6:\"blocks\";i:1;s:5:\"media\";}s:4:\"slug\";s:11:\"image-block\";s:5:\"title\";s:15:\"Bloco de imagem\";s:7:\"summary\";s:362:\"Este artigo fornece instruções sobre como adicionar e personalizar blocos de imagem no editor do WordPress. Explica como adicionar imagens usando o botão Adicionar Bloco ou o comando de barra, e como redimensionar e alinhar imagens. Também aborda recursos como legendas, opções de ligação, edição de imagem, adição de texto em sobreposição, e mais.\";}i:64;a:5:{s:2:\"id\";i:345;s:4:\"cats\";a:2:{i:0;s:6:\"blocks\";i:1;s:5:\"media\";}s:4:\"slug\";s:13:\"gallery-block\";s:5:\"title\";s:16:\"Bloco de galeria\";s:7:\"summary\";s:199:\"O bloco Galeria no WordPress permite-lhe adicionar várias fotos e organizá-las numa galeria. Pode controlar o número de colunas, o tamanho da imagem, e adicionar legendas e ligações às imagens.\";}i:65;a:5:{s:2:\"id\";i:346;s:4:\"cats\";a:2:{i:0;s:6:\"blocks\";i:1;s:5:\"media\";}s:4:\"slug\";s:11:\"audio-block\";s:5:\"title\";s:15:\"Bloco de áudio\";s:7:\"summary\";s:253:\"O bloco de áudio permite-lhe incorporar música, podcasts ou outros ficheiros de som na sua página ou artigo. Pode carregar um ficheiro do seu computador, selecionar um ficheiro da sua biblioteca multimédia, ou inserir um ficheiro a partir de um URL.\";}i:66;a:5:{s:2:\"id\";i:347;s:4:\"cats\";a:2:{i:0;s:6:\"blocks\";i:1;s:5:\"media\";}s:4:\"slug\";s:11:\"cover-block\";s:5:\"title\";s:18:\"Bloco de cobertura\";s:7:\"summary\";s:264:\"O bloco Cover no WordPress permite-lhe adicionar uma /image ou um /video com uma sobreposição de texto. Pode personalizar o bloco adicionando conteúdo multimédia, alterando o alinhamento, redimensionando e ajustando opções como a cor de fundo e a tipografia.\";}i:67;a:5:{s:2:\"id\";i:348;s:4:\"cats\";a:2:{i:0;s:6:\"blocks\";i:1;s:5:\"media\";}s:4:\"slug\";s:10:\"file-block\";s:5:\"title\";s:16:\"Bloco de arquivo\";s:7:\"summary\";s:382:\"Este artigo fornece instruções sobre como adicionar um bloco de Ficheiro a um artigo ou página no WordPress. Explica como carregar ficheiros, alterar nomes de ficheiros, copiar URLs de ficheiros e personalizar o bloco usando os ícones da barra de ferramentas e as opções do bloco. O artigo também inclui um registo de alterações com atualizações para o bloco de Ficheiro.\";}i:68;a:5:{s:2:\"id\";i:349;s:4:\"cats\";a:2:{i:0;s:6:\"blocks\";i:1;s:5:\"media\";}s:4:\"slug\";s:16:\"media-text-block\";s:5:\"title\";s:24:\"Bloco de texto de mídia\";s:7:\"summary\";s:280:\"O bloco de Multimédia & Texto permite colocar uma imagem ou vídeo lado a lado com texto. Pode adicionar conteúdo, alinhar o bloco, inserir ligações, substituir o ficheiro multimédia e personalizar as opções do bloco, como cor, tipografia, dimensões e opções avançadas.\";}i:69;a:5:{s:2:\"id\";i:350;s:4:\"cats\";a:2:{i:0;s:6:\"blocks\";i:1;s:5:\"media\";}s:4:\"slug\";s:11:\"video-block\";s:5:\"title\";s:15:\"Bloco de vídeo\";s:7:\"summary\";s:714:\"O bloco de Vídeo permite-lhe carregar e incorporar vídeos no seu artigo ou página. Pode optar por carregar um novo ficheiro de vídeo, selecionar um ficheiro da sua biblioteca multimédia, ou inserir um URL de um tipo de bloco suportado como o YouTube. A barra de ferramentas do bloco fornece opções para transformar o bloco de Vídeo em outros tipos de blocos, mover o bloco, alterar o alinhamento, adicionar faixas de texto, substituir o ficheiro de vídeo, e aceder a mais opções. O painel de opções do bloco permite-lhe personalizar a reprodução automática, loop, silenciar, reproduzir em linha, controlos de reprodução, pré-carregamento, imagem de capa, dimensões, elemento HTML e classes CSS.\";}}", "off");
INSERT INTO `wp_options` VALUES("42510", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("42525", "_transient_timeout_wc_shipping_method_count", "1765076293", "off");
INSERT INTO `wp_options` VALUES("42526", "_transient_wc_shipping_method_count", "a:2:{s:7:\"version\";s:10:\"1735061447\";s:5:\"value\";i:0;}", "off");
INSERT INTO `wp_options` VALUES("42529", "_transient_timeout_orders-all-statuses", "1763089094", "off");
INSERT INTO `wp_options` VALUES("42530", "_transient_orders-all-statuses", "a:2:{s:7:\"version\";s:10:\"1735061646\";s:5:\"value\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("42536", "_transient_timeout_wc_shipping_method_count_legacy", "1765076540", "off");
INSERT INTO `wp_options` VALUES("42537", "_transient_wc_shipping_method_count_legacy", "a:2:{s:7:\"version\";s:10:\"1735061447\";s:5:\"value\";i:0;}", "off");
INSERT INTO `wp_options` VALUES("42607", "_transient_timeout_elementor_unread_notifications_1", "1763471118", "off");
INSERT INTO `wp_options` VALUES("42608", "_transient_elementor_unread_notifications_1", "a:17:{i:0;s:22:\"variables-manager-3.33\";i:1;s:15:\"custom-css-3.33\";i:2;s:15:\"blend-mode-3.33\";i:3;s:14:\"transform-3.32\";i:4;s:18:\"size-variable-3.32\";i:5;s:16:\"transitions-3.32\";i:6;s:14:\"variables-3.31\";i:7;s:12:\"filters-3.31\";i:8;s:14:\"ally-assistant\";i:9;s:12:\"classes-3.31\";i:10;s:15:\"attributes-3.31\";i:11;s:19:\"cloud-websites-3.30\";i:12;s:17:\"ally-notification\";i:13;s:15:\"ai-site-planner\";i:14;s:20:\"image-optimizer-3.19\";i:15;s:20:\"5-star-rating-prompt\";i:16;s:23:\"site-mailer-introducing\";}", "off");
INSERT INTO `wp_options` VALUES("42642", "_transient_timeout_woocommerce_blocks_asset_api_script_data", "1767362242", "off");
INSERT INTO `wp_options` VALUES("42643", "_transient_woocommerce_blocks_asset_api_script_data", "{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"eb5ac71a827c4c81fed8\",\"dependencies\":[\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"bda84b1be3361607d04a\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"e3f189e7e5007fb14fff\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"bf6b6808e29dd19e91b9\",\"dependencies\":[\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"b11f59edc6d52068b7a2\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"8db91d7a57c47e3eb6f6\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"8eba41362d1dafa41905\",\"dependencies\":[\"react\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-dom-ready\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"6eb6865831aa5a75475d\",\"dependencies\":[\"react\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"cba59eca47d9101980bf\",\"dependencies\":[\"react\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"483d2180eda1f53dc60d\",\"dependencies\":[\"wc-settings\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\",\"version\":\"310fb0b97cc939547132\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\",\"version\":\"7c1cbc00f89f395a28b2\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\",\"version\":\"c785ec96148aa09a247a\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"b00178cb31b1aeee8038\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"5f11d5c440e62fef7bb5\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-interactivity-dropdown.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-interactivity-dropdown.js\",\"version\":\"8997b5406dcf18064a4e\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-interactivity-checkbox-list.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-interactivity-checkbox-list.js\",\"version\":\"9f910c57a575d29e7f8e\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/mini-cart-component-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-component-frontend.js\",\"version\":\"ed1ec23bf662f0bfee15\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"http:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]}},\"version\":\"wc-9.5.1\",\"hash\":\"b391ae53763da5c54a9aa2e4e0a0ea0a\"}", "off");
INSERT INTO `wp_options` VALUES("42667", "_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl", "1769081600", "off");
INSERT INTO `wp_options` VALUES("42668", "_transient_woocommerce_blocks_asset_api_script_data_ssl", "{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"eb5ac71a827c4c81fed8\",\"dependencies\":[\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"bda84b1be3361607d04a\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"e3f189e7e5007fb14fff\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"bf6b6808e29dd19e91b9\",\"dependencies\":[\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"b11f59edc6d52068b7a2\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"8db91d7a57c47e3eb6f6\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"8eba41362d1dafa41905\",\"dependencies\":[\"react\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-dom-ready\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"6eb6865831aa5a75475d\",\"dependencies\":[\"react\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"cba59eca47d9101980bf\",\"dependencies\":[\"react\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"483d2180eda1f53dc60d\",\"dependencies\":[\"wc-settings\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\",\"version\":\"310fb0b97cc939547132\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\",\"version\":\"7c1cbc00f89f395a28b2\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\",\"version\":\"c785ec96148aa09a247a\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"b00178cb31b1aeee8038\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"5f11d5c440e62fef7bb5\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-interactivity-dropdown.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-interactivity-dropdown.js\",\"version\":\"8997b5406dcf18064a4e\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-interactivity-checkbox-list.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-interactivity-checkbox-list.js\",\"version\":\"9f910c57a575d29e7f8e\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/mini-cart-component-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-component-frontend.js\",\"version\":\"ed1ec23bf662f0bfee15\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.5.1\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\":{\"src\":\"https:\\/\\/tangoandmore.com\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\",\"version\":\"f8559bf4a68d3090c1b0\",\"dependencies\":[\"react\",\"react-dom\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]}},\"version\":\"wc-9.5.1\",\"hash\":\"b391ae53763da5c54a9aa2e4e0a0ea0a\"}", "off");
INSERT INTO `wp_options` VALUES("42680", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:4:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/pt_PT/wordpress-6.9.zip\";s:6:\"locale\";s:5:\"pt_PT\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/pt_PT/wordpress-6.9.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.9\";s:7:\"version\";s:3:\"6.9\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.9.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.9.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-6.9-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-6.9-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.9\";s:7:\"version\";s:3:\"6.9\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:49:\"https://downloads.w.org/release/wordpress-6.9.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:49:\"https://downloads.w.org/release/wordpress-6.9.zip\";s:10:\"no_content\";s:60:\"https://downloads.w.org/release/wordpress-6.9-no-content.zip\";s:11:\"new_bundled\";s:61:\"https://downloads.w.org/release/wordpress-6.9-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.9\";s:7:\"version\";s:3:\"6.9\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:3;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:51:\"https://downloads.w.org/release/wordpress-6.8.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:51:\"https://downloads.w.org/release/wordpress-6.8.3.zip\";s:10:\"no_content\";s:62:\"https://downloads.w.org/release/wordpress-6.8.3-no-content.zip\";s:11:\"new_bundled\";s:63:\"https://downloads.w.org/release/wordpress-6.8.3-new-bundled.zip\";s:7:\"partial\";s:61:\"https://downloads.w.org/release/wordpress-6.8.3-partial-2.zip\";s:8:\"rollback\";s:62:\"https://downloads.w.org/release/wordpress-6.8.3-rollback-2.zip\";}s:7:\"current\";s:5:\"6.8.3\";s:7:\"version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:5:\"6.8.2\";s:9:\"new_files\";s:0:\"\";}}s:12:\"last_checked\";i:1766489600;s:15:\"version_checked\";s:5:\"6.8.2\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("42700", "_site_transient_timeout_available_translations", "1766500391", "off");
INSERT INTO `wp_options` VALUES("42701", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.11/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.7/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-10 08:09:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.7/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.28/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-26 09:35:39\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-01 14:03:28\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-19 10:33:50\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-09 08:25:54\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-11 16:48:51\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-25 10:23:08\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-05 10:10:20\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-29 01:31:30\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-29 01:33:14\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.2/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-28 10:25:03\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-28 10:25:24\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.8.2/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-21 14:54:13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-22 11:56:25\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-30 21:52:12\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-19 23:02:24\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-25 13:50:40\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-29 13:22:09\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-19 08:40:47\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-26 16:45:13\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-28 22:23:40\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-14 15:46:25\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-29 19:09:09\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-30 13:57:29\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.12/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.18/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-11 05:24:36\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.23/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-05 12:26:55\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-02-14 17:29:08\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-03 12:49:52\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-12 09:41:09\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-29 15:04:36\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-25 05:20:17\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.7/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2025-12-20 19:08:53\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2025-10-21 16:35:04\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.8/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-16 11:10:04\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-29 04:27:18\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.34\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.34/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-31 12:41:06\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-09 13:56:03\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-16 04:17:52\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-11 21:28:29\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-22 12:19:14\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-14 08:02:58\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.23/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-22 16:17:50\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-15 15:01:44\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-22 23:30:14\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.2/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-17 05:00:42\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.2/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-27 20:51:17\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-15 19:11:43\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.0.11/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-24 16:32:35\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.7/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-26 17:30:52\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.17\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.17/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-30 18:16:57\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-23 09:31:59\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-29 06:56:09\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-31 11:10:17\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.2/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-15 07:18:24\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-20 12:00:49\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.35\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.35/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-27 23:38:30\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-30 11:47:36\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-27 23:48:59\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.8.2/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-24 09:05:42\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-24 17:30:30\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.18/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-29 04:32:58\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-24 16:58:02\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-14 09:44:53\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-18 09:38:51\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-08 20:51:20\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-10 20:44:58\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-28 12:50:48\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.12/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-08 16:09:09\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-16 23:11:08\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-29 21:46:36\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-18 21:10:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.8/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.18/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-01 09:12:13\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-16 04:41:52\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-29 06:55:14\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "off");
INSERT INTO `wp_options` VALUES("42702", "_transient_timeout_extendify_partner_data_cache_check", "1766662397", "off");
INSERT INTO `wp_options` VALUES("42703", "_transient_extendify_partner_data_cache_check", "1", "off");
INSERT INTO `wp_options` VALUES("42704", "_transient_timeout_wcpay_incentive_store_has_orders", "1766511199", "off");
INSERT INTO `wp_options` VALUES("42705", "_transient_wcpay_incentive_store_has_orders", "no", "off");
INSERT INTO `wp_options` VALUES("42706", "_transient_timeout_wcpay_welcome_page_incentive", "1766575999", "off");
INSERT INTO `wp_options` VALUES("42707", "_transient_wcpay_welcome_page_incentive", "a:3:{s:9:\"incentive\";a:0:{}s:12:\"context_hash\";s:32:\"f7bd5159a604f1404866beafa173411b\";s:9:\"timestamp\";i:1766489599;}", "off");
INSERT INTO `wp_options` VALUES("42708", "_transient_timeout_wc_tracks_blog_details", "1766576000", "off");
INSERT INTO `wp_options` VALUES("42709", "_transient_wc_tracks_blog_details", "a:6:{s:3:\"url\";s:24:\"https://tangoandmore.com\";s:9:\"blog_lang\";s:5:\"pt_PT\";s:7:\"blog_id\";b:0;s:8:\"store_id\";s:36:\"118918b1-e6c2-4cde-840c-105718ff509a\";s:14:\"products_count\";i:0;s:10:\"wc_version\";s:5:\"9.5.1\";}", "off");
INSERT INTO `wp_options` VALUES("42710", "_transient_timeout_woocommerce_admin_payment_method_promotion_specs", "1766500716", "off");
INSERT INTO `wp_options` VALUES("42711", "_transient_woocommerce_admin_payment_method_promotion_specs", "a:1:{s:5:\"pt_PT\";a:2:{i:0;a:7:{s:2:\"id\";s:27:\"woocommerce_payments:woopay\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:74:\"Payments made simple — including WooPay, a new express checkout feature.\";s:5:\"image\";s:90:\"https://tangoandmore.com/wp-content/plugins/woocommerce/assets/images/onboarding/wcpay.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}}}}s:9:\"sub_title\";s:805:\"<img class=\"wcpay-visa-icon wcpay-icon\" src=\"https://tangoandmore.com/wp-content/plugins/woocommerce/assets/images/payment-methods/visa.svg\" alt=\"Visa\"><img class=\"wcpay-mastercard-icon wcpay-icon\" src=\"https://tangoandmore.com/wp-content/plugins/woocommerce/assets/images/payment-methods/mastercard.svg\" alt=\"Mastercard\"><img class=\"wcpay-amex-icon wcpay-icon\" src=\"https://tangoandmore.com/wp-content/plugins/woocommerce/assets/images/payment-methods/amex.svg\" alt=\"Amex\"><img class=\"wcpay-googlepay-icon wcpay-icon\" src=\"https://tangoandmore.com/wp-content/plugins/woocommerce/assets/images/payment-methods/googlepay.svg\" alt=\"Googlepay\"><img class=\"wcpay-applepay-icon wcpay-icon\" src=\"https://tangoandmore.com/wp-content/plugins/woocommerce/assets/images/payment-methods/applepay.svg\" alt=\"Applepay\">\";}i:1;a:7:{s:2:\"id\";s:20:\"woocommerce_payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:160:\"Payments made simple, with no monthly fees – designed exclusively for WooCommerce stores. Accept credit cards, debit cards, and other popular payment methods.\";s:5:\"image\";s:90:\"https://tangoandmore.com/wp-content/plugins/woocommerce/assets/images/onboarding/wcpay.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}}s:9:\"sub_title\";s:805:\"<img class=\"wcpay-visa-icon wcpay-icon\" src=\"https://tangoandmore.com/wp-content/plugins/woocommerce/assets/images/payment-methods/visa.svg\" alt=\"Visa\"><img class=\"wcpay-mastercard-icon wcpay-icon\" src=\"https://tangoandmore.com/wp-content/plugins/woocommerce/assets/images/payment-methods/mastercard.svg\" alt=\"Mastercard\"><img class=\"wcpay-amex-icon wcpay-icon\" src=\"https://tangoandmore.com/wp-content/plugins/woocommerce/assets/images/payment-methods/amex.svg\" alt=\"Amex\"><img class=\"wcpay-googlepay-icon wcpay-icon\" src=\"https://tangoandmore.com/wp-content/plugins/woocommerce/assets/images/payment-methods/googlepay.svg\" alt=\"Googlepay\"><img class=\"wcpay-applepay-icon wcpay-icon\" src=\"https://tangoandmore.com/wp-content/plugins/woocommerce/assets/images/payment-methods/applepay.svg\" alt=\"Applepay\">\";}}}", "off");
INSERT INTO `wp_options` VALUES("42714", "duplicator_expire_search-replace-wpcode", "{\"expire\":1767699351,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.0\"}}", "on");
INSERT INTO `wp_options` VALUES("42715", "duplicator_expire_wp-mail-smtp", "{\"expire\":1767699351,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.4\"}}", "on");
INSERT INTO `wp_options` VALUES("42716", "duplicator_expire_insert-headers-and-footers", "{\"expire\":1767699352,\"value\":{\"wp_version\":\"5.0\",\"php_version\":\"7.0\"}}", "on");
INSERT INTO `wp_options` VALUES("42717", "duplicator_ui_view_state", "a:2:{s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"1\";}", "auto");
INSERT INTO `wp_options` VALUES("42718", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-23 11:38:19\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.2.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:36:\"20251223_fernandoycarolinatangoargen\";s:4:\"Hash\";s:35:\"6541b2a8d4ffcb727893_20251223113819\";s:8:\"NameHash\";s:72:\"20251223_fernandoycarolinatangoargen_6541b2a8d4ffcb727893_20251223113819\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:82:\"20251223_fernandoycarolinatangoargen_6541b2a8d4ffcb727893_20251223113819_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:35:\"/data/sites/web/tangoandmorecom/www\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2530;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:15986;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-23 11:38:19\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.2.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:36:\"20251223_fernandoycarolinatangoargen\";s:4:\"Hash\";s:35:\"6541b2a8d4ffcb727893_20251223113819\";s:8:\"NameHash\";s:72:\"20251223_fernandoycarolinatangoargen_6541b2a8d4ffcb727893_20251223113819\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:49:\"/data/sites/web/tangoandmorecom/www/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:56:\"Percona Server (GPL), Release \'28\', Revision \'47601f19\'$\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:44:\"/data/sites/web/tangoandmorecom/www/wp-admin\";i:1;s:47:\"/data/sites/web/tangoandmorecom/www/wp-includes\";i:2;s:56:\"/data/sites/web/tangoandmorecom/www/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:35:\"/data/sites/web/tangoandmorecom/www\";i:1;s:35:\"/data/sites/web/tangoandmorecom/www\";i:2;s:46:\"/data/sites/web/tangoandmorecom/www/wp-content\";i:3;s:54:\"/data/sites/web/tangoandmorecom/www/wp-content/uploads\";i:4;s:54:\"/data/sites/web/tangoandmorecom/www/wp-content/plugins\";i:5;s:57:\"/data/sites/web/tangoandmorecom/www/wp-content/mu-plugins\";i:6;s:53:\"/data/sites/web/tangoandmorecom/www/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:67:\"/data/sites/web/tangoandmorecom/www/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("260", "17", "wpforms_form_locations", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("261", "70", "_elementor_edit_mode", "builder");
INSERT INTO `wp_postmeta` VALUES("262", "70", "_elementor_template_type", "kit");
INSERT INTO `wp_postmeta` VALUES("263", "8341", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("264", "8341", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("265", "8341", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("266", "8341", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("267", "8341", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("268", "8341", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("269", "8341", "slide_template", "");
INSERT INTO `wp_postmeta` VALUES("270", "8341", "_content_under_header", "content");
INSERT INTO `wp_postmeta` VALUES("271", "8341", "_order", "ASC");
INSERT INTO `wp_postmeta` VALUES("272", "8341", "_enable_desc", "on");
INSERT INTO `wp_postmeta` VALUES("273", "8341", "_theme", "slider");
INSERT INTO `wp_postmeta` VALUES("274", "8341", "_album_content", "G");
INSERT INTO `wp_postmeta` VALUES("275", "8341", "_brick_columns", "1");
INSERT INTO `wp_postmeta` VALUES("276", "8341", "_bricks_max_width", "1920px");
INSERT INTO `wp_postmeta` VALUES("277", "8341", "_brick_margin", "0px");
INSERT INTO `wp_postmeta` VALUES("278", "8341", "_slide_cover_color", "rgba(0,0,0,0.5)");
INSERT INTO `wp_postmeta` VALUES("279", "8341", "_bricks_hover", "none");
INSERT INTO `wp_postmeta` VALUES("280", "8341", "_bricks_title_position", "top_left");
INSERT INTO `wp_postmeta` VALUES("281", "8341", "_bricks_overlay_cover", "off");
INSERT INTO `wp_postmeta` VALUES("282", "8341", "_bricks_overlay_cover_hover", "off");
INSERT INTO `wp_postmeta` VALUES("283", "8341", "_bricks_overlay_gradient", "off");
INSERT INTO `wp_postmeta` VALUES("284", "8341", "_bricks_overlay_gradient_hover", "off");
INSERT INTO `wp_postmeta` VALUES("285", "8341", "_bricks_overlay_texts", "on");
INSERT INTO `wp_postmeta` VALUES("286", "8341", "_bricks_overlay_texts_hover", "on");
INSERT INTO `wp_postmeta` VALUES("287", "8341", "_fit_variant", "4");
INSERT INTO `wp_postmeta` VALUES("288", "8341", "_autoplay", "on");
INSERT INTO `wp_postmeta` VALUES("289", "8341", "_transition", "3");
INSERT INTO `wp_postmeta` VALUES("290", "8341", "_ken_scale", "110%");
INSERT INTO `wp_postmeta` VALUES("291", "8341", "_gradient", "off");
INSERT INTO `wp_postmeta` VALUES("292", "8341", "_slide_title_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("293", "8341", "_pattern", "0");
INSERT INTO `wp_postmeta` VALUES("294", "8341", "_thumbs", "off");
INSERT INTO `wp_postmeta` VALUES("295", "8341", "_www", "");
INSERT INTO `wp_postmeta` VALUES("296", "8341", "_custom_1", "Client: Vogue");
INSERT INTO `wp_postmeta` VALUES("297", "8341", "_custom_2", "Agency: Boxx");
INSERT INTO `wp_postmeta` VALUES("298", "8341", "_custom_3", "Art Director: Robert Smith");
INSERT INTO `wp_postmeta` VALUES("299", "8341", "_custom_4", "Stylist: Amanda Pierce");
INSERT INTO `wp_postmeta` VALUES("300", "8341", "_custom_5", "Photographer: John Mill");
INSERT INTO `wp_postmeta` VALUES("301", "8341", "_header_custom_sidebar", "G");
INSERT INTO `wp_postmeta` VALUES("302", "8341", "_alt_link", "");
INSERT INTO `wp_postmeta` VALUES("303", "8341", "_subtitle", "Fullscreen Slideshow");
INSERT INTO `wp_postmeta` VALUES("304", "8341", "_brick_ratio_x", "1");
INSERT INTO `wp_postmeta` VALUES("305", "8341", "_cover_color", "rgba(0,0,0,0.7)");
INSERT INTO `wp_postmeta` VALUES("306", "8341", "_exclude_in_albums_list", "off");
INSERT INTO `wp_postmeta` VALUES("307", "8341", "_images_n_videos", "[{\"image_tags\":\"\",\"image_link\":\"\",\"image_link_target\":\"0\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11908},{\"image_tags\":\"\",\"image_link\":\"\",\"image_link_target\":\"0\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11903},{\"image_tags\":\"\",\"image_link\":\"\",\"image_link_target\":\"0\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":12088},{\"image_tags\":\"\",\"image_link\":\"\",\"image_link_target\":\"0\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":12096},{\"image_tags\":\"\",\"image_link\":\"\",\"image_link_target\":\"0\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11907},{\"image_tags\":\"\",\"image_link\":\"\",\"image_link_target\":\"0\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11904}]");
INSERT INTO `wp_postmeta` VALUES("308", "8341", "_wp_old_slug", "woman-fashion");
INSERT INTO `wp_postmeta` VALUES("309", "8341", "_bricks_proportions_size", "0");
INSERT INTO `wp_postmeta` VALUES("310", "8341", "_horizontal_header_color_variant", "light");
INSERT INTO `wp_postmeta` VALUES("311", "8341", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("312", "8341", "_wp_old_slug", "slideshow1");
INSERT INTO `wp_postmeta` VALUES("313", "8341", "_bricks_lightbox", "on");
INSERT INTO `wp_postmeta` VALUES("314", "8341", "_thumbs_on_load", "on");
INSERT INTO `wp_postmeta` VALUES("315", "8341", "_thumbnail_id", "11747");
INSERT INTO `wp_postmeta` VALUES("316", "8341", "_bricks_lightbox_mobile", "on");
INSERT INTO `wp_postmeta` VALUES("317", "8375", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("318", "8375", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("319", "8375", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("320", "8375", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("321", "8375", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("322", "8375", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("323", "8375", "_wp_old_slug", "woman-fashion");
INSERT INTO `wp_postmeta` VALUES("324", "8375", "slide_template", "");
INSERT INTO `wp_postmeta` VALUES("325", "8375", "_content_under_header", "G");
INSERT INTO `wp_postmeta` VALUES("326", "8375", "_order", "ASC");
INSERT INTO `wp_postmeta` VALUES("327", "8375", "_enable_desc", "on");
INSERT INTO `wp_postmeta` VALUES("328", "8375", "_theme", "bricks");
INSERT INTO `wp_postmeta` VALUES("329", "8375", "_album_content", "right");
INSERT INTO `wp_postmeta` VALUES("330", "8375", "_brick_columns", "2");
INSERT INTO `wp_postmeta` VALUES("331", "8375", "_bricks_max_width", "1920px");
INSERT INTO `wp_postmeta` VALUES("332", "8375", "_brick_margin", "0px");
INSERT INTO `wp_postmeta` VALUES("333", "8375", "_slide_cover_color", "rgba(0,0,0, 0.3)");
INSERT INTO `wp_postmeta` VALUES("334", "8375", "_bricks_hover", "none");
INSERT INTO `wp_postmeta` VALUES("335", "8375", "_bricks_title_position", "top_left");
INSERT INTO `wp_postmeta` VALUES("336", "8375", "_bricks_overlay_cover", "off");
INSERT INTO `wp_postmeta` VALUES("337", "8375", "_bricks_overlay_cover_hover", "off");
INSERT INTO `wp_postmeta` VALUES("338", "8375", "_bricks_overlay_gradient", "off");
INSERT INTO `wp_postmeta` VALUES("339", "8375", "_bricks_overlay_gradient_hover", "off");
INSERT INTO `wp_postmeta` VALUES("340", "8375", "_bricks_overlay_texts", "off");
INSERT INTO `wp_postmeta` VALUES("341", "8375", "_bricks_overlay_texts_hover", "off");
INSERT INTO `wp_postmeta` VALUES("342", "8375", "_fit_variant", "4");
INSERT INTO `wp_postmeta` VALUES("343", "8375", "_autoplay", "G");
INSERT INTO `wp_postmeta` VALUES("344", "8375", "_transition", "-1");
INSERT INTO `wp_postmeta` VALUES("345", "8375", "_ken_scale", "120%");
INSERT INTO `wp_postmeta` VALUES("346", "8375", "_gradient", "on");
INSERT INTO `wp_postmeta` VALUES("347", "8375", "_slide_title_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("348", "8375", "_pattern", "0");
INSERT INTO `wp_postmeta` VALUES("349", "8375", "_thumbs", "G");
INSERT INTO `wp_postmeta` VALUES("350", "8375", "_www", "");
INSERT INTO `wp_postmeta` VALUES("351", "8375", "_custom_1", "Client: Vogue");
INSERT INTO `wp_postmeta` VALUES("352", "8375", "_custom_2", "Agency: Boxx");
INSERT INTO `wp_postmeta` VALUES("353", "8375", "_custom_3", "Art Director: Robert Smith");
INSERT INTO `wp_postmeta` VALUES("354", "8375", "_custom_4", "Stylist: Amanda Pierce");
INSERT INTO `wp_postmeta` VALUES("355", "8375", "_custom_5", "Photographer: John Mill");
INSERT INTO `wp_postmeta` VALUES("356", "8375", "_header_custom_sidebar", "G");
INSERT INTO `wp_postmeta` VALUES("357", "8375", "_alt_link", "");
INSERT INTO `wp_postmeta` VALUES("358", "8375", "_subtitle", "Grid Album");
INSERT INTO `wp_postmeta` VALUES("359", "8375", "_brick_ratio_x", "1");
INSERT INTO `wp_postmeta` VALUES("360", "8375", "_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("361", "8375", "_exclude_in_albums_list", "off");
INSERT INTO `wp_postmeta` VALUES("362", "8375", "_images_n_videos", "[{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11748},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11746},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11747},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11745},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11743},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11744},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11742},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11741}]");
INSERT INTO `wp_postmeta` VALUES("363", "8375", "_wp_old_slug", "woman-fashion-2");
INSERT INTO `wp_postmeta` VALUES("364", "8375", "_wp_old_slug", "glamour-girls");
INSERT INTO `wp_postmeta` VALUES("365", "8375", "_bricks_proportions_size", "3/2");
INSERT INTO `wp_postmeta` VALUES("366", "8375", "_horizontal_header_color_variant", "G");
INSERT INTO `wp_postmeta` VALUES("367", "8375", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("368", "8375", "_bricks_lightbox", "on");
INSERT INTO `wp_postmeta` VALUES("369", "8375", "_thumbs_on_load", "off");
INSERT INTO `wp_postmeta` VALUES("370", "8375", "_thumbnail_id", "11742");
INSERT INTO `wp_postmeta` VALUES("371", "8401", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("372", "8401", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("373", "8401", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("374", "8401", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("375", "8401", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("376", "8401", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("377", "8401", "_wp_old_slug", "glamour-girls");
INSERT INTO `wp_postmeta` VALUES("378", "8401", "slide_template", "");
INSERT INTO `wp_postmeta` VALUES("379", "8401", "_content_under_header", "G");
INSERT INTO `wp_postmeta` VALUES("380", "8401", "_order", "random");
INSERT INTO `wp_postmeta` VALUES("381", "8401", "_enable_desc", "on");
INSERT INTO `wp_postmeta` VALUES("382", "8401", "_theme", "bricks");
INSERT INTO `wp_postmeta` VALUES("383", "8401", "_album_content", "left");
INSERT INTO `wp_postmeta` VALUES("384", "8401", "_brick_columns", "2");
INSERT INTO `wp_postmeta` VALUES("385", "8401", "_bricks_max_width", "1920px");
INSERT INTO `wp_postmeta` VALUES("386", "8401", "_brick_margin", "0px");
INSERT INTO `wp_postmeta` VALUES("387", "8401", "_slide_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("388", "8401", "_bricks_hover", "pop");
INSERT INTO `wp_postmeta` VALUES("389", "8401", "_bricks_title_position", "top_left");
INSERT INTO `wp_postmeta` VALUES("390", "8401", "_bricks_overlay_cover", "off");
INSERT INTO `wp_postmeta` VALUES("391", "8401", "_bricks_overlay_cover_hover", "on");
INSERT INTO `wp_postmeta` VALUES("392", "8401", "_bricks_overlay_gradient", "off");
INSERT INTO `wp_postmeta` VALUES("393", "8401", "_bricks_overlay_gradient_hover", "off");
INSERT INTO `wp_postmeta` VALUES("394", "8401", "_bricks_overlay_texts", "off");
INSERT INTO `wp_postmeta` VALUES("395", "8401", "_bricks_overlay_texts_hover", "off");
INSERT INTO `wp_postmeta` VALUES("396", "8401", "_fit_variant", "0");
INSERT INTO `wp_postmeta` VALUES("397", "8401", "_autoplay", "G");
INSERT INTO `wp_postmeta` VALUES("398", "8401", "_transition", "-1");
INSERT INTO `wp_postmeta` VALUES("399", "8401", "_ken_scale", "120%");
INSERT INTO `wp_postmeta` VALUES("400", "8401", "_gradient", "on");
INSERT INTO `wp_postmeta` VALUES("401", "8401", "_slide_title_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("402", "8401", "_pattern", "0");
INSERT INTO `wp_postmeta` VALUES("403", "8401", "_thumbs", "G");
INSERT INTO `wp_postmeta` VALUES("404", "8401", "_www", "");
INSERT INTO `wp_postmeta` VALUES("405", "8401", "_custom_1", "Client: Vogue");
INSERT INTO `wp_postmeta` VALUES("406", "8401", "_custom_2", "Agency: Boxx");
INSERT INTO `wp_postmeta` VALUES("407", "8401", "_custom_3", "Art Director: Robert Smith");
INSERT INTO `wp_postmeta` VALUES("408", "8401", "_custom_4", "Stylist: Amanda Pierce");
INSERT INTO `wp_postmeta` VALUES("409", "8401", "_custom_5", "Photographer: John Mill");
INSERT INTO `wp_postmeta` VALUES("410", "8401", "_header_custom_sidebar", "G");
INSERT INTO `wp_postmeta` VALUES("411", "8401", "_alt_link", "");
INSERT INTO `wp_postmeta` VALUES("412", "8401", "_subtitle", "");
INSERT INTO `wp_postmeta` VALUES("413", "8401", "_brick_ratio_x", "1");
INSERT INTO `wp_postmeta` VALUES("414", "8401", "_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("415", "8401", "_exclude_in_albums_list", "off");
INSERT INTO `wp_postmeta` VALUES("416", "8401", "_images_n_videos", "[{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11748},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11746},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11747},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11745},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11743},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11744},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11742},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11741}]");
INSERT INTO `wp_postmeta` VALUES("417", "8401", "_wp_old_slug", "glamour-girls-2");
INSERT INTO `wp_postmeta` VALUES("418", "8401", "_bricks_proportions_size", "16/9");
INSERT INTO `wp_postmeta` VALUES("419", "8401", "_horizontal_header_color_variant", "G");
INSERT INTO `wp_postmeta` VALUES("420", "8401", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("421", "8401", "_bricks_lightbox", "on");
INSERT INTO `wp_postmeta` VALUES("422", "8401", "_thumbs_on_load", "off");
INSERT INTO `wp_postmeta` VALUES("423", "8401", "_thumbnail_id", "11743");
INSERT INTO `wp_postmeta` VALUES("424", "8402", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("425", "8402", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("426", "8402", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("427", "8402", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("428", "8402", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("429", "8402", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("430", "8402", "_wp_old_slug", "glamour-girls-2");
INSERT INTO `wp_postmeta` VALUES("431", "8402", "slide_template", "");
INSERT INTO `wp_postmeta` VALUES("432", "8402", "_content_under_header", "G");
INSERT INTO `wp_postmeta` VALUES("433", "8402", "_order", "random");
INSERT INTO `wp_postmeta` VALUES("434", "8402", "_enable_desc", "on");
INSERT INTO `wp_postmeta` VALUES("435", "8402", "_theme", "bricks");
INSERT INTO `wp_postmeta` VALUES("436", "8402", "_album_content", "off");
INSERT INTO `wp_postmeta` VALUES("437", "8402", "_brick_columns", "3");
INSERT INTO `wp_postmeta` VALUES("438", "8402", "_bricks_max_width", "1920px");
INSERT INTO `wp_postmeta` VALUES("439", "8402", "_brick_margin", "0px");
INSERT INTO `wp_postmeta` VALUES("440", "8402", "_slide_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("441", "8402", "_bricks_hover", "none");
INSERT INTO `wp_postmeta` VALUES("442", "8402", "_bricks_title_position", "mid_center");
INSERT INTO `wp_postmeta` VALUES("443", "8402", "_bricks_overlay_cover", "off");
INSERT INTO `wp_postmeta` VALUES("444", "8402", "_bricks_overlay_cover_hover", "off");
INSERT INTO `wp_postmeta` VALUES("445", "8402", "_bricks_overlay_gradient", "off");
INSERT INTO `wp_postmeta` VALUES("446", "8402", "_bricks_overlay_gradient_hover", "off");
INSERT INTO `wp_postmeta` VALUES("447", "8402", "_bricks_overlay_texts", "off");
INSERT INTO `wp_postmeta` VALUES("448", "8402", "_bricks_overlay_texts_hover", "off");
INSERT INTO `wp_postmeta` VALUES("449", "8402", "_fit_variant", "0");
INSERT INTO `wp_postmeta` VALUES("450", "8402", "_autoplay", "G");
INSERT INTO `wp_postmeta` VALUES("451", "8402", "_transition", "-1");
INSERT INTO `wp_postmeta` VALUES("452", "8402", "_ken_scale", "120%");
INSERT INTO `wp_postmeta` VALUES("453", "8402", "_gradient", "on");
INSERT INTO `wp_postmeta` VALUES("454", "8402", "_slide_title_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("455", "8402", "_pattern", "0");
INSERT INTO `wp_postmeta` VALUES("456", "8402", "_thumbs", "G");
INSERT INTO `wp_postmeta` VALUES("457", "8402", "_www", "");
INSERT INTO `wp_postmeta` VALUES("458", "8402", "_custom_1", "");
INSERT INTO `wp_postmeta` VALUES("459", "8402", "_custom_2", "");
INSERT INTO `wp_postmeta` VALUES("460", "8402", "_custom_3", "");
INSERT INTO `wp_postmeta` VALUES("461", "8402", "_custom_4", "");
INSERT INTO `wp_postmeta` VALUES("462", "8402", "_custom_5", "");
INSERT INTO `wp_postmeta` VALUES("463", "8402", "_header_custom_sidebar", "G");
INSERT INTO `wp_postmeta` VALUES("464", "8402", "_alt_link", "");
INSERT INTO `wp_postmeta` VALUES("465", "8402", "_subtitle", "With Filter");
INSERT INTO `wp_postmeta` VALUES("466", "8402", "_brick_ratio_x", "1");
INSERT INTO `wp_postmeta` VALUES("467", "8402", "_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("468", "8402", "_exclude_in_albums_list", "off");
INSERT INTO `wp_postmeta` VALUES("469", "8402", "_images_n_videos", "[{\"image_tags\":\"Landscape\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11748},{\"image_tags\":\"People\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11746},{\"image_tags\":\"People, Portrait\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11747},{\"image_tags\":\"Landscape\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11745},{\"image_tags\":\"People\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11743},{\"image_tags\":\"Landscape\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11744},{\"image_tags\":\"Landscape\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11742},{\"image_tags\":\"People\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11741},{\"image_tags\":\"People, Portrait\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11542}]");
INSERT INTO `wp_postmeta` VALUES("470", "8402", "_wp_old_slug", "glamour-girls-3");
INSERT INTO `wp_postmeta` VALUES("471", "8402", "_bricks_proportions_size", "4/3");
INSERT INTO `wp_postmeta` VALUES("472", "8402", "_horizontal_header_color_variant", "G");
INSERT INTO `wp_postmeta` VALUES("473", "8402", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("474", "8402", "_bricks_lightbox", "on");
INSERT INTO `wp_postmeta` VALUES("475", "8402", "_thumbs_on_load", "off");
INSERT INTO `wp_postmeta` VALUES("476", "8402", "_thumbnail_id", "11745");
INSERT INTO `wp_postmeta` VALUES("477", "8403", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("478", "8403", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("479", "8403", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("480", "8403", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("481", "8403", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("482", "8403", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("483", "8403", "slide_template", "");
INSERT INTO `wp_postmeta` VALUES("484", "8403", "_content_under_header", "content");
INSERT INTO `wp_postmeta` VALUES("485", "8403", "_order", "random");
INSERT INTO `wp_postmeta` VALUES("486", "8403", "_enable_desc", "on");
INSERT INTO `wp_postmeta` VALUES("487", "8403", "_theme", "bricks");
INSERT INTO `wp_postmeta` VALUES("488", "8403", "_album_content", "off");
INSERT INTO `wp_postmeta` VALUES("489", "8403", "_brick_columns", "2");
INSERT INTO `wp_postmeta` VALUES("490", "8403", "_bricks_max_width", "1200px");
INSERT INTO `wp_postmeta` VALUES("491", "8403", "_brick_margin", "0px");
INSERT INTO `wp_postmeta` VALUES("492", "8403", "_slide_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("493", "8403", "_bricks_hover", "drop");
INSERT INTO `wp_postmeta` VALUES("494", "8403", "_bricks_title_position", "bottom_center");
INSERT INTO `wp_postmeta` VALUES("495", "8403", "_bricks_overlay_cover", "off");
INSERT INTO `wp_postmeta` VALUES("496", "8403", "_bricks_overlay_cover_hover", "on");
INSERT INTO `wp_postmeta` VALUES("497", "8403", "_bricks_overlay_gradient", "off");
INSERT INTO `wp_postmeta` VALUES("498", "8403", "_bricks_overlay_gradient_hover", "off");
INSERT INTO `wp_postmeta` VALUES("499", "8403", "_bricks_overlay_texts", "off");
INSERT INTO `wp_postmeta` VALUES("500", "8403", "_bricks_overlay_texts_hover", "on");
INSERT INTO `wp_postmeta` VALUES("501", "8403", "_fit_variant", "0");
INSERT INTO `wp_postmeta` VALUES("502", "8403", "_autoplay", "G");
INSERT INTO `wp_postmeta` VALUES("503", "8403", "_transition", "-1");
INSERT INTO `wp_postmeta` VALUES("504", "8403", "_ken_scale", "120%");
INSERT INTO `wp_postmeta` VALUES("505", "8403", "_gradient", "on");
INSERT INTO `wp_postmeta` VALUES("506", "8403", "_slide_title_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("507", "8403", "_pattern", "0");
INSERT INTO `wp_postmeta` VALUES("508", "8403", "_thumbs", "G");
INSERT INTO `wp_postmeta` VALUES("509", "8403", "_www", "");
INSERT INTO `wp_postmeta` VALUES("510", "8403", "_custom_1", "");
INSERT INTO `wp_postmeta` VALUES("511", "8403", "_custom_2", "");
INSERT INTO `wp_postmeta` VALUES("512", "8403", "_custom_3", "");
INSERT INTO `wp_postmeta` VALUES("513", "8403", "_custom_4", "");
INSERT INTO `wp_postmeta` VALUES("514", "8403", "_custom_5", "");
INSERT INTO `wp_postmeta` VALUES("515", "8403", "_header_custom_sidebar", "G");
INSERT INTO `wp_postmeta` VALUES("516", "8403", "_alt_link", "");
INSERT INTO `wp_postmeta` VALUES("517", "8403", "_subtitle", "");
INSERT INTO `wp_postmeta` VALUES("518", "8403", "_brick_ratio_x", "1");
INSERT INTO `wp_postmeta` VALUES("519", "8403", "_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("520", "8403", "_exclude_in_albums_list", "off");
INSERT INTO `wp_postmeta` VALUES("521", "8403", "_images_n_videos", "[{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11748},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11746},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11747},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11745},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11743},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11744},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11742},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11741}]");
INSERT INTO `wp_postmeta` VALUES("522", "8403", "_wp_old_slug", "glamour-girls-4");
INSERT INTO `wp_postmeta` VALUES("523", "8403", "_bricks_proportions_size", "1/1");
INSERT INTO `wp_postmeta` VALUES("524", "8403", "_horizontal_header_color_variant", "light");
INSERT INTO `wp_postmeta` VALUES("525", "8403", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("526", "8403", "_bricks_lightbox", "on");
INSERT INTO `wp_postmeta` VALUES("527", "8403", "_thumbs_on_load", "off");
INSERT INTO `wp_postmeta` VALUES("528", "8403", "_thumbnail_id", "11746");
INSERT INTO `wp_postmeta` VALUES("529", "8412", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("530", "8412", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("531", "8412", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("532", "8412", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("533", "8412", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("534", "8412", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("535", "8412", "_wp_old_slug", "woman-fashion");
INSERT INTO `wp_postmeta` VALUES("536", "8412", "slide_template", "");
INSERT INTO `wp_postmeta` VALUES("537", "8412", "_content_under_header", "content");
INSERT INTO `wp_postmeta` VALUES("538", "8412", "_order", "random");
INSERT INTO `wp_postmeta` VALUES("539", "8412", "_enable_desc", "off");
INSERT INTO `wp_postmeta` VALUES("540", "8412", "_theme", "slider");
INSERT INTO `wp_postmeta` VALUES("541", "8412", "_album_content", "G");
INSERT INTO `wp_postmeta` VALUES("542", "8412", "_brick_columns", "3");
INSERT INTO `wp_postmeta` VALUES("543", "8412", "_bricks_max_width", "1920px");
INSERT INTO `wp_postmeta` VALUES("544", "8412", "_brick_margin", "10px");
INSERT INTO `wp_postmeta` VALUES("545", "8412", "_slide_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("546", "8412", "_bricks_hover", "cross");
INSERT INTO `wp_postmeta` VALUES("547", "8412", "_bricks_title_position", "top_left");
INSERT INTO `wp_postmeta` VALUES("548", "8412", "_bricks_overlay_cover", "on");
INSERT INTO `wp_postmeta` VALUES("549", "8412", "_bricks_overlay_cover_hover", "off");
INSERT INTO `wp_postmeta` VALUES("550", "8412", "_bricks_overlay_gradient", "on");
INSERT INTO `wp_postmeta` VALUES("551", "8412", "_bricks_overlay_gradient_hover", "off");
INSERT INTO `wp_postmeta` VALUES("552", "8412", "_bricks_overlay_texts", "on");
INSERT INTO `wp_postmeta` VALUES("553", "8412", "_bricks_overlay_texts_hover", "on");
INSERT INTO `wp_postmeta` VALUES("554", "8412", "_fit_variant", "4");
INSERT INTO `wp_postmeta` VALUES("555", "8412", "_autoplay", "G");
INSERT INTO `wp_postmeta` VALUES("556", "8412", "_transition", "2");
INSERT INTO `wp_postmeta` VALUES("557", "8412", "_ken_scale", "120%");
INSERT INTO `wp_postmeta` VALUES("558", "8412", "_gradient", "off");
INSERT INTO `wp_postmeta` VALUES("559", "8412", "_slide_title_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("560", "8412", "_pattern", "0");
INSERT INTO `wp_postmeta` VALUES("561", "8412", "_thumbs", "off");
INSERT INTO `wp_postmeta` VALUES("562", "8412", "_www", "");
INSERT INTO `wp_postmeta` VALUES("563", "8412", "_custom_1", "");
INSERT INTO `wp_postmeta` VALUES("564", "8412", "_custom_2", "");
INSERT INTO `wp_postmeta` VALUES("565", "8412", "_custom_3", "");
INSERT INTO `wp_postmeta` VALUES("566", "8412", "_custom_4", "");
INSERT INTO `wp_postmeta` VALUES("567", "8412", "_custom_5", "");
INSERT INTO `wp_postmeta` VALUES("568", "8412", "_header_custom_sidebar", "G");
INSERT INTO `wp_postmeta` VALUES("569", "8412", "_alt_link", "");
INSERT INTO `wp_postmeta` VALUES("570", "8412", "_subtitle", "Fullscreen Slideshow");
INSERT INTO `wp_postmeta` VALUES("571", "8412", "_brick_ratio_x", "1");
INSERT INTO `wp_postmeta` VALUES("572", "8412", "_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("573", "8412", "_exclude_in_albums_list", "off");
INSERT INTO `wp_postmeta` VALUES("574", "8412", "_images_n_videos", "[{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11748},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11746},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11747},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11745},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11743},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11744},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11742},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11741}]");
INSERT INTO `wp_postmeta` VALUES("575", "8412", "_wp_old_slug", "woman-fashion-2");
INSERT INTO `wp_postmeta` VALUES("576", "8412", "_horizontal_header_color_variant", "light");
INSERT INTO `wp_postmeta` VALUES("577", "8412", "_bricks_proportions_size", "0");
INSERT INTO `wp_postmeta` VALUES("578", "8412", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("579", "8412", "_wp_old_slug", "slideshow3");
INSERT INTO `wp_postmeta` VALUES("580", "8412", "_bricks_lightbox", "on");
INSERT INTO `wp_postmeta` VALUES("581", "8412", "_thumbs_on_load", "off");
INSERT INTO `wp_postmeta` VALUES("582", "8412", "_thumbnail_id", "11741");
INSERT INTO `wp_postmeta` VALUES("583", "8413", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("584", "8413", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("585", "8413", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("586", "8413", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("587", "8413", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("588", "8413", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("589", "8413", "slide_template", "");
INSERT INTO `wp_postmeta` VALUES("590", "8413", "_content_under_header", "G");
INSERT INTO `wp_postmeta` VALUES("591", "8413", "_order", "random");
INSERT INTO `wp_postmeta` VALUES("592", "8413", "_enable_desc", "on");
INSERT INTO `wp_postmeta` VALUES("593", "8413", "_theme", "slider");
INSERT INTO `wp_postmeta` VALUES("594", "8413", "_album_content", "G");
INSERT INTO `wp_postmeta` VALUES("595", "8413", "_brick_columns", "3");
INSERT INTO `wp_postmeta` VALUES("596", "8413", "_bricks_max_width", "1920px");
INSERT INTO `wp_postmeta` VALUES("597", "8413", "_brick_margin", "10px");
INSERT INTO `wp_postmeta` VALUES("598", "8413", "_slide_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("599", "8413", "_bricks_hover", "cross");
INSERT INTO `wp_postmeta` VALUES("600", "8413", "_bricks_title_position", "top_left");
INSERT INTO `wp_postmeta` VALUES("601", "8413", "_bricks_overlay_cover", "on");
INSERT INTO `wp_postmeta` VALUES("602", "8413", "_bricks_overlay_cover_hover", "off");
INSERT INTO `wp_postmeta` VALUES("603", "8413", "_bricks_overlay_gradient", "on");
INSERT INTO `wp_postmeta` VALUES("604", "8413", "_bricks_overlay_gradient_hover", "off");
INSERT INTO `wp_postmeta` VALUES("605", "8413", "_bricks_overlay_texts", "on");
INSERT INTO `wp_postmeta` VALUES("606", "8413", "_bricks_overlay_texts_hover", "on");
INSERT INTO `wp_postmeta` VALUES("607", "8413", "_fit_variant", "4");
INSERT INTO `wp_postmeta` VALUES("608", "8413", "_autoplay", "G");
INSERT INTO `wp_postmeta` VALUES("609", "8413", "_transition", "1");
INSERT INTO `wp_postmeta` VALUES("610", "8413", "_ken_scale", "120%");
INSERT INTO `wp_postmeta` VALUES("611", "8413", "_gradient", "off");
INSERT INTO `wp_postmeta` VALUES("612", "8413", "_slide_title_bg_color", "rgba(0,0,0,0.6)");
INSERT INTO `wp_postmeta` VALUES("613", "8413", "_pattern", "1");
INSERT INTO `wp_postmeta` VALUES("614", "8413", "_thumbs", "on");
INSERT INTO `wp_postmeta` VALUES("615", "8413", "_www", "");
INSERT INTO `wp_postmeta` VALUES("616", "8413", "_custom_1", "");
INSERT INTO `wp_postmeta` VALUES("617", "8413", "_custom_2", "");
INSERT INTO `wp_postmeta` VALUES("618", "8413", "_custom_3", "");
INSERT INTO `wp_postmeta` VALUES("619", "8413", "_custom_4", "");
INSERT INTO `wp_postmeta` VALUES("620", "8413", "_custom_5", "");
INSERT INTO `wp_postmeta` VALUES("621", "8413", "_header_custom_sidebar", "G");
INSERT INTO `wp_postmeta` VALUES("622", "8413", "_alt_link", "");
INSERT INTO `wp_postmeta` VALUES("623", "8413", "_subtitle", "You can edit this subtitle");
INSERT INTO `wp_postmeta` VALUES("624", "8413", "_brick_ratio_x", "1");
INSERT INTO `wp_postmeta` VALUES("625", "8413", "_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("626", "8413", "_exclude_in_albums_list", "off");
INSERT INTO `wp_postmeta` VALUES("627", "8413", "_images_n_videos", "[{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11748},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11746},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11747},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11745},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11743},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11744},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11742},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11741}]");
INSERT INTO `wp_postmeta` VALUES("628", "8413", "_wp_old_slug", "woman-fashion-3");
INSERT INTO `wp_postmeta` VALUES("629", "8413", "_horizontal_header_color_variant", "G");
INSERT INTO `wp_postmeta` VALUES("630", "8413", "_bricks_proportions_size", "0");
INSERT INTO `wp_postmeta` VALUES("631", "8413", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("632", "8413", "_wp_old_slug", "slideshow2");
INSERT INTO `wp_postmeta` VALUES("633", "8413", "_bricks_lightbox", "on");
INSERT INTO `wp_postmeta` VALUES("634", "8413", "_thumbs_on_load", "off");
INSERT INTO `wp_postmeta` VALUES("635", "8413", "_thumbnail_id", "11744");
INSERT INTO `wp_postmeta` VALUES("636", "8414", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("637", "8414", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("638", "8414", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("639", "8414", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("640", "8414", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("641", "8414", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("642", "8414", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("643", "8414", "_content_under_header", "content");
INSERT INTO `wp_postmeta` VALUES("644", "8414", "_order", "ASC");
INSERT INTO `wp_postmeta` VALUES("645", "8414", "_enable_desc", "off");
INSERT INTO `wp_postmeta` VALUES("646", "8414", "_theme", "slider");
INSERT INTO `wp_postmeta` VALUES("647", "8414", "_album_content", "G");
INSERT INTO `wp_postmeta` VALUES("648", "8414", "_brick_columns", "3");
INSERT INTO `wp_postmeta` VALUES("649", "8414", "_bricks_max_width", "1920px");
INSERT INTO `wp_postmeta` VALUES("650", "8414", "_brick_margin", "10px");
INSERT INTO `wp_postmeta` VALUES("651", "8414", "_slide_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("652", "8414", "_bricks_hover", "cross");
INSERT INTO `wp_postmeta` VALUES("653", "8414", "_bricks_title_position", "top_left");
INSERT INTO `wp_postmeta` VALUES("654", "8414", "_bricks_overlay_cover", "on");
INSERT INTO `wp_postmeta` VALUES("655", "8414", "_bricks_overlay_cover_hover", "off");
INSERT INTO `wp_postmeta` VALUES("656", "8414", "_bricks_overlay_gradient", "on");
INSERT INTO `wp_postmeta` VALUES("657", "8414", "_bricks_overlay_gradient_hover", "off");
INSERT INTO `wp_postmeta` VALUES("658", "8414", "_bricks_overlay_texts", "on");
INSERT INTO `wp_postmeta` VALUES("659", "8414", "_bricks_overlay_texts_hover", "on");
INSERT INTO `wp_postmeta` VALUES("660", "8414", "_fit_variant", "2");
INSERT INTO `wp_postmeta` VALUES("661", "8414", "_autoplay", "G");
INSERT INTO `wp_postmeta` VALUES("662", "8414", "_transition", "-1");
INSERT INTO `wp_postmeta` VALUES("663", "8414", "_ken_scale", "120%");
INSERT INTO `wp_postmeta` VALUES("664", "8414", "_gradient", "off");
INSERT INTO `wp_postmeta` VALUES("665", "8414", "_slide_title_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("666", "8414", "_pattern", "0");
INSERT INTO `wp_postmeta` VALUES("667", "8414", "_thumbs", "on");
INSERT INTO `wp_postmeta` VALUES("668", "8414", "_www", "");
INSERT INTO `wp_postmeta` VALUES("669", "8414", "_custom_1", "");
INSERT INTO `wp_postmeta` VALUES("670", "8414", "_custom_2", "");
INSERT INTO `wp_postmeta` VALUES("671", "8414", "_custom_3", "");
INSERT INTO `wp_postmeta` VALUES("672", "8414", "_custom_4", "");
INSERT INTO `wp_postmeta` VALUES("673", "8414", "_custom_5", "");
INSERT INTO `wp_postmeta` VALUES("674", "8414", "_header_custom_sidebar", "G");
INSERT INTO `wp_postmeta` VALUES("675", "8414", "_alt_link", "");
INSERT INTO `wp_postmeta` VALUES("676", "8414", "_subtitle", "Fullscreen Slideshow");
INSERT INTO `wp_postmeta` VALUES("677", "8414", "_brick_ratio_x", "1");
INSERT INTO `wp_postmeta` VALUES("678", "8414", "_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("679", "8414", "_exclude_in_albums_list", "off");
INSERT INTO `wp_postmeta` VALUES("680", "8414", "_images_n_videos", "[{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11450},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11449},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11448},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11441}]");
INSERT INTO `wp_postmeta` VALUES("681", "8414", "_thumbnail_id", "11748");
INSERT INTO `wp_postmeta` VALUES("682", "8414", "_wp_old_slug", "woman-fashion-4");
INSERT INTO `wp_postmeta` VALUES("683", "8414", "_bricks_proportions_size", "0");
INSERT INTO `wp_postmeta` VALUES("684", "8414", "_horizontal_header_color_variant", "light");
INSERT INTO `wp_postmeta` VALUES("685", "8414", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("686", "8414", "_wp_old_slug", "slideshow4");
INSERT INTO `wp_postmeta` VALUES("687", "8414", "_bricks_lightbox", "on");
INSERT INTO `wp_postmeta` VALUES("688", "8414", "_thumbs_on_load", "off");
INSERT INTO `wp_postmeta` VALUES("689", "8468", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("690", "8468", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("691", "8468", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("692", "8468", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("693", "8468", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("694", "8468", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("695", "8468", "slide_template", "");
INSERT INTO `wp_postmeta` VALUES("696", "8468", "_content_under_header", "content");
INSERT INTO `wp_postmeta` VALUES("697", "8468", "_order", "ASC");
INSERT INTO `wp_postmeta` VALUES("698", "8468", "_enable_desc", "on");
INSERT INTO `wp_postmeta` VALUES("699", "8468", "_theme", "bricks");
INSERT INTO `wp_postmeta` VALUES("700", "8468", "_album_content", "off");
INSERT INTO `wp_postmeta` VALUES("701", "8468", "_brick_columns", "2");
INSERT INTO `wp_postmeta` VALUES("702", "8468", "_bricks_max_width", "1920px");
INSERT INTO `wp_postmeta` VALUES("703", "8468", "_brick_margin", "0px");
INSERT INTO `wp_postmeta` VALUES("704", "8468", "_slide_cover_color", "rgba(0,0,0, 0.6)");
INSERT INTO `wp_postmeta` VALUES("705", "8468", "_bricks_hover", "shift");
INSERT INTO `wp_postmeta` VALUES("706", "8468", "_bricks_title_position", "bottom_left");
INSERT INTO `wp_postmeta` VALUES("707", "8468", "_bricks_overlay_cover", "on");
INSERT INTO `wp_postmeta` VALUES("708", "8468", "_bricks_overlay_cover_hover", "off");
INSERT INTO `wp_postmeta` VALUES("709", "8468", "_bricks_overlay_gradient", "off");
INSERT INTO `wp_postmeta` VALUES("710", "8468", "_bricks_overlay_gradient_hover", "off");
INSERT INTO `wp_postmeta` VALUES("711", "8468", "_bricks_overlay_texts", "on");
INSERT INTO `wp_postmeta` VALUES("712", "8468", "_bricks_overlay_texts_hover", "off");
INSERT INTO `wp_postmeta` VALUES("713", "8468", "_fit_variant", "0");
INSERT INTO `wp_postmeta` VALUES("714", "8468", "_autoplay", "G");
INSERT INTO `wp_postmeta` VALUES("715", "8468", "_transition", "-1");
INSERT INTO `wp_postmeta` VALUES("716", "8468", "_ken_scale", "120%");
INSERT INTO `wp_postmeta` VALUES("717", "8468", "_gradient", "on");
INSERT INTO `wp_postmeta` VALUES("718", "8468", "_slide_title_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("719", "8468", "_pattern", "0");
INSERT INTO `wp_postmeta` VALUES("720", "8468", "_thumbs", "G");
INSERT INTO `wp_postmeta` VALUES("721", "8468", "_www", "");
INSERT INTO `wp_postmeta` VALUES("722", "8468", "_custom_1", "");
INSERT INTO `wp_postmeta` VALUES("723", "8468", "_custom_2", "");
INSERT INTO `wp_postmeta` VALUES("724", "8468", "_custom_3", "");
INSERT INTO `wp_postmeta` VALUES("725", "8468", "_custom_4", "");
INSERT INTO `wp_postmeta` VALUES("726", "8468", "_custom_5", "");
INSERT INTO `wp_postmeta` VALUES("727", "8468", "_header_custom_sidebar", "G");
INSERT INTO `wp_postmeta` VALUES("728", "8468", "_alt_link", "");
INSERT INTO `wp_postmeta` VALUES("729", "8468", "_subtitle", "");
INSERT INTO `wp_postmeta` VALUES("730", "8468", "_brick_ratio_x", "1");
INSERT INTO `wp_postmeta` VALUES("731", "8468", "_cover_color", "rgba(0,0,0, 0.7)");
INSERT INTO `wp_postmeta` VALUES("732", "8468", "_exclude_in_albums_list", "off");
INSERT INTO `wp_postmeta` VALUES("733", "8468", "_images_n_videos", "[{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11748},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11746},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11747},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11745},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11743},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11744},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11742},{\"image_tags\":\"\",\"image_link\":\"\",\"image_bg_color\":\"\",\"image_ratio_x\":\"1\",\"type\":\"image\",\"id\":11741}]");
INSERT INTO `wp_postmeta` VALUES("734", "8468", "_wp_old_slug", "gallery");
INSERT INTO `wp_postmeta` VALUES("735", "8468", "_bricks_proportions_size", "16/9");
INSERT INTO `wp_postmeta` VALUES("736", "8468", "_horizontal_header_color_variant", "light");
INSERT INTO `wp_postmeta` VALUES("737", "8468", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("738", "8468", "_bricks_lightbox", "on");
INSERT INTO `wp_postmeta` VALUES("739", "8468", "_thumbs_on_load", "off");
INSERT INTO `wp_postmeta` VALUES("740", "8468", "_thumbnail_id", "11542");
INSERT INTO `wp_postmeta` VALUES("741", "11441", "_wp_attached_file", "2018/02/cropps-photo3.jpg");
INSERT INTO `wp_postmeta` VALUES("742", "11441", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:25:\"2018/02/cropps-photo3.jpg\";s:8:\"filesize\";i:34185;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"cropps-photo3-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11458;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"cropps-photo3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5065;}s:25:\"a13_navigation_image_size\";a:5:{s:4:\"file\";s:25:\"cropps-photo3-245x100.jpg\";s:5:\"width\";i:245;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4469;}s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:25:\"cropps-photo3-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14615;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:25:\"cropps-photo3-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2855;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("743", "11448", "_wp_attached_file", "2018/02/cropps-photo4.jpg");
INSERT INTO `wp_postmeta` VALUES("744", "11448", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:25:\"2018/02/cropps-photo4.jpg\";s:8:\"filesize\";i:20620;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"cropps-photo4-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6304;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"cropps-photo4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3422;}s:25:\"a13_navigation_image_size\";a:5:{s:4:\"file\";s:25:\"cropps-photo4-245x100.jpg\";s:5:\"width\";i:245;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3033;}s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:25:\"cropps-photo4-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9861;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:25:\"cropps-photo4-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2006;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("745", "11449", "_wp_attached_file", "2018/02/cropps-photo5.jpg");
INSERT INTO `wp_postmeta` VALUES("746", "11449", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:25:\"2018/02/cropps-photo5.jpg\";s:8:\"filesize\";i:22911;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"cropps-photo5-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7050;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"cropps-photo5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3525;}s:25:\"a13_navigation_image_size\";a:5:{s:4:\"file\";s:25:\"cropps-photo5-245x100.jpg\";s:5:\"width\";i:245;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3669;}s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:25:\"cropps-photo5-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9821;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:25:\"cropps-photo5-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2058;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("747", "11450", "_wp_attached_file", "2018/02/cropps-photo6.jpg");
INSERT INTO `wp_postmeta` VALUES("748", "11450", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:25:\"2018/02/cropps-photo6.jpg\";s:8:\"filesize\";i:26390;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"cropps-photo6-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8048;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"cropps-photo6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s: